/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/LineNumberRange;", "", "startLine", "", "lineCount", "<init>", "(II)V", "getStartLine", "()I", "getLineCount", "createAnchoredDiffChunk", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "document", "Lcom/intellij/openapi/editor/Document;", "newContent", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "aiplugin.editor.prediction-services"})
public final class LineNumberRange {
    private final int startLine;
    private final int lineCount;

    public LineNumberRange(int startLine, int lineCount) {
        this.startLine = startLine;
        this.lineCount = lineCount;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    @NotNull
    public final AnchoredDiffChunk createAnchoredDiffChunk(@NotNull Document document2, @NotNull String newContent2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)newContent2, (String)"newContent");
        int textRangeStartOffset = document2.getLineStartOffset(this.startLine);
        int lineAfterRange = this.startLine + this.lineCount;
        if (!(lineAfterRange <= document2.getLineCount())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int textRangeEndOffset = lineAfterRange == document2.getLineCount() ? document2.getLineEndOffset(lineAfterRange - 1) : document2.getLineStartOffset(lineAfterRange);
        return AnchoredDiffChunk.Companion.forUncommittedChange(document2, new TextRange(textRangeStartOffset, textRangeEndOffset), newContent2);
    }

    public final int component1() {
        return this.startLine;
    }

    public final int component2() {
        return this.lineCount;
    }

    @NotNull
    public final LineNumberRange copy(int startLine, int lineCount) {
        return new LineNumberRange(startLine, lineCount);
    }

    public static /* synthetic */ LineNumberRange copy$default(LineNumberRange lineNumberRange, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = lineNumberRange.startLine;
        }
        if ((n3 & 2) != 0) {
            n2 = lineNumberRange.lineCount;
        }
        return lineNumberRange.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "LineNumberRange(startLine=" + this.startLine + ", lineCount=" + this.lineCount + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.startLine);
        result2 = result2 * 31 + Integer.hashCode(this.lineCount);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LineNumberRange)) {
            return false;
        }
        LineNumberRange lineNumberRange = (LineNumberRange)other;
        if (this.startLine != lineNumberRange.startLine) {
            return false;
        }
        return this.lineCount == lineNumberRange.lineCount;
    }
}

