/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction.grouping.transformation;

import com.google.common.base.CaseFormat;
import com.google.tools.aiplugin.editor.prediction.Differ;
import com.google.tools.aiplugin.editor.prediction.grouping.transformation.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ$\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher;", "", "startStrings", "", "", "targetStrings", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "findShortestPaths", "Lcom/google/tools/aiplugin/editor/prediction/grouping/transformation/Transformation;", "maxPaths", "", "maxCost", "getTotalDistance", "current", "target", "generateNeighbors", "currentNode", "Lcom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher$SearchNode;", "SearchNode", "Companion", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nTransformationSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformationSearcher.kt\ncom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,353:1\n1563#2:354\n1634#2,3:355\n2783#2,7:359\n2783#2,7:366\n2783#2,7:373\n2783#2,7:380\n2783#2,7:387\n2783#2,7:394\n2783#2,7:401\n2783#2,7:408\n1740#2,2:415\n1742#2:419\n1740#2,2:420\n1742#2:424\n1761#2,3:425\n1869#2,2:428\n827#2:430\n855#2:431\n1761#2,3:432\n856#2:435\n827#2:436\n855#2:437\n1761#2,3:438\n856#2:441\n1#3:358\n1088#4,2:417\n1088#4,2:422\n*S KotlinDebug\n*F\n+ 1 TransformationSearcher.kt\ncom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher\n*L\n80#1:354\n80#1:355,3\n125#1:359,7\n130#1:366,7\n135#1:373,7\n140#1:380,7\n144#1:387,7\n148#1:394,7\n153#1:401,7\n158#1:408,7\n164#1:415,2\n164#1:419\n166#1:420,2\n166#1:424\n173#1:425,3\n174#1:428,2\n185#1:430\n185#1:431\n188#1:432,3\n185#1:435\n193#1:436\n193#1:437\n194#1:438,3\n193#1:441\n164#1:417,2\n166#1:422,2\n*E\n"})
public final class TransformationSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> startStrings;
    @NotNull
    private final List<String> targetStrings;
    private static final int MAX_NUM_STRINGS = 10;
    private static final int MAX_STRING_LENGTH = 20;

    public TransformationSearcher(@NotNull List<String> startStrings, @NotNull List<String> targetStrings) {
        Intrinsics.checkNotNullParameter(startStrings, (String)"startStrings");
        Intrinsics.checkNotNullParameter(targetStrings, (String)"targetStrings");
        this.startStrings = startStrings;
        this.targetStrings = targetStrings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<Transformation>> findShortestPaths(int maxPaths, int maxCost) {
        List foundPaths = new ArrayList();
        PriorityQueue<SearchNode> openSet = new PriorityQueue<SearchNode>();
        Map gCostMap = new LinkedHashMap();
        int hCost = this.getTotalDistance(this.startStrings, this.targetStrings);
        openSet.add(new SearchNode(this.startStrings, CollectionsKt.emptyList(), hCost));
        gCostMap.put(this.startStrings, 0);
        while (!((Collection)openSet).isEmpty() && foundPaths.size() < maxPaths) {
            SearchNode currentNode = (SearchNode)openSet.poll();
            if (currentNode.getHCost() == 0) {
                foundPaths.add(currentNode.getPath());
                continue;
            }
            Intrinsics.checkNotNull((Object)currentNode);
            for (Transformation transformation : this.generateNeighbors(currentNode)) {
                int newGCost;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = currentNode.getCurrentStrings();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(transformation.transform((String)it));
                }
                List newStrings = (List)destination$iv$iv;
                if (Intrinsics.areEqual((Object)newStrings, currentNode.getCurrentStrings()) || (newGCost = currentNode.getGCost() + 1) >= maxCost || newGCost > ((Number)gCostMap.getOrDefault(newStrings, Integer.MAX_VALUE)).intValue()) continue;
                gCostMap.put(newStrings, newGCost);
                int newHCost = this.getTotalDistance(newStrings, this.targetStrings);
                SearchNode newNode = new SearchNode(newStrings, CollectionsKt.plus((Collection)currentNode.getPath(), (Object)transformation), newHCost);
                openSet.add(newNode);
            }
        }
        return foundPaths;
    }

    /*
     * WARNING - void declaration
     */
    private final int getTotalDistance(List<String> current2, List<String> target) {
        Iterable iterable = CollectionsKt.zip((Iterable)current2, (Iterable)target);
        int n = 0;
        for (Object t : iterable) {
            void it;
            Pair pair = (Pair)t;
            int n2 = n;
            boolean bl = false;
            int n3 = Differ.INSTANCE.distance((String)it.getFirst(), (String)it.getSecond());
            n = n2 + n3;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private final List<Transformation> generateNeighbors(SearchNode currentNode) {
        $this$generateNeighbors_u24lambda_u2437 = var2_2 = CollectionsKt.createListBuilder();
        $i$a$-buildList-TransformationSearcher$generateNeighbors$1 = false;
        potentialRemovablePrefixes = new LinkedHashSet<E>();
        potentialRemovableSuffixes = new LinkedHashSet<E>();
        potentialAddablePrefixes = new LinkedHashSet<E>();
        potentialAddableSuffixes = new LinkedHashSet<E>();
        pairs = SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)currentNode.getCurrentStrings()), (Sequence)CollectionsKt.asSequence((Iterable)this.targetStrings));
        var10_10 /* !! */  = pairs.iterator();
        while (var10_10 /* !! */ .hasNext()) {
            var11_11 /* !! */  = (Pair)var10_10 /* !! */ .next();
            cur = (String)var11_11 /* !! */ .component1();
            if (StringsKt.endsWith((String)cur, (String)(target = (String)var11_11 /* !! */ .component2()), (boolean)true)) {
                potentialRemovablePrefixes.add(StringsKt.removeSuffix((String)cur, (CharSequence)target));
            }
            if (StringsKt.startsWith((String)cur, (String)target, (boolean)true)) {
                potentialRemovableSuffixes.add(StringsKt.removePrefix((String)cur, (CharSequence)target));
            }
            if (StringsKt.endsWith((String)target, (String)cur, (boolean)true)) {
                potentialAddablePrefixes.add(StringsKt.removeSuffix((String)target, (CharSequence)cur));
            }
            if (!StringsKt.startsWith((String)target, (String)cur, (boolean)true)) continue;
            potentialAddableSuffixes.add(StringsKt.removePrefix((String)target, (CharSequence)cur));
        }
        p0 = var11_11 /* !! */  = potentialRemovablePrefixes;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$1 = false;
        v0 = var10_10 /* !! */  = !((Collection)p0).isEmpty() != false ? var11_11 /* !! */  : null;
        if (var10_10 /* !! */  == null) ** GOTO lbl-1000
        p0 = (Iterable)var10_10 /* !! */ ;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            var16_68 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$2 = false;
            accumulator$iv /* !! */  = StringsKt.commonPrefixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        var11_11 /* !! */  = (String)accumulator$iv /* !! */ ;
        if (var11_11 /* !! */  == null) ** GOTO lbl-1000
        p0 = $i$f$reduce = var11_11 /* !! */ ;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$3 = false;
        v1 = $this$reduce$iv = ((CharSequence)p0).length() > 0 != false ? $i$f$reduce : null;
        if ($this$reduce$iv != null) {
            it = $this$reduce$iv;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$4 = false;
            v2 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.RemovePrefix((String)it));
        } else lbl-1000:
        // 3 sources

        {
            v2 = null;
        }
        p0 = var11_11 /* !! */  = potentialRemovableSuffixes;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$5 = false;
        v3 = var10_10 /* !! */  = !((Collection)p0).isEmpty() != false ? var11_11 /* !! */  : null;
        if (var10_10 /* !! */  == null) ** GOTO lbl-1000
        p0 = (Iterable)var10_10 /* !! */ ;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            p1 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$6 = false;
            accumulator$iv /* !! */  = StringsKt.commonSuffixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        var11_11 /* !! */  = (String)accumulator$iv /* !! */ ;
        if (var11_11 /* !! */  == null) ** GOTO lbl-1000
        p0 = $i$f$reduce = var11_11 /* !! */ ;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$7 = false;
        v4 = $this$reduce$iv = ((CharSequence)p0).length() > 0 != false ? $i$f$reduce : null;
        if ($this$reduce$iv != null) {
            it = $this$reduce$iv;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$8 = false;
            v5 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.RemoveSuffix((String)it));
        } else lbl-1000:
        // 3 sources

        {
            v5 = null;
        }
        p0 = var11_11 /* !! */  = potentialAddablePrefixes;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$9 = false;
        v6 = var10_10 /* !! */  = !((Collection)p0).isEmpty() != false ? var11_11 /* !! */  : null;
        if (var10_10 /* !! */  == null) ** GOTO lbl-1000
        p0 = (Iterable)var10_10 /* !! */ ;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            p1 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$10 = false;
            accumulator$iv /* !! */  = StringsKt.commonPrefixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        var11_11 /* !! */  = (String)accumulator$iv /* !! */ ;
        if (var11_11 /* !! */  == null) ** GOTO lbl-1000
        p0 = $i$f$reduce = var11_11 /* !! */ ;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$11 = false;
        v7 = $this$reduce$iv = ((CharSequence)p0).length() > 0 != false ? $i$f$reduce : null;
        if ($this$reduce$iv != null) {
            it = $this$reduce$iv;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$12 = false;
            v8 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.AddPrefix((String)it));
        } else lbl-1000:
        // 3 sources

        {
            v8 = null;
        }
        p0 = var11_11 /* !! */  = potentialAddableSuffixes;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$13 = false;
        v9 = var10_10 /* !! */  = !((Collection)p0).isEmpty() != false ? var11_11 /* !! */  : null;
        if (var10_10 /* !! */  == null) ** GOTO lbl-1000
        p0 = (Iterable)var10_10 /* !! */ ;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            p1 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$14 = 0;
            accumulator$iv /* !! */  = StringsKt.commonSuffixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        var11_11 /* !! */  = (String)accumulator$iv /* !! */ ;
        if (var11_11 /* !! */  == null) ** GOTO lbl-1000
        p0 = $i$f$reduce = var11_11 /* !! */ ;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$15 = false;
        v10 = $this$reduce$iv = ((CharSequence)p0).length() > 0 != false ? $i$f$reduce : null;
        if ($this$reduce$iv != null) {
            it = $this$reduce$iv;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$16 = false;
            v11 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.AddSuffix((String)it));
        } else lbl-1000:
        // 3 sources

        {
            v11 = null;
        }
        $this$reduce$iv = this.targetStrings;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            $i$a$-let-TransformationSearcher$generateNeighbors$1$16 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$17 = false;
            accumulator$iv /* !! */  = StringsKt.commonSuffixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        $this$reduce$iv = accumulator$iv /* !! */ ;
        p0 = (String)$this$reduce$iv;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$18 = false;
        v12 = (String)(((CharSequence)p0).length() > 0 != false ? $this$reduce$iv : null);
        if (v12 != null) {
            it = v12;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$19 = false;
            v13 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.AddSuffix(it));
        } else {
            v13 = null;
        }
        $this$reduce$iv = this.targetStrings;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            p1 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$20 = false;
            accumulator$iv /* !! */  = StringsKt.commonPrefixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        $this$reduce$iv = accumulator$iv /* !! */ ;
        p0 = (String)$this$reduce$iv;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$21 = false;
        v14 = (String)(((CharSequence)p0).length() > 0 != false ? $this$reduce$iv : null);
        if (v14 != null) {
            it = v14;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$22 = false;
            v15 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.AddPrefix(it));
        } else {
            v15 = null;
        }
        $this$reduce$iv = currentNode.getCurrentStrings();
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            p1 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$23 = false;
            accumulator$iv /* !! */  = StringsKt.commonSuffixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        $this$reduce$iv = accumulator$iv /* !! */ ;
        p0 = (String)$this$reduce$iv;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$24 = false;
        var10_10 /* !! */  = (String)(((CharSequence)p0).length() > 0 != false ? $this$reduce$iv : null);
        if (var10_10 /* !! */  != null) {
            it = var10_10 /* !! */ ;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$25 = false;
            v16 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.RemoveSuffix((String)it));
        } else {
            v16 = null;
        }
        $this$reduce$iv = currentNode.getCurrentStrings();
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv /* !! */  = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            p1 = (CharSequence)iterator$iv.next();
            p0 = (CharSequence)accumulator$iv /* !! */ ;
            $i$a$-reduce-TransformationSearcher$generateNeighbors$1$26 = false;
            accumulator$iv /* !! */  = StringsKt.commonPrefixWith$default((CharSequence)p0, (CharSequence)p1, (boolean)false, (int)2, null);
        }
        $this$reduce$iv = accumulator$iv /* !! */ ;
        p0 = (String)$this$reduce$iv;
        $i$a$-takeIf-TransformationSearcher$generateNeighbors$1$27 = false;
        var10_10 /* !! */  = (String)(((CharSequence)p0).length() > 0 != false ? $this$reduce$iv : null);
        if (var10_10 /* !! */  != null) {
            it = var10_10 /* !! */ ;
            $i$a$-let-TransformationSearcher$generateNeighbors$1$28 = false;
            v17 = $this$generateNeighbors_u24lambda_u2437.add(new Transformation.RemovePrefix((String)it));
        } else {
            v17 = null;
        }
        if (!(CollectionsKt.lastOrNull(currentNode.getPath()) instanceof Transformation.CaseTransformation)) {
            block69: {
                block68: {
                    block66: {
                        $this$all$iv = currentNode.getCurrentStrings();
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v18 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                block65: {
                                    it = (String)element$iv;
                                    $i$a$-all-TransformationSearcher$generateNeighbors$1$29 = false;
                                    $this$any$iv = (CharSequence)it;
                                    $i$f$any = false;
                                    for ($i$a$-reduce-TransformationSearcher$generateNeighbors$1$14 = 0; $i$a$-reduce-TransformationSearcher$generateNeighbors$1$14 < $this$any$iv.length(); ++$i$a$-reduce-TransformationSearcher$generateNeighbors$1$14) {
                                        p0 = element$iv = $this$any$iv.charAt($i$a$-reduce-TransformationSearcher$generateNeighbors$1$14);
                                        $i$a$-any-TransformationSearcher$generateNeighbors$1$29$1 = false;
                                        if (!Character.isUpperCase(p0)) continue;
                                        v19 = true;
                                        break block65;
                                    }
                                    v19 = false;
                                }
                                if (v19) continue;
                                v18 = false;
                                break block66;
                            }
                            v18 = true;
                        }
                    }
                    if (v18) {
                        $this$generateNeighbors_u24lambda_u2437.add(Transformation.ToLowerCase.INSTANCE);
                    }
                    $this$all$iv = currentNode.getCurrentStrings();
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v20 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            block67: {
                                it = (String)element$iv;
                                $i$a$-all-TransformationSearcher$generateNeighbors$1$30 = false;
                                $this$any$iv = (CharSequence)it;
                                $i$f$any = false;
                                for ($i$a$-reduce-TransformationSearcher$generateNeighbors$1$14 = 0; $i$a$-reduce-TransformationSearcher$generateNeighbors$1$14 < $this$any$iv.length(); ++$i$a$-reduce-TransformationSearcher$generateNeighbors$1$14) {
                                    p0 = element$iv = $this$any$iv.charAt($i$a$-reduce-TransformationSearcher$generateNeighbors$1$14);
                                    $i$a$-any-TransformationSearcher$generateNeighbors$1$30$1 = false;
                                    if (!Character.isLowerCase(p0)) continue;
                                    v21 = true;
                                    break block67;
                                }
                                v21 = false;
                            }
                            if (v21) continue;
                            v20 = false;
                            break block68;
                        }
                        v20 = true;
                    }
                }
                if (v20) {
                    $this$generateNeighbors_u24lambda_u2437.add(Transformation.ToUpperCase.INSTANCE);
                }
                $this$generateNeighbors_u24lambda_u2437.add(Transformation.ToTitleCase.INSTANCE);
                $this$generateNeighbors_u24lambda_u2437.add(Transformation.UpperCaseFirstChar.INSTANCE);
                $this$generateNeighbors_u24lambda_u2437.add(Transformation.LowerCaseFirstChar.INSTANCE);
                $this$any$iv = currentNode.getPath();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v22 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (Transformation)element$iv;
                        $i$a$-any-TransformationSearcher$generateNeighbors$1$31 = false;
                        if (!(it instanceof Transformation.CaseChange)) continue;
                        v22 = true;
                        break block69;
                    }
                    v22 = false;
                }
            }
            if (!v22) {
                $this$forEach$iv = com.google.tools.aiplugin.editor.prediction.grouping.transformation.TransformationSearcher$Companion.access$detectCommonCaseFormats(TransformationSearcher.Companion, currentNode.getCurrentStrings());
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (CaseFormat)element$iv;
                    $i$a$-forEach-TransformationSearcher$generateNeighbors$1$32 = false;
                    for (CaseFormat to : EntriesMappings.entries$0) {
                        if (it == to) continue;
                        $this$generateNeighbors_u24lambda_u2437.add(new Transformation.CaseChange((CaseFormat)it, to));
                    }
                }
            }
        }
        $this$filterNot$iv = TransformationSearcher.Companion.internalMaximalCommonSubsequences$aiplugin_editor_prediction_services(currentNode.getCurrentStrings());
        $i$f$filterNot = false;
        element$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            block70: {
                from = (CharSequence)element$iv$iv;
                $i$a$-filterNot-TransformationSearcher$generateNeighbors$1$fromCandidates$1 = false;
                p0 = CollectionsKt.lastOrNull(currentNode.getPath());
                v23 = p0 instanceof Transformation.Replace != false ? (Transformation.Replace)p0 : null;
                if (from.equals(v23 != null ? v23.getTo() : null)) ** GOTO lbl-1000
                $this$any$iv = this.targetStrings;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v24 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        $i$a$-any-TransformationSearcher$generateNeighbors$1$fromCandidates$1$1 = false;
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)from, (boolean)false, (int)2, null)) continue;
                        v24 = true;
                        break block70;
                    }
                    v24 = false;
                }
            }
            if (v24) lbl-1000:
            // 2 sources

            {
                v25 = true;
            } else {
                v25 = false;
            }
            if (v25) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fromCandidates = (List)destination$iv$iv;
        $this$filterNot$iv = TransformationSearcher.Companion.internalMaximalCommonSubsequences$aiplugin_editor_prediction_services(this.targetStrings);
        $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            block71: {
                to = (CharSequence)element$iv$iv;
                $i$a$-filterNot-TransformationSearcher$generateNeighbors$1$toCandidates$1 = false;
                $this$any$iv = currentNode.getCurrentStrings();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v26 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        $i$a$-any-TransformationSearcher$generateNeighbors$1$toCandidates$1$1 = false;
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)to, (boolean)false, (int)2, null)) continue;
                        v26 = true;
                        break block71;
                    }
                    v26 = false;
                }
            }
            if (v26) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        toCandidates = (List)destination$iv$iv;
        for (CharSequence from : fromCandidates) {
            for (CharSequence to : toCandidates) {
                $this$generateNeighbors_u24lambda_u2437.add(new Transformation.Replace(from.toString(), to.toString()));
            }
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.build((List)var2_2));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0001\u00a2\u0006\u0002\b\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher$Companion;", "", "<init>", "()V", "MAX_NUM_STRINGS", "", "MAX_STRING_LENGTH", "internalMaximalCommonSubsequences", "", "", "strings", "", "internalMaximalCommonSubsequences$aiplugin_editor_prediction_services", "detectCommonCaseFormats", "Lcom/google/common/base/CaseFormat;", "", "aiplugin.editor.prediction-services"})
    @SourceDebugExtension(value={"SMAP\nTransformationSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformationSearcher.kt\ncom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,353:1\n1761#2,3:354\n2393#2,14:357\n1740#2,3:371\n827#2:375\n855#2:376\n1740#2,3:377\n856#2:380\n1740#2,3:381\n1740#2,3:384\n1740#2,2:387\n1742#2:391\n1740#2,2:392\n1742#2:396\n1740#2,3:397\n1740#2,3:400\n1#3:374\n1855#4,2:389\n1855#4,2:394\n*S KotlinDebug\n*F\n+ 1 TransformationSearcher.kt\ncom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher$Companion\n*L\n242#1:354,3\n247#1:357,14\n266#1:371,3\n296#1:375\n296#1:376\n297#1:377,3\n296#1:380\n314#1:381,3\n315#1:384,3\n318#1:387,2\n318#1:391\n319#1:392,2\n319#1:396\n322#1:397,3\n323#1:400,3\n318#1:389,2\n319#1:394,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @VisibleForTesting
        @NotNull
        public final Set<CharSequence> internalMaximalCommonSubsequences$aiplugin_editor_prediction_services(@NotNull List<? extends CharSequence> strings) {
            block25: {
                Intrinsics.checkNotNullParameter(strings, (String)"strings");
                var2_2 = strings.size();
                if (!(2 <= var2_2 ? var2_2 < 11 : false)) {
                    return SetsKt.emptySet();
                }
                $this$any$iv = strings;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (CharSequence)element$iv;
                        $i$a$-any-TransformationSearcher$Companion$internalMaximalCommonSubsequences$1 = false;
                        var8_15 = it.length();
                        v1 = 1 <= var8_15 ? var8_15 < 21 : false;
                        if (!(v1 == false)) continue;
                        v0 = true;
                        break block25;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                return SetsKt.emptySet();
            }
            $this$minBy$iv = strings;
            $i$f$minByOrThrow = false;
            iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                it = (CharSequence)minElem$iv;
                $i$a$-minByOrThrow-TransformationSearcher$Companion$internalMaximalCommonSubsequences$shortestStr$1 = false;
                minValue$iv = it.length();
                do {
                    e$iv = iterator$iv.next();
                    it = (CharSequence)e$iv;
                    $i$a$-minByOrThrow-TransformationSearcher$Companion$internalMaximalCommonSubsequences$shortestStr$1 = false;
                    v$iv = it.length();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
            shortestStr = (CharSequence)v2;
            maximalCommonSubsequences = new LinkedHashSet<E>();
            i = 0;
            j = 1;
            currentCommonSubsequence = null;
            while (i < shortestStr.length() - 1 && j <= shortestStr.length()) {
                block26: {
                    candidate = shortestStr.subSequence(i, j);
                    $this$all$iv = strings;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v3 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (CharSequence)element$iv;
                            $i$a$-all-TransformationSearcher$Companion$internalMaximalCommonSubsequences$2 = false;
                            if (StringsKt.contains$default((CharSequence)it, (CharSequence)candidate, (boolean)false, (int)2, null)) continue;
                            v3 = false;
                            break block26;
                        }
                        v3 = true;
                    }
                }
                if (v3) {
                    currentCommonSubsequence = candidate;
                    ++j;
                    continue;
                }
                if (currentCommonSubsequence != null) {
                    $i$a$-let-TransformationSearcher$Companion$internalMaximalCommonSubsequences$3 = false;
                    maximalCommonSubsequences.add(p0);
                }
                currentCommonSubsequence = null;
                j = RangesKt.coerceAtLeast((int)j, (int)(++i + 1));
            }
            v4 = currentCommonSubsequence;
            if (v4 != null) {
                p0 = v4;
                $i$a$-let-TransformationSearcher$Companion$internalMaximalCommonSubsequences$4 = false;
                maximalCommonSubsequences.add(p0);
            }
            candidate = maximalCommonSubsequences;
            $i$f$filterNot = false;
            p0 = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                block28: {
                    block27: {
                        candidate = (CharSequence)element$iv$iv;
                        $i$a$-filterNot-TransformationSearcher$Companion$internalMaximalCommonSubsequences$5 = false;
                        $this$all$iv = strings;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v5 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                it = (CharSequence)element$iv;
                                $i$a$-all-TransformationSearcher$Companion$internalMaximalCommonSubsequences$5$1 = false;
                                if (StringsKt.endsWith$default((CharSequence)it, (CharSequence)candidate, (boolean)false, (int)2, null)) continue;
                                v5 = false;
                                break block27;
                            }
                            v5 = true;
                        }
                    }
                    if (v5) ** GOTO lbl-1000
                    $this$all$iv = strings;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v6 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (CharSequence)element$iv;
                            $i$a$-all-TransformationSearcher$Companion$internalMaximalCommonSubsequences$5$2 = false;
                            if (StringsKt.startsWith$default((CharSequence)it, (CharSequence)candidate, (boolean)false, (int)2, null)) continue;
                            v6 = false;
                            break block28;
                        }
                        v6 = true;
                    }
                }
                if (v6) lbl-1000:
                // 2 sources

                {
                    v7 = true;
                } else {
                    v7 = false;
                }
                if (v7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private final Set<CaseFormat> detectCommonCaseFormats(List<String> strings) {
            Set set;
            boolean bl;
            boolean allStartWithLowercase;
            boolean allHaveNoLowercase;
            boolean allHaveNoUppercase;
            boolean allHaveNoHyphens;
            boolean allHaveNoUnderscores;
            block33: {
                boolean bl2;
                block32: {
                    boolean bl3;
                    block31: {
                        boolean bl4;
                        block29: {
                            boolean bl5;
                            block27: {
                                boolean bl6;
                                block26: {
                                    if (strings.isEmpty()) {
                                        return SetsKt.emptySet();
                                    }
                                    Iterable $this$all$iv = strings;
                                    boolean $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        bl6 = true;
                                    } else {
                                        for (Object element$iv : $this$all$iv) {
                                            String it = (String)element$iv;
                                            boolean bl7 = false;
                                            if (!StringsKt.contains$default((CharSequence)it, (char)'_', (boolean)false, (int)2, null)) continue;
                                            bl6 = false;
                                            break block26;
                                        }
                                        bl6 = true;
                                    }
                                }
                                allHaveNoUnderscores = bl6;
                                Iterable $this$all$iv = strings;
                                boolean $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl5 = true;
                                } else {
                                    for (Object element$iv : $this$all$iv) {
                                        String it = (String)element$iv;
                                        boolean bl8 = false;
                                        if (!StringsKt.contains$default((CharSequence)it, (char)'-', (boolean)false, (int)2, null)) continue;
                                        bl5 = false;
                                        break block27;
                                    }
                                    bl5 = true;
                                }
                            }
                            allHaveNoHyphens = bl5;
                            Iterable $this$all$iv = strings;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl4 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    boolean bl9;
                                    block28: {
                                        String it = (String)element$iv;
                                        boolean bl10 = false;
                                        CharSequence $this$none$iv = it;
                                        boolean $i$f$none = false;
                                        for (int j = 0; j < $this$none$iv.length(); ++j) {
                                            char element$iv2;
                                            char p0 = element$iv2 = $this$none$iv.charAt(j);
                                            boolean bl11 = false;
                                            if (!Character.isUpperCase(p0)) continue;
                                            bl9 = false;
                                            break block28;
                                        }
                                        bl9 = true;
                                    }
                                    if (bl9) continue;
                                    bl4 = false;
                                    break block29;
                                }
                                bl4 = true;
                            }
                        }
                        allHaveNoUppercase = bl4;
                        Iterable $this$all$iv = strings;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                boolean bl12;
                                block30: {
                                    String it = (String)element$iv;
                                    boolean bl13 = false;
                                    CharSequence $this$none$iv = it;
                                    boolean $i$f$none = false;
                                    for (int j = 0; j < $this$none$iv.length(); ++j) {
                                        char element$iv3;
                                        char p0 = element$iv3 = $this$none$iv.charAt(j);
                                        boolean bl14 = false;
                                        if (!Character.isLowerCase(p0)) continue;
                                        bl12 = false;
                                        break block30;
                                    }
                                    bl12 = true;
                                }
                                if (bl12) continue;
                                bl3 = false;
                                break block31;
                            }
                            bl3 = true;
                        }
                    }
                    allHaveNoLowercase = bl3;
                    Iterable $this$all$iv = strings;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl15 = false;
                            if (((CharSequence)it).length() == 0 || Character.isLowerCase(StringsKt.first((CharSequence)it))) continue;
                            bl2 = false;
                            break block32;
                        }
                        bl2 = true;
                    }
                }
                allStartWithLowercase = bl2;
                Iterable $this$all$iv = strings;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl16 = false;
                        if (((CharSequence)it).length() == 0 || Character.isUpperCase(StringsKt.first((CharSequence)it))) continue;
                        bl = false;
                        break block33;
                    }
                    bl = true;
                }
            }
            boolean allStartWithUppercase = bl;
            Set $this$detectCommonCaseFormats_u24lambda_u2415 = set = SetsKt.createSetBuilder();
            boolean bl17 = false;
            if (allHaveNoUnderscores && allHaveNoUppercase) {
                $this$detectCommonCaseFormats_u24lambda_u2415.add(CaseFormat.LOWER_HYPHEN);
            }
            if (allHaveNoHyphens && allHaveNoUppercase) {
                $this$detectCommonCaseFormats_u24lambda_u2415.add(CaseFormat.LOWER_UNDERSCORE);
            }
            if (allHaveNoHyphens && allHaveNoLowercase) {
                $this$detectCommonCaseFormats_u24lambda_u2415.add(CaseFormat.UPPER_UNDERSCORE);
            }
            if (allHaveNoUnderscores && allHaveNoHyphens && allStartWithLowercase) {
                $this$detectCommonCaseFormats_u24lambda_u2415.add(CaseFormat.LOWER_CAMEL);
            }
            if (allHaveNoUnderscores && allHaveNoHyphens && allStartWithUppercase) {
                $this$detectCommonCaseFormats_u24lambda_u2415.add(CaseFormat.UPPER_CAMEL);
            }
            return SetsKt.build((Set)set);
        }

        public static final /* synthetic */ Set access$detectCommonCaseFormats(Companion $this, List strings) {
            return $this.detectCommonCaseFormats(strings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<CaseFormat> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])CaseFormat.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J3\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/grouping/transformation/TransformationSearcher$SearchNode;", "", "currentStrings", "", "", "path", "Lcom/google/tools/aiplugin/editor/prediction/grouping/transformation/Transformation;", "hCost", "", "<init>", "(Ljava/util/List;Ljava/util/List;I)V", "getCurrentStrings", "()Ljava/util/List;", "getPath", "getHCost", "()I", "gCost", "getGCost", "fCost", "getFCost", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "aiplugin.editor.prediction-services"})
    private static final class SearchNode
    implements Comparable<SearchNode> {
        @NotNull
        private final List<String> currentStrings;
        @NotNull
        private final List<Transformation> path;
        private final int hCost;
        private final int fCost;

        public SearchNode(@NotNull List<String> currentStrings, @NotNull List<? extends Transformation> path2, int hCost) {
            Intrinsics.checkNotNullParameter(currentStrings, (String)"currentStrings");
            Intrinsics.checkNotNullParameter(path2, (String)"path");
            this.currentStrings = currentStrings;
            this.path = path2;
            this.hCost = hCost;
            this.fCost = this.getGCost() + this.hCost;
        }

        @NotNull
        public final List<String> getCurrentStrings() {
            return this.currentStrings;
        }

        @NotNull
        public final List<Transformation> getPath() {
            return this.path;
        }

        public final int getHCost() {
            return this.hCost;
        }

        public final int getGCost() {
            return this.path.size();
        }

        public final int getFCost() {
            return this.fCost;
        }

        @Override
        public int compareTo(@NotNull SearchNode other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)this.fCost, (int)other.fCost);
        }

        @NotNull
        public final List<String> component1() {
            return this.currentStrings;
        }

        @NotNull
        public final List<Transformation> component2() {
            return this.path;
        }

        public final int component3() {
            return this.hCost;
        }

        @NotNull
        public final SearchNode copy(@NotNull List<String> currentStrings, @NotNull List<? extends Transformation> path2, int hCost) {
            Intrinsics.checkNotNullParameter(currentStrings, (String)"currentStrings");
            Intrinsics.checkNotNullParameter(path2, (String)"path");
            return new SearchNode(currentStrings, path2, hCost);
        }

        public static /* synthetic */ SearchNode copy$default(SearchNode searchNode, List list, List list2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = searchNode.currentStrings;
            }
            if ((n2 & 2) != 0) {
                list2 = searchNode.path;
            }
            if ((n2 & 4) != 0) {
                n = searchNode.hCost;
            }
            return searchNode.copy(list, list2, n);
        }

        @NotNull
        public String toString() {
            return "SearchNode(currentStrings=" + this.currentStrings + ", path=" + this.path + ", hCost=" + this.hCost + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.currentStrings).hashCode();
            result2 = result2 * 31 + ((Object)this.path).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.hCost);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SearchNode)) {
                return false;
            }
            SearchNode searchNode = (SearchNode)other;
            if (!Intrinsics.areEqual(this.currentStrings, searchNode.currentStrings)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.path, searchNode.path)) {
                return false;
            }
            return this.hCost == searchNode.hCost;
        }
    }
}

