/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.ChatBotEvent;
import com.android.tools.idea.studiobot.Status;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpHeaders;
import com.google.api.services.cloudcode_pa.v1internal.model.ServerProcessingDetails;
import com.google.cloud.tools.intellij.analytics.SendsEvents;
import com.google.cloud.tools.intellij.analytics.UsageTrackerBase;
import com.google.cloud.tools.intellij.hats.HatsActivationManagerBase;
import com.google.tools.intellij.aiplugin.analytics.ChatMetadata;
import com.google.tools.intellij.aiplugin.analytics.CompletionCitationMetricsMetadata;
import com.google.tools.intellij.aiplugin.analytics.CompletionCommonMetricsMetadata;
import com.google.tools.intellij.aiplugin.hats.HatsActivationManager;
import com.google.tools.intellij.aiplugin.oauth.AiPluginLoginService;
import com.google.tools.intellij.aiplugin.util.HttpCodeToGrpcStatusMapper;
import com.intellij.openapi.diagnostic.Logger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u0010&\u001a\u00020\u00002\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u0010\u0010(\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u0010)\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%J\u001a\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0010\u0010/\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/TrackingEvent;", "Lcom/google/cloud/tools/intellij/analytics/UsageTrackerBase$PingsAnalytics;", "eventSender", "Lcom/google/cloud/tools/intellij/analytics/SendsEvents;", "action", "", "(Lcom/google/cloud/tools/intellij/analytics/SendsEvents;Ljava/lang/String;)V", "metadataMap", "", "projectId", "traceId", "addChatMetadata", "chatMetadata", "Lcom/google/tools/intellij/aiplugin/analytics/ChatMetadata;", "addCompletionCitationMetadata", "citationMetadata", "Lcom/google/tools/intellij/aiplugin/analytics/CompletionCitationMetricsMetadata;", "addCompletionCommonMetadata", "language", "sessionIndex", "completionIndex", "addCompletionCommonMetricsMetadata", "metadata", "Lcom/google/tools/intellij/aiplugin/analytics/CompletionCommonMetricsMetadata;", "addFailureReason", "t", "", "addMetadata", "key", "value", "addProcessingDetails", "processingDetails", "Lcom/google/api/services/cloudcode_pa/v1internal/model/ServerProcessingDetails;", "addQueryBoxEventMetadata", "Lcom/android/studio/ml/ChatBotEvent$QueryBoxEventMetadata;", "addServerContext", "headers", "Lcom/google/api/client/http/HttpHeaders;", "addTierId", "tierId", "addTimingMetadata", "addTraceId", "getEffectiveCompletionMethod", "completionMethod", "ping", "", "setProjectId", "setTraceId", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTrackingEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackingEvent.kt\ncom/google/tools/intellij/aiplugin/analytics/TrackingEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
public final class TrackingEvent
implements UsageTrackerBase.PingsAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SendsEvents eventSender;
    @NotNull
    private final String action;
    @Nullable
    private String projectId;
    @Nullable
    private String traceId;
    @NotNull
    private final Map<String, String> metadataMap;
    public static final int $stable = 8;
    @NotNull
    private static final Logger logger;

    public TrackingEvent(@NotNull SendsEvents eventSender, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)eventSender, (String)"eventSender");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.eventSender = eventSender;
        this.action = action;
        this.metadataMap = new LinkedHashMap();
    }

    @NotNull
    public final TrackingEvent addCompletionCommonMetricsMetadata(@NotNull CompletionCommonMetricsMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.setProjectId(metadata.getProjectId());
        if (metadata.getResponseHeader() != null) {
            this.addTimingMetadata(metadata.getResponseHeader());
            this.addServerContext(metadata.getResponseHeader());
            this.addTraceId(metadata.getResponseHeader());
        }
        if (metadata.getProcessingDetails() != null) {
            this.addProcessingDetails(metadata.getProcessingDetails());
        }
        if (metadata.getCitationMetadata() != null) {
            this.addCompletionCitationMetadata(metadata.getCitationMetadata());
        }
        this.addMetadata("v2_completion_index", metadata.getCompletionIndex());
        this.addMetadata("v2_completion_method", this.getEffectiveCompletionMethod(metadata.getCompletionMethod(), metadata.getProcessingDetails()));
        this.addMetadata("v2_language", metadata.getLanguage());
        this.addMetadata("v2_ide_session_index", metadata.getIdeSessionIndex());
        this.addMetadata("v2_from_cache", String.valueOf(metadata.getFromCache()));
        this.addMetadata("v2_config_use_cloudcode_api", String.valueOf(metadata.getConfigUseCloudCodeApi()));
        return this;
    }

    @NotNull
    public final TrackingEvent addCompletionCitationMetadata(@NotNull CompletionCitationMetricsMetadata citationMetadata) {
        Intrinsics.checkNotNullParameter((Object)citationMetadata, (String)"citationMetadata");
        this.addMetadata("v2_citation_count", String.valueOf(citationMetadata.getCitationCount()));
        this.addMetadata("v2_prompt_citation_count", String.valueOf(citationMetadata.getPromptCitationCount()));
        this.addMetadata("v2_citation_count", String.valueOf(citationMetadata.getCitationCount()));
        this.addMetadata("v2_prompt_citation_count", String.valueOf(citationMetadata.getPromptCitationCount()));
        return this;
    }

    @NotNull
    public final TrackingEvent addMetadata(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.metadataMap.put(key, value);
        return this;
    }

    @NotNull
    public final TrackingEvent addTierId(@Nullable String tierId) {
        CharSequence charSequence = tierId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.addMetadata("tier_id", tierId);
        }
        return this;
    }

    @NotNull
    public final TrackingEvent setProjectId(@Nullable String projectId) {
        this.projectId = projectId;
        return this;
    }

    @NotNull
    public final TrackingEvent setTraceId(@Nullable String traceId) {
        CharSequence charSequence = traceId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.addMetadata("trace_id_set", "false");
        } else {
            this.traceId = traceId;
            this.addMetadata("trace_id_set", "true");
        }
        return this;
    }

    @Override
    public void ping() {
        HatsActivationManagerBase.recordActionInBackground$default(HatsActivationManager.Companion.getInstance(), this.action, null, null, 6, null);
        logger.debug("Sending event: aiplugin_intellij, " + this.action + ", " + this.metadataMap);
        String string = AiPluginLoginService.Companion.getInstance().getEmail();
        if (string == null) {
            Authenticator.UserInfo userInfo = Authenticator.Companion.current().getLoggedInUser();
            string = userInfo != null ? userInfo.getEmail() : null;
        }
        this.eventSender.sendEvent("aiplugin_intellij", this.action, string, this.projectId, this.metadataMap, this.traceId);
    }

    @NotNull
    public final TrackingEvent addCompletionCommonMetadata(@NotNull String language2, @NotNull String sessionIndex, @NotNull String completionIndex) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter((Object)sessionIndex, (String)"sessionIndex");
        Intrinsics.checkNotNullParameter((Object)completionIndex, (String)"completionIndex");
        return this.addMetadata("ide_session_index", sessionIndex).addMetadata("completion_index", completionIndex).addMetadata("language", language2);
    }

    @NotNull
    public final TrackingEvent addFailureReason(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.addMetadata("failure_reason", TrackingEvent.Companion.toFailureReason(t));
        return this;
    }

    @NotNull
    public final TrackingEvent addTimingMetadata(@Nullable HttpHeaders headers) {
        Object object;
        block6: {
            block5: {
                TrackingEvent trackingEvent;
                object = headers;
                if (object == null) break block5;
                HttpHeaders it = object;
                boolean bl = false;
                String string = TrackingEvent.Companion.getT4t7Time(it);
                if (string != null) {
                    String serverTiming = string;
                    boolean bl2 = false;
                    this.addMetadata("server_timing_t4t7", serverTiming);
                    trackingEvent = this.addMetadata("v2_server_timing_t4t7", serverTiming);
                } else {
                    trackingEvent = null;
                }
                object = trackingEvent;
                if (trackingEvent != null) break block6;
            }
            object = this;
        }
        return object;
    }

    @NotNull
    public final TrackingEvent addTraceId(@Nullable HttpHeaders headers) {
        block0: {
            Object object = headers;
            if (object == null || (object = Companion.getTraceId((HttpHeaders)object)) == null) break block0;
            Object p0 = object;
            boolean bl = false;
            this.setTraceId((String)p0);
        }
        return this;
    }

    @NotNull
    public final TrackingEvent addServerContext(@Nullable HttpHeaders headers) {
        Object object;
        block6: {
            block5: {
                TrackingEvent trackingEvent;
                object = headers;
                if (object == null) break block5;
                HttpHeaders it = object;
                boolean bl = false;
                String string = TrackingEvent.Companion.getServerContext(it);
                if (string != null) {
                    String serverContext = string;
                    boolean bl2 = false;
                    this.addMetadata("server_context", serverContext);
                    trackingEvent = this.addMetadata("v2_server_context", serverContext);
                } else {
                    trackingEvent = null;
                }
                object = trackingEvent;
                if (trackingEvent != null) break block6;
            }
            object = this;
        }
        return object;
    }

    @NotNull
    public final TrackingEvent addProcessingDetails(@Nullable ServerProcessingDetails processingDetails) {
        if (processingDetails != null) {
            this.addMetadata("automatic_generation", String.valueOf(Companion.isAutomaticGeneration(processingDetails)));
        }
        ServerProcessingDetails serverProcessingDetails = processingDetails;
        if ((serverProcessingDetails != null ? serverProcessingDetails.getR() : null) != null) {
            String string = processingDetails.getR();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getR(...)");
            this.addMetadata("rag_status", string);
            String string2 = processingDetails.getR();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getR(...)");
            this.addMetadata("v2_rag_status", string2);
        }
        return this;
    }

    @NotNull
    public final TrackingEvent addChatMetadata(@Nullable ChatMetadata chatMetadata) {
        block4: {
            if (chatMetadata == null) {
                return this;
            }
            String string = chatMetadata.getTraceId();
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                this.setTraceId(p0);
            }
            this.addMetadata("included_code", String.valueOf(chatMetadata.getIncludedCode()));
            this.addMetadata("citation_count", String.valueOf(chatMetadata.getCitationCount()));
            this.addMetadata("file_change_count", String.valueOf(chatMetadata.getWorkspaceChanges()));
            this.addMetadata("diff_code_block_count", String.valueOf(chatMetadata.getDiffCodeBlocks()));
            if (chatMetadata.getRemoteRepositoriesTotal() != null) {
                this.addMetadata("remote_repositories_total", chatMetadata.getRemoteRepositoriesTotal().toString());
            }
            if (chatMetadata.getRemoteRepositoriesMentioned() != null) {
                this.addMetadata("remote_repositories_mentioned", chatMetadata.getRemoteRepositoriesMentioned().toString());
            }
            String string2 = chatMetadata.getDetectedIntent();
            if (string2 == null) break block4;
            String it = string2;
            boolean bl = false;
            this.addMetadata("detected_intent", it);
        }
        return this.setProjectId(chatMetadata.getGcpProject());
    }

    @NotNull
    public final TrackingEvent addQueryBoxEventMetadata(@NotNull ChatBotEvent.QueryBoxEventMetadata metadata) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            this.addMetadata("context_type", String.valueOf(metadata.getAttachmentType()));
            this.addMetadata("input_source", String.valueOf(metadata.getInputSource()));
            Integer n = metadata.getAttachmentCount();
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.addMetadata("file_count", String.valueOf(it));
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getEffectiveCompletionMethod(String completionMethod, ServerProcessingDetails processingDetails) {
        if (Intrinsics.areEqual((Object)completionMethod, (Object)"CompleteCode")) {
            boolean bl;
            ServerProcessingDetails serverProcessingDetails = processingDetails;
            if (serverProcessingDetails != null) {
                if (Companion.isAutomaticGeneration(serverProcessingDetails)) {
                    return "AutomaticGeneration";
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return "AutomaticGeneration";
            }
        }
        String string = completionMethod;
        return string;
    }

    static {
        Logger logger = Logger.getInstance((String)"AiPluginTrackingEvent");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TrackingEvent.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002J\f\u0010\r\u001a\u0004\u0018\u00010\n*\u00020\u000bJ\f\u0010\u000e\u001a\u00020\n*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/TrackingEvent$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isAutomaticGeneration", "", "Lcom/google/api/services/cloudcode_pa/v1internal/model/ServerProcessingDetails;", "(Lcom/google/api/services/cloudcode_pa/v1internal/model/ServerProcessingDetails;)Z", "getServerContext", "", "Lcom/google/api/client/http/HttpHeaders;", "getT4t7Time", "getTraceId", "toFailureReason", "", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nTrackingEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackingEvent.kt\ncom/google/tools/intellij/aiplugin/analytics/TrackingEvent$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAutomaticGeneration(@NotNull ServerProcessingDetails $this$isAutomaticGeneration) {
            Intrinsics.checkNotNullParameter((Object)$this$isAutomaticGeneration, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isAutomaticGeneration.getCm(), (Object)"GENERATION");
        }

        private final String toFailureReason(Throwable $this$toFailureReason) {
            Object object;
            String errorName;
            String string = Reflection.getOrCreateKotlinClass($this$toFailureReason.getClass()).getSimpleName();
            if (string == null) {
                string = errorName = "unknown_exception";
            }
            if ($this$toFailureReason instanceof GoogleJsonResponseException) {
                Object object2;
                int n = ((GoogleJsonResponseException)$this$toFailureReason).getStatusCode();
                Status status2 = HttpCodeToGrpcStatusMapper.INSTANCE.map(((GoogleJsonResponseException)$this$toFailureReason).getStatusCode());
                if (((GoogleJsonResponseException)$this$toFailureReason).getDetails() != null && ((GoogleJsonResponseException)$this$toFailureReason).getDetails().getDetails() != null) {
                    Object object3;
                    Object object4 = ((GoogleJsonError.Details)((GoogleJsonResponseException)$this$toFailureReason).getDetails().getDetails().get(0)).get((Object)"domain");
                    if (object4 == null) {
                        object4 = "UNKNOWN_DOMAIN";
                    }
                    if ((object3 = ((GoogleJsonError.Details)((GoogleJsonResponseException)$this$toFailureReason).getDetails().getDetails().get(0)).get((Object)"reason")) == null) {
                        object3 = "UNKNOWN_REASON";
                    }
                    object2 = " " + object4 + "/" + object3;
                } else {
                    object2 = "";
                }
                object = errorName + " " + n + " " + status2 + (String)object2;
            } else {
                object = errorName;
            }
            return object;
        }

        private final String getT4t7Time(HttpHeaders $this$getT4t7Time) {
            Pattern gfet4t7Regex = Pattern.compile("gfet4t7; *dur=(\\d+)");
            Matcher matcher = gfet4t7Regex.matcher(String.valueOf($this$getT4t7Time.get((Object)"Server-Timing")));
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matchResult = matcher;
            if (matchResult.find(1)) {
                return matchResult.group(1);
            }
            return null;
        }

        private final String getServerContext(HttpHeaders $this$getServerContext) {
            Object object;
            Object object2 = $this$getServerContext.get((Object)"x-cloudaicompanion-server-context");
            if (object2 != null) {
                Object it = object2;
                boolean bl = false;
                object = it instanceof List ? (List)it : null;
                if (object == null || (object = (String)CollectionsKt.first((List)object)) == null) {
                    object = it.toString();
                }
            } else {
                object = null;
            }
            return object;
        }

        @Nullable
        public final String getTraceId(@NotNull HttpHeaders $this$getTraceId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$getTraceId, (String)"<this>");
            Object object2 = $this$getTraceId.get((Object)"x-cloudaicompanion-trace-id");
            if (object2 != null) {
                Object it = object2;
                boolean bl = false;
                object = it instanceof List ? (List)it : null;
                if (object == null || (object = (String)CollectionsKt.first((List)object)) == null) {
                    object = it.toString();
                }
            } else {
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

