/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.cloud.tools.intellij.analytics.IUsageTrackingManagement;
import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.google.tools.intellij.aiplugin.util.PluginInfoUtil;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.ApplicationKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/UsageTrackingManagementService;", "Lcom/google/cloud/tools/intellij/analytics/IUsageTrackingManagement;", "()V", "getInstallationId", "", "getLastInstalledPluginVersion", "hasUserOptedIn", "", "hasUserRecordedTrackingPreference", "initializeInstallationIdIfNull", "", "isTrackingEnabled", "isUsageTrackingAvailable", "resetInstallationId", "setPluginVersion", "setTrackingPreference", "optIn", "wipeoutAndCycleInstallationId", "Action", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
public final class UsageTrackingManagementService
implements IUsageTrackingManagement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String INSTALLATION_ID_KEY = "GEMINI_INTELLIJ_INSTALLATION_ID";
    @NotNull
    private static final String USAGE_TRACKER_KEY = "AIPLUGIN_USAGE_TRACKER_OPT_IN";
    @NotNull
    private static final String PLUGIN_VERSION_KEY = "AIPLUGIN_VERSION";

    @Override
    public void setTrackingPreference(boolean optIn) {
        PropertiesComponent.getInstance().setValue(USAGE_TRACKER_KEY, optIn, true);
        if (!optIn) {
            this.wipeoutAndCycleInstallationId();
        }
    }

    @Override
    public boolean hasUserOptedIn() {
        return PropertiesComponent.getInstance().getBoolean(USAGE_TRACKER_KEY, true);
    }

    @Override
    public boolean hasUserRecordedTrackingPreference() {
        return PropertiesComponent.getInstance().getValue(USAGE_TRACKER_KEY) != null;
    }

    @Override
    public boolean isUsageTrackingAvailable() {
        return !ApplicationKt.getApplication().isUnitTestMode();
    }

    @Override
    public boolean isTrackingEnabled() {
        return this.isUsageTrackingAvailable() && this.hasUserOptedIn();
    }

    @Override
    public void initializeInstallationIdIfNull() {
        if (PropertiesComponent.getInstance().getValue(INSTALLATION_ID_KEY) == null) {
            this.resetInstallationId();
        }
    }

    @Override
    public void wipeoutAndCycleInstallationId() {
        UsageTrackerService.Companion.getInstance().sendInstallIdWipeoutPing();
        this.resetInstallationId();
    }

    @Override
    @NotNull
    public String getInstallationId() {
        String string = PropertiesComponent.getInstance().getValue(INSTALLATION_ID_KEY);
        if (string == null) {
            string = this.resetInstallationId();
        }
        return string;
    }

    @Override
    public void setPluginVersion() {
        PropertiesComponent.getInstance().setValue(PLUGIN_VERSION_KEY, PluginInfoUtil.INSTANCE.getPluginVersion());
    }

    @Override
    @Nullable
    public String getLastInstalledPluginVersion() {
        return PropertiesComponent.getInstance().getValue(PLUGIN_VERSION_KEY);
    }

    private final String resetInstallationId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String installationId = string;
        PropertiesComponent.getInstance().setValue(INSTALLATION_ID_KEY, installationId);
        return installationId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/UsageTrackingManagementService$Action;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=0)
    public static final class Action
    extends AnAction {
        public static final int $stable = 8;

        public Action() {
            super("Set Last Plugin Version to 0.0.0");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PropertiesComponent.getInstance().setValue(UsageTrackingManagementService.PLUGIN_VERSION_KEY, "0.0.0");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/UsageTrackingManagementService$Companion;", "", "()V", "INSTALLATION_ID_KEY", "", "PLUGIN_VERSION_KEY", "USAGE_TRACKER_KEY", "getInstance", "Lcom/google/tools/intellij/aiplugin/analytics/UsageTrackingManagementService;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nUsageTrackingManagementService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageTrackingManagementService.kt\ncom/google/tools/intellij/aiplugin/analytics/UsageTrackingManagementService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,96:1\n40#2,3:97\n*S KotlinDebug\n*F\n+ 1 UsageTrackingManagementService.kt\ncom/google/tools/intellij/aiplugin/analytics/UsageTrackingManagementService$Companion\n*L\n78#1:97,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UsageTrackingManagementService getInstance() {
            boolean $i$f$service = false;
            Class<UsageTrackingManagementService> serviceClass$iv = UsageTrackingManagementService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (UsageTrackingManagementService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

