/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.cloud;

import com.android.studio.ml.Authenticator;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.cloud.tools.intellij.IntellijPluginCoreMessageBundle;
import com.google.cloud.tools.intellij.analytics.UsageTrackerBase;
import com.google.cloud.tools.intellij.login.GoogleLoginListener;
import com.google.cloud.tools.intellij.project.CloudProject;
import com.google.cloud.tools.intellij.project.FilteredTextTableCellRenderer;
import com.google.cloud.tools.intellij.ui.components.TableUtilKt;
import com.google.cloud.tools.intellij.util.DebouncedDocumentAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.tools.intellij.aiplugin.cloud.ProjectListTableModel;
import com.google.tools.intellij.aiplugin.cloud.ProjectLoader;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectSelectionDialogBase {
    private JTextField filterTextField;
    private JTable projectListTable;
    private JPanel centerPanel;
    protected ProjectSelectionDialogWrapper dialogWrapper;
    private JPanel centerPanelWrapper;
    private RefreshAction refreshAction;
    private ProjectListTableModel projectListTableModel;
    private JProgressBar progressBar;
    private ProjectLoader projectLoader = new ProjectLoader();
    private final Map<String, ProjectLoaderJob> runningProjectLoaderJobs = Maps.newHashMap();
    private final Map<String, String> selectedProjectsByAccount = Maps.newHashMap();
    private final Map<String, List<Project>> cachedProjectList = Maps.newHashMap();
    protected com.intellij.openapi.project.Project ideProject;
    protected boolean updateLoginProgressBarState = true;

    public ProjectSelectionDialogBase() {
        this.setup();
    }

    public void clearCachedProjectList() {
        this.cachedProjectList.clear();
    }

    public abstract Authenticator.UserInfo getActiveUser();

    public abstract boolean isLoggedIn();

    public abstract UsageTrackerBase.PingsAnalytics trackEvent(String var1, Map<String, String> var2);

    protected String getOkButtonText(boolean isSignedIn) {
        String message = isSignedIn ? IntellijPluginCoreMessageBundle.message("login.panel.sign.in.button.text.ok", new Object[0]) : IntellijPluginCoreMessageBundle.message("login.panel.sign.in.button.text", new Object[0]);
        return message;
    }

    private void setup() {
        this.createUIComponents();
        this.centerPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fillx, hidemode 3", "[left][grow][left]"));
        this.centerPanel.setMinimumSize(new Dimension(500, 200));
        this.centerPanel.setPreferredSize(new Dimension(700, 500));
        JLabel searchLabel = new JLabel(IntellijPluginCoreMessageBundle.message("cloud.project.selector.dialog.search.label", new Object[0]));
        this.centerPanel.add(searchLabel);
        this.centerPanel.add((Component)this.filterTextField, "growx, wrap");
        JBScrollPane projectScrollPane = new JBScrollPane();
        projectScrollPane.setViewportView(this.projectListTable);
        this.centerPanel.add((Component)projectScrollPane, "span, pushy, grow");
    }

    @Nullable
    public CloudProject showDialog(@Nullable CloudProject cloudProject, @Nullable com.intellij.openapi.project.Project ideProject) {
        this.ideProject = ideProject;
        if (this.dialogWrapper == null) {
            boolean isSignedIn = this.isLoggedIn();
            this.dialogWrapper = new ProjectSelectionDialogWrapper(isSignedIn);
            this.dialogWrapper.setTitle(IntellijPluginCoreMessageBundle.getString("cloud.project.selector.dialog.title", new Object[0]));
            this.installTableSpeedSearch(this.projectListTable);
            this.installProgressBar(this.dialogWrapper);
            ApplicationManager.getApplication().getMessageBus().connect(this.dialogWrapper.getDisposable()).subscribe(GoogleLoginListener.GOOGLE_LOGIN_LISTENER_TOPIC, () -> {
                this.loadAllProjects();
                this.dialogWrapper.updateOkButtonUiState(true);
            });
            this.filterTextField.getDocument().addDocumentListener((DocumentListener)((Object)new DebouncedDocumentAdapter(this.dialogWrapper.getDisposable()){

                @Override
                protected void debouncedTextChanged(DocumentEvent e) {
                    ProjectSelectionDialogBase.this.cancelCurrentUserRunningJob();
                    ProjectSelectionDialogBase.this.loadAllProjects();
                }
            }));
        }
        this.clearCachedProjectList();
        this.loadAllProjects();
        this.setSelectedProject(cloudProject);
        this.dialogWrapper.show();
        int result2 = this.dialogWrapper.getExitCode();
        if (result2 == 0) {
            this.trackEvent("cloudcode.project.selection", Collections.emptyMap()).ping();
            return this.getSelectedProject();
        }
        return null;
    }

    @VisibleForTesting
    void setSelectedProject(CloudProject cloudProject) {
        if (cloudProject != null && !Strings.isNullOrEmpty((String)cloudProject.googleUsername())) {
            Authenticator.UserInfo activeUser = this.getActiveUser();
            this.selectedProjectsByAccount.put(activeUser.getEmail(), cloudProject.projectName());
        }
    }

    @VisibleForTesting
    CloudProject getSelectedProject() {
        Authenticator.UserInfo user = this.getActiveUser();
        return CloudProject.Companion.create(this.getSelectedProjectName(), this.getSelectedProjectId(), this.getSelectedProjectNumber(), user.getEmail());
    }

    @VisibleForTesting
    void loadAllProjects() {
        if (!this.centerPanel.isShowing()) {
            this.centerPanelWrapper.add(this.centerPanel);
            this.dialogWrapper.validate();
            this.dialogWrapper.pack();
        }
        String filter2 = this.filterTextField.getText();
        this.loadProjectList(filter2);
    }

    private void loadProjectList(String filter2) {
        final Authenticator.UserInfo user = this.getActiveUser();
        final String cachedProjectListKey = String.join((CharSequence)"_", user.getEmail(), filter2);
        if (!this.cachedProjectList.containsKey(cachedProjectListKey) && this.runningProjectLoaderJobs.get(user.getEmail()) == null) {
            this.trackEvent("cloudcode.project.list.start", Collections.emptyMap()).ping();
            AtomicBoolean cancelled = new AtomicBoolean(false);
            ListenableFuture<List<Project>> futureResult = this.projectLoader.loadUserProjectsInBackground(filter2, cancelled);
            this.runningProjectLoaderJobs.put(user.getEmail(), new ProjectLoaderJob(futureResult, cancelled));
            this.addProjectListFutureCallback(futureResult, new FutureCallback<List<Project>>(){

                public void onSuccess(List<Project> projects) {
                    SwingUtilities.invokeLater(() -> {
                        ProjectSelectionDialogBase.this.runningProjectLoaderJobs.remove(user.getEmail());
                        ProjectSelectionDialogBase.this.cachedProjectList.put(cachedProjectListKey, projects);
                        ProjectSelectionDialogBase.this.refreshProjectListUi();
                    });
                    ProjectSelectionDialogBase.this.trackEvent("cloudcode.project.list.end", (Map<String, String>)ImmutableMap.of()).ping();
                }

                public void onFailure(@NotNull Throwable throwable) {
                    if (throwable instanceof CancellationException) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        ProjectSelectionDialogBase.this.runningProjectLoaderJobs.remove(user.getEmail());
                        String errorMessage = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getName());
                        ProjectSelectionDialogBase.this.dialogWrapper.setErrorText(errorMessage, ProjectSelectionDialogBase.this.projectListTable);
                        ProjectSelectionDialogBase.this.refreshProjectListUi();
                    });
                    ProjectSelectionDialogBase.this.trackEvent("cloudcode.project.list.end", Collections.singletonMap("success", Boolean.FALSE.toString())).ping();
                }
            });
            this.refreshProjectListUi();
        } else {
            this.refreshProjectListUi();
        }
    }

    private void refreshProjectListUi() {
        Authenticator.UserInfo user = this.getActiveUser();
        String filter2 = this.filterTextField.getText();
        String cachedProjectListKey = String.join((CharSequence)"_", user.getEmail(), filter2);
        if (this.cachedProjectList.containsKey(cachedProjectListKey)) {
            this.setLoading(false);
            this.projectListTableModel.setProjectList(this.cachedProjectList.get(cachedProjectListKey));
            this.showProjectInList(this.selectedProjectsByAccount.get(user.getEmail()));
        } else {
            this.projectListTableModel.setProjectList(Collections.emptyList());
        }
        if (this.runningProjectLoaderJobs.get(user.getEmail()) != null) {
            this.setLoading(true);
        }
    }

    @VisibleForTesting
    void setLoading(boolean loading) {
        TableUtilKt.configureEmptyText((JBTable)this.projectListTable, loading, IntellijPluginCoreMessageBundle.message("table.default.loading", new Object[0]), IntellijPluginCoreMessageBundle.message("table.default.empty", new Object[0]));
        this.progressBar.setVisible(loading);
        int progressBarLength = 150;
        this.progressBar.setBounds(this.dialogWrapper.getSize().width / 2 - progressBarLength / 2, this.dialogWrapper.getSize().height / 2, progressBarLength, this.progressBar.getPreferredSize().height);
    }

    @VisibleForTesting
    void createUIComponents() {
        this.projectListTable = new JBTable();
        this.projectListTableModel = new ProjectListTableModel();
        this.projectListTable.setModel(this.projectListTableModel);
        this.projectListTable.setSelectionMode(0);
        this.projectListTable.getSelectionModel().addListSelectionListener(e -> this.validateProjectSelection());
        FilteredTextTableCellRenderer filterRenderer = new FilteredTextTableCellRenderer();
        this.projectListTable.setDefaultRenderer(Object.class, filterRenderer);
        DoubleClickListener tableDoubleClickListener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ProjectSelectionDialogBase.this.dialogWrapper.clickDefaultButton();
                return true;
            }
        };
        tableDoubleClickListener.installOn((Component)this.projectListTable);
        this.filterTextField = new JBTextField();
        TableRowSorter<ProjectListTableModel> sorter = new TableRowSorter<ProjectListTableModel>(this.projectListTableModel);
        this.projectListTable.setRowSorter(sorter);
        this.refreshAction = new RefreshAction();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.centerPanelWrapper = new JPanel(new BorderLayout());
    }

    @VisibleForTesting
    void installTableSpeedSearch(JTable projectListTable) {
        new TableSpeedSearch(projectListTable){

            protected void selectElement(Object element, String selectedText) {
                super.selectElement(element, selectedText);
                ProjectSelectionDialogBase.this.filterTextField.setText(selectedText);
            }
        };
    }

    private void installProgressBar(ProjectSelectionDialogWrapper dialogWrapper) {
        dialogWrapper.getRootPane().getLayeredPane().add((Component)this.progressBar, JLayeredPane.DRAG_LAYER);
    }

    private void validateProjectSelection() {
        int selectedRow = this.projectListTable.getSelectedRow();
        int visibleRowCount = this.projectListTable.getRowSorter().getViewRowCount();
        if (selectedRow >= 0 && selectedRow < visibleRowCount) {
            this.dialogWrapper.setOKActionEnabled(true);
            this.selectedProjectsByAccount.put(this.getActiveUser().getEmail(), this.getSelectedProjectName());
        } else if (selectedRow < 0) {
            this.dialogWrapper.setOKActionEnabled(false);
            this.selectedProjectsByAccount.remove(this.getActiveUser().getEmail());
        }
    }

    @VisibleForTesting
    void showProjectInList(String projectName) {
        for (int i2 = 0; i2 < this.projectListTableModel.getRowCount(); ++i2) {
            String projectNameAtRow = this.projectListTableModel.getProjectNameAtRow(i2);
            if (!projectNameAtRow.equals(projectName)) continue;
            this.projectListTable.getSelectionModel().setSelectionInterval(i2, i2);
            this.projectListTable.scrollRectToVisible(this.projectListTable.getCellRect(i2, 0, true));
            break;
        }
    }

    @VisibleForTesting
    String getSelectedProjectName() {
        int actualSelectedRow = this.projectListTable.getRowSorter().convertRowIndexToModel(this.projectListTable.getSelectedRow());
        return this.projectListTableModel.getProjectNameAtRow(actualSelectedRow);
    }

    @VisibleForTesting
    String getSelectedProjectId() {
        int actualSelectedRow = this.projectListTable.getRowSorter().convertRowIndexToModel(this.projectListTable.getSelectedRow());
        return this.projectListTableModel.getProjectIdAtRow(actualSelectedRow);
    }

    @VisibleForTesting
    Long getSelectedProjectNumber() {
        int actualSelectedRow = this.projectListTable.getRowSorter().convertRowIndexToModel(this.projectListTable.getSelectedRow());
        return this.projectListTableModel.getProjectNumberAtRow(actualSelectedRow);
    }

    @VisibleForTesting
    JButton getDialogButton(@NotNull Action action) {
        return this.dialogWrapper.getButton(action);
    }

    @VisibleForTesting
    JTable getProjectListTable() {
        return this.projectListTable;
    }

    @VisibleForTesting
    ProjectListTableModel getProjectListTableModel() {
        return this.projectListTableModel;
    }

    @VisibleForTesting
    JPanel getCenterPanelWrapper() {
        return this.centerPanelWrapper;
    }

    @VisibleForTesting
    void setProjectLoader(ProjectLoader projectLoader) {
        this.projectLoader = projectLoader;
    }

    @VisibleForTesting
    void setDialogWrapper(ProjectSelectionDialogWrapper dialogWrapper) {
        this.dialogWrapper = dialogWrapper;
    }

    @VisibleForTesting
    void addProjectListFutureCallback(ListenableFuture<List<Project>> future, FutureCallback<List<Project>> callback2) {
        Futures.addCallback(future, callback2, (Executor)MoreExecutors.directExecutor());
    }

    private void cancelCurrentUserRunningJob() {
        Authenticator.UserInfo user = this.getActiveUser();
        String userEmail = user.getEmail();
        ProjectLoaderJob runningJob = this.runningProjectLoaderJobs.get(userEmail);
        if (runningJob != null) {
            runningJob.future.cancel(false);
            runningJob.cancelled.set(true);
            this.runningProjectLoaderJobs.remove(userEmail);
        }
    }

    protected class ProjectSelectionDialogWrapper
    extends DialogWrapper {
        private ProjectSelectionDialogWrapper(boolean isSignedIn) {
            super(false);
            this.init();
            this.updateOkButtonUiState(isSignedIn);
        }

        protected void updateOkButtonUiState(boolean isSignedIn) {
            this.setOKActionEnabled(!isSignedIn);
            this.setOKButtonText(ProjectSelectionDialogBase.this.getOkButtonText(isSignedIn));
        }

        public void doCancelAction() {
            ProjectSelectionDialogBase.this.updateLoginProgressBarState = false;
            ProjectSelectionDialogBase.this.cancelCurrentUserRunningJob();
            super.doCancelAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return ProjectSelectionDialogBase.this.centerPanelWrapper;
        }

        protected void setErrorText(@Nullable String text2, @Nullable JComponent component2) {
            if (!this.isDisposed()) {
                super.setErrorText(text2, component2);
            }
        }

        @NotNull
        protected @NotNull Action @NotNull [] createLeftSideActions() {
            return new Action[]{ProjectSelectionDialogBase.this.refreshAction};
        }

        public void setOKActionEnabled(boolean isEnabled) {
            super.setOKActionEnabled(isEnabled);
        }

        @Nullable
        protected JButton getButton(@NotNull Action action) {
            return super.getButton(action);
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return ProjectSelectionDialogBase.this.filterTextField;
        }
    }

    private static class ProjectLoaderJob {
        private final ListenableFuture<List<Project>> future;
        private final AtomicBoolean cancelled;

        private ProjectLoaderJob(ListenableFuture<List<Project>> future, AtomicBoolean cancelled) {
            this.future = future;
            this.cancelled = cancelled;
        }
    }

    private final class RefreshAction
    extends AbstractAction {
        private RefreshAction() {
            this.putValue("SmallIcon", AllIcons.Actions.Refresh);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectSelectionDialogBase.this.clearCachedProjectList();
            ProjectSelectionDialogBase.this.loadAllProjects();
        }
    }
}

