/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.completion.SuggestionLine;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00102\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/SuggestionLineRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "suggestionLine", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isSelected", "", "(Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;Lcom/intellij/openapi/editor/Editor;Z)V", "getSuggestionLine", "()Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public final class SuggestionLineRenderer
implements EditorCustomElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SuggestionLine suggestionLine;
    @NotNull
    private final Editor editor;
    private final boolean isSelected;
    public static final int $stable = 8;
    private static final int SELECTED_GHOST_TEXT_ALPHA = 192;
    private static final int UNSELECTED_GHOST_TEXT_ALPHA = 128;
    private static final int SELECTED_BACKGROUND_ALPHA = 64;

    public SuggestionLineRenderer(@NotNull SuggestionLine suggestionLine, @NotNull Editor editor2, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)suggestionLine, (String)"suggestionLine");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.suggestionLine = suggestionLine;
        this.editor = editor2;
        this.isSelected = isSelected;
    }

    public /* synthetic */ SuggestionLineRenderer(SuggestionLine suggestionLine, Editor editor2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(suggestionLine, editor2, bl);
    }

    @NotNull
    public final SuggestionLine getSuggestionLine() {
        return this.suggestionLine;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Font font = this.editor.getColorsScheme().getFont(EditorFontType.ITALIC);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font italicFont = font;
        FontMetrics fontMetrics = this.editor.getContentComponent().getFontMetrics(italicFont);
        String text2 = ((CharSequence)this.suggestionLine.getText()).length() == 0 ? " " : this.suggestionLine.getText();
        return fontMetrics.stringWidth(text2);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        g.setFont(this.editor.getColorsScheme().getFont(EditorFontType.ITALIC));
        if (this.isSelected) {
            Color color = new Color(90, 150, 90);
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 64));
            g.fillRect(targetRegion.x, targetRegion.y, targetRegion.width, targetRegion.height);
            EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.Companion.getInstance();
            Project project2 = this.editor.getProject();
            FileType fileType = this.editor.getVirtualFile().getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
            EditorHighlighter highlighter2 = editorHighlighterFactory.createEditorHighlighter(project2, fileType);
            highlighter2.setText((CharSequence)this.suggestionLine.getText());
            HighlighterIterator highlighterIterator = highlighter2.createIterator(0);
            Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
            HighlighterIterator iterator = highlighterIterator;
            int currentX = targetRegion.x;
            while (!iterator.atEnd()) {
                String text2;
                TextAttributes attributes = iterator.getTextAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)this.suggestionLine.getText().substring(iterator.getStart(), iterator.getEnd()), (String)"substring(...)");
                Color color2 = attributes.getForegroundColor();
                if (color2 == null) {
                    Color color3 = this.editor.getColorsScheme().getDefaultForeground();
                    color2 = color3;
                    Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getDefaultForeground(...)");
                }
                Color color4 = color2;
                g.setColor(new Color(color4.getRed(), color4.getGreen(), color4.getBlue(), 192));
                g.drawString(text2, currentX, targetRegion.y + this.editor.getAscent());
                currentX += g.getFontMetrics().stringWidth(text2);
                iterator.advance();
            }
        } else {
            Color it = this.editor.getColorsScheme().getDefaultForeground();
            boolean bl = false;
            g.setColor(new Color(it.getRed(), it.getGreen(), it.getBlue(), 128));
            g.drawString(this.suggestionLine.getText(), targetRegion.x, targetRegion.y + this.editor.getAscent());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/SuggestionLineRenderer$Companion;", "", "()V", "SELECTED_BACKGROUND_ALPHA", "", "SELECTED_GHOST_TEXT_ALPHA", "UNSELECTED_GHOST_TEXT_ALPHA", "aiplugin.ij-platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

