/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.completion.SmlInlineCompletionInlayManager;
import com.google.tools.intellij.aiplugin.completion.EditorUtilsKt;
import com.google.tools.intellij.aiplugin.completion.GutterIconRenderer;
import com.google.tools.intellij.aiplugin.completion.LoadingIndicator;
import com.google.tools.intellij.aiplugin.completion.LoadingIndicatorRenderer;
import com.google.tools.intellij.aiplugin.completion.Suggestion;
import com.google.tools.intellij.aiplugin.completion.SuggestionLine;
import com.google.tools.intellij.aiplugin.completion.SuggestionLineRenderer;
import com.google.tools.intellij.aiplugin.completion.SuggestionSession;
import com.google.tools.intellij.aiplugin.completion.SuggestionUIFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0016J\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0016\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\fJ\u0016\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/SuggestionRenderer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "decoratorInlay", "Lcom/intellij/openapi/editor/Inlay;", "loadingIndicator", "Lcom/google/tools/intellij/aiplugin/completion/LoadingIndicator;", "loadingRender", "Lcom/google/tools/intellij/aiplugin/completion/LoadingIndicatorRenderer;", "addGutterIcon", "", "suggestionLine", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;", "lineDelta", "", "createSuggestionInlay", "renderer", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionLineRenderer;", "dispose", "hideLoadingIndicator", "hideSuggestionDecorator", "isLoadingIndicationVisible", "", "redrawSuggestions", "suggestions", "", "Lcom/google/tools/intellij/aiplugin/completion/Suggestion;", "showHintInlay", "suggestion", "sessionStatus", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionSession$SessionStatus;", "showLoadingIndicator", "showSuggestionDecorator", "firstSuggestionLine", "totalSuggestions", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSuggestionRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestionRenderer.kt\ncom/google/tools/intellij/aiplugin/completion/SuggestionRenderer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n24#2:207\n1#3:208\n*S KotlinDebug\n*F\n+ 1 SuggestionRenderer.kt\ncom/google/tools/intellij/aiplugin/completion/SuggestionRenderer\n*L\n48#1:207\n*E\n"})
public final class SuggestionRenderer
implements Disposable {
    @NotNull
    private final Editor editor;
    @Nullable
    private Inlay<?> decoratorInlay;
    @NotNull
    private final LoadingIndicatorRenderer loadingRender;
    @NotNull
    private LoadingIndicator loadingIndicator;
    public static final int $stable = 8;

    public SuggestionRenderer(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.loadingRender = new LoadingIndicatorRenderer(this.editor);
        this.loadingIndicator = new LoadingIndicator();
    }

    public final void redrawSuggestions(@NotNull List<Suggestion> suggestions) {
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        int lineDelta = 0;
        boolean isFirstSuggestion = true;
        try {
            for (Suggestion suggestion : suggestions) {
                if (!suggestion.isShowing()) continue;
                for (SuggestionLine suggestionLine : suggestion.getSuggestionLines()) {
                    this.createSuggestionInlay(new SuggestionLineRenderer(suggestionLine, this.editor, suggestion.isNext()), lineDelta);
                    if (!isFirstSuggestion) continue;
                    this.addGutterIcon(suggestionLine, lineDelta);
                    isFirstSuggestion = false;
                }
                lineDelta += suggestion.getLineDelta();
            }
        }
        catch (Throwable t) {
            SuggestionRenderer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SuggestionRenderer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to redraw suggestions", t);
            this.dispose();
        }
    }

    public final void showHintInlay(@NotNull Suggestion suggestion, @NotNull SuggestionSession.SessionStatus sessionStatus) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)((Object)sessionStatus), (String)"sessionStatus");
        SuggestionLine suggestionLine = (SuggestionLine)CollectionsKt.firstOrNull(suggestion.getSuggestionLines());
        if (suggestionLine == null) {
            return;
        }
        SuggestionLine suggestionLine2 = suggestionLine;
        if (sessionStatus == SuggestionSession.SessionStatus.ACCEPTING_SUGGESTIONS) {
            int targetLine = suggestionLine2.getAtLine();
            if (targetLine >= this.editor.getDocument().getLineCount()) {
                return;
            }
            Integer n2 = suggestionLine2.getInlineOffset();
            int targetColumn = n2 != null ? n2 : 0;
            LogicalPosition targetPosition = new LogicalPosition(targetLine, targetColumn);
            Point point = this.editor.logicalPositionToXY(targetPosition);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"logicalPositionToXY(...)");
            Point targetPoint = point;
            Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            this.editor.getCaretModel().moveToLogicalPosition(targetPosition);
            if (!visibleArea.contains(targetPoint)) {
                this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        }
        if (suggestionLine2.isDeletion()) {
            RangeHighlighter rangeHighlighter = suggestionLine2.getHighlighter();
            n = (rangeHighlighter != null ? rangeHighlighter.getStartOffset() : 1) - 1;
        } else {
            Inlay<?> inlay = suggestionLine2.getInlay();
            n = inlay != null ? Integer.valueOf(inlay.getOffset()) : null;
        }
        Integer hintOffset = n;
        InlayPresentation customHint = SuggestionUIFactory.INSTANCE.createAcceptDismissHint(this.editor);
        SmlInlineCompletionInlayManager.Companion.show(this.editor, hintOffset, customHint);
    }

    private final void createSuggestionInlay(SuggestionLineRenderer renderer2, int lineDelta) {
        block5: {
            SuggestionLine suggestionLine;
            block4: {
                Color it;
                Color baseBgColor;
                suggestionLine = renderer2.getSuggestionLine();
                if (!suggestionLine.isInline() && !suggestionLine.isDeletion()) break block4;
                TextAttributes attribute = this.editor.getColorsScheme().getAttributes(EditorColors.DELETED_TEXT_ATTRIBUTES);
                attribute.setFontType(2);
                Color color = baseBgColor = attribute.getBackgroundColor();
                if (color != null) {
                    it = color;
                    boolean bl = false;
                    attribute.setBackgroundColor(new Color(it.getRed(), it.getGreen(), it.getBlue(), 64));
                }
                int offset2 = EditorUtilsKt.getInlineSuggestionLineOffset(this.editor, suggestionLine, lineDelta);
                if (offset2 == -1) {
                    return;
                }
                if (!suggestionLine.isDeletion() && (it = this.editor.getInlayModel().addInlineElement(offset2 + suggestionLine.getToReplace().length(), true, (EditorCustomElementRenderer)renderer2)) != null) {
                    Color it2 = it;
                    boolean bl = false;
                    suggestionLine.setInlay((Inlay<?>)it2);
                }
                RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(offset2, offset2 + suggestionLine.getToReplace().length(), 1, attribute, HighlighterTargetArea.EXACT_RANGE);
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                suggestionLine.setHighlighter(rangeHighlighter, this.editor);
                break block5;
            }
            int offset3 = EditorUtilsKt.getBlockSuggestionLineOffset(this.editor, suggestionLine, lineDelta);
            if (offset3 == -1) {
                return;
            }
            Inlay inlay = this.editor.getInlayModel().addBlockElement(offset3, true, offset3 == 0, 1, (EditorCustomElementRenderer)renderer2);
            if (inlay == null) break block5;
            Inlay it = inlay;
            boolean bl = false;
            suggestionLine.setInlay(it);
        }
    }

    private final void addGutterIcon(SuggestionLine suggestionLine, int lineDelta) {
        int atLine = suggestionLine.getAtLine() - lineDelta;
        if (!suggestionLine.isInline() && !suggestionLine.isDeletion()) {
            --atLine;
        }
        if (atLine < 0 || atLine >= this.editor.getDocument().getLineCount()) {
            return;
        }
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(this.editor.getDocument().getLineStartOffset(atLine), this.editor.getDocument().getLineStartOffset(atLine), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter2 = rangeHighlighter;
        highlighter2.setGutterIconRenderer((com.intellij.openapi.editor.markup.GutterIconRenderer)GutterIconRenderer.INSTANCE);
        suggestionLine.setGutterHighlighter(highlighter2, this.editor);
    }

    public final void hideSuggestionDecorator() {
        Inlay<?> inlay = this.decoratorInlay;
        if (inlay != null) {
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.decoratorInlay = null;
    }

    public final void showSuggestionDecorator(@NotNull SuggestionLine firstSuggestionLine, int totalSuggestions) {
        int caretLine;
        Intrinsics.checkNotNullParameter((Object)firstSuggestionLine, (String)"firstSuggestionLine");
        int suggestionLineNum = firstSuggestionLine.getAtLine() + 1;
        if (!firstSuggestionLine.isInline() && !firstSuggestionLine.isDeletion()) {
            --suggestionLineNum;
        }
        String arrow = suggestionLineNum > (caretLine = this.editor.getCaretModel().getLogicalPosition().line) ? "\u25bc" : "\u25b2";
        boolean lineIsVisible = EditorUtilsKt.isLineVisible(this.editor, suggestionLineNum - 1);
        String hintText = lineIsVisible ? (totalSuggestions > 1 ? "Multiple suggestions " + arrow + " " : "Suggestion " + arrow + " ") : (totalSuggestions > 1 ? "Multiple suggestions. Start at line " + suggestionLineNum + " " + arrow + " " : "Suggestion at line " + suggestionLineNum + " " + arrow + " ");
        ApplicationManager.getApplication().runReadAction(() -> SuggestionRenderer.showSuggestionDecorator$lambda$5(this, hintText));
    }

    public final void showLoadingIndicator() {
        WriteCommandAction.runWriteCommandAction((Project)this.editor.getProject(), () -> SuggestionRenderer.showLoadingIndicator$lambda$7(this));
    }

    public final void hideLoadingIndicator() {
        WriteCommandAction.runWriteCommandAction((Project)this.editor.getProject(), () -> SuggestionRenderer.hideLoadingIndicator$lambda$8(this));
    }

    public final boolean isLoadingIndicationVisible() {
        return this.loadingIndicator.getInlay() != null;
    }

    public void dispose() {
        this.hideSuggestionDecorator();
        this.hideLoadingIndicator();
    }

    private static final void showSuggestionDecorator$lambda$5(SuggestionRenderer this$0, String $hintText) {
        block0: {
            Inlay inlay;
            InlayPresentation finalPresentation = SuggestionUIFactory.INSTANCE.createDecoratorAcceptDismissHint(this$0.editor, $hintText);
            PresentationRenderer renderer2 = new PresentationRenderer(finalPresentation);
            Inlay inlay2 = inlay = this$0.editor.getInlayModel().addAfterLineEndElement(this$0.editor.getCaretModel().getOffset(), false, (EditorCustomElementRenderer)renderer2);
            if (inlay2 == null) break block0;
            Inlay it = inlay2;
            boolean bl = false;
            this$0.decoratorInlay = it;
            Disposer.register((Disposable)this$0, (Disposable)((Disposable)it));
        }
    }

    private static final void showLoadingIndicator$lambda$7(SuggestionRenderer this$0) {
        block0: {
            int currentLine = this$0.editor.getCaretModel().getLogicalPosition().line;
            int endOfLineOffset = this$0.editor.getDocument().getLineEndOffset(currentLine);
            this$0.loadingRender.resetAndStart();
            Inlay inlay = this$0.editor.getInlayModel().addInlineElement(endOfLineOffset, true, (EditorCustomElementRenderer)this$0.loadingRender);
            if (inlay == null) break block0;
            Inlay it = inlay;
            boolean bl = false;
            this$0.loadingIndicator.setInlay(it);
        }
    }

    private static final void hideLoadingIndicator$lambda$8(SuggestionRenderer this$0) {
        this$0.loadingIndicator.dispose();
    }
}

