/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.onboarding;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.bot.configuration.StudioBotAppSettings;
import com.android.studio.ml.bot.configuration.StudioBotSettingsNotificationService;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.google.common.annotations.VisibleForTesting;
import com.google.tools.intellij.aiplugin.CaicProjectService;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.analytics.AiPluginOnboardingSessionTracking;
import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.google.tools.intellij.aiplugin.experimentation.ExperimentationCacheService;
import com.google.tools.intellij.aiplugin.experimentation.ExperimentationFlagsService;
import com.google.tools.intellij.aiplugin.experimentation.ExperimentationFlagsServiceKt;
import com.google.tools.intellij.aiplugin.flag.FeatureFlagsService;
import com.google.tools.intellij.aiplugin.notification.AiPluginGotItToolTipsService;
import com.google.tools.intellij.aiplugin.onboarding.HealthChecker;
import com.google.tools.intellij.aiplugin.state.AiPluginSettingsProvider;
import com.google.tools.intellij.aiplugin.tier.UserTierService;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J2\u0010\u001f\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010 \u001a\u00020!2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/google/tools/intellij/aiplugin/onboarding/AiPluginOnboardingState;", "Lcom/android/studio/ml/bot/ui/onboarding/OnboardingState;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "_currentState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/studio/ml/bot/ui/onboarding/OnboardingState$State;", "_resetOnboarding", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "currentState", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentState", "()Lkotlinx/coroutines/flow/StateFlow;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "restartOnboarding", "Lkotlinx/coroutines/flow/SharedFlow;", "getRestartOnboarding", "()Lkotlinx/coroutines/flow/SharedFlow;", "calculateCurrentState", "authState", "Lcom/android/studio/ml/Authenticator$AuthState;", "currentProject", "", "userTierState", "Lcom/google/tools/intellij/aiplugin/tier/UserTierService$State;", "clearOnboardingRelatedSettings", "project", "Lcom/intellij/openapi/project/Project;", "getStatusBarDescription", "flags", "Lcom/google/tools/intellij/aiplugin/experimentation/ExperimentationCacheService$Flags;", "setUserHasCompletedOnboarding", "setUserHasNotCompletedOnboarding", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAiPluginOnboardingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginOnboardingState.kt\ncom/google/tools/intellij/aiplugin/onboarding/AiPluginOnboardingState\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,258:1\n24#2:259\n40#3,3:260\n40#3,3:263\n40#3,3:266\n40#3,3:269\n40#3,3:272\n40#3,3:275\n40#3,3:278\n40#3,3:281\n40#3,3:284\n40#3,3:287\n40#3,3:290\n*S KotlinDebug\n*F\n+ 1 AiPluginOnboardingState.kt\ncom/google/tools/intellij/aiplugin/onboarding/AiPluginOnboardingState\n*L\n44#1:259\n55#1:260,3\n57#1:263,3\n86#1:266,3\n168#1:269,3\n171#1:272,3\n174#1:275,3\n180#1:278,3\n181#1:281,3\n182#1:284,3\n183#1:287,3\n199#1:290,3\n*E\n"})
public final class AiPluginOnboardingState
implements OnboardingState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MutableStateFlow<OnboardingState.State> _currentState;
    @NotNull
    private final StateFlow<OnboardingState.State> currentState;
    @NotNull
    private final MutableSharedFlow<Unit> _resetOnboarding;
    @NotNull
    private final SharedFlow<Unit> restartOnboarding;
    public static final int $stable = 8;

    public AiPluginOnboardingState(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        AiPluginOnboardingState $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AiPluginOnboardingState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this._currentState = StateFlowKt.MutableStateFlow((Object)((Object)OnboardingState.State.INITIALIZING));
        this.currentState = FlowKt.asStateFlow(this._currentState);
        this._resetOnboarding = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.restartOnboarding = (SharedFlow)this._resetOnboarding;
        StateFlow<UserTierService.State> tierStateFlow = UserTierService.Companion.getInstance().getCurrentState();
        boolean $i$f$service = false;
        Class<CaicProjectService> serviceClass$iv = CaicProjectService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        StateFlow<String> gcpProjectFlow = ((CaicProjectService)object).getCaicProjectId();
        boolean $i$f$service2 = false;
        Class<ExperimentationFlagsService> serviceClass$iv2 = ExperimentationFlagsService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Flow<Boolean> flagFlow = ExperimentationFlagsServiceKt.nonDefaultValueUpdates((ExperimentationFlagsService)object2, FeatureFlagsService.Companion.getEnableFreeTier());
        StateFlow<Authenticator.AuthState> authFlow = Authenticator.Companion.current().getAuthenticationState();
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)authFlow), (Function2)((Function2)new Function2<Authenticator.AuthState, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AiPluginOnboardingState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Authenticator.AuthState it = (Authenticator.AuthState)this.L$0;
                        if (Authenticator.AuthState.Companion.hasProfileInfo(it)) return Unit.INSTANCE;
                        this.label = 1;
                        Object object3 = this.this$0._resetOnboarding.emit((Object)Unit.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Authenticator.AuthState p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.combine((Flow)((Flow)authFlow), flagFlow, (Flow)((Flow)gcpProjectFlow), (Flow)((Flow)tierStateFlow), (Function5)((Function5)new Function5<Authenticator.AuthState, Boolean, String, UserTierService.State, Continuation<? super Object>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            /* synthetic */ Object L$2;
            final /* synthetic */ AiPluginOnboardingState this$0;
            {
                this.this$0 = $receiver;
                super(5, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Authenticator.AuthState authState = (Authenticator.AuthState)this.L$0;
                        String gcpProject = (String)this.L$1;
                        UserTierService.State tierState = (UserTierService.State)this.L$2;
                        OnboardingState.State state2 = this.this$0.calculateCurrentState(authState, gcpProject, tierState);
                        return switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                            case 1 -> Boxing.boxBoolean((boolean)this.this$0._currentState.tryEmit((Object)OnboardingState.State.INITIALIZING));
                            case 2 -> {
                                this.this$0.setUserHasNotCompletedOnboarding();
                                yield Unit.INSTANCE;
                            }
                            case 3 -> {
                                this.this$0.setUserHasCompletedOnboarding();
                                yield Unit.INSTANCE;
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        };
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Authenticator.AuthState p1, boolean p2, String p3, UserTierService.State p4, Continuation<Object> p5) {
                var var6_6 = new /* invalid duplicate definition of identical inner class */;
                var6_6.L$0 = p1;
                var6_6.L$1 = p3;
                var6_6.L$2 = p4;
                return var6_6.invokeSuspend(Unit.INSTANCE);
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[OnboardingState.State.values().length];
                    try {
                        nArray[OnboardingState.State.INITIALIZING.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OnboardingState.State.ONBOARDING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OnboardingState.State.ONBOARDED.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        })), (CoroutineScope)this.coroutineScope);
        boolean $i$f$service3 = false;
        Class<ExperimentationFlagsService> serviceClass$iv3 = ExperimentationFlagsService.class;
        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv3);
        if (object3 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv3.getName() + " (classloader=" + serviceClass$iv3.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        FlowKt.launchIn((Flow)FlowKt.flowCombine((Flow)((Flow)this.getCurrentState()), ((ExperimentationFlagsService)object3).getFlagsUpdates(), (Function3)((Function3)new Function3<OnboardingState.State, ExperimentationFlagsService.FlagsState, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        OnboardingState.State state2 = (OnboardingState.State)((Object)this.L$0);
                        boolean $i$f$service = false;
                        Class<HealthChecker> serviceClass$iv = HealthChecker.class;
                        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object2 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        HealthChecker healthChecker = (HealthChecker)object2;
                        StudioBotSettingsNotificationService.Companion.getInstance().notifySettingsUpdated();
                        OnboardingState.State state3 = state2;
                        switch (WhenMappings.$EnumSwitchMapping$0[state3.ordinal()]) {
                            case 1: {
                                healthChecker.clearResults();
                                break;
                            }
                            case 2: {
                                healthChecker.healthCheckInBackground();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(OnboardingState.State p1, ExperimentationFlagsService.FlagsState p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[OnboardingState.State.values().length];
                    try {
                        nArray[OnboardingState.State.ONBOARDING.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OnboardingState.State.ONBOARDED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        })), (CoroutineScope)this.coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.getCurrentState()), (Function2)((Function2)new Function2<OnboardingState.State, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AiPluginOnboardingState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        OnboardingState.State it = (OnboardingState.State)((Object)this.L$0);
                        this.this$0.logger.info("Onboarding state: " + it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(OnboardingState.State p1, Continuation<? super Unit> p2) {
                return (this.create((Object)p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
    }

    @Override
    @NotNull
    public StateFlow<OnboardingState.State> getCurrentState() {
        return this.currentState;
    }

    @Override
    @NotNull
    public SharedFlow<Unit> getRestartOnboarding() {
        return this.restartOnboarding;
    }

    @VisibleForTesting
    @NotNull
    public final OnboardingState.State calculateCurrentState(@NotNull Authenticator.AuthState authState, @Nullable String currentProject, @NotNull UserTierService.State userTierState) {
        OnboardingState.State state2;
        Intrinsics.checkNotNullParameter((Object)authState, (String)"authState");
        Intrinsics.checkNotNullParameter((Object)userTierState, (String)"userTierState");
        if (authState instanceof Authenticator.AuthState.Initializing) {
            return OnboardingState.State.INITIALIZING;
        }
        if (!Authenticator.AuthState.Companion.hasProfileInfo(authState)) {
            return OnboardingState.State.ONBOARDING;
        }
        if (ExperimentationCacheService.Companion.getInstance().getCurrentFlags().getValue() instanceof ExperimentationCacheService.Flags.Defaults) {
            return OnboardingState.State.INITIALIZING;
        }
        if (FeatureFlagsService.Companion.getInstance().tierAwareOnboardingEnabled()) {
            OnboardingState.State state3;
            UserTierService.State state4 = userTierState;
            if (state4 instanceof UserTierService.State.Unknown) {
                this.logger.info("UserTierService.State.Unknown show Initializing.");
                state3 = OnboardingState.State.INITIALIZING;
            } else if (state4 instanceof UserTierService.State.LoadCodeAssistCall) {
                this.logger.info("UserTierService.State.LoadCodeAssistCall show Onboarding.");
                state3 = OnboardingState.State.ONBOARDING;
            } else if (state4 instanceof UserTierService.State.UserInput) {
                this.logger.info("UserTierService.State.UserInput show Onboarding.");
                state3 = OnboardingState.State.ONBOARDING;
            } else if (state4 instanceof UserTierService.State.OnboardingCall) {
                this.logger.info("UserTierService.State.OnboardingCall show Onboarding.");
                state3 = OnboardingState.State.ONBOARDING;
            } else if (state4 instanceof UserTierService.State.Ready) {
                CharSequence charSequence = currentProject;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    this.logger.info("UserTierService.State.Ready and currentProject is null show Onboarding.");
                    state3 = OnboardingState.State.ONBOARDING;
                } else {
                    this.logger.info("UserTierService.State.Ready and currentProject is not null show Timeline.");
                    state3 = OnboardingState.State.ONBOARDED;
                }
            } else if (state4 instanceof UserTierService.State.Error) {
                this.logger.info("UserTierService.State.Error show Onboarding.");
                state3 = OnboardingState.State.ONBOARDING;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return state3;
        }
        CharSequence charSequence = currentProject;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.logger.info("Tiers Disabled and currentProject is null show Onboarding.");
            state2 = OnboardingState.State.ONBOARDING;
        } else {
            this.logger.info("Tiers Disabled and currentProject is not null show Timeline.");
            state2 = OnboardingState.State.ONBOARDED;
        }
        return state2;
    }

    @Override
    public void setUserHasCompletedOnboarding() {
        Authenticator.UserInfo userInfo = Authenticator.Companion.current().getLoggedInUser();
        String currentUserEmail = userInfo != null ? userInfo.getEmail() : null;
        boolean $i$f$service = false;
        Class serviceClass$iv = StudioBotAppSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((StudioBotAppSettings)object).setOnboardingCompleted(true);
        if (currentUserEmail == null) {
            this.logger.warn("Current user email should not be null here.");
        } else {
            $i$f$service = false;
            serviceClass$iv = AiPluginSettingsProvider.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            if (!Intrinsics.areEqual((Object)currentUserEmail, (Object)((AiPluginSettingsProvider)object2).getLastLoggedInEmail())) {
                this.logger.info("Resetting chat history since the user has changed.");
                $i$f$service = false;
                serviceClass$iv = AiPluginSettingsProvider.class;
                Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object3 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((AiPluginSettingsProvider)object3).updateLastLoggedInEmail(currentUserEmail);
            }
        }
        this._currentState.tryEmit((Object)OnboardingState.State.ONBOARDED);
        this.logger.info("Onboarding marked as completed");
        if (FeatureFlagsService.Companion.getInstance().tierAwareOnboardingEnabled()) {
            boolean $i$f$service2 = false;
            Class serviceClass$iv2 = UserTierService.class;
            Object object4 = ApplicationManager.getApplication().getService(serviceClass$iv2);
            if (object4 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            String tierId = ((UserTierService)object4).getCurrentUserTierId();
            $i$f$service2 = false;
            serviceClass$iv2 = UsageTrackerService.class;
            Object object5 = ApplicationManager.getApplication().getService(serviceClass$iv2);
            if (object5 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((UsageTrackerService)object5).trackOnboardingEnd(tierId);
            $i$f$service2 = false;
            serviceClass$iv2 = AiPluginOnboardingSessionTracking.class;
            Object object6 = ApplicationManager.getApplication().getService(serviceClass$iv2);
            if (object6 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((AiPluginOnboardingSessionTracking)object6).prepareForNewOnboarding();
            $i$f$service2 = false;
            serviceClass$iv2 = AiPluginGotItToolTipsService.class;
            Object object7 = ApplicationManager.getApplication().getService(serviceClass$iv2);
            if (object7 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((AiPluginGotItToolTipsService)object7).showWelcomeTour();
        }
    }

    @Override
    public void setUserHasNotCompletedOnboarding() {
        this._currentState.tryEmit((Object)OnboardingState.State.ONBOARDING);
        this.logger.info("Onboarding completion has been reset");
    }

    @Override
    public void clearOnboardingRelatedSettings(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
    }

    @Nullable
    public final String getStatusBarDescription(@NotNull Authenticator.AuthState authState, @NotNull ExperimentationCacheService.Flags flags2, @Nullable String currentProject, @NotNull UserTierService.State userTierState) {
        Intrinsics.checkNotNullParameter((Object)authState, (String)"authState");
        Intrinsics.checkNotNullParameter((Object)flags2, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)userTierState, (String)"userTierState");
        if (!Authenticator.AuthState.Companion.hasProfileInfo(authState)) {
            return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.loggedOut", new Object[0]);
        }
        if (flags2 instanceof ExperimentationCacheService.Flags.Defaults) {
            return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.flagsNotUpdated", new Object[0]);
        }
        if (FeatureFlagsService.Companion.getInstance().tierAwareOnboardingEnabled()) {
            UserTierService.State state2 = userTierState;
            if (state2 instanceof UserTierService.State.Ready) {
                CharSequence charSequence = currentProject;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.gcpProjectNotSelected", new Object[0]);
                }
            } else {
                if (state2 instanceof UserTierService.State.OnboardingCall) {
                    return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.userTierStateOnboarding", new Object[0]);
                }
                if (state2 instanceof UserTierService.State.UserInput) {
                    return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.userTierStateOnboarding", new Object[0]);
                }
                if (state2 instanceof UserTierService.State.Error) {
                    return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.userTierStateError", new Object[0]);
                }
                if (state2 instanceof UserTierService.State.LoadCodeAssistCall) {
                    return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.userTierStateUnknown", new Object[0]);
                }
                if (state2 instanceof UserTierService.State.Unknown) {
                    return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.userTierStateUnknown", new Object[0]);
                }
            }
        } else {
            CharSequence charSequence = currentProject;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return SmlIjBundle.message("aiplugin.completion.statusBarWidget.status.gcpProjectNotSelected", new Object[0]);
            }
        }
        return null;
    }

    public static /* synthetic */ String getStatusBarDescription$default(AiPluginOnboardingState aiPluginOnboardingState, Authenticator.AuthState authState, ExperimentationCacheService.Flags flags2, String string, UserTierService.State state2, int n, Object object) {
        if ((n & 1) != 0) {
            authState = (Authenticator.AuthState)Authenticator.Companion.current().getAuthenticationState().getValue();
        }
        if ((n & 2) != 0) {
            flags2 = (ExperimentationCacheService.Flags)ExperimentationCacheService.Companion.getInstance().getCurrentFlags().getValue();
        }
        if ((n & 4) != 0) {
            boolean $i$f$service = false;
            Class<CaicProjectService> serviceClass$iv = CaicProjectService.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            string = (String)((CaicProjectService)object2).getCaicProjectId().getValue();
        }
        if ((n & 8) != 0) {
            state2 = (UserTierService.State)UserTierService.Companion.getInstance().getCurrentState().getValue();
        }
        return aiPluginOnboardingState.getStatusBarDescription(authState, flags2, string, state2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/google/tools/intellij/aiplugin/onboarding/AiPluginOnboardingState$Companion;", "", "()V", "getInstance", "Lcom/google/tools/intellij/aiplugin/onboarding/AiPluginOnboardingState;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nAiPluginOnboardingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginOnboardingState.kt\ncom/google/tools/intellij/aiplugin/onboarding/AiPluginOnboardingState$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,258:1\n40#2,3:259\n*S KotlinDebug\n*F\n+ 1 AiPluginOnboardingState.kt\ncom/google/tools/intellij/aiplugin/onboarding/AiPluginOnboardingState$Companion\n*L\n255#1:259,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AiPluginOnboardingState getInstance() {
            boolean $i$f$service = false;
            Class<AiPluginOnboardingState> serviceClass$iv = AiPluginOnboardingState.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AiPluginOnboardingState)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

