/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.kotlin.sdk.shared;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.modelcontextprotocol.kotlin.sdk.JSONRPCMessage;
import io.modelcontextprotocol.kotlin.sdk.shared.ReadBufferKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/modelcontextprotocol/kotlin/sdk/shared/ReadBuffer;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "buffer", "Lkotlinx/io/Buffer;", "append", "", "chunk", "", "readMessage", "Lio/modelcontextprotocol/kotlin/sdk/JSONRPCMessage;", "clear", "mcp.kotlin-sdk.sdkcompat"})
public final class ReadBuffer {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(ReadBuffer::logger$lambda$0);
    @NotNull
    private final Buffer buffer = new Buffer();

    public final void append(@NotNull byte[] chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Sink.write$default((Sink)((Sink)this.buffer), (byte[])chunk, (int)0, (int)0, (int)6, null);
    }

    @Nullable
    public final JSONRPCMessage readMessage() {
        if (this.buffer.exhausted()) {
            return null;
        }
        long lfIndex = BuffersKt.indexOf$default((Buffer)this.buffer, (byte)10, (long)0L, (long)0L, (int)6, null);
        long l2 = lfIndex;
        if (l2 == -1L) {
            return null;
        }
        if (l2 == 0L) {
            this.buffer.skip(1L);
            return null;
        }
        int skipBytes = 1;
        if (this.buffer.get(lfIndex - 1L) == 13) {
            --lfIndex;
            ++skipBytes;
        }
        String string = Utf8Kt.readString((Source)((Source)this.buffer), (long)lfIndex);
        this.buffer.skip((long)skipBytes);
        String line = string;
        try {
            return ReadBufferKt.deserializeMessage(line);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, () -> ReadBuffer.readMessage$lambda$1(line));
            int braceIndex = StringsKt.indexOf$default((CharSequence)line, (char)'{', (int)0, (boolean)false, (int)6, null);
            if (braceIndex != -1) {
                String string2 = line.substring(braceIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String trimmed = string2;
                try {
                    return ReadBufferKt.deserializeMessage(trimmed);
                }
                catch (Exception ignored) {
                    this.logger.error((Throwable)ignored, () -> ReadBuffer.readMessage$lambda$2(line));
                }
            }
            return null;
        }
    }

    public final void clear() {
        this.buffer.clear();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object readMessage$lambda$1(String $line) {
        return "Failed to deserialize message from line: " + $line + "\nAttempting to recover...";
    }

    private static final Object readMessage$lambda$2(String $line) {
        return "Deserialization failed for line: " + $line + "\nSkipping...";
    }
}

