/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.google.common.collect.ImmutableList;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.DeepLink;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.UrlPrefix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bJ6\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\bJ\u0014\u0010\u001d\u001a\u00020\u00142\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/google/urlassistant/DeepLinks;", "", "<init>", "()V", "deepLinks", "", "Lcom/google/urlassistant/DeepLink;", "addLink", "", "order", "Lcom/google/urlassistant/Order;", "url", "Lcom/google/urlassistant/UrlPrefix;", "pathData", "Lcom/google/urlassistant/PathData;", "activityData", "Lcom/google/urlassistant/ActivityData;", "alwaysAddToEnd", "", "clear", "", "removeLinkAt", "index", "updateLink", "supportOrder", "deepLinkList", "Lcom/google/common/collect/ImmutableList;", "getDeepLinkList", "()Lcom/google/common/collect/ImmutableList;", "addDeepLinks", "", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nDeepLinks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepLinks.kt\ncom/google/urlassistant/DeepLinks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class DeepLinks {
    @NotNull
    private final List<DeepLink> deepLinks = new ArrayList();

    public final synchronized int addLink(@NotNull Order order, @NotNull UrlPrefix url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean alwaysAddToEnd) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        Intrinsics.checkNotNullParameter((Object)activityData, (String)"activityData");
        DeepLink newDeepLink = new DeepLink(order, activityData, url, pathData);
        if (!alwaysAddToEnd) {
            int n = ((Collection)this.deepLinks).size();
            for (int i = 0; i < n; ++i) {
                DeepLink deepLink = this.deepLinks.get(i);
                if (!Intrinsics.areEqual((Object)deepLink.getActivityData().getModuleName(), (Object)activityData.getModuleName())) continue;
                if (deepLink.getOrder().getIntValue() > newDeepLink.getOrder().getIntValue()) {
                    this.deepLinks.add(i, newDeepLink);
                    return i;
                }
                if (i != this.deepLinks.size() - 1 && Intrinsics.areEqual((Object)this.deepLinks.get(i + 1).getActivityData().getModuleName(), (Object)activityData.getModuleName())) continue;
                this.deepLinks.add(i + 1, newDeepLink);
                return i + 1;
            }
        }
        this.deepLinks.add(newDeepLink);
        return this.deepLinks.size() - 1;
    }

    public final synchronized void clear() {
        this.deepLinks.clear();
    }

    public final synchronized void removeLinkAt(int index) {
        this.deepLinks.remove(index);
    }

    public final synchronized int updateLink(@NotNull Order order, @NotNull UrlPrefix url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean supportOrder, int index) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        Intrinsics.checkNotNullParameter((Object)activityData, (String)"activityData");
        if (!(0 <= index ? index < ((Collection)this.deepLinks).size() : false)) {
            boolean bl = false;
            String string = "Index " + index + " is out of bounds.";
            throw new IllegalArgumentException(string.toString());
        }
        DeepLink deepLink = this.deepLinks.get(index);
        if (!Intrinsics.areEqual((Object)activityData.getModuleName(), (Object)deepLink.getActivityData().getModuleName()) || supportOrder && deepLink.getOrder().getIntValue() != order.getIntValue()) {
            this.deepLinks.remove(index);
            return this.addLink(order, url, pathData, activityData, !supportOrder);
        }
        this.deepLinks.set(index, new DeepLink(order, activityData, url, pathData));
        return index;
    }

    @NotNull
    public final synchronized ImmutableList<DeepLink> getDeepLinkList() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this.deepLinks);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
        return immutableList;
    }

    public final synchronized void addDeepLinks(@NotNull Collection<DeepLink> deepLinks) {
        Intrinsics.checkNotNullParameter(deepLinks, (String)"deepLinks");
        this.deepLinks.addAll(deepLinks);
    }
}

