/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.google.urlassistant.AppLinkTableCell;
import com.google.urlassistant.PathType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathData
implements AppLinkTableCell {
    private final String myPathValue;
    private final PathType myPathType;

    public PathData(@NotNull PathType pathType, @Nullable String pathValue) {
        this.myPathType = pathType;
        this.myPathValue = pathValue;
    }

    @Nullable
    public String getPathValue() {
        if (StringUtil.isEmpty((String)this.myPathValue)) {
            return null;
        }
        return XmlUtil.unescape((String)this.myPathValue);
    }

    @NotNull
    public PathType getPathType() {
        return this.myPathType;
    }

    @Override
    @NotNull
    public String getHtmlText(boolean isSelected) {
        return AppLinkTableCell.generateHtmlText(this.getPathValue(), this.myPathType.toString(), isSelected);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PathData)) {
            return false;
        }
        PathData target = (PathData)obj;
        if (!StringUtil.equals((CharSequence)this.myPathValue, (CharSequence)target.getPathValue())) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myPathValue) && StringUtil.isEmpty((String)target.getPathValue())) {
            return true;
        }
        return this.myPathType.equals((Object)target.getPathType());
    }

    public int hashCode() {
        return 31 * this.myPathType.hashCode() + this.myPathValue.hashCode();
    }

    public String toString() {
        return AppLinkTableCell.generateRegularText(this.getPathValue(), this.myPathType.toString());
    }

    public static class PathDataComparator
    implements Comparator<PathData> {
        @Override
        public int compare(PathData o1, PathData o2) {
            int pathTypeComparison = o1.myPathType.compareTo(o2.myPathType);
            if (pathTypeComparison != 0) {
                return pathTypeComparison;
            }
            return o1.myPathValue.compareTo(o2.myPathValue);
        }
    }
}

