/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.editor;

import com.android.tools.adtui.TreeWalker;
import com.google.urlassistant.editor.UrlAssistantVirtualFile;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.font.FontRenderContext;
import java.util.Collection;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/google/urlassistant/editor/UrlAssistantFileEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/google/urlassistant/editor/UrlAssistantVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/google/urlassistant/editor/UrlAssistantVirtualFile;)V", "mainWindow", "Lcom/google/urlassistant/editor/UrlAssistantWindowBase;", "panel", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "getPanel", "()Ljavax/swing/JComponent;", "panel$delegate", "Lkotlin/Lazy;", "getComponent", "getPreferredFocusedComponent", "getName", "", "selectNotify", "", "deselectNotify", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "WheelScrollLayerUI", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nUrlAssistantFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlAssistantFileEditor.kt\ncom/google/urlassistant/editor/UrlAssistantFileEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1761#2,3:126\n*S KotlinDebug\n*F\n+ 1 UrlAssistantFileEditor.kt\ncom/google/urlassistant/editor/UrlAssistantFileEditor\n*L\n40#1:126,3\n*E\n"})
public final class UrlAssistantFileEditor
extends FileEditorBase {
    @NotNull
    private final Project project;
    @NotNull
    private final UrlAssistantVirtualFile file;
    @NotNull
    private final UrlAssistantWindowBase mainWindow;
    @NotNull
    private final Lazy panel$delegate;

    public UrlAssistantFileEditor(@NotNull Project project, @NotNull UrlAssistantVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.project = project;
        this.file = file;
        this.mainWindow = this.file.createWindow((Disposable)this);
        this.panel$delegate = LazyKt.lazy(() -> UrlAssistantFileEditor.panel_delegate$lambda$3(this));
    }

    private final JComponent getPanel() {
        Lazy lazy = this.panel$delegate;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    public JComponent getComponent() {
        return this.getPanel();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.getPanel();
    }

    @NotNull
    public String getName() {
        String string = UrlAssistantBundle.message("url.assistant.editor.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void selectNotify() {
        this.mainWindow.selectNotify();
    }

    public void deselectNotify() {
        this.mainWindow.deselectNotify();
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    private static final JComponent panel_delegate$lambda$3(UrlAssistantFileEditor this$0) {
        JComponent jComponent;
        boolean bl;
        JComponent panel2;
        block5: {
            JComponent jComponent2 = this$0.mainWindow.asPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"asPanel(...)");
            panel2 = jComponent2;
            Iterable iterable = new TreeWalker((Component)panel2).descendants();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"descendants(...)");
            Iterable $this$any$iv = iterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Component it = (Component)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof JScrollPane)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl && !this$0.file.isHorizontalScrollMandatory()) {
            jComponent = panel2;
        } else {
            Object object = new JBScrollPane((Component)panel2);
            JBScrollPane $this$panel_delegate_u24lambda_u243_u24lambda_u241 = object;
            boolean bl3 = false;
            $this$panel_delegate_u24lambda_u243_u24lambda_u241.getVerticalScrollBar().setUnitIncrement(16);
            $this$panel_delegate_u24lambda_u243_u24lambda_u241.setHorizontalScrollBarPolicy(this$0.file.isHorizontalScrollMandatory() ? 32 : 31);
            JBScrollPane scrollPane = object;
            Object $this$panel_delegate_u24lambda_u243_u24lambda_u242 = object = new JLayer<Component>((Component)scrollPane, new WheelScrollLayerUI());
            boolean bl4 = false;
            ((Component)$this$panel_delegate_u24lambda_u243_u24lambda_u242).addComponentListener(new ComponentAdapter(this$0, scrollPane){
                final /* synthetic */ UrlAssistantFileEditor this$0;
                final /* synthetic */ JBScrollPane $scrollPane;
                {
                    this.this$0 = $receiver;
                    this.$scrollPane = $scrollPane;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Font font = new JBLabel().getFont();
                    FontRenderContext renderContext = new JBLabel().getFontMetrics(font).getFontRenderContext();
                    if (!UrlAssistantFileEditor.access$getFile$p(this.this$0).isHorizontalScrollMandatory()) {
                        this.$scrollPane.setHorizontalScrollBarPolicy((double)e.getComponent().getWidth() <= font.getStringBounds("a", renderContext).getWidth() * (double)75 ? 30 : 31);
                    }
                }
            });
            jComponent = (JComponent)object;
        }
        return jComponent;
    }

    public static final /* synthetic */ UrlAssistantVirtualFile access$getFile$p(UrlAssistantFileEditor $this) {
        return $this.file;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/google/urlassistant/editor/UrlAssistantFileEditor$WheelScrollLayerUI;", "Ljavax/swing/plaf/LayerUI;", "Lcom/intellij/ui/components/JBScrollPane;", "<init>", "()V", "installUI", "", "c", "Ljavax/swing/JComponent;", "uninstallUI", "processMouseWheelEvent", "e", "Ljava/awt/event/MouseWheelEvent;", "l", "Ljavax/swing/JLayer;", "url-assistant"})
    private static final class WheelScrollLayerUI
    extends LayerUI<JBScrollPane> {
        @Override
        public void installUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super.installUI(c);
            if (c instanceof JLayer) {
                ((JLayer)c).setLayerEventMask(131072L);
            }
        }

        @Override
        public void uninstallUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            if (c instanceof JLayer) {
                ((JLayer)c).setLayerEventMask(0L);
            }
            super.uninstallUI(c);
        }

        @Override
        protected void processMouseWheelEvent(@NotNull MouseWheelEvent e, @NotNull JLayer<? extends JBScrollPane> l) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter(l, (String)"l");
            Component c = e.getComponent();
            int direction = e.getWheelRotation();
            JBScrollPane main = l.getView();
            if (c instanceof JBScrollPane && !Intrinsics.areEqual((Object)c, (Object)main)) {
                BoundedRangeModel boundedRangeModel = ((JBScrollPane)c).getVerticalScrollBar().getModel();
                Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"getModel(...)");
                BoundedRangeModel m = boundedRangeModel;
                int extent = m.getExtent();
                int minimum = m.getMinimum();
                int maximum = m.getMaximum();
                int value = m.getValue();
                if (direction > 0 && value >= maximum - extent || direction < 0 && value <= minimum) {
                    main.dispatchEvent((AWTEvent)SwingUtilities.convertMouseEvent(c, e, (Component)main));
                }
            }
        }
    }
}

