/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.net.HostSpecifier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.UrlAssistColors;
import com.google.urlassistant.UrlPrefix;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.util.DalUtils;
import com.google.urlassistant.util.DalVerifier;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.Sha256FingerprintUtils;
import com.google.urlassistant.util.SigningConfig;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@UiThread
public class DigitalAssetLinkWindowLegacy
extends JPanel
implements UrlAssistantWindowBase {
    private final DocumentListener myKeystorePathDocumentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            DigitalAssetLinkWindowLegacy.this.hideKeyAlias();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DigitalAssetLinkWindowLegacy.this.hideKeyAlias();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DigitalAssetLinkWindowLegacy.this.hideKeyAlias();
        }
    };
    private JBTextField myDomainField;
    private JBTextField myPackageIDField;
    private JButton myGenerateButton;
    private JTextPane mySaveFileMessageEditPane;
    private JButton mySaveFileButton;
    private JButton myVerifyButton;
    private JPanel myRootPanel;
    private JPanel myPreviewPanel;
    private JRadioButton myAppKeystoreRadioButton;
    private JRadioButton mySigningConfigRadioButton;
    private JTextField myKeystoreFilePathTextField;
    private JButton myBrowseButton;
    private JPanel myChooseFilePanel;
    private JPanel myCardPanel;
    private JComboBox<String> mySigningConfigComboBox;
    private JComboBox<Module> myModuleComboBox;
    private JTextPane myAddedStatementsTextPane;
    private JTextPane myLinkedStringsTextPane;
    private JTextPane myAddedAutoVerifyTextPane;
    private JPanel myAddedStatementsJPanel;
    private JBLabel myAddedStatementsLabel;
    private JTextPane mySuccessTextPane;
    private JBLabel myAddedAutoVerifyLabel;
    private JBLabel mySuccessLabel;
    private JBLabel myLinkedStringsLabel;
    private JPanel myAddedAutoVerifyPanel;
    private JPanel mySuccessPanel;
    private JPanel myLinkedStringsPanel;
    private JPanel myResultContainerPanel;
    private AsyncProcessIcon myAsyncProcessIcon;
    private JPanel myProgressPanel;
    private JPanel myResultPanel;
    private JEditorPane myPreviewEditorPane;
    private JBLabel mySmallTitleLabel;
    private JTextPane myInstructionTextPane;
    private JBLabel mySelectModuleInstructionLabel;
    private JPanel mySelectModulePanel;
    private JTextPane myKeystoreWarningTextPane;
    private JComboBox<String> myKeyStoreAlias;
    private JCheckBox mySupportSmartLockCheckBox;
    private JBTextField mySignInUrlTextField;
    private JPanel mySmartLockPanel;
    private HyperlinkLabel myWhatIsSmartLockTextPane;
    private JBLabel myDomainErrorMessageLabel;
    private JBLabel mySignInUrlErrorMessageLabel;
    private JBLabel myApplicationIdErrorMessageLabel;
    private JBLabel myKeystoreErrorMessageLabel;
    private JCheckBox mySameAsSiteDomainCheckBox;
    private JPanel myTextFieldPanel;
    private JPanel myKeystorePanel;
    private DalUtils.SigningConfigComboBoxModel mySigningConfigComboBoxModel;
    private final Project myProject;
    private CardLayout myCardLayout;
    private String myStringResText;
    private String myFingerprints;
    private String myJsonFileUrl;
    private VirtualFile myStringsFile;
    private List<AndroidFacet> myAndroidFacetList;
    private final Color myPanelBackground;
    private Module myCurrentModule;
    private String myLoadedAliases;
    private UrlPrefix myDomainUrlPrefix;
    private UrlPrefix mySignInUrlPrefix;
    private boolean myIsSmartLockSupported;
    private boolean isDisposed = false;
    private final ItemListener moduleItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DigitalAssetLinkWindowLegacy.this.myModuleComboBox.getItemCount() > 0) {
                DigitalAssetLinkWindowLegacy.this.myCurrentModule = (Module)DigitalAssetLinkWindowLegacy.this.myModuleComboBox.getSelectedItem();
                ListenableFuture<String> firstUrlFuture = UrlAssistUtils.getFirstValidUrl(DigitalAssetLinkWindowLegacy.this.myCurrentModule, DigitalAssetLinkWindowLegacy.this);
                Futures.addCallback(firstUrlFuture, (FutureCallback)new FutureCallback<String>(){

                    public void onSuccess(String firstUrl) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (StringUtil.isNotEmpty((String)firstUrl)) {
                                DigitalAssetLinkWindowLegacy.this.myDomainField.setText(firstUrl);
                                DigitalAssetLinkWindowLegacy.this.mySignInUrlTextField.setText(firstUrl);
                            }
                            DigitalAssetLinkWindowLegacy.this.reloadSigningConfigs();
                            DigitalAssetLinkWindowLegacy.this.hideResultPanels();
                        });
                    }

                    public void onFailure(Throwable t) {
                        if (!(t instanceof CancellationException)) {
                            DigitalAssetLinkWindowLegacy.getLog().error(t);
                        }
                    }
                }, (Executor)SameThreadExecutor.INSTANCE);
            }
        }
    };
    private final HyperlinkListener myHyperlinkListener = e -> {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            BrowserUtil.browse((URL)e.getURL());
        }
    };

    private static Logger getLog() {
        return Logger.getInstance(DigitalAssetLinkWindowLegacy.class);
    }

    public DigitalAssetLinkWindowLegacy(@NotNull Project project, @NotNull Disposable parentDisposable) {
        super(new BorderLayout());
        this.setupUI();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myPanelBackground = this.myPreviewPanel.getBackground();
        this.fillContent();
        ButtonGroup group = new ButtonGroup();
        group.add(this.myAppKeystoreRadioButton);
        group.add(this.mySigningConfigRadioButton);
        this.myAppKeystoreRadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.myCardLayout.first(this.myCardPanel);
            }
        });
        this.mySigningConfigRadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.myCardLayout.last(this.myCardPanel);
            }
        });
        this.myKeystoreFilePathTextField.addActionListener(e -> this.reloadKeyAliases(this.myKeystoreFilePathTextField.getText()));
        this.myKeystoreFilePathTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DigitalAssetLinkWindowLegacy.this.reloadKeyAliases(DigitalAssetLinkWindowLegacy.this.myKeystoreFilePathTextField.getText());
            }
        });
        this.hideResultPanels();
        this.add(this.myRootPanel);
    }

    private void createUIComponents() {
        this.myAsyncProcessIcon = new AsyncProcessIcon.Big(UrlAssistantBundle.message("dal.link.and.verify", new Object[0]));
    }

    private void hideKeyAlias() {
        this.myKeyStoreAlias.setVisible(false);
        this.myLoadedAliases = null;
    }

    private void reloadKeyAliases(@NotNull String keystorePath) {
        if (keystorePath.equals(this.myLoadedAliases)) {
            return;
        }
        if (!new File(keystorePath).isFile()) {
            this.hideKeyAlias();
            return;
        }
        List<String> aliases = Sha256FingerprintUtils.getAliases(keystorePath, null);
        this.myKeyStoreAlias.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(aliases)));
        if (aliases.size() > 1) {
            this.myKeyStoreAlias.setVisible(true);
        } else {
            this.hideKeyAlias();
        }
        this.myLoadedAliases = keystorePath;
    }

    private void fillContent() {
        this.mySaveFileMessageEditPane.addHyperlinkListener(this.myHyperlinkListener);
        this.myCardLayout = (CardLayout)this.myCardPanel.getLayout();
        this.myCardLayout.first(this.myCardPanel);
        this.myGenerateButton.addActionListener(e -> {
            if (!this.generateDalPreviewText()) {
                this.showDalErrorAndHideUi();
            } else {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_GENERATE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
                if (this.mySupportSmartLockCheckBox.isSelected()) {
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
                }
            }
        });
        this.myBrowseButton.addActionListener(e -> {
            VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false), (Project)this.myProject, null);
            if (virtualFile != null) {
                this.myKeystoreFilePathTextField.getDocument().removeDocumentListener(this.myKeystorePathDocumentListener);
                this.myKeystoreFilePathTextField.setText(virtualFile.getPath());
                this.myKeystoreFilePathTextField.getDocument().addDocumentListener(this.myKeystorePathDocumentListener);
                this.reloadKeyAliases(virtualFile.getPath());
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_BROWSE_KEYSTORE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
            } else {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_BROWSE_KEYSTORE_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
            }
        });
        this.mySaveFileButton.addActionListener(e -> this.saveDalTextAsFile());
        this.myVerifyButton.addActionListener(e -> {
            AndroidFacet facet = AndroidFacet.getInstance((Module)this.myCurrentModule);
            if (facet == null) {
                return;
            }
            Map facetToManifest = null;
            try {
                facetToManifest = (Map)ApplicationManager.getApplication().executeOnPooledThread(() -> DalUtils.getManifestsNeedingMetadataForFacet(facet)).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                return;
            }
            boolean metadataExists = facetToManifest.values().stream().anyMatch(DalUtils::checkMetaDataInAndroidManifestExists);
            if (DalUtils.checkDalStringResourceExists(facet, this.myStringResText) || metadataExists) {
                DialogBuilder dialogBuilder = new DialogBuilder();
                dialogBuilder.setTitle(UrlAssistantBundle.message("dal.file.save.overwrite.title", new Object[0]));
                dialogBuilder.setCenterPanel((JComponent)new JLabel(UrlAssistantBundle.message("dal.file.save.overwrite.message", new Object[0])));
                dialogBuilder.setOkOperation(() -> {
                    this.linkAndVerify();
                    dialogBuilder.getDialogWrapper().close(0);
                });
                dialogBuilder.setCancelOperation(() -> {
                    this.myResultContainerPanel.setVisible(false);
                    dialogBuilder.getDialogWrapper().close(1);
                });
                dialogBuilder.show();
            } else {
                this.linkAndVerify();
            }
        });
        this.myAddedStatementsTextPane.setBackground(this.myPanelBackground);
        this.myAddedStatementsTextPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(this.myStringsFile, true);
            }
        });
        this.myLinkedStringsTextPane.setBackground(this.myPanelBackground);
        this.myLinkedStringsTextPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                try {
                    VirtualFile virtualFile = ManifestUtils.getAndroidManiFest(this.myAndroidFacetList.get(Integer.valueOf(e.getDescription()) - 1));
                    if (virtualFile != null) {
                        FileEditorManager.getInstance((Project)this.myProject).openFile(virtualFile, true);
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        });
        this.myAddedAutoVerifyTextPane.setBackground(this.myPanelBackground);
        this.mySuccessTextPane.setBackground(this.myPanelBackground);
        this.mySuccessTextPane.addHyperlinkListener(this.myHyperlinkListener);
        this.myKeystoreWarningTextPane.setText(UrlAssistantBundle.message("dal.debug.keystore.warning", new Object[0]));
        this.myKeystoreWarningTextPane.setForeground((Color)UrlAssistColors.SUBTITLE_TEXT_COLOR);
        this.myKeystoreWarningTextPane.setBackground(this.myPanelBackground);
        this.myKeystoreFilePathTextField.getDocument().addDocumentListener(this.myKeystorePathDocumentListener);
        this.myPreviewEditorPane.setBackground(this.myPanelBackground);
        this.mySaveFileMessageEditPane.setBackground(this.myPanelBackground);
        this.myInstructionTextPane.setBackground(this.myPanelBackground);
        this.myInstructionTextPane.setText(UrlAssistantBundle.message("dal.panel.instruction", new Object[0]));
        this.mySmallTitleLabel.setForeground((Color)UrlAssistColors.SUBTITLE_TEXT_COLOR);
        this.myPackageIDField.getEmptyText().setText(UrlAssistantBundle.message("dal.package.id.hint", new Object[0]));
        this.myRootPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myDomainField.getEmptyText().setText(UrlAssistantBundle.message("dal.domain.hint", new Object[0]));
        this.mySignInUrlTextField.getEmptyText().setText(UrlAssistantBundle.message("dal.sign.in.url.hint", new Object[0]));
        this.mySignInUrlTextField.setTextToTriggerEmptyTextStatus("https://");
        this.mySignInUrlTextField.setText("https://");
        this.mySupportSmartLockCheckBox.setText(UrlAssistantBundle.message("dal.support.smart.lock.checkbox.text", new Object[0]));
        this.mySupportSmartLockCheckBox.addItemListener(e -> {
            this.mySmartLockPanel.setVisible(!this.mySmartLockPanel.isVisible());
            if (this.mySmartLockPanel.isVisible()) {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
            } else {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.EXIT, this.myProject);
            }
        });
        this.mySameAsSiteDomainCheckBox.addItemListener(e -> {
            this.mySignInUrlTextField.setEnabled(!this.mySignInUrlTextField.isEnabled());
            if (!this.mySignInUrlTextField.isEnabled()) {
                this.mySignInUrlTextField.setText(this.myDomainField.getText());
            } else {
                this.mySignInUrlTextField.setText("https://");
            }
        });
        this.myDomainField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!DigitalAssetLinkWindowLegacy.this.mySignInUrlTextField.isEnabled()) {
                    DigitalAssetLinkWindowLegacy.this.mySignInUrlTextField.setText(DigitalAssetLinkWindowLegacy.this.myDomainField.getText());
                }
                if (DigitalAssetLinkWindowLegacy.this.myDomainField.getDocument().getLength() == 0 || DigitalAssetLinkWindowLegacy.this.generateDomainUrlPrefix()) {
                    DigitalAssetLinkWindowLegacy.this.myDomainErrorMessageLabel.setText("");
                }
            }
        });
        this.mySignInUrlTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (DigitalAssetLinkWindowLegacy.this.generateSignInUrlPrefix()) {
                    DigitalAssetLinkWindowLegacy.this.mySignInUrlErrorMessageLabel.setText("");
                }
            }
        });
        this.myWhatIsSmartLockTextPane.setHyperlinkText(UrlAssistantBundle.message("dal.what.is.smart.lock.text", new Object[0]));
        this.myWhatIsSmartLockTextPane.setHyperlinkTarget(UrlAssistantBundle.message("dal.what.is.smart.lock.url", new Object[0]));
        this.myWhatIsSmartLockTextPane.setBackground(this.myPanelBackground);
    }

    private void hideResultPanels() {
        this.myPreviewPanel.setVisible(false);
        this.myResultContainerPanel.setVisible(false);
        this.clearErrorMessages();
    }

    public void reload() {
        this.myModuleComboBox.removeItemListener(this.moduleItemListener);
        this.myModuleComboBox.removeAllItems();
        for (Module module : ProjectSystemUtil.getAndroidModulesForDisplay((Project)this.myProject)) {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null) continue;
            Module baseFeature = InstantApps.findBaseFeature((Project)this.myProject);
            if (baseFeature != null) {
                this.myModuleComboBox.addItem(baseFeature);
                break;
            }
            if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
            this.myModuleComboBox.addItem(facet.getModule());
        }
        if (this.myCurrentModule != null && this.myCurrentModule.isLoaded()) {
            this.myModuleComboBox.setSelectedItem(this.myCurrentModule);
        } else {
            this.myCurrentModule = (Module)this.myModuleComboBox.getSelectedItem();
        }
        this.myModuleComboBox.addItemListener(this.moduleItemListener);
        if (StringUtil.isEmpty((String)this.myDomainField.getText())) {
            ListenableFuture<String> firstUrlFuture = UrlAssistUtils.getFirstValidUrl(this.myCurrentModule, this);
            Futures.addCallback(firstUrlFuture, (FutureCallback)new FutureCallback<String>(){

                public void onSuccess(String firstUrl) {
                    ApplicationManager.getApplication().invokeLater(() -> DigitalAssetLinkWindowLegacy.this.myDomainField.setText(firstUrl));
                }

                public void onFailure(Throwable t) {
                    if (!(t instanceof CancellationException)) {
                        DigitalAssetLinkWindowLegacy.getLog().error(t);
                    }
                }
            }, (Executor)SameThreadExecutor.INSTANCE);
        }
        this.mySelectModulePanel.setVisible(this.myModuleComboBox.getItemCount() > 1);
        this.reloadSigningConfigs();
    }

    private void reloadSigningConfigs() {
        ArrayList<SigningConfig> results = new ArrayList<SigningConfig>();
        this.myPackageIDField.setText(DalUtils.loadSigningConfigs(this.myCurrentModule, results));
        if (results.isEmpty()) {
            this.mySigningConfigRadioButton.setEnabled(false);
            this.myAppKeystoreRadioButton.setSelected(true);
        } else {
            this.mySigningConfigRadioButton.setEnabled(true);
            this.mySigningConfigRadioButton.setSelected(true);
            this.mySigningConfigComboBoxModel = new DalUtils.SigningConfigComboBoxModel(results);
            this.mySigningConfigComboBox.setModel(this.mySigningConfigComboBoxModel);
        }
    }

    private boolean generateDalPreviewText() {
        this.clearErrorMessages();
        if (StringUtil.isEmpty((String)this.myPackageIDField.getText())) {
            this.myApplicationIdErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.package.id", new Object[0]));
            return false;
        }
        if (StringUtil.isEmpty((String)this.myDomainField.getText())) {
            this.myDomainErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.domain", new Object[0]));
            return false;
        }
        if (this.myAppKeystoreRadioButton.isSelected() && StringUtil.isEmpty((String)this.myKeystoreFilePathTextField.getText())) {
            this.myKeystoreErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.keystore.file", new Object[0]));
            return false;
        }
        if (this.mySupportSmartLockCheckBox.isSelected() && (StringUtil.isEmpty((String)this.mySignInUrlTextField.getText()) || this.mySignInUrlTextField.getText().equals("https://"))) {
            this.mySignInUrlErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.sign.in.url", new Object[0]));
            return false;
        }
        if (this.myAppKeystoreRadioButton.isSelected()) {
            String keystorePath = this.myKeystoreFilePathTextField.getText();
            this.reloadKeyAliases(keystorePath);
            return this.showPreviewText(Sha256FingerprintUtils.generateFingerprints(keystorePath, this.myKeyStoreAlias.getSelectedItem() != null ? this.myKeyStoreAlias.getSelectedItem().toString() : null, null));
        }
        return this.showPreviewText(this.getFingerPrintsFromSigningConfig());
    }

    private void clearErrorMessages() {
        this.myApplicationIdErrorMessageLabel.setText("");
        this.myDomainErrorMessageLabel.setText("");
        this.myKeystoreErrorMessageLabel.setText("");
        this.mySignInUrlErrorMessageLabel.setText("");
    }

    private void showDalErrorAndHideUi() {
        this.myPreviewPanel.setVisible(false);
        this.myResultContainerPanel.setVisible(false);
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_GENERATE_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
        if (this.mySupportSmartLockCheckBox.isSelected()) {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
        }
    }

    private boolean generateDomainUrlPrefix() {
        try {
            this.myDomainUrlPrefix = DalUtils.getUrlPrefixWithHttps(this.myDomainField.getText());
            if (!HostSpecifier.isValid((String)this.myDomainUrlPrefix.getHost())) {
                this.myDomainErrorMessageLabel.setText(UrlAssistantBundle.message("add.url.invalid.input.host", new Object[0]));
                return false;
            }
        }
        catch (MalformedURLException e) {
            this.myDomainErrorMessageLabel.setText(UrlAssistantBundle.message("url.malformed", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean generateSignInUrlPrefix() {
        try {
            if (this.mySupportSmartLockCheckBox.isSelected()) {
                this.mySignInUrlPrefix = DalUtils.getUrlPrefixWithHttps(this.mySignInUrlTextField.getText());
                if (!HostSpecifier.isValid((String)this.mySignInUrlPrefix.getHost())) {
                    this.mySignInUrlErrorMessageLabel.setText(UrlAssistantBundle.message("dal.invalid.sign.in.url", new Object[0]));
                    return false;
                }
            } else {
                this.mySignInUrlPrefix = null;
            }
        }
        catch (MalformedURLException e) {
            this.mySignInUrlErrorMessageLabel.setText(UrlAssistantBundle.message("dal.invalid.sign.in.url", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean showPreviewText(@NotNull String fingerprints) {
        this.myResultContainerPanel.setVisible(false);
        if (StringUtil.isEmpty((String)fingerprints)) {
            return false;
        }
        this.myFingerprints = fingerprints;
        if (!this.generateDomainUrlPrefix()) {
            return false;
        }
        if (!this.generateSignInUrlPrefix()) {
            return false;
        }
        this.myIsSmartLockSupported = this.mySupportSmartLockCheckBox.isSelected();
        this.myPreviewPanel.setVisible(true);
        String digitalAssetLinkText = DalUtils.getDalFileText(this.myPackageIDField.getText(), fingerprints, this.mySignInUrlPrefix == null ? null : this.mySignInUrlPrefix.toString());
        this.myStringResText = DalUtils.getDalStringResText(this.myDomainUrlPrefix.toString());
        this.myPreviewEditorPane.setText(digitalAssetLinkText);
        String jsonFileUrl = DalUtils.getDalJsonFileUrl(this.myDomainUrlPrefix.toString());
        if (this.mySignInUrlPrefix == null) {
            this.mySaveFileMessageEditPane.setText(UrlAssistantBundle.message("dal.save.file.message", jsonFileUrl));
        } else {
            String smartLockJsonFileUrl = DalUtils.getDalJsonFileUrl(this.mySignInUrlPrefix.toString());
            if (jsonFileUrl.equals(smartLockJsonFileUrl)) {
                this.mySaveFileMessageEditPane.setText(UrlAssistantBundle.message("dal.save.file.message", jsonFileUrl));
            } else {
                this.mySaveFileMessageEditPane.setText(UrlAssistantBundle.message("dal.save.file.two.places.message", jsonFileUrl, smartLockJsonFileUrl));
            }
        }
        return true;
    }

    @NotNull
    private String getFingerPrintsFromSigningConfig() {
        SigningConfig signingConfig = this.mySigningConfigComboBoxModel.getSelectedSigningConfig();
        String keystoreFile = signingConfig == null ? null : signingConfig.getStoreFileAbsolutePath();
        String alias = signingConfig == null ? null : signingConfig.getKeyAlias();
        String password = signingConfig == null ? null : signingConfig.getStorePassword();
        return Sha256FingerprintUtils.generateFingerprints(keystoreFile, alias, password);
    }

    private void saveDalTextAsFile() {
        FileSaverDescriptor descriptor = new FileSaverDescriptor(UrlAssistantBundle.message("dal.save.file", new Object[0]), UrlAssistantBundle.message("dal.save.file.as.json", new Object[0]), "json");
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)this.myRootPanel);
        VirtualFileWrapper target = saveFileDialog.save((VirtualFile)null, "assetlinks.json");
        if (target == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile virtualFile = target.getVirtualFile(true);
            try {
                if (virtualFile != null) {
                    virtualFile.setBinaryContent(this.myPreviewEditorPane.getText().getBytes(StandardCharsets.UTF_8));
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SAVE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
                } else {
                    this.showSaveFailDialog(null);
                }
            }
            catch (IOException e) {
                this.showSaveFailDialog(e);
            }
        });
    }

    @UiThread
    private void linkAndVerify() {
        CardLayout cl = (CardLayout)this.myResultContainerPanel.getLayout();
        cl.last(this.myResultContainerPanel);
        this.myResultContainerPanel.setVisible(true);
        this.setResultForAddStringResource(false);
        this.setResultForLinkStringsToManifest(false);
        this.myAddedStatementsJPanel.setVisible(this.myIsSmartLockSupported);
        this.myLinkedStringsPanel.setVisible(this.myIsSmartLockSupported);
        this.setResultForAddAutoVerify(false);
        AndroidFacet facet = AndroidFacet.getInstance((Module)this.myCurrentModule);
        if (facet != null) {
            try {
                Map facetToManifest = (Map)ApplicationManager.getApplication().executeOnPooledThread(() -> DalUtils.getManifestsNeedingMetadataForFacet(facet)).get();
                if (this.myIsSmartLockSupported) {
                    WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
                        this.myStringsFile = DalUtils.addDalStringResource(facet, this.myStringResText);
                        this.setResultForAddStringResource(this.myStringsFile != null);
                        ArrayList<AndroidFacet> successfulFacets = new ArrayList<AndroidFacet>();
                        for (AndroidFacet f : facetToManifest.keySet()) {
                            if (!DalUtils.addMetaDataToAndroidManifest((Manifest)facetToManifest.get(f))) continue;
                            successfulFacets.add(f);
                        }
                        this.myAndroidFacetList = successfulFacets;
                        this.setResultForLinkStringsToManifest(!this.myAndroidFacetList.isEmpty());
                        boolean anySucceeded = facetToManifest.values().stream().anyMatch(DalUtils::addAutoVerifyToAppLinks);
                        this.setResultForAddAutoVerify(anySucceeded);
                        DalVerifier dalVerifier = new DalVerifier();
                        DalVerifier.ErrorMessage error = this.checkDalFile(dalVerifier, this.myPackageIDField.getText(), this.myDomainUrlPrefix.toString(), this.myFingerprints, this.mySignInUrlPrefix == null ? null : this.mySignInUrlPrefix.toString());
                        this.mySuccessLabel.setIcon(error.getErrorCode() == DalVerifier.ErrorCode.SUCCESS ? StudioIcons.Common.SUCCESS : StudioIcons.Common.ERROR);
                        this.mySuccessTextPane.setText(error.toMessage());
                        cl.first(this.myResultContainerPanel);
                    });
                } else {
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> this.setResultForAddAutoVerify(facetToManifest.values().stream().anyMatch(DalUtils::addAutoVerifyToAppLinks)));
                    DalVerifier dalVerifier = new DalVerifier();
                    DalVerifier.ErrorMessage error = this.checkDalFile(dalVerifier, this.myPackageIDField.getText(), this.myDomainUrlPrefix.toString(), this.myFingerprints, this.mySignInUrlPrefix == null ? null : this.mySignInUrlPrefix.toString());
                    this.mySuccessLabel.setIcon(error.getErrorCode() == DalVerifier.ErrorCode.SUCCESS ? StudioIcons.Common.SUCCESS : StudioIcons.Common.ERROR);
                    this.mySuccessTextPane.setText(error.toMessage());
                    cl.first(this.myResultContainerPanel);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                DigitalAssetLinkWindowLegacy.getLog().error((Throwable)e);
            }
        }
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_VERIFY_BUTTON, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
    }

    private void setResultForAddStringResource(boolean isSuccessful) {
        this.myAddedStatementsTextPane.setText(UrlAssistantBundle.message(isSuccessful ? "dal.add.statements.success" : "dal.add.statements.fail", new Object[0]));
        this.myAddedStatementsLabel.setIcon(isSuccessful ? StudioIcons.Common.SUCCESS : StudioIcons.Common.ERROR);
    }

    private void setResultForLinkStringsToManifest(boolean isSuccessful) {
        String finalText;
        this.myLinkedStringsLabel.setIcon(isSuccessful ? StudioIcons.Common.SUCCESS : StudioIcons.Common.ERROR);
        if (!isSuccessful) {
            finalText = UrlAssistantBundle.message("dal.linked.strings.fail", new Object[0]);
        } else if (this.myAndroidFacetList.size() == 1) {
            finalText = UrlAssistantBundle.message("dal.linked.strings.success", new Object[0]);
        } else {
            StringBuilder messageBuilder = new StringBuilder(UrlAssistantBundle.message("dal.linked.strings.success.multiple", new Object[0]));
            for (int i = 1; i <= this.myAndroidFacetList.size(); ++i) {
                messageBuilder.append("  ").append(i).append(". <a href=\"").append(i).append("\">AndroidManifest.xml (").append(this.myAndroidFacetList.get(i - 1).getModule().getName()).append(")</a>");
            }
            finalText = messageBuilder.toString();
        }
        this.myLinkedStringsTextPane.setText(finalText);
    }

    private void setResultForAddAutoVerify(boolean isSuccessful) {
        this.myAddedAutoVerifyTextPane.setText(UrlAssistantBundle.message(isSuccessful ? "dal.add.autoverify.success" : "dal.add.autoverify.fail", new Object[0]));
        this.myAddedAutoVerifyLabel.setIcon(isSuccessful ? StudioIcons.Common.SUCCESS : StudioIcons.Common.ERROR);
    }

    @VisibleForTesting
    public DalVerifier.ErrorMessage checkDalFile(@NotNull DalVerifier dalVerifier, @NotNull String packageId, @NotNull String domain, @NotNull String fingerprints, @Nullable String signInUrl) {
        DalVerifier.ErrorMessage errorMessage = dalVerifier.validateAssetLinksFile(packageId, domain, fingerprints, false);
        if (DalVerifier.ErrorCode.SUCCESS == errorMessage.getErrorCode() && signInUrl != null) {
            errorMessage = dalVerifier.validateAssetLinksFile(packageId, signInUrl, fingerprints, true);
        }
        return errorMessage;
    }

    private void showSaveFailDialog(@Nullable Exception e) {
        Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.file.save.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        if (e == null) {
            DigitalAssetLinkWindowLegacy.getLog().warn("Failed to save the DAL file.");
        } else {
            DigitalAssetLinkWindowLegacy.getLog().warn((Throwable)e);
        }
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SAVE_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void selectNotify() {
        this.reload();
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this;
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(23, 4, new Insets(20, 30, 20, 30), -1, -1));
        this.myRootPanel.setFocusCycleRoot(true);
        this.myRootPanel.setFocusTraversalPolicyProvider(false);
        this.myRootPanel.setMinimumSize(new Dimension(1000, 1400));
        this.myRootPanel.setPreferredSize(new Dimension(1000, 1400));
        this.myRootPanel.setRequestFocusEnabled(true);
        this.myInstructionTextPane = new JTextPane();
        this.myInstructionTextPane.setContentType("text/html");
        this.myInstructionTextPane.setEditable(false);
        this.myInstructionTextPane.setFocusCycleRoot(false);
        this.myInstructionTextPane.setFocusable(false);
        Font myInstructionTextPaneFont = UIManager.getFont("Label.font");
        if (myInstructionTextPaneFont != null) {
            this.myInstructionTextPane.setFont(myInstructionTextPaneFont);
        }
        this.myInstructionTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.myInstructionTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myRootPanel.add((Component)this.myInstructionTextPane, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 0, new Dimension(-1, 15), null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myRootPanel.add((Component)spacer1, new GridConstraints(22, 0, 1, 4, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRootPanel.add((Component)spacer2, new GridConstraints(8, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 15), new Dimension(-1, 15), 0, false));
        Spacer spacer3 = new Spacer();
        this.myRootPanel.add((Component)spacer3, new GridConstraints(10, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setFocusable(false);
        Font jBLabel1Font = this.getFont(null, -1, 14, jBLabel1.getFont());
        if (jBLabel1Font != null) {
            jBLabel1.setFont(jBLabel1Font);
        }
        jBLabel1.setText("SHA256 Fingerprint of signing certificate");
        this.myRootPanel.add((Component)jBLabel1, new GridConstraints(14, 0, 1, 4, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCardPanel = new JPanel();
        this.myCardPanel.setLayout(new CardLayout(0, 0));
        this.myRootPanel.add((Component)this.myCardPanel, new GridConstraints(17, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        this.myChooseFilePanel = new JPanel();
        this.myChooseFilePanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myCardPanel.add((Component)this.myChooseFilePanel, "Card2");
        this.myKeystoreFilePathTextField = new JTextField();
        this.myKeystoreFilePathTextField.setEditable(true);
        this.myChooseFilePanel.add((Component)this.myKeystoreFilePathTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        this.myBrowseButton = new JButton();
        this.myBrowseButton.setText("Browse");
        this.myChooseFilePanel.add((Component)this.myBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myKeyStoreAlias = new JComboBox();
        this.myKeyStoreAlias.setEnabled(true);
        this.myKeyStoreAlias.setVisible(false);
        this.myChooseFilePanel.add(this.myKeyStoreAlias, new GridConstraints(0, 2, 1, 1, 8, 1, 3, 0, null, null, null, 0, false));
        this.myKeystoreErrorMessageLabel = new JBLabel();
        this.myKeystoreErrorMessageLabel.setFocusable(false);
        this.myKeystoreErrorMessageLabel.setForeground(new Color(-65536));
        this.myChooseFilePanel.add((Component)this.myKeystoreErrorMessageLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myCardPanel.add((Component)panel1, "Card3");
        this.mySigningConfigComboBox = new JComboBox();
        panel1.add(this.mySigningConfigComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myRootPanel.add((Component)spacer4, new GridConstraints(19, 0, 1, 4, 0, 0, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.myGenerateButton = new JButton();
        this.myGenerateButton.setText("Generate Digital Asset Links file");
        this.myRootPanel.add((Component)this.myGenerateButton, new GridConstraints(20, 0, 1, 4, 8, 0, 3, 0, null, null, null, 0, false));
        this.myPreviewPanel = new JPanel();
        this.myPreviewPanel.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPreviewPanel.setVisible(true);
        this.myRootPanel.add((Component)this.myPreviewPanel, new GridConstraints(21, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        this.mySaveFileMessageEditPane = new JTextPane();
        this.mySaveFileMessageEditPane.setBackground(new Color(-1513240));
        this.mySaveFileMessageEditPane.setContentType("text/html");
        this.mySaveFileMessageEditPane.setEditable(false);
        this.mySaveFileMessageEditPane.setFocusCycleRoot(false);
        this.mySaveFileMessageEditPane.setFocusable(false);
        Font mySaveFileMessageEditPaneFont = UIManager.getFont("Label.font");
        if (mySaveFileMessageEditPaneFont != null) {
            this.mySaveFileMessageEditPane.setFont(mySaveFileMessageEditPaneFont);
        }
        this.mySaveFileMessageEditPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myPreviewPanel.add((Component)this.mySaveFileMessageEditPane, new GridConstraints(3, 0, 1, 1, 8, 0, 5, 0, new Dimension(-1, 20), null, null, 0, false));
        this.mySaveFileButton = new JButton();
        this.mySaveFileButton.setText("Save file");
        this.myPreviewPanel.add((Component)this.mySaveFileButton, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 0, null, null, null, 0, false));
        JSeparator separator1 = new JSeparator();
        this.myPreviewPanel.add((Component)separator1, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setFocusable(false);
        Font jBLabel2Font = this.getFont(null, -1, 14, jBLabel2.getFont());
        if (jBLabel2Font != null) {
            jBLabel2.setFont(jBLabel2Font);
        }
        jBLabel2.setText("Complete the association");
        this.myPreviewPanel.add((Component)jBLabel2, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setFocusable(false);
        jBLabel3.setText("Link your Digital Asset Links file with your app and verify that it has been uploaded to the current location.");
        this.myPreviewPanel.add((Component)jBLabel3, new GridConstraints(8, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.myVerifyButton = new JButton();
        this.myVerifyButton.setText("Link and Verify");
        this.myPreviewPanel.add((Component)this.myVerifyButton, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setFocusable(false);
        Font jBLabel4Font = this.getFont(null, -1, 14, jBLabel4.getFont());
        if (jBLabel4Font != null) {
            jBLabel4.setFont(jBLabel4Font);
        }
        jBLabel4.setText("Preview:");
        this.myPreviewPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        this.myPreviewPanel.add((Component)spacer5, new GridConstraints(0, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.myResultContainerPanel = new JPanel();
        this.myResultContainerPanel.setLayout(new CardLayout(0, 0));
        this.myPreviewPanel.add((Component)this.myResultContainerPanel, new GridConstraints(12, 0, 1, 2, 0, 3, 5, 5, null, null, null, 0, false));
        this.myResultPanel = new JPanel();
        this.myResultPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myResultPanel.setMinimumSize(new Dimension(-1, 117));
        this.myResultPanel.setPreferredSize(new Dimension(-1, 155));
        this.myResultContainerPanel.add((Component)this.myResultPanel, "Card1");
        this.myAddedStatementsJPanel = new JPanel();
        this.myAddedStatementsJPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAddedStatementsJPanel.setVisible(true);
        this.myResultPanel.add((Component)this.myAddedStatementsJPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null, 0, false));
        this.myAddedStatementsTextPane = new JTextPane();
        this.myAddedStatementsTextPane.setContentType("text/html");
        this.myAddedStatementsTextPane.setEditable(false);
        this.myAddedStatementsTextPane.setFocusCycleRoot(false);
        this.myAddedStatementsTextPane.setFocusable(false);
        Font myAddedStatementsTextPaneFont = UIManager.getFont("Label.font");
        if (myAddedStatementsTextPaneFont != null) {
            this.myAddedStatementsTextPane.setFont(myAddedStatementsTextPaneFont);
        }
        this.myAddedStatementsTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.myAddedStatementsTextPane.setVisible(true);
        this.myAddedStatementsTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myAddedStatementsJPanel.add((Component)this.myAddedStatementsTextPane, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(-1, 1), null, 0, false));
        this.myAddedStatementsLabel = new JBLabel();
        this.myAddedStatementsLabel.setFocusable(false);
        this.myAddedStatementsJPanel.add((Component)this.myAddedStatementsLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myLinkedStringsPanel = new JPanel();
        this.myLinkedStringsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myLinkedStringsPanel.setVisible(true);
        this.myResultPanel.add((Component)this.myLinkedStringsPanel, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 1, null, null, null, 0, false));
        this.myLinkedStringsTextPane = new JTextPane();
        this.myLinkedStringsTextPane.setContentType("text/html");
        this.myLinkedStringsTextPane.setEditable(false);
        this.myLinkedStringsTextPane.setFocusCycleRoot(false);
        this.myLinkedStringsTextPane.setFocusable(false);
        Font myLinkedStringsTextPaneFont = UIManager.getFont("Label.font");
        if (myLinkedStringsTextPaneFont != null) {
            this.myLinkedStringsTextPane.setFont(myLinkedStringsTextPaneFont);
        }
        this.myLinkedStringsTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.myLinkedStringsTextPane.setVisible(true);
        this.myLinkedStringsTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myLinkedStringsPanel.add((Component)this.myLinkedStringsTextPane, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, new Dimension(-1, 1), null, 0, false));
        this.myLinkedStringsLabel = new JBLabel();
        this.myLinkedStringsLabel.setFocusable(false);
        this.myLinkedStringsPanel.add((Component)this.myLinkedStringsLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myAddedAutoVerifyPanel = new JPanel();
        this.myAddedAutoVerifyPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAddedAutoVerifyPanel.setVisible(true);
        this.myResultPanel.add((Component)this.myAddedAutoVerifyPanel, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 1, null, null, null, 0, false));
        this.myAddedAutoVerifyTextPane = new JTextPane();
        this.myAddedAutoVerifyTextPane.setContentType("text/html");
        this.myAddedAutoVerifyTextPane.setEditable(false);
        this.myAddedAutoVerifyTextPane.setFocusCycleRoot(false);
        this.myAddedAutoVerifyTextPane.setFocusable(false);
        Font myAddedAutoVerifyTextPaneFont = UIManager.getFont("Label.font");
        if (myAddedAutoVerifyTextPaneFont != null) {
            this.myAddedAutoVerifyTextPane.setFont(myAddedAutoVerifyTextPaneFont);
        }
        this.myAddedAutoVerifyTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.myAddedAutoVerifyTextPane.setVisible(true);
        this.myAddedAutoVerifyTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myAddedAutoVerifyPanel.add((Component)this.myAddedAutoVerifyTextPane, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, new Dimension(-1, 1), null, 0, false));
        this.myAddedAutoVerifyLabel = new JBLabel();
        this.myAddedAutoVerifyLabel.setFocusable(false);
        this.myAddedAutoVerifyLabel.setText("");
        this.myAddedAutoVerifyPanel.add((Component)this.myAddedAutoVerifyLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.mySuccessPanel = new JPanel();
        this.mySuccessPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mySuccessPanel.setVisible(true);
        this.myResultPanel.add((Component)this.mySuccessPanel, new GridConstraints(6, 0, 1, 1, 1, 1, 3, 5, null, null, null, 0, false));
        this.mySuccessTextPane = new JTextPane();
        this.mySuccessTextPane.setContentType("text/html");
        this.mySuccessTextPane.setEditable(false);
        this.mySuccessTextPane.setFocusCycleRoot(false);
        this.mySuccessTextPane.setFocusable(false);
        Font mySuccessTextPaneFont = UIManager.getFont("Label.font");
        if (mySuccessTextPaneFont != null) {
            this.mySuccessTextPane.setFont(mySuccessTextPaneFont);
        }
        this.mySuccessTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.mySuccessTextPane.setVisible(true);
        this.mySuccessTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.mySuccessPanel.add((Component)this.mySuccessTextPane, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, new Dimension(-1, 1), null, 0, false));
        this.mySuccessLabel = new JBLabel();
        this.mySuccessLabel.setFocusable(false);
        this.mySuccessPanel.add((Component)this.mySuccessLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer6 = new Spacer();
        this.myResultPanel.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5), 0, false));
        Spacer spacer7 = new Spacer();
        this.myResultPanel.add((Component)spacer7, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5), 0, false));
        Spacer spacer8 = new Spacer();
        this.myResultPanel.add((Component)spacer8, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5), 0, false));
        this.myProgressPanel = new JPanel();
        this.myProgressPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myProgressPanel.setMinimumSize(new Dimension(-1, -1));
        this.myResultContainerPanel.add((Component)this.myProgressPanel, "Card2");
        this.myAsyncProcessIcon.setFocusable(false);
        this.myProgressPanel.add((Component)this.myAsyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setFocusable(false);
        jBLabel5.setInheritsPopupMenu(false);
        jBLabel5.setOpaque(true);
        jBLabel5.setText("Verifying..");
        this.myProgressPanel.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer9 = new Spacer();
        this.myProgressPanel.add((Component)spacer9, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer10 = new Spacer();
        this.myPreviewPanel.add((Component)spacer10, new GridConstraints(9, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 8), new Dimension(-1, 8), 0, false));
        Spacer spacer11 = new Spacer();
        this.myPreviewPanel.add((Component)spacer11, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        jBScrollPane1.setFocusable(false);
        this.myPreviewPanel.add((Component)jBScrollPane1, new GridConstraints(2, 0, 1, 2, 0, 1, 1, 2, null, null, null, 0, false));
        this.myPreviewEditorPane = new JEditorPane();
        this.myPreviewEditorPane.setBackground(new Color(-1513240));
        this.myPreviewEditorPane.setEditable(false);
        this.myPreviewEditorPane.setFocusCycleRoot(false);
        this.myPreviewEditorPane.setFocusable(true);
        this.myPreviewEditorPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
        jBScrollPane1.setViewportView((Component)this.myPreviewEditorPane);
        Spacer spacer12 = new Spacer();
        this.myPreviewPanel.add((Component)spacer12, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        Spacer spacer13 = new Spacer();
        this.myPreviewPanel.add((Component)spacer13, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 4, null, new Dimension(-1, 8), new Dimension(-1, 8), 0, false));
        this.myTextFieldPanel = new JPanel();
        this.myTextFieldPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        this.myTextFieldPanel.setFocusCycleRoot(false);
        this.myRootPanel.add((Component)this.myTextFieldPanel, new GridConstraints(7, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDomainField = new JBTextField();
        this.myTextFieldPanel.add((Component)this.myDomainField, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setFocusable(false);
        Font jBLabel6Font = this.getFont(null, -1, 14, jBLabel6.getFont());
        if (jBLabel6Font != null) {
            jBLabel6.setFont(jBLabel6Font);
        }
        jBLabel6.setText("Site domain");
        this.myTextFieldPanel.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myPackageIDField = new JBTextField();
        this.myPackageIDField.setAutoscrolls(true);
        this.myTextFieldPanel.add((Component)this.myPackageIDField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setFocusable(false);
        Font jBLabel7Font = this.getFont(null, -1, 14, jBLabel7.getFont());
        if (jBLabel7Font != null) {
            jBLabel7.setFont(jBLabel7Font);
        }
        jBLabel7.setText("Application ID");
        this.myTextFieldPanel.add((Component)jBLabel7, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDomainErrorMessageLabel = new JBLabel();
        this.myDomainErrorMessageLabel.setFocusable(false);
        this.myDomainErrorMessageLabel.setForeground(new Color(-65536));
        this.myTextFieldPanel.add((Component)this.myDomainErrorMessageLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.myApplicationIdErrorMessageLabel = new JBLabel();
        this.myApplicationIdErrorMessageLabel.setFocusable(false);
        this.myApplicationIdErrorMessageLabel.setForeground(new Color(-65536));
        this.myTextFieldPanel.add((Component)this.myApplicationIdErrorMessageLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.mySmallTitleLabel = new JBLabel();
        this.mySmallTitleLabel.setFocusable(false);
        Font mySmallTitleLabelFont = this.getFont(null, -1, 12, this.mySmallTitleLabel.getFont());
        if (mySmallTitleLabelFont != null) {
            this.mySmallTitleLabel.setFont(mySmallTitleLabelFont);
        }
        this.mySmallTitleLabel.setText("Android App Links Support");
        this.myRootPanel.add((Component)this.mySmallTitleLabel, new GridConstraints(1, 1, 1, 2, 10, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setFocusable(false);
        jBLabel8.setIcon((Icon)new ImageIcon(this.getClass().getResource("/url_assistant/step_three.png")));
        this.myRootPanel.add((Component)jBLabel8, new GridConstraints(1, 0, 2, 1, 0, 0, 0, 0, null, new Dimension(50, 50), null, 0, false));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setFocusable(false);
        Font jBLabel9Font = this.getFont(null, -1, 22, jBLabel9.getFont());
        if (jBLabel9Font != null) {
            jBLabel9.setFont(jBLabel9Font);
        }
        jBLabel9.setText("Declare Website Association");
        jBLabel9.setVerticalAlignment(1);
        jBLabel9.setVerticalTextPosition(1);
        this.myRootPanel.add((Component)jBLabel9, new GridConstraints(2, 1, 1, 2, 9, 0, 0, 0, null, null, null, 0, false));
        JSeparator separator2 = new JSeparator();
        this.myRootPanel.add((Component)separator2, new GridConstraints(9, 0, 1, 4, 0, 1, 0, 0, null, null, null, 0, false));
        this.myKeystorePanel = new JPanel();
        this.myKeystorePanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPanel.add((Component)this.myKeystorePanel, new GridConstraints(16, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        this.myAppKeystoreRadioButton = new JRadioButton();
        this.myAppKeystoreRadioButton.setText("Select keystore file");
        this.myKeystorePanel.add((Component)this.myAppKeystoreRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, null, null, 0, false));
        this.mySigningConfigRadioButton = new JRadioButton();
        this.mySigningConfigRadioButton.setMargin(new Insets(2, 2, 2, 100));
        this.mySigningConfigRadioButton.setText("Signing config");
        this.myKeystorePanel.add((Component)this.mySigningConfigRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setFocusable(false);
        jBLabel10.setText("Specify either the signing config or the keystore file used to sign your app to obtain the SHA256 fingerprint.");
        this.myRootPanel.add((Component)jBLabel10, new GridConstraints(15, 0, 1, 4, 0, 1, 0, 0, null, null, null, 0, false));
        Spacer spacer14 = new Spacer();
        this.myRootPanel.add((Component)spacer14, new GridConstraints(5, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 7), new Dimension(-1, 7), 0, false));
        this.mySelectModulePanel = new JPanel();
        this.mySelectModulePanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPanel.add((Component)this.mySelectModulePanel, new GridConstraints(6, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        this.mySelectModuleInstructionLabel = new JBLabel();
        this.mySelectModuleInstructionLabel.setFocusable(false);
        this.mySelectModuleInstructionLabel.setText("Select a module you want to work on");
        this.mySelectModulePanel.add((Component)this.mySelectModuleInstructionLabel, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null, 0, false));
        this.myModuleComboBox = new JComboBox();
        this.mySelectModulePanel.add(this.myModuleComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        Spacer spacer15 = new Spacer();
        this.mySelectModulePanel.add((Component)spacer15, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 15), new Dimension(-1, 15), 0, false));
        Spacer spacer16 = new Spacer();
        this.myRootPanel.add((Component)spacer16, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.mySupportSmartLockCheckBox = new JCheckBox();
        this.mySupportSmartLockCheckBox.setFocusable(true);
        Font mySupportSmartLockCheckBoxFont = UIManager.getFont("Label.font");
        if (mySupportSmartLockCheckBoxFont != null) {
            this.mySupportSmartLockCheckBox.setFont(mySupportSmartLockCheckBoxFont);
        }
        this.mySupportSmartLockCheckBox.setText("Support Smart Lock for Passwords");
        this.myRootPanel.add((Component)this.mySupportSmartLockCheckBox, new GridConstraints(11, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.mySmartLockPanel = new JPanel();
        this.mySmartLockPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mySmartLockPanel.setVisible(false);
        this.myRootPanel.add((Component)this.mySmartLockPanel, new GridConstraints(12, 0, 1, 4, 1, 1, 3, 1, null, null, null, 0, false));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setFocusable(false);
        jBLabel11.setText("Sign in URL");
        this.mySmartLockPanel.add((Component)jBLabel11, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.mySignInUrlTextField = new JBTextField();
        this.mySignInUrlTextField.setEditable(true);
        this.mySignInUrlTextField.setEnabled(true);
        this.mySignInUrlTextField.setFocusable(true);
        this.mySmartLockPanel.add((Component)this.mySignInUrlTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        this.mySignInUrlErrorMessageLabel = new JBLabel();
        this.mySignInUrlErrorMessageLabel.setFocusable(false);
        this.mySignInUrlErrorMessageLabel.setForeground(new Color(-65536));
        this.mySmartLockPanel.add((Component)this.mySignInUrlErrorMessageLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.mySameAsSiteDomainCheckBox = new JCheckBox();
        this.mySameAsSiteDomainCheckBox.setSelected(false);
        this.mySameAsSiteDomainCheckBox.setText("Sign in URL is the same as site domain");
        this.mySmartLockPanel.add((Component)this.mySameAsSiteDomainCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer17 = new Spacer();
        this.myRootPanel.add((Component)spacer17, new GridConstraints(13, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 13), new Dimension(-1, 13), 0, false));
        this.myWhatIsSmartLockTextPane = new HyperlinkLabel();
        this.myWhatIsSmartLockTextPane.setFocusable(false);
        Font myWhatIsSmartLockTextPaneFont = UIManager.getFont("Label.font");
        if (myWhatIsSmartLockTextPaneFont != null) {
            this.myWhatIsSmartLockTextPane.setFont(myWhatIsSmartLockTextPaneFont);
        }
        this.myWhatIsSmartLockTextPane.setRequestFocusEnabled(true);
        this.myWhatIsSmartLockTextPane.setVerifyInputWhenFocusTarget(true);
        this.myRootPanel.add((Component)this.myWhatIsSmartLockTextPane, new GridConstraints(11, 2, 1, 1, 8, 0, 3, 1, null, null, null, 0, false));
        Spacer spacer18 = new Spacer();
        this.myRootPanel.add((Component)spacer18, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 1, null, null, null, 0, false));
        Spacer spacer19 = new Spacer();
        this.myRootPanel.add((Component)spacer19, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myKeystoreWarningTextPane = new JTextPane();
        this.myKeystoreWarningTextPane.setEditable(false);
        this.myKeystoreWarningTextPane.setFocusCycleRoot(false);
        this.myKeystoreWarningTextPane.setFocusable(false);
        Font myKeystoreWarningTextPaneFont = UIManager.getFont("Label.font");
        if (myKeystoreWarningTextPaneFont != null) {
            this.myKeystoreWarningTextPane.setFont(myKeystoreWarningTextPaneFont);
        }
        this.myKeystoreWarningTextPane.setText("");
        this.myRootPanel.add((Component)this.myKeystoreWarningTextPane, new GridConstraints(18, 0, 1, 4, 8, 0, 0, 0, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }
}

