/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import java.util.Arrays;

public class AndroidPatternMatcher {
    private static final int TOKEN_TYPE_LITERAL = 0;
    private static final int TOKEN_TYPE_ANY = 1;
    private static final int TOKEN_TYPE_SET = 2;
    private static final int TOKEN_TYPE_INVERSE_SET = 3;
    private static final int NO_MATCH = -1;
    private static final int PARSED_TOKEN_CHAR_SET_START = -1;
    private static final int PARSED_TOKEN_CHAR_SET_INVERSE_START = -2;
    private static final int PARSED_TOKEN_CHAR_SET_STOP = -3;
    private static final int PARSED_TOKEN_CHAR_ANY = -4;
    private static final int PARSED_MODIFIER_RANGE_START = -5;
    private static final int PARSED_MODIFIER_RANGE_STOP = -6;
    private static final int PARSED_MODIFIER_ZERO_OR_MORE = -7;
    private static final int PARSED_MODIFIER_ONE_OR_MORE = -8;
    private static final int MAX_PATTERN_STORAGE = 2048;
    private static final int[] sParsedPatternScratch = new int[2048];

    static boolean matchGlobPattern(String pattern, String match) {
        int NP = pattern.length();
        if (NP <= 0) {
            return match.length() <= 0;
        }
        int NM = match.length();
        int ip = 0;
        int im = 0;
        char nextChar = pattern.charAt(0);
        while (ip < NP && im < NM) {
            boolean escaped;
            char c = nextChar;
            nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            boolean bl = escaped = c == '\\';
            if (escaped) {
                c = nextChar;
                char c2 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            }
            if (nextChar == '*') {
                if (!escaped && c == '.') {
                    if (ip >= NP - 1) {
                        return true;
                    }
                    if ((nextChar = pattern.charAt(++ip)) == '\\') {
                        char c3 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    }
                    while (match.charAt(im) != nextChar && ++im < NM) {
                    }
                    if (im == NM) {
                        return false;
                    }
                    nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    ++im;
                    continue;
                }
                while (match.charAt(im) == c && ++im < NM) {
                }
                nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                continue;
            }
            if (c != '.' && match.charAt(im) != c) {
                return false;
            }
            ++im;
        }
        if (ip >= NP && im >= NM) {
            return true;
        }
        return ip == NP - 2 && pattern.charAt(ip) == '.' && pattern.charAt(ip + 1) == '*';
    }

    static synchronized int[] parseAndVerifyAdvancedPattern(String pattern) {
        int ip = 0;
        int LP = pattern.length();
        int it = 0;
        boolean inSet = false;
        boolean inRange = false;
        boolean inCharClass = false;
        block12: while (ip < LP) {
            if (it > 2045) {
                throw new IllegalArgumentException("Pattern is too large!");
            }
            char c = pattern.charAt(ip);
            boolean addToParsedPattern = false;
            switch (c) {
                case '[': {
                    if (inSet) {
                        addToParsedPattern = true;
                        break;
                    }
                    if (pattern.charAt(ip + 1) == '^') {
                        AndroidPatternMatcher.sParsedPatternScratch[it++] = -2;
                        ++ip;
                    } else {
                        AndroidPatternMatcher.sParsedPatternScratch[it++] = -1;
                    }
                    ++ip;
                    inSet = true;
                    continue block12;
                }
                case ']': {
                    if (!inSet) {
                        addToParsedPattern = true;
                        break;
                    }
                    int parsedToken = sParsedPatternScratch[it - 1];
                    if (parsedToken == -1 || parsedToken == -2) {
                        throw new IllegalArgumentException("You must define characters in a set.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = -3;
                    inSet = false;
                    inCharClass = false;
                    break;
                }
                case '{': {
                    if (inSet) break;
                    if (it == 0 || AndroidPatternMatcher.isParsedModifier(sParsedPatternScratch[it - 1])) {
                        throw new IllegalArgumentException("Modifier must follow a token.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = -5;
                    ++ip;
                    inRange = true;
                    break;
                }
                case '}': {
                    if (!inRange) break;
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = -6;
                    inRange = false;
                    break;
                }
                case '*': {
                    if (inSet) break;
                    if (it == 0 || AndroidPatternMatcher.isParsedModifier(sParsedPatternScratch[it - 1])) {
                        throw new IllegalArgumentException("Modifier must follow a token.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = -7;
                    break;
                }
                case '+': {
                    if (inSet) break;
                    if (it == 0 || AndroidPatternMatcher.isParsedModifier(sParsedPatternScratch[it - 1])) {
                        throw new IllegalArgumentException("Modifier must follow a token.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = -8;
                    break;
                }
                case '.': {
                    if (inSet) break;
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = -4;
                    break;
                }
                case '\\': {
                    if (ip + 1 >= LP) {
                        throw new IllegalArgumentException("Escape found at end of pattern!");
                    }
                    c = pattern.charAt(++ip);
                    addToParsedPattern = true;
                    break;
                }
                default: {
                    addToParsedPattern = true;
                }
            }
            if (inSet) {
                if (inCharClass) {
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = c;
                    inCharClass = false;
                } else if (ip + 2 < LP && pattern.charAt(ip + 1) == '-' && pattern.charAt(ip + 2) != ']') {
                    inCharClass = true;
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = c;
                    ++ip;
                } else {
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = c;
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = c;
                }
            } else {
                if (inRange) {
                    int endOfSet = pattern.indexOf(125, ip);
                    if (endOfSet < 0) {
                        throw new IllegalArgumentException("Range not ended with '}'");
                    }
                    String rangeString = pattern.substring(ip, endOfSet);
                    int commaIndex = rangeString.indexOf(44);
                    try {
                        int rangeMin;
                        int rangeMax;
                        if (commaIndex < 0) {
                            int parsedRange;
                            rangeMin = rangeMax = (parsedRange = Integer.parseInt(rangeString));
                        } else {
                            rangeMin = Integer.parseInt(rangeString.substring(0, commaIndex));
                            rangeMax = commaIndex == rangeString.length() - 1 ? Integer.MAX_VALUE : Integer.parseInt(rangeString.substring(commaIndex + 1));
                        }
                        if (rangeMin > rangeMax) {
                            throw new IllegalArgumentException("Range quantifier minimum is greater than maximum");
                        }
                        AndroidPatternMatcher.sParsedPatternScratch[it++] = rangeMin;
                        AndroidPatternMatcher.sParsedPatternScratch[it++] = rangeMax;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Range number format incorrect", e);
                    }
                    ip = endOfSet;
                    continue;
                }
                if (addToParsedPattern) {
                    AndroidPatternMatcher.sParsedPatternScratch[it++] = c;
                }
            }
            ++ip;
        }
        if (inSet) {
            throw new IllegalArgumentException("Set was not terminated!");
        }
        return Arrays.copyOf(sParsedPatternScratch, it);
    }

    private static boolean isParsedModifier(int parsedChar) {
        return parsedChar == -8 || parsedChar == -7 || parsedChar == -6 || parsedChar == -5;
    }

    static boolean matchAdvancedPattern(int[] parsedPattern, String match) {
        int ip = 0;
        int im = 0;
        int LP = parsedPattern.length;
        int LM = match.length();
        int charSetStart = 0;
        int charSetEnd = 0;
        while (ip < LP) {
            int minRepetition;
            int maxRepetition;
            int tokenType;
            int patternChar = parsedPattern[ip];
            switch (patternChar) {
                case -4: {
                    tokenType = 1;
                    ++ip;
                    break;
                }
                case -2: 
                case -1: {
                    tokenType = patternChar == -1 ? 2 : 3;
                    charSetStart = ip + 1;
                    while (++ip < LP && parsedPattern[ip] != -3) {
                    }
                    charSetEnd = ip - 1;
                    ++ip;
                    break;
                }
                default: {
                    charSetStart = ip++;
                    tokenType = 0;
                }
            }
            if (ip >= LP) {
                maxRepetition = 1;
                minRepetition = 1;
            } else {
                patternChar = parsedPattern[ip];
                switch (patternChar) {
                    case -7: {
                        minRepetition = 0;
                        maxRepetition = Integer.MAX_VALUE;
                        ++ip;
                        break;
                    }
                    case -8: {
                        minRepetition = 1;
                        maxRepetition = Integer.MAX_VALUE;
                        ++ip;
                        break;
                    }
                    case -5: {
                        minRepetition = parsedPattern[++ip];
                        maxRepetition = parsedPattern[++ip];
                        ip += 2;
                        break;
                    }
                    default: {
                        maxRepetition = 1;
                        minRepetition = 1;
                    }
                }
            }
            if (minRepetition > maxRepetition) {
                return false;
            }
            int matched = AndroidPatternMatcher.matchChars(match, im, LM, tokenType, minRepetition, maxRepetition, parsedPattern, charSetStart, charSetEnd);
            if (matched == -1) {
                return false;
            }
            im += matched;
        }
        return ip >= LP && im >= LM;
    }

    private static int matchChars(String match, int im, int lm, int tokenType, int minRepetition, int maxRepetition, int[] parsedPattern, int tokenStart, int tokenEnd) {
        int matched;
        for (matched = 0; matched < maxRepetition && AndroidPatternMatcher.matchChar(match, im + matched, lm, tokenType, parsedPattern, tokenStart, tokenEnd); ++matched) {
        }
        return matched < minRepetition ? -1 : matched;
    }

    private static boolean matchChar(String match, int im, int lm, int tokenType, int[] parsedPattern, int tokenStart, int tokenEnd) {
        if (im >= lm) {
            return false;
        }
        switch (tokenType) {
            case 1: {
                return true;
            }
            case 2: {
                for (int i = tokenStart; i < tokenEnd; i += 2) {
                    char matchChar = match.charAt(im);
                    if (matchChar < parsedPattern[i] || matchChar > parsedPattern[i + 1]) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                for (int i = tokenStart; i < tokenEnd; i += 2) {
                    char matchChar = match.charAt(im);
                    if (matchChar < parsedPattern[i] || matchChar > parsedPattern[i + 1]) continue;
                    return false;
                }
                return true;
            }
            case 0: {
                return match.charAt(im) == parsedPattern[tokenStart];
            }
        }
        return false;
    }
}

