/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.url;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Luk/co/ben_gibson/url/Scheme;", "", "scheme", "", "(Ljava/lang/String;)V", "component1", "copy", "equals", "", "other", "hashCode", "", "isHttp", "isHttps", "isScheme", "value", "toString", "Companion", "url"})
public final class Scheme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String scheme;

    private Scheme(String scheme) {
        this.scheme = scheme;
        CharSequence charSequence = this.scheme;
        if (!new Regex("^[a-z]([a-z\\d+.-]+)?$", RegexOption.IGNORE_CASE).matches(charSequence)) {
            throw new IllegalArgumentException("Invalid scheme '" + this.scheme + '\'');
        }
    }

    public final boolean isScheme(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Intrinsics.areEqual((Object)this.scheme, (Object)value);
    }

    public final boolean isHttps() {
        return this.isScheme("https");
    }

    public final boolean isHttp() {
        return this.isScheme("http");
    }

    @NotNull
    public String toString() {
        return this.scheme;
    }

    private final String component1() {
        return this.scheme;
    }

    @NotNull
    public final Scheme copy(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return new Scheme(scheme);
    }

    public static /* synthetic */ Scheme copy$default(Scheme scheme, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = scheme.scheme;
        }
        return scheme.copy(string);
    }

    public int hashCode() {
        return this.scheme.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Scheme)) {
            return false;
        }
        Scheme scheme = (Scheme)other;
        return Intrinsics.areEqual((Object)this.scheme, (Object)scheme.scheme);
    }

    public /* synthetic */ Scheme(String scheme, DefaultConstructorMarker $constructor_marker) {
        this(scheme);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u0011\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Luk/co/ben_gibson/url/Scheme$Companion;", "", "()V", "http", "Luk/co/ben_gibson/url/Scheme;", "https", "invoke", "value", "", "url"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Scheme invoke(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = ((Object)StringsKt.trim((CharSequence)value)).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return new Scheme(string, null);
        }

        @NotNull
        public final Scheme https() {
            return new Scheme("https", null);
        }

        @NotNull
        public final Scheme http() {
            return new Scheme("http", null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

