/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.platform;

import com.intellij.codeWithMe.ClientId;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import uk.co.ben_gibson.git.link.git.RemoteExtensionsKt;
import uk.co.ben_gibson.git.link.git.RepositoryExtensionsKt;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.platform.PlatformRepository;
import uk.co.ben_gibson.git.link.settings.ApplicationSettings;
import uk.co.ben_gibson.git.link.settings.ProjectSettings;
import uk.co.ben_gibson.url.Host;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\b0\nJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Luk/co/ben_gibson/git/link/platform/PlatformDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "detect", "", "consumer", "Lkotlin/Function1;", "Luk/co/ben_gibson/git/link/platform/Platform;", "getPlatformForRepository", "repository", "Lgit4idea/repo/GitRepository;", "getRepositoryForFile", "projectDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "GitLink"})
@SourceDebugExtension(value={"SMAP\nPlatformDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformDetector.kt\nuk/co/ben_gibson/git/link/platform/PlatformDetector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n30#2,3:63\n43#3,3:66\n43#3,3:69\n1#4:72\n*S KotlinDebug\n*F\n+ 1 PlatformDetector.kt\nuk/co/ben_gibson/git/link/platform/PlatformDetector\n*L\n30#1:63,3\n34#1:66,3\n35#1:69,3\n*E\n"})
public final class PlatformDetector {
    @NotNull
    private final Project project;

    public PlatformDetector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void detect(@NotNull Function1<? super Platform, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        VirtualFile projectDirectory = ProjectUtil.guessProjectDir((Project)this.project);
        if (projectDirectory == null) {
            consumer.invoke(null);
            return;
        }
        this.getRepositoryForFile(projectDirectory, (Function1<? super GitRepository, Unit>)((Function1)new Function1<GitRepository, Unit>(this, consumer){
            final /* synthetic */ PlatformDetector this$0;
            final /* synthetic */ Function1<Platform, Unit> $consumer;
            {
                this.this$0 = $receiver;
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(@NotNull GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Platform platform = PlatformDetector.access$getPlatformForRepository(this.this$0, repository);
                this.$consumer.invoke((Object)platform);
            }
        }));
    }

    private final Platform getPlatformForRepository(GitRepository repository) {
        Platform platform;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectSettings> serviceClass$iv = ProjectSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ProjectSettings settings2 = (ProjectSettings)object;
        GitRemote gitRemote = RepositoryExtensionsKt.locateRemote(repository, settings2.getRemote());
        if (gitRemote == null) {
            return null;
        }
        GitRemote remote = gitRemote;
        boolean $i$f$service2 = false;
        Class<ApplicationSettings> serviceClass$iv2 = ApplicationSettings.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ApplicationSettings applicationSettings = (ApplicationSettings)object2;
        boolean $i$f$service3 = false;
        Class<PlatformRepository> serviceClass$iv3 = PlatformRepository.class;
        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv3);
        if (object3 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv3.getName() + " (classloader=" + serviceClass$iv3.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        PlatformRepository platforms = (PlatformRepository)object3;
        Host host = RemoteExtensionsKt.getDomain(remote);
        if (host != null) {
            Host it = host;
            boolean bl = false;
            platform = platforms.getByDomain(it);
            if (platform == null) {
                String string = applicationSettings.findPlatformIdByCustomDomain(it);
                if (string != null) {
                    String id = string;
                    boolean bl2 = false;
                    platform = platforms.getById(id);
                } else {
                    platform = null;
                }
            }
        } else {
            platform = null;
        }
        return platform;
    }

    private final void getRepositoryForFile(VirtualFile projectDirectory, Function1<? super GitRepository, Unit> consumer) {
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getInstance(...)");
        GitRepositoryManager gitRepositoryManager2 = gitRepositoryManager;
        GitRepository repository = (GitRepository)gitRepositoryManager2.getRepositoryForFile(projectDirectory);
        if (repository != null) {
            consumer.invoke((Object)repository);
            return;
        }
        MessageBusConnection busConnection = this.project.getMessageBus().connect();
        Topic topic = VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_REPOSITORY_MAPPING_UPDATED");
        busConnection.subscribe(topic, () -> PlatformDetector.getRepositoryForFile$lambda$2(busConnection, gitRepositoryManager2, projectDirectory, consumer));
    }

    private static final void getRepositoryForFile$lambda$2(MessageBusConnection $busConnection, GitRepositoryManager $gitRepositoryManager, VirtualFile $projectDirectory, Function1 $consumer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$busConnection, (String)"$busConnection");
            Intrinsics.checkNotNullParameter((Object)$gitRepositoryManager, (String)"$gitRepositoryManager");
            Intrinsics.checkNotNullParameter((Object)$projectDirectory, (String)"$projectDirectory");
            Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
            $busConnection.disconnect();
            GitRepository gitRepository = (GitRepository)$gitRepositoryManager.getRepositoryForFile($projectDirectory);
            if (gitRepository == null) break block0;
            $consumer.invoke((Object)gitRepository);
        }
    }

    public static final /* synthetic */ Platform access$getPlatformForRepository(PlatformDetector $this, GitRepository repository) {
        return $this.getPlatformForRepository(repository);
    }
}

