/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.change.change;

import com.maddyhome.idea.vim.action.change.change.ChangeCharacterAction;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimChangeGroup;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "changeCharacter", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "count", "", "ch", "", "getLeadingWhitespace", "", "line", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nChangeCharacterAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeCharacterAction.kt\ncom/maddyhome/idea/vim/action/change/change/ChangeCharacterActionKt\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,102:1\n34#2,4:103\n39#2:107\n*S KotlinDebug\n*F\n+ 1 ChangeCharacterAction.kt\ncom/maddyhome/idea/vim/action/change/change/ChangeCharacterActionKt\n*L\n77#1:103,4\n51#1:107\n*E\n"})
public final class ChangeCharacterActionKt {
    @NotNull
    private static final VimLogger logger;

    private static final boolean changeCharacter(VimEditor editor, VimCaret caret, int count, char ch) {
        int col = caret.getBufferPosition().getColumn();
        int len = EngineEditorHelperKt.lineLength(editor, editor.currentCaret().getBufferPosition().getLine());
        int offset = caret.getOffset();
        if (len - col < count) {
            return false;
        }
        int num = count;
        String space = null;
        if (ch == '\n') {
            num = 1;
            space = ChangeCharacterActionKt.getLeadingWhitespace(editor, editor.offsetToBufferPosition(offset).getLine());
            VimLogger $this$debug$iv = logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                VimLogger vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("space='" + space + "'");
            }
        }
        StringBuilder repl = new StringBuilder(count);
        int n = num;
        for (int i = 0; i < n; ++i) {
            repl.append(ch);
        }
        VimChangeGroup vimChangeGroup = VimInjectorKt.getInjector().getChangeGroup();
        String string = repl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        vimChangeGroup.replaceText(editor, caret, offset, offset + count, string);
        if (ch == '\n') {
            VimChangeGroup vimChangeGroup2 = VimInjectorKt.getInjector().getChangeGroup();
            String string2 = space;
            Intrinsics.checkNotNull((Object)string2);
            vimChangeGroup2.insertText(editor, caret, offset + 1, string2);
            int slen = space.length();
            if (slen == 0) {
                ++slen;
            }
            caret.moveToInlayAwareOffset(offset + slen);
        }
        return true;
    }

    private static final String getLeadingWhitespace(VimEditor $this$getLeadingWhitespace, int line) {
        int start = $this$getLeadingWhitespace.getLineStartOffset(line);
        int end = EngineEditorHelperKt.getLeadingCharacterOffset($this$getLeadingWhitespace, line, 0);
        return ((Object)$this$getLeadingWhitespace.text().subSequence(start, end)).toString();
    }

    public static final /* synthetic */ boolean access$changeCharacter(VimEditor editor, VimCaret caret, int count, char ch) {
        return ChangeCharacterActionKt.changeCharacter(editor, caret, count, ch);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(ChangeCharacterAction.class);
    }
}

