/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.ex;

import com.maddyhome.idea.vim.action.ex.CommandLineActionHandler;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/action/ex/InsertFilenameUnderCaretAction;", "Lcom/maddyhome/idea/vim/action/ex/CommandLineActionHandler;", "<init>", "()V", "execute", "", "commandLine", "Lcom/maddyhome/idea/vim/api/VimCommandLine;", "vim-engine"})
public final class InsertFilenameUnderCaretAction
extends CommandLineActionHandler {
    @Override
    protected boolean execute(@NotNull VimCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        VimEditor editor = commandLine.getEditor();
        TextRange textRange = VimInjectorKt.getInjector().getSearchGroup().getCurrentIncsearchResultRange(editor);
        int offset = textRange != null ? textRange.getEndOffset() : editor.primaryCaret().getOffset();
        TextRange range = VimInjectorKt.getInjector().getSearchHelper().findFilenameAtOrFollowingCursor(editor, offset);
        if (range == null) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(commandLine.getEditor(), VimInjectorKt.getInjector().getMessages().message("E446", new Object[0]));
            return false;
        }
        CharSequence text = editor.text();
        String filename = ((Object)text.subSequence(range.getStartOffset(), range.getEndOffset() + 1)).toString();
        commandLine.insertText(commandLine.getCaret().getOffset(), filename);
        return true;
    }
}

