/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u001e\u0010\u0002\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\"\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\nR \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/api/MultikeyMap;", "", "entries", "", "Lcom/maddyhome/idea/vim/options/Option;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "<init>", "([Lcom/maddyhome/idea/vim/options/Option;)V", "primaryKeyStorage", "", "", "secondaryKeyStorage", "put", "", "key1", "key2", "value", "get", "key", "remove", "contains", "", "values", "", "getValues", "()Ljava/util/Collection;", "vim-engine"})
final class MultikeyMap {
    @NotNull
    private final Map<String, Option<VimDataType>> primaryKeyStorage;
    @NotNull
    private final Map<String, Option<VimDataType>> secondaryKeyStorage;

    public MultikeyMap(Option<VimDataType> ... entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.primaryKeyStorage = new LinkedHashMap();
        this.secondaryKeyStorage = new LinkedHashMap();
        for (Option<VimDataType> entry : entries) {
            this.primaryKeyStorage.put(entry.getName(), entry);
            this.secondaryKeyStorage.put(entry.getAbbrev(), entry);
        }
    }

    public final void put(@NotNull String key1, @NotNull String key2, @NotNull Option<VimDataType> value) {
        Intrinsics.checkNotNullParameter((Object)key1, (String)"key1");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key2");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.primaryKeyStorage.put(key1, value);
        this.secondaryKeyStorage.put(key2, value);
    }

    @Nullable
    public final Option<VimDataType> get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Option<VimDataType> option = this.primaryKeyStorage.get(key);
        if (option == null) {
            option = this.secondaryKeyStorage.get(key);
        }
        return option;
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Option<VimDataType> option = this.primaryKeyStorage.get(key);
        if (option == null) {
            option = this.secondaryKeyStorage.get(key);
        }
        Option<VimDataType> option2 = option;
        TypeIntrinsics.asMutableCollection(this.primaryKeyStorage.values()).remove(option2);
        TypeIntrinsics.asMutableCollection(this.secondaryKeyStorage.values()).remove(option2);
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.primaryKeyStorage.containsKey(key) || this.secondaryKeyStorage.containsKey(key);
    }

    @NotNull
    public final Collection<Option<VimDataType>> getValues() {
        return this.primaryKeyStorage.values();
    }
}

