/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimStringParser;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\b&\u0018\u0000 32\u00020\u0001:\u0003123B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0016\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u000b\u0010\u0014\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0017\u0010\u001f\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u00172\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0003J\u0012\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0017\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010(J\u0017\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010(J\u001a\u0010*\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u001eH\u0002J\u001e\u0010,\u001a\u0004\u0018\u00010\u001e2\r\u0010!\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0017H\u0002\u00a2\u0006\u0002\u0010-J\u0017\u0010.\u001a\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001eH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u00064"}, d2={"Lcom/maddyhome/idea/vim/api/VimStringParserBase;", "Lcom/maddyhome/idea/vim/api/VimStringParser;", "<init>", "()V", "plugKeyStroke", "Ljavax/swing/KeyStroke;", "getPlugKeyStroke", "()Ljavax/swing/KeyStroke;", "actionKeyStroke", "getActionKeyStroke", "toPrintableString", "", "keys", "", "keyStrokeToString", "key", "toKeyNotation", "keyStrokes", "keyStroke", "parseKeys", "string", "getMapLeader", "stringToKeys", "Lorg/jetbrains/annotations/NonNls;", "isControlCharacter", "", "c", "", "isControlCharacterKeyCode", "code", "", "getVimKeyValue", "containsDisplayUppercaseKeyNames", "lower", "capitalize", "s", "toEscapeNotation", "isControlKeyCode", "parseVimScriptString", "octalDigitToNumber", "(C)Ljava/lang/Integer;", "hexDigitToNumber", "parseSpecialKey", "modifiers", "getVimKeyName", "(Ljava/lang/String;)Ljava/lang/Integer;", "getVimTypedKeyName", "(Ljava/lang/String;)Ljava/lang/Character;", "getTypedOrPressedKeyStroke", "VimStringState", "KeyParserState", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimStringParserBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimStringParserBase.kt\ncom/maddyhome/idea/vim/api/VimStringParserBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,637:1\n1#2:638\n*E\n"})
public abstract class VimStringParserBase
implements VimStringParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CMD_PREFIX = "d-";
    @NotNull
    private static final String META_PREFIX = "m-";
    @NotNull
    private static final String ALT_PREFIX = "a-";
    @NotNull
    private static final String CTRL_PREFIX = "c-";
    @NotNull
    private static final String SHIFT_PREFIX = "s-";
    private static final int VK_PLUG = 65534;
    private static final int VK_ACTION = 65533;

    @Override
    @NotNull
    public KeyStroke getPlugKeyStroke() {
        return this.parseKeys("<Plug>").get(0);
    }

    @Override
    @NotNull
    public KeyStroke getActionKeyStroke() {
        return this.parseKeys("<Action>").get(0);
    }

    @Override
    @NotNull
    public String toPrintableString(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        StringBuilder builder = new StringBuilder();
        for (KeyStroke keyStroke : keys) {
            String keyAsString = this.keyStrokeToString(keyStroke);
            builder.append(keyAsString);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String keyStrokeToString(KeyStroke key) {
        if (key.getKeyChar() != '\uffff') {
            return String.valueOf(key.getKeyChar());
        }
        if ((key.getModifiers() & 0x80) == 128) {
            return this.isControlCharacterKeyCode(key.getKeyCode()) ? (key.getKeyCode() == 74 ? "\u0000" : String.valueOf((char)(key.getKeyCode() - 65 + 1))) : "^" + (char)key.getKeyCode();
        }
        if (key.getKeyChar() == '\uffff' && key.getKeyCode() == 10) {
            return "\r";
        }
        return String.valueOf((char)key.getKeyCode());
    }

    @Override
    @NotNull
    public String toKeyNotation(@NotNull List<? extends KeyStroke> keyStrokes) {
        Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
        if (keyStrokes.isEmpty()) {
            return "<Nop>";
        }
        StringBuilder builder = new StringBuilder();
        for (KeyStroke keyStroke : keyStrokes) {
            builder.append(this.toKeyNotation(keyStroke));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String toKeyNotation(@NotNull KeyStroke keyStroke) {
        String name;
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        char c = keyStroke.getKeyChar();
        int keyCode = keyStroke.getKeyCode();
        int modifiers = keyStroke.getModifiers();
        if (c != '\uffff' && !this.isControlCharacter(c)) {
            return String.valueOf(c);
        }
        Object prefix = "";
        if ((modifiers & 0x100) != 0) {
            prefix = (String)prefix + "M-";
        }
        if ((modifiers & 0x200) != 0) {
            prefix = (String)prefix + "A-";
        }
        if ((modifiers & 0x80) != 0) {
            prefix = (String)prefix + "C-";
        }
        if ((modifiers & 0x40) != 0) {
            prefix = (String)prefix + "S-";
        }
        if ((name = this.getVimKeyValue(keyCode)) != null) {
            if (this.containsDisplayUppercaseKeyNames(name)) {
                String string = name;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toUpperCase(locale);
                v2 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            } else {
                v2 = name = this.capitalize(name);
            }
        }
        if (name == null) {
            String escape = this.toEscapeNotation(keyStroke);
            if (escape != null) {
                return escape;
            }
            try {
                char[] cArray = Character.toChars(keyCode);
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toChars(...)");
                char[] cArray2 = cArray;
                name = new String(cArray2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String string = name;
        return string != null ? "<" + (String)prefix + string + ">" : "<<" + keyStroke + ">>";
    }

    @Override
    @NotNull
    public List<KeyStroke> parseKeys(@NotNull String string) {
        List list;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        List $this$parseKeys_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        StringBuilder specialKeyBuilder = new StringBuilder();
        KeyParserState state = KeyParserState.INIT;
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    Object object;
                    Object object2;
                    Object object3;
                    switch (c) {
                        case '\\': {
                            state = KeyParserState.ESCAPE;
                            object3 = Unit.INSTANCE;
                            continue block9;
                        }
                        case '<': {
                            state = KeyParserState.SPECIAL;
                            object3 = StringsKt.clear((StringBuilder)specialKeyBuilder);
                            continue block9;
                        }
                    }
                    if (c == '\t' || c == '\n') {
                        object2 = KeyStroke.getKeyStroke((int)c, 0);
                        Intrinsics.checkNotNull((Object)object2);
                        object = object2;
                    } else if (this.isControlCharacter(c)) {
                        object2 = KeyStroke.getKeyStroke(c + 65 - 1, 128);
                        Intrinsics.checkNotNull((Object)object2);
                        object = object2;
                    } else {
                        object2 = KeyStroke.getKeyStroke(c);
                        Intrinsics.checkNotNull((Object)object2);
                        object = object2;
                    }
                    KeyStroke stroke = object;
                    object3 = $this$parseKeys_u24lambda_u240.add(stroke);
                    continue block9;
                }
                case 2: {
                    state = KeyParserState.INIT;
                    if (c != '\\') {
                        KeyStroke keyStroke = KeyStroke.getKeyStroke('\\');
                        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                        $this$parseKeys_u24lambda_u240.add(keyStroke);
                    }
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
                    Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                    Object object3 = $this$parseKeys_u24lambda_u240.add(keyStroke);
                    continue block9;
                }
                case 3: {
                    Object object2;
                    Object object3;
                    if (c == '>') {
                        String lower;
                        String specialKeyName;
                        state = KeyParserState.INIT;
                        Intrinsics.checkNotNullExpressionValue((Object)specialKeyBuilder.toString(), (String)"toString(...)");
                        object2 = specialKeyName;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)((String)object2).toLowerCase(locale), (String)"toLowerCase(...)");
                        if (!(!Intrinsics.areEqual((Object)"sid", (Object)lower))) {
                            boolean bl2 = false;
                            String string2 = "<" + specialKeyName + "> is not supported";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        if (Intrinsics.areEqual((Object)"leader", (Object)lower)) {
                            $this$parseKeys_u24lambda_u240.addAll((Collection)this.getMapLeader());
                        } else if (!Intrinsics.areEqual((Object)"nop", (Object)lower)) {
                            KeyStroke specialKey = this.parseSpecialKey(specialKeyName, 0);
                            if (specialKey != null && specialKeyName.length() > 1) {
                                v5 = $this$parseKeys_u24lambda_u240.add(specialKey);
                            } else {
                                KeyStroke keyStroke = KeyStroke.getKeyStroke('<');
                                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                                $this$parseKeys_u24lambda_u240.add(keyStroke);
                                $this$parseKeys_u24lambda_u240.addAll((Collection)this.stringToKeys(specialKeyName));
                                KeyStroke keyStroke2 = KeyStroke.getKeyStroke('>');
                                Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"getKeyStroke(...)");
                                v5 = $this$parseKeys_u24lambda_u240.add(keyStroke2);
                            }
                        }
                        object3 = Unit.INSTANCE;
                        continue block9;
                    }
                    if (c == '<') {
                        KeyStroke keyStroke = KeyStroke.getKeyStroke('<');
                        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                        $this$parseKeys_u24lambda_u240.add(keyStroke);
                        String string3 = specialKeyBuilder.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                        $this$parseKeys_u24lambda_u240.addAll((Collection)this.stringToKeys(string3));
                        object3 = StringsKt.clear((StringBuilder)specialKeyBuilder);
                        continue block9;
                    }
                    object3 = specialKeyBuilder.append(c);
                    continue block9;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (state == KeyParserState.ESCAPE) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke('\\');
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
            $this$parseKeys_u24lambda_u240.add(keyStroke);
        } else if (state == KeyParserState.SPECIAL) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke('<');
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
            $this$parseKeys_u24lambda_u240.add(keyStroke);
            String string4 = specialKeyBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            $this$parseKeys_u24lambda_u240.addAll((Collection)this.stringToKeys(string4));
        }
        return CollectionsKt.build((List)list);
    }

    private final List<KeyStroke> getMapLeader() {
        List<KeyStroke> list;
        VimDataType mapLeader = VimInjectorKt.getInjector().getVariableService().getGlobalVariableValue("mapleader");
        if (mapLeader instanceof VimString) {
            String v = ((VimString)mapLeader).getValue();
            if (StringsKt.startsWith$default((String)v, (String)"\\<", (boolean)false, (int)2, null) && v.length() >= 4 && v.charAt(v.length() - 1) == '>') {
                String string = v.substring(2, v.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                KeyStroke specialKey = this.parseSpecialKey(string, 0);
                list = specialKey != null ? CollectionsKt.listOf((Object)specialKey) : this.stringToKeys(((VimString)mapLeader).getValue());
            } else {
                list = this.stringToKeys(((VimString)mapLeader).getValue());
            }
        } else {
            list = this.stringToKeys("\\");
        }
        return list;
    }

    @Override
    @NotNull
    public List<KeyStroke> stringToKeys(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        List res = new ArrayList();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char element = string.charAt(i);
            if (this.isControlCharacter(element) && element != '\n') {
                if (element == '\u0000') {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(74, 128);
                    Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                    bl = res.add(keyStroke);
                    continue;
                }
                if (element == '\t') {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke('\t');
                    Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                    bl = res.add(keyStroke);
                    continue;
                }
                KeyStroke keyStroke = KeyStroke.getKeyStroke(element + 65 - 1, 128);
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                bl = res.add(keyStroke);
                continue;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke(element);
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
            bl = res.add(keyStroke);
        }
        return res;
    }

    private final boolean isControlCharacter(char c) {
        return Intrinsics.compare((int)c, (int)32) < 0;
    }

    private final boolean isControlCharacterKeyCode(int code) {
        return code >= 65 && code <= 95;
    }

    private final String getVimKeyValue(int c) {
        return switch (c) {
            case 10 -> "cr";
            case 155 -> "ins";
            case 36 -> "home";
            case 35 -> "end";
            case 33 -> "pageup";
            case 34 -> "pagedown";
            case 127 -> "del";
            case 27 -> "esc";
            case 8 -> "bs";
            case 9 -> "tab";
            case 38 -> "up";
            case 40 -> "down";
            case 37 -> "left";
            case 39 -> "right";
            case 112 -> "f1";
            case 113 -> "f2";
            case 114 -> "f3";
            case 115 -> "f4";
            case 116 -> "f5";
            case 117 -> "f6";
            case 118 -> "f7";
            case 119 -> "f8";
            case 120 -> "f9";
            case 121 -> "f10";
            case 122 -> "f11";
            case 123 -> "f12";
            case 61440 -> "f13";
            case 61441 -> "f14";
            case 61442 -> "f15";
            case 61443 -> "f16";
            case 61444 -> "f17";
            case 61445 -> "f18";
            case 61446 -> "f19";
            case 61447 -> "f20";
            case 61448 -> "f21";
            case 61449 -> "f22";
            case 61450 -> "f23";
            case 61451 -> "f24";
            case 65534 -> "plug";
            case 65533 -> "action";
            case 96 -> "k0";
            case 97 -> "k1";
            case 98 -> "k2";
            case 99 -> "k3";
            case 100 -> "k4";
            case 101 -> "k5";
            case 102 -> "k6";
            case 103 -> "k7";
            case 104 -> "k8";
            case 105 -> "k9";
            case 225 -> "kdown";
            case 224 -> "kup";
            case 226 -> "kleft";
            case 227 -> "kright";
            case 65483 -> "undo";
            default -> null;
        };
    }

    private final boolean containsDisplayUppercaseKeyNames(String lower) {
        return Intrinsics.areEqual((Object)"cr", (Object)lower) || Intrinsics.areEqual((Object)"bs", (Object)lower);
    }

    @Contract(pure=true)
    private final String capitalize(String s) {
        Object object;
        if (((CharSequence)s).length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            String string = s.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            object = s;
        } else {
            char c = Character.toUpperCase(s.charAt(0));
            String string = s.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = c + string;
        }
        return object;
    }

    private final String toEscapeNotation(KeyStroke key) {
        char c = key.getKeyChar();
        if (this.isControlCharacter(c)) {
            return "^" + (char)(c + 65 - 1);
        }
        if (this.isControlKeyCode(key)) {
            return "^" + (char)(key.getKeyCode() + 65 - 1);
        }
        return null;
    }

    private final boolean isControlKeyCode(KeyStroke key) {
        return key.getKeyChar() == '\uffff' && key.getKeyCode() < 32 && key.getModifiers() == 0;
    }

    @Override
    @NotNull
    public String parseVimScriptString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        StringBuilder result = new StringBuilder();
        VimStringState state = VimStringState.INIT;
        StringBuilder specialKeyBuilder = null;
        int digitsLeft = 0;
        int number = 0;
        String vimStringWithForceEnd = string + "\u0000";
        block7: for (int i = 0; i < vimStringWithForceEnd.length(); ++i) {
            char c = vimStringWithForceEnd.charAt(i);
            switch (WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
                case 1: {
                    if (c == '\\') {
                        state = VimStringState.ESCAPE;
                        continue block7;
                    }
                    if (c == '\u0000') {
                        i = vimStringWithForceEnd.length();
                        continue block7;
                    }
                    result.append(c);
                    continue block7;
                }
                case 2: {
                    Integer octalToDigital = this.octalDigitToNumber(c);
                    if (octalToDigital != null) {
                        number = octalToDigital;
                        digitsLeft = 2;
                        state = VimStringState.OCTAL_NUMBER;
                        continue block7;
                    }
                    if (Character.toLowerCase(c) == 'x') {
                        digitsLeft = 2;
                        state = VimStringState.HEX_NUMBER;
                        continue block7;
                    }
                    if (c == 'u') {
                        digitsLeft = 4;
                        state = VimStringState.HEX_NUMBER;
                        continue block7;
                    }
                    if (c == 'U') {
                        digitsLeft = 8;
                        state = VimStringState.HEX_NUMBER;
                        continue block7;
                    }
                    if (c == 'b') {
                        result.append('\b');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == 'e') {
                        result.append('\u001b');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == 'f') {
                        result.append('\f');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == 'n') {
                        result.append('\n');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == 'r') {
                        result.append('\r');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == 't') {
                        result.append('\t');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == '\\') {
                        result.append('\\');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == '\"') {
                        result.append('\"');
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == '<') {
                        state = VimStringState.SPECIAL;
                        specialKeyBuilder = new StringBuilder();
                        continue block7;
                    }
                    if (c == '\u0000') {
                        i = vimStringWithForceEnd.length();
                        continue block7;
                    }
                    result.append(c);
                    state = VimStringState.INIT;
                    continue block7;
                }
                case 3: {
                    Integer value = this.octalDigitToNumber(c);
                    if (value != null) {
                        number = number * 8 + value;
                        if (--digitsLeft != 0 && i != vimStringWithForceEnd.length() - 1) continue block7;
                        if (number != 0) {
                            result.append((char)number);
                        } else {
                            i = vimStringWithForceEnd.length();
                        }
                        number = 0;
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (number != 0) {
                        result.append((char)number);
                    } else {
                        i = vimStringWithForceEnd.length();
                    }
                    number = 0;
                    digitsLeft = 0;
                    state = VimStringState.INIT;
                    --i;
                    continue block7;
                }
                case 4: {
                    Integer val = this.hexDigitToNumber(c);
                    if (val == null) {
                        if (vimStringWithForceEnd.charAt(i - 2) == '\\') {
                            v0 = result.append(vimStringWithForceEnd.charAt(i - 1));
                        } else if (number != 0) {
                            v0 = result.append((char)number);
                        } else {
                            i = vimStringWithForceEnd.length();
                            v0 = Unit.INSTANCE;
                        }
                        number = 0;
                        digitsLeft = 0;
                        state = VimStringState.INIT;
                        --i;
                        continue block7;
                    }
                    number = number * 16 + val;
                    if (--digitsLeft != 0 && i != vimStringWithForceEnd.length() - 1) continue block7;
                    if (number != 0) {
                        result.append((char)number);
                    } else {
                        i = vimStringWithForceEnd.length();
                    }
                    number = 0;
                    state = VimStringState.INIT;
                    continue block7;
                }
                case 5: {
                    if (c == '\u0000') {
                        result.append((CharSequence)specialKeyBuilder);
                    }
                    if (c == '>') {
                        KeyStroke specialKey = this.parseSpecialKey(String.valueOf(specialKeyBuilder), 0);
                        if (specialKey != null) {
                            int keyCode = specialKey.getKeyCode();
                            boolean useKeyCode = true;
                            if (specialKey.getKeyCode() == 0) {
                                keyCode = specialKey.getKeyChar();
                            } else if ((specialKey.getModifiers() & 0x80) == 128) {
                                if (this.isControlCharacterKeyCode(specialKey.getKeyCode())) {
                                    keyCode = specialKey.getKeyCode() == 74 ? 0 : specialKey.getKeyCode() - 65 + 1;
                                } else {
                                    useKeyCode = false;
                                    result.append("\\<" + specialKeyBuilder + ">");
                                }
                            }
                            if (useKeyCode) {
                                result.append((char)keyCode);
                            }
                        } else {
                            result.append("<").append((CharSequence)specialKeyBuilder).append(">");
                        }
                        specialKeyBuilder = new StringBuilder();
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    if (c == '\u0000') {
                        result.append("<").append((CharSequence)specialKeyBuilder);
                        state = VimStringState.INIT;
                        continue block7;
                    }
                    StringBuilder stringBuilder = specialKeyBuilder;
                    Intrinsics.checkNotNull(stringBuilder);
                    stringBuilder.append(c);
                    continue block7;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        String string2 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final Integer octalDigitToNumber(char c) {
        return ('0' <= c ? c < '8' : false) ? Integer.valueOf(c - 48) : null;
    }

    private final Integer hexDigitToNumber(char c) {
        char lowerChar = Character.toLowerCase(c);
        if (Character.isDigit(lowerChar)) {
            return lowerChar - 48;
        }
        boolean bl = 'a' <= lowerChar ? lowerChar < 'g' : false;
        if (bl) {
            return lowerChar - 97 + 10;
        }
        return null;
    }

    private final KeyStroke parseSpecialKey(String s, int modifiers) {
        String string = s;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String lower = string2;
        Integer keyCode = this.getVimKeyName(lower);
        Character typedChar = this.getVimTypedKeyName(lower);
        if (keyCode != null) {
            return KeyStroke.getKeyStroke(keyCode, modifiers);
        }
        if (typedChar != null) {
            return this.getTypedOrPressedKeyStroke(typedChar.charValue(), modifiers);
        }
        if (StringsKt.startsWith$default((String)lower, (String)CMD_PREFIX, (boolean)false, (int)2, null)) {
            String string3 = s.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return this.parseSpecialKey(string3, modifiers | 0x100);
        }
        if (StringsKt.startsWith$default((String)lower, (String)META_PREFIX, (boolean)false, (int)2, null)) {
            String string4 = s.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            return this.parseSpecialKey(string4, modifiers | 0x200);
        }
        if (StringsKt.startsWith$default((String)lower, (String)ALT_PREFIX, (boolean)false, (int)2, null)) {
            String string5 = s.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return this.parseSpecialKey(string5, modifiers | 0x200);
        }
        if (StringsKt.startsWith$default((String)lower, (String)CTRL_PREFIX, (boolean)false, (int)2, null)) {
            String string6 = s.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            return this.parseSpecialKey(string6, modifiers | 0x80);
        }
        if (StringsKt.startsWith$default((String)lower, (String)SHIFT_PREFIX, (boolean)false, (int)2, null)) {
            String string7 = s.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            return this.parseSpecialKey(string7, modifiers | 0x40);
        }
        if (s.length() == 1) {
            return this.getTypedOrPressedKeyStroke(s.charAt(0), modifiers);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final Integer getVimKeyName(String lower) {
        block179: {
            block123: {
                block171: {
                    block149: {
                        block174: {
                            block168: {
                                block148: {
                                    block150: {
                                        block173: {
                                            block165: {
                                                block164: {
                                                    block163: {
                                                        block162: {
                                                            block161: {
                                                                block160: {
                                                                    block158: {
                                                                        block157: {
                                                                            block155: {
                                                                                block153: {
                                                                                    block146: {
                                                                                        block167: {
                                                                                            block159: {
                                                                                                block154: {
                                                                                                    block156: {
                                                                                                        block151: {
                                                                                                            block152: {
                                                                                                                block140: {
                                                                                                                    block134: {
                                                                                                                        block137: {
                                                                                                                            block130: {
                                                                                                                                block132: {
                                                                                                                                    block127: {
                                                                                                                                        block128: {
                                                                                                                                            block125: {
                                                                                                                                                block126: {
                                                                                                                                                    block124: {
                                                                                                                                                        block144: {
                                                                                                                                                            block143: {
                                                                                                                                                                block142: {
                                                                                                                                                                    block141: {
                                                                                                                                                                        block139: {
                                                                                                                                                                            block138: {
                                                                                                                                                                                block136: {
                                                                                                                                                                                    block133: {
                                                                                                                                                                                        block131: {
                                                                                                                                                                                            block175: {
                                                                                                                                                                                                block166: {
                                                                                                                                                                                                    block135: {
                                                                                                                                                                                                        block147: {
                                                                                                                                                                                                            block145: {
                                                                                                                                                                                                                block170: {
                                                                                                                                                                                                                    block178: {
                                                                                                                                                                                                                        block129: {
                                                                                                                                                                                                                            block177: {
                                                                                                                                                                                                                                block169: {
                                                                                                                                                                                                                                    block172: {
                                                                                                                                                                                                                                        block176: {
                                                                                                                                                                                                                                            var2_2 = lower;
                                                                                                                                                                                                                                            if (var2_2 == null) break block123;
                                                                                                                                                                                                                                            switch (var2_2.hashCode()) {
                                                                                                                                                                                                                                                case 99589: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f10")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block124;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99591: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f12")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block125;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99590: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f11")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block126;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99593: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f14")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block127;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99592: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f13")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block128;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99339: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("del")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block129;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99595: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f16")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block130;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3211: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f1")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block131;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99594: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f15")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block132;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3212: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f2")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block133;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99597: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f18")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block134;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3089570: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("down")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block135;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3213: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f3")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block136;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99596: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f17")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block137;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3214: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f4")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block138;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3215: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f5")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block139;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99598: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f19")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block140;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3216: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f6")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block141;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3217: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f7")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block142;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3218: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f8")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block143;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3219: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f9")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block144;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 114581: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("tab")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block145;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case -1422950858: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("action")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block146;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 96667352: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("enter")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    ** GOTO lbl248
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3739: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("up")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block147;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 101906317: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("kdown")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block148;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case -1123136367: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("kright")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block149;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3288208: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("kend")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block150;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99621: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f21")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block151;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99620: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f20")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block152;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3365: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k0")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block153;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99623: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f23")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block154;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3366: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k1")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block155;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99622: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f22")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block156;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3367: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k2")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block157;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3368: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k3")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block158;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 99624: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("f24")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block159;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3369: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k4")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block160;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3370: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k5")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block161;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3371: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k6")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block162;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3372: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k7")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block163;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3373: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k8")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block164;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3374: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("k9")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block165;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3317767: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("left")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block166;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3444110: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("plug")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block167;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 106566: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("kup")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block168;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case -1183792455: {
                                                                                                                                                                                                                                                    if (var2_2.equals("insert")) break;
                                                                                                                                                                                                                                                    ** break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case -995751574: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("pageup")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block169;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case -1335458389: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("delete")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block129;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3153: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("bs")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block170;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3594468: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("undo")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block171;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 1353507967: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("backspace")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block170;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 100571: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("end")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block172;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 102025162: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("khome")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block173;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 102134514: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("kleft")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block174;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 108511772: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("right")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block175;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3183: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("cr")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    ** GOTO lbl248
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 104430: {
                                                                                                                                                                                                                                                    if (var2_2.equals("ins")) break;
                                                                                                                                                                                                                                                    ** break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3208415: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("home")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block176;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 859940785: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("pagedown")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block177;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 100725: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("esc")) {
                                                                                                                                                                                                                                                        ** break;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block178;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case -934396624: {
                                                                                                                                                                                                                                                    if (!var2_2.equals("return")) ** break;
lbl248:
                                                                                                                                                                                                                                                    // 3 sources

                                                                                                                                                                                                                                                    v0 = 10;
                                                                                                                                                                                                                                                    break block179;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            v0 = 155;
                                                                                                                                                                                                                                            break block179;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        v0 = 36;
                                                                                                                                                                                                                                        break block179;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    v0 = 35;
                                                                                                                                                                                                                                    break block179;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                v0 = 33;
                                                                                                                                                                                                                                break block179;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            v0 = 34;
                                                                                                                                                                                                                            break block179;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        v0 = 127;
                                                                                                                                                                                                                        break block179;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    v0 = 27;
                                                                                                                                                                                                                    break block179;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                v0 = 8;
                                                                                                                                                                                                                break block179;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            v0 = 9;
                                                                                                                                                                                                            break block179;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        v0 = 38;
                                                                                                                                                                                                        break block179;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    v0 = 40;
                                                                                                                                                                                                    break block179;
                                                                                                                                                                                                }
                                                                                                                                                                                                v0 = 37;
                                                                                                                                                                                                break block179;
                                                                                                                                                                                            }
                                                                                                                                                                                            v0 = 39;
                                                                                                                                                                                            break block179;
                                                                                                                                                                                        }
                                                                                                                                                                                        v0 = 112;
                                                                                                                                                                                        break block179;
                                                                                                                                                                                    }
                                                                                                                                                                                    v0 = 113;
                                                                                                                                                                                    break block179;
                                                                                                                                                                                }
                                                                                                                                                                                v0 = 114;
                                                                                                                                                                                break block179;
                                                                                                                                                                            }
                                                                                                                                                                            v0 = 115;
                                                                                                                                                                            break block179;
                                                                                                                                                                        }
                                                                                                                                                                        v0 = 116;
                                                                                                                                                                        break block179;
                                                                                                                                                                    }
                                                                                                                                                                    v0 = 117;
                                                                                                                                                                    break block179;
                                                                                                                                                                }
                                                                                                                                                                v0 = 118;
                                                                                                                                                                break block179;
                                                                                                                                                            }
                                                                                                                                                            v0 = 119;
                                                                                                                                                            break block179;
                                                                                                                                                        }
                                                                                                                                                        v0 = 120;
                                                                                                                                                        break block179;
                                                                                                                                                    }
                                                                                                                                                    v0 = 121;
                                                                                                                                                    break block179;
                                                                                                                                                }
                                                                                                                                                v0 = 122;
                                                                                                                                                break block179;
                                                                                                                                            }
                                                                                                                                            v0 = 123;
                                                                                                                                            break block179;
                                                                                                                                        }
                                                                                                                                        v0 = 61440;
                                                                                                                                        break block179;
                                                                                                                                    }
                                                                                                                                    v0 = 61441;
                                                                                                                                    break block179;
                                                                                                                                }
                                                                                                                                v0 = 61442;
                                                                                                                                break block179;
                                                                                                                            }
                                                                                                                            v0 = 61443;
                                                                                                                            break block179;
                                                                                                                        }
                                                                                                                        v0 = 61444;
                                                                                                                        break block179;
                                                                                                                    }
                                                                                                                    v0 = 61445;
                                                                                                                    break block179;
                                                                                                                }
                                                                                                                v0 = 61446;
                                                                                                                break block179;
                                                                                                            }
                                                                                                            v0 = 61447;
                                                                                                            break block179;
                                                                                                        }
                                                                                                        v0 = 61448;
                                                                                                        break block179;
                                                                                                    }
                                                                                                    v0 = 61449;
                                                                                                    break block179;
                                                                                                }
                                                                                                v0 = 61450;
                                                                                                break block179;
                                                                                            }
                                                                                            v0 = 61451;
                                                                                            break block179;
                                                                                        }
                                                                                        v0 = 65534;
                                                                                        break block179;
                                                                                    }
                                                                                    v0 = 65533;
                                                                                    break block179;
                                                                                }
                                                                                v0 = 96;
                                                                                break block179;
                                                                            }
                                                                            v0 = 97;
                                                                            break block179;
                                                                        }
                                                                        v0 = 98;
                                                                        break block179;
                                                                    }
                                                                    v0 = 99;
                                                                    break block179;
                                                                }
                                                                v0 = 100;
                                                                break block179;
                                                            }
                                                            v0 = 101;
                                                            break block179;
                                                        }
                                                        v0 = 102;
                                                        break block179;
                                                    }
                                                    v0 = 103;
                                                    break block179;
                                                }
                                                v0 = 104;
                                                break block179;
                                            }
                                            v0 = 105;
                                            break block179;
                                        }
                                        v0 = 36;
                                        break block179;
                                    }
                                    v0 = 35;
                                    break block179;
                                }
                                v0 = 225;
                                break block179;
                            }
                            v0 = 224;
                            break block179;
                        }
                        v0 = 226;
                        break block179;
                    }
                    v0 = 227;
                    break block179;
                }
                v0 = 65483;
                break block179;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Character getVimTypedKeyName(String lower) {
        Character c;
        block8: {
            block9: {
                String string = lower;
                switch (string.hashCode()) {
                    case 97299: {
                        if (string.equals("bar")) break;
                        return null;
                    }
                    case 3464: {
                        if (!string.equals("lt")) {
                            return null;
                        }
                        break block8;
                    }
                    case -1379791269: {
                        if (!string.equals("bslash")) {
                            return null;
                        }
                        break block9;
                    }
                    case 109637894: {
                        if (!string.equals("space")) return null;
                        c = Character.valueOf(' ');
                        return c;
                    }
                }
                c = Character.valueOf('|');
                return c;
            }
            c = Character.valueOf('\\');
            return c;
        }
        c = Character.valueOf('<');
        return c;
        return null;
    }

    private final KeyStroke getTypedOrPressedKeyStroke(char c, int modifiers) {
        KeyStroke keyStroke;
        if (modifiers == 0) {
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(c);
            Intrinsics.checkNotNull((Object)keyStroke2);
            keyStroke = keyStroke2;
        } else if (modifiers == 64 && Character.isLetter(c)) {
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(Character.toUpperCase(c));
            Intrinsics.checkNotNull((Object)keyStroke3);
            keyStroke = keyStroke3;
        } else {
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke((int)Character.toUpperCase(c), modifiers);
            Intrinsics.checkNotNull((Object)keyStroke4);
            keyStroke = keyStroke4;
        }
        return keyStroke;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/api/VimStringParserBase$Companion;", "", "<init>", "()V", "CMD_PREFIX", "", "META_PREFIX", "ALT_PREFIX", "CTRL_PREFIX", "SHIFT_PREFIX", "VK_PLUG", "", "VK_ACTION", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/api/VimStringParserBase$KeyParserState;", "", "<init>", "(Ljava/lang/String;I)V", "INIT", "ESCAPE", "SPECIAL", "vim-engine"})
    private static final class KeyParserState
    extends Enum<KeyParserState> {
        public static final /* enum */ KeyParserState INIT = new KeyParserState();
        public static final /* enum */ KeyParserState ESCAPE = new KeyParserState();
        public static final /* enum */ KeyParserState SPECIAL = new KeyParserState();
        private static final /* synthetic */ KeyParserState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static KeyParserState[] values() {
            return (KeyParserState[])$VALUES.clone();
        }

        public static KeyParserState valueOf(String value) {
            return Enum.valueOf(KeyParserState.class, value);
        }

        @NotNull
        public static EnumEntries<KeyParserState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = keyParserStateArray = new KeyParserState[]{KeyParserState.INIT, KeyParserState.ESCAPE, KeyParserState.SPECIAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/api/VimStringParserBase$VimStringState;", "", "<init>", "(Ljava/lang/String;I)V", "INIT", "ESCAPE", "OCTAL_NUMBER", "HEX_NUMBER", "SPECIAL", "vim-engine"})
    private static final class VimStringState
    extends Enum<VimStringState> {
        public static final /* enum */ VimStringState INIT = new VimStringState();
        public static final /* enum */ VimStringState ESCAPE = new VimStringState();
        public static final /* enum */ VimStringState OCTAL_NUMBER = new VimStringState();
        public static final /* enum */ VimStringState HEX_NUMBER = new VimStringState();
        public static final /* enum */ VimStringState SPECIAL = new VimStringState();
        private static final /* synthetic */ VimStringState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VimStringState[] values() {
            return (VimStringState[])$VALUES.clone();
        }

        public static VimStringState valueOf(String value) {
            return Enum.valueOf(VimStringState.class, value);
        }

        @NotNull
        public static EnumEntries<VimStringState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = vimStringStateArray = new VimStringState[]{VimStringState.INIT, VimStringState.ESCAPE, VimStringState.OCTAL_NUMBER, VimStringState.HEX_NUMBER, VimStringState.SPECIAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KeyParserState.values().length];
            try {
                nArray[KeyParserState.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyParserState.ESCAPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyParserState.SPECIAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VimStringState.values().length];
            try {
                nArray[VimStringState.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimStringState.ESCAPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimStringState.OCTAL_NUMBER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimStringState.HEX_NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimStringState.SPECIAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

