/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.LiveRange;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001d\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/common/VimEditorReplaceMask;", "", "<init>", "()V", "changedChars", "", "Lcom/maddyhome/idea/vim/common/LiveRange;", "", "recordChangeAtCaret", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "popChange", "offset", "", "(Lcom/maddyhome/idea/vim/api/VimEditor;I)Ljava/lang/Character;", "vim-engine"})
public final class VimEditorReplaceMask {
    @NotNull
    private final Map<LiveRange, Character> changedChars = new LinkedHashMap();

    public final void recordChangeAtCaret(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        for (VimCaret caret : editor.carets()) {
            int offset = caret.getOffset();
            if ((long)offset >= editor.fileSize()) continue;
            LiveRange marker = editor.createLiveMarker(offset, offset);
            this.changedChars.put(marker, Character.valueOf(editor.charAt(offset)));
        }
    }

    @Nullable
    public final Character popChange(@NotNull VimEditor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LiveRange marker = editor.createLiveMarker(offset, offset);
        Character change = this.changedChars.get(marker);
        this.changedChars.remove(marker);
        return change;
    }
}

