/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.EditorListener;
import com.maddyhome.idea.vim.common.IsReplaceCharListener;
import com.maddyhome.idea.vim.common.Listener;
import com.maddyhome.idea.vim.common.ListenerOwner;
import com.maddyhome.idea.vim.common.MacroRecordingListener;
import com.maddyhome.idea.vim.common.ModeChangeListener;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimPluginListener;
import com.maddyhome.idea.vim.common.VimYankListener;
import com.maddyhome.idea.vim.state.mode.Mode;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020\u0018J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010&\u001a\u00020\u00182\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(J(\u0010+\u001a\u00020\u0018\"\b\b\u0000\u0010,*\u00020-2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H,0\u0005H\u0002J\u000e\u0010+\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/J\u0006\u00101\u001a\u00020\u0018R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u00062"}, d2={"Lcom/maddyhome/idea/vim/common/VimListenersNotifier;", "", "<init>", "()V", "modeChangeListeners", "", "Lcom/maddyhome/idea/vim/common/ModeChangeListener;", "getModeChangeListeners", "()Ljava/util/Collection;", "myEditorListeners", "Lcom/maddyhome/idea/vim/common/EditorListener;", "getMyEditorListeners", "macroRecordingListeners", "Lcom/maddyhome/idea/vim/common/MacroRecordingListener;", "getMacroRecordingListeners", "vimPluginListeners", "Lcom/maddyhome/idea/vim/common/VimPluginListener;", "getVimPluginListeners", "isReplaceCharListeners", "Lcom/maddyhome/idea/vim/common/IsReplaceCharListener;", "yankListeners", "Lcom/maddyhome/idea/vim/common/VimYankListener;", "getYankListeners", "notifyModeChanged", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "oldMode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "notifyEditorCreated", "notifyEditorReleased", "notifyEditorFocusGained", "notifyEditorFocusLost", "notifyMacroRecordingStarted", "notifyMacroRecordingFinished", "notifyPluginTurnedOn", "notifyPluginTurnedOff", "notifyIsReplaceCharChanged", "notifyYankPerformed", "caretToRange", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "Lcom/maddyhome/idea/vim/common/TextRange;", "unloadListeners", "T", "Lcom/maddyhome/idea/vim/common/Listener;", "listenerOwner", "Lcom/maddyhome/idea/vim/common/ListenerOwner;", "listenerCollection", "reset", "vim-engine"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVimListenersNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimListenersNotifier.kt\ncom/maddyhome/idea/vim/common/VimListenersNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,106:1\n1869#2,2:107\n1869#2,2:109\n1869#2,2:111\n1869#2,2:113\n1869#2,2:115\n1869#2,2:117\n1869#2,2:119\n1869#2,2:121\n1869#2,2:123\n1869#2,2:125\n1869#2,2:127\n13805#3,2:129\n*S KotlinDebug\n*F\n+ 1 VimListenersNotifier.kt\ncom/maddyhome/idea/vim/common/VimListenersNotifier\n*L\n29#1:107,2\n34#1:109,2\n39#1:111,2\n44#1:113,2\n49#1:115,2\n54#1:117,2\n59#1:119,2\n63#1:121,2\n67#1:123,2\n72#1:125,2\n77#1:127,2\n95#1:129,2\n*E\n"})
public final class VimListenersNotifier {
    @NotNull
    private final Collection<ModeChangeListener> modeChangeListeners = new ConcurrentLinkedDeque();
    @NotNull
    private final Collection<EditorListener> myEditorListeners = new ConcurrentLinkedDeque();
    @NotNull
    private final Collection<MacroRecordingListener> macroRecordingListeners = new ConcurrentLinkedDeque();
    @NotNull
    private final Collection<VimPluginListener> vimPluginListeners = new ConcurrentLinkedDeque();
    @NotNull
    private final Collection<IsReplaceCharListener> isReplaceCharListeners = new ConcurrentLinkedDeque();
    @NotNull
    private final Collection<VimYankListener> yankListeners = new ConcurrentLinkedDeque();

    @NotNull
    public final Collection<ModeChangeListener> getModeChangeListeners() {
        return this.modeChangeListeners;
    }

    @NotNull
    public final Collection<EditorListener> getMyEditorListeners() {
        return this.myEditorListeners;
    }

    @NotNull
    public final Collection<MacroRecordingListener> getMacroRecordingListeners() {
        return this.macroRecordingListeners;
    }

    @NotNull
    public final Collection<VimPluginListener> getVimPluginListeners() {
        return this.vimPluginListeners;
    }

    @NotNull
    public final Collection<IsReplaceCharListener> isReplaceCharListeners() {
        return this.isReplaceCharListeners;
    }

    @NotNull
    public final Collection<VimYankListener> getYankListeners() {
        return this.yankListeners;
    }

    public final void notifyModeChanged(@NotNull VimEditor editor, @NotNull Mode oldMode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)oldMode, (String)"oldMode");
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.modeChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModeChangeListener it = (ModeChangeListener)element$iv;
            boolean bl = false;
            it.modeChanged(editor, oldMode);
        }
    }

    public final void notifyEditorCreated(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.myEditorListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorListener it = (EditorListener)element$iv;
            boolean bl = false;
            it.created(editor);
        }
    }

    public final void notifyEditorReleased(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.myEditorListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorListener it = (EditorListener)element$iv;
            boolean bl = false;
            it.released(editor);
        }
    }

    public final void notifyEditorFocusGained(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.myEditorListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorListener it = (EditorListener)element$iv;
            boolean bl = false;
            it.focusGained(editor);
        }
    }

    public final void notifyEditorFocusLost(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.myEditorListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorListener it = (EditorListener)element$iv;
            boolean bl = false;
            it.focusLost(editor);
        }
    }

    public final void notifyMacroRecordingStarted() {
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.macroRecordingListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MacroRecordingListener it = (MacroRecordingListener)element$iv;
            boolean bl = false;
            it.recordingStarted();
        }
    }

    public final void notifyMacroRecordingFinished() {
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.macroRecordingListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MacroRecordingListener it = (MacroRecordingListener)element$iv;
            boolean bl = false;
            it.recordingFinished();
        }
    }

    public final void notifyPluginTurnedOn() {
        Iterable $this$forEach$iv = this.vimPluginListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimPluginListener it = (VimPluginListener)element$iv;
            boolean bl = false;
            it.turnedOn();
        }
    }

    public final void notifyPluginTurnedOff() {
        Iterable $this$forEach$iv = this.vimPluginListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimPluginListener it = (VimPluginListener)element$iv;
            boolean bl = false;
            it.turnedOff();
        }
    }

    public final void notifyIsReplaceCharChanged(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.isReplaceCharListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IsReplaceCharListener it = (IsReplaceCharListener)element$iv;
            boolean bl = false;
            it.isReplaceCharChanged(editor);
        }
    }

    public final void notifyYankPerformed(@NotNull Map<ImmutableVimCaret, TextRange> caretToRange) {
        Intrinsics.checkNotNullParameter(caretToRange, (String)"caretToRange");
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = this.yankListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimYankListener it = (VimYankListener)element$iv;
            boolean bl = false;
            it.yankPerformed(caretToRange);
        }
    }

    private final <T extends Listener> void unloadListeners(ListenerOwner listenerOwner, Collection<T> listenerCollection) {
        listenerCollection.removeIf(arg_0 -> VimListenersNotifier.unloadListeners$lambda$1(arg_0 -> VimListenersNotifier.unloadListeners$lambda$0(listenerOwner, arg_0), arg_0));
    }

    public final void unloadListeners(@NotNull ListenerOwner listenerOwner) {
        Intrinsics.checkNotNullParameter((Object)listenerOwner, (String)"listenerOwner");
        Collection[] collectionArray = new Collection[]{this.modeChangeListeners, this.myEditorListeners, this.macroRecordingListeners, this.vimPluginListeners, this.isReplaceCharListeners, this.yankListeners};
        Collection[] $this$forEach$iv = collectionArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Collection element$iv;
            Collection it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.unloadListeners(listenerOwner, it);
        }
    }

    public final void reset() {
        this.modeChangeListeners.clear();
        this.myEditorListeners.clear();
        this.macroRecordingListeners.clear();
        this.vimPluginListeners.clear();
        this.isReplaceCharListeners.clear();
    }

    private static final boolean unloadListeners$lambda$0(ListenerOwner $listenerOwner, Listener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getOwner(), (Object)$listenerOwner);
    }

    private static final boolean unloadListeners$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

