/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.SearchGroupKt;
import com.maddyhome.idea.vim.group.State;
import com.maddyhome.idea.vim.group.StringUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003\u001a\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003\u001a\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003\u001a \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003\u001a\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001a\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a5\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001d\u001a \u0010\u001e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u001f\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010$\u001a\u001f\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010$\u001a-\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0007\u00a2\u0006\u0002\u0010)\u001aI\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010,\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010-\u001aK\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u00072\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010/\u001a0\u00100\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0003\u001a>\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u0001032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0007H\u0002\u001a5\u00104\u001a\u0004\u0018\u00010\u0007*\u00020\"2\u0006\u0010!\u001a\u0002052\u0006\u0010#\u001a\u00020\u00072\b\u00106\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u00107\u001a \u00108\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"2\u0006\u00109\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003\u001a \u0010:\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"2\u0006\u00109\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003\u001a*\u0010;\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"2\u0006\u00109\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u0003H\u0002\u001a\u0018\u0010=\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0002\u001a2\u0010A\u001a\b\u0012\u0004\u0012\u0002HB0?\"\u0004\b\u0000\u0010B*\b\u0012\u0004\u0012\u0002HB0?2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u0002HB\u0012\u0004\u0012\u00020\u00030DH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"BLOCK_CHARS", "", "isInsideComment", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "pos", "", "isInsideSingleQuotes", "isInner", "isInsideDoubleQuotes", "isInsideString", "getStringAtPos", "Lcom/maddyhome/idea/vim/common/TextRange;", "getCommentsOppositeBoundary", "(Lcom/maddyhome/idea/vim/api/VimEditor;I)Ljava/lang/Integer;", "findMatchingPairOnCurrentLine", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;)Ljava/lang/Integer;", "parsMatchPairsOption", "", "", "findMatchingChar", "start", "charToMatch", "pairChar", "direction", "Lcom/maddyhome/idea/vim/common/Direction;", "(Lcom/maddyhome/idea/vim/api/VimEditor;ICCLcom/maddyhome/idea/vim/common/Direction;)Ljava/lang/Integer;", "getRangeOfNonBlockComments", "startComment", "findNextNonWhitespaceChar", "chars", "", "startIndex", "(Ljava/lang/CharSequence;I)Ljava/lang/Integer;", "findPreviousNonWhitespaceChar", "findUnmatchedBlock", "type", "count", "(Lcom/maddyhome/idea/vim/api/VimEditor;ICI)Ljava/lang/Integer;", "findBlockLocation", "range", "delta", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/common/TextRange;ICCLcom/maddyhome/idea/vim/common/Direction;I)Ljava/lang/Integer;", "rangeToSearch", "(Lcom/maddyhome/idea/vim/api/VimEditor;ICCLcom/maddyhome/idea/vim/common/Direction;ILcom/maddyhome/idea/vim/common/TextRange;)Ljava/lang/Integer;", "findBlockRange", "isOuter", "findBlock", "Lkotlin/Pair;", "indexOfAnyOrNullInDirection", "", "escaped", "(Ljava/lang/CharSequence;[CILjava/lang/Boolean;Lcom/maddyhome/idea/vim/common/Direction;)Ljava/lang/Integer;", "getDoubleQuotesRangeNoPSI", "currentPos", "getSingleQuotesRangeNoPSI", "getQuoteRangeNoPSI", "isSingleQuotes", "isEscaped", "quotesChanges", "Lkotlin/sequences/Sequence;", "Lcom/maddyhome/idea/vim/group/State;", "takeWhileInclusive", "T", "predicate", "Lkotlin/Function1;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nSearchGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchGroup.kt\ncom/maddyhome/idea/vim/group/SearchGroupKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,610:1\n230#2,2:611\n774#2:613\n865#2,2:614\n1193#2,2:616\n1267#2,4:618\n320#3,7:622\n183#3,2:629\n183#3,2:631\n*S KotlinDebug\n*F\n+ 1 SearchGroup.kt\ncom/maddyhome/idea/vim/group/SearchGroupKt\n*L\n141#1:611,2\n149#1:613\n149#1:614,2\n150#1:616,2\n150#1:618,4\n538#1:622,7\n539#1:629,2\n540#1:631,2\n*E\n"})
public final class SearchGroupKt {
    @NotNull
    public static final String BLOCK_CHARS = "{}()[]<>";

    public static final boolean isInsideComment(@NotNull VimEditor editor, int pos) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return VimInjectorKt.getInjector().getPsiService().getCommentAtPos(editor, pos) != null;
    }

    public static final boolean isInsideSingleQuotes(@NotNull VimEditor editor, int pos, boolean isInner) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = VimInjectorKt.getInjector().getPsiService().getSingleQuotedString(editor, pos, isInner);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        return range.contains(pos);
    }

    public static final boolean isInsideDoubleQuotes(@NotNull VimEditor editor, int pos, boolean isInner) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = VimInjectorKt.getInjector().getPsiService().getDoubleQuotedString(editor, pos, isInner);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        return range.contains(pos);
    }

    public static final boolean isInsideString(@NotNull VimEditor editor, int pos, boolean isInner) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = SearchGroupKt.getStringAtPos(editor, pos, isInner);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        return range.contains(pos);
    }

    @Nullable
    public static final TextRange getStringAtPos(@NotNull VimEditor editor, int pos, boolean isInner) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = VimInjectorKt.getInjector().getPsiService().getDoubleQuotedString(editor, pos, isInner);
        if (textRange == null) {
            textRange = VimInjectorKt.getInjector().getPsiService().getSingleQuotedString(editor, pos, isInner);
        }
        return textRange;
    }

    @Nullable
    public static final Integer getCommentsOppositeBoundary(@NotNull VimEditor editor, int pos) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Pair<TextRange, Pair<String, String>> pair = VimInjectorKt.getInjector().getPsiService().getCommentAtPos(editor, pos);
        if (pair == null) {
            return null;
        }
        Pair<TextRange, Pair<String, String>> pair2 = pair;
        TextRange range = (TextRange)pair2.component1();
        Pair prefixToSuffix = (Pair)pair2.component2();
        if (prefixToSuffix == null) {
            return null;
        }
        return pos < range.getStartOffset() + ((String)prefixToSuffix.getFirst()).length() ? Integer.valueOf(range.getEndOffset() - 1) : (pos >= range.getEndOffset() - ((String)prefixToSuffix.getSecond()).length() ? Integer.valueOf(range.getStartOffset()) : null);
    }

    @Nullable
    public static final Integer findMatchingPairOnCurrentLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        char c;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int pos = caret.getOffset();
        Integer commentPos = SearchGroupKt.getCommentsOppositeBoundary(editor, pos);
        if (commentPos != null) {
            return commentPos;
        }
        int lineEnd = editor.getLineEndOffset(caret.getBufferPosition().getLine());
        if (pos > 0 && pos >= lineEnd) {
            pos = lineEnd - 1;
        }
        CharSequence chars = editor.text();
        Map<Character, Character> charPairs = SearchGroupKt.parsMatchPairsOption(editor);
        Set pairChars = SetsKt.plus(charPairs.keySet(), (Iterable)charPairs.values());
        if (!pairChars.contains(Character.valueOf(chars.charAt(pos)))) {
            Integer n = StringUtilKt.indexOfAnyOrNull(chars, CollectionsKt.toCharArray((Collection)pairChars), pos, lineEnd, null);
            if (n == null) {
                return null;
            }
            pos = n;
        }
        char charToMatch = chars.charAt(pos);
        Character c2 = charPairs.get(Character.valueOf(charToMatch));
        if (c2 != null) {
            c = c2.charValue();
        } else {
            Object element$iv2;
            block7: {
                Iterable $this$first$iv = charPairs.entrySet();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Map.Entry it = (Map.Entry)element$iv2;
                    boolean bl = false;
                    if (!(((Character)it.getValue()).charValue() == charToMatch)) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            c = ((Character)((Map.Entry)element$iv2).getKey()).charValue();
        }
        char pairChar = c;
        Direction direction = charPairs.containsKey(Character.valueOf(charToMatch)) ? Direction.FORWARDS : Direction.BACKWARDS;
        return SearchGroupKt.findMatchingChar(editor, pos, charToMatch, pairChar, direction);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Character, Character> parsMatchPairsOption(VimEditor editor) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)((Object)VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getMatchpairs());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(it.length() == 3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)Character.valueOf(it.charAt(0)), (Object)Character.valueOf(it.charAt(2)));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    @Nullable
    public static final Integer findMatchingChar(@NotNull VimEditor editor, int start, char charToMatch, char pairChar, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        TextRange stringRange = SearchGroupKt.getStringAtPos(editor, start, true);
        if (stringRange != null && stringRange.contains(start)) {
            return SearchGroupKt.findBlockLocation$default(editor, stringRange, start, charToMatch, pairChar, direction, 0, 64, null);
        }
        Pair<TextRange, Pair<String, String>> comment = VimInjectorKt.getInjector().getPsiService().getCommentAtPos(editor, start);
        if (comment != null && ((TextRange)comment.getFirst()).contains(start)) {
            Integer n;
            Pair prefixToSuffix = (Pair)comment.getSecond();
            if (prefixToSuffix != null) {
                n = SearchGroupKt.findBlockLocation$default(editor, (TextRange)comment.getFirst(), start, charToMatch, pairChar, direction, 0, 64, null);
            } else {
                TextRange commentRange = SearchGroupKt.getRangeOfNonBlockComments(editor, (TextRange)comment.getFirst(), direction);
                n = SearchGroupKt.findBlockLocation$default(editor, commentRange, start, charToMatch, pairChar, direction, 0, 64, null);
            }
            return n;
        }
        return SearchGroupKt.findBlockLocation$default(editor, start, charToMatch, pairChar, direction, 0, null, 64, null);
    }

    private static final TextRange getRangeOfNonBlockComments(VimEditor editor, TextRange startComment, Direction direction) {
        TextRange lastComment = startComment;
        while (true) {
            Integer n = direction == Direction.FORWARDS ? SearchGroupKt.findNextNonWhitespaceChar(editor.text(), lastComment.getEndOffset()) : SearchGroupKt.findPreviousNonWhitespaceChar(editor.text(), lastComment.getStartOffset() - 1);
            if (n == null) {
                break;
            }
            int nextNonWhitespaceChar = n;
            Pair<TextRange, Pair<String, String>> nextComment = VimInjectorKt.getInjector().getPsiService().getCommentAtPos(editor, nextNonWhitespaceChar);
            if (nextComment == null || nextComment.getSecond() != null) break;
            lastComment = (TextRange)nextComment.getFirst();
        }
        return direction == Direction.FORWARDS ? new TextRange(startComment.getStartOffset(), lastComment.getEndOffset()) : new TextRange(lastComment.getStartOffset(), startComment.getEndOffset());
    }

    private static final Integer findNextNonWhitespaceChar(CharSequence chars, int startIndex) {
        int i = startIndex;
        int n = StringsKt.getLastIndex((CharSequence)chars);
        if (i <= n) {
            while (true) {
                if (!CharsKt.isWhitespace((char)chars.charAt(i))) {
                    return i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return null;
    }

    private static final Integer findPreviousNonWhitespaceChar(CharSequence chars, int startIndex) {
        for (int i = startIndex; -1 < i; --i) {
            if (CharsKt.isWhitespace((char)chars.charAt(i))) continue;
            return i;
        }
        return null;
    }

    @Nullable
    public static final Integer findUnmatchedBlock(@NotNull VimEditor editor, int pos, char type, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence chars = editor.text();
        int loc = StringsKt.indexOf$default((CharSequence)BLOCK_CHARS, (char)type, (int)0, (boolean)false, (int)6, null);
        Direction direction = loc % 2 == 0 ? Direction.BACKWARDS : Direction.FORWARDS;
        char charToMatch = BLOCK_CHARS.charAt(loc);
        char pairChar = BLOCK_CHARS.charAt(loc - direction.toInt());
        int start = pos < chars.length() && (chars.charAt(pos) == type || chars.charAt(pos) == pairChar) ? pos + direction.toInt() : pos;
        return SearchGroupKt.findBlockLocation$default(editor, start, charToMatch, pairChar, direction, count, null, 64, null);
    }

    private static final Integer findBlockLocation(VimEditor editor, TextRange range, int start, char charToMatch, char pairChar, Direction direction, int delta) {
        boolean strictEscapeMatching = true;
        CharSequence chars = editor.text();
        int depth = 0;
        Boolean escapedRestriction = SearchGroupKt.isEscaped(chars, start);
        Integer i = start;
        while (i != null && range.contains(i)) {
            char c = chars.charAt(i);
            char c2 = c;
            if (c2 == charToMatch) {
                ++depth;
            } else if (c2 == pairChar) {
                --depth;
            }
            if (depth == delta && (c == charToMatch || c == pairChar)) {
                return i;
            }
            char[] cArray = new char[]{charToMatch, pairChar};
            i = SearchGroupKt.indexOfAnyOrNullInDirection(chars, cArray, i + direction.toInt(), escapedRestriction, direction);
        }
        return null;
    }

    static /* synthetic */ Integer findBlockLocation$default(VimEditor vimEditor, TextRange textRange, int n, char c, char c2, Direction direction, int n2, int n3, Object object) {
        if ((n3 & 0x40) != 0) {
            n2 = 0;
        }
        return SearchGroupKt.findBlockLocation(vimEditor, textRange, n, c, c2, direction, n2);
    }

    private static final Integer findBlockLocation(VimEditor editor, int start, char charToMatch, char pairChar, Direction direction, int delta, TextRange rangeToSearch) {
        boolean strictEscapeMatching = true;
        CharSequence chars = editor.text();
        Integer result = null;
        int depth = 0;
        Boolean escapedRestriction = SearchGroupKt.isEscaped(chars, start);
        Integer i = start;
        while (i != null && (rangeToSearch == null || rangeToSearch.contains(i))) {
            char c;
            if (rangeToSearch == null) {
                TextRange rangeToSkip;
                TextRange textRange = SearchGroupKt.getStringAtPos(editor, i, false);
                if (textRange == null) {
                    Pair<TextRange, Pair<String, String>> pair = VimInjectorKt.getInjector().getPsiService().getCommentAtPos(editor, i);
                    textRange = pair != null ? (TextRange)pair.getFirst() : null;
                }
                if ((rangeToSkip = textRange) != null) {
                    int searchStart = direction == Direction.FORWARDS ? rangeToSkip.getEndOffset() : rangeToSkip.getStartOffset() - 1;
                    char[] cArray = new char[]{charToMatch, pairChar};
                    i = SearchGroupKt.indexOfAnyOrNullInDirection(chars, cArray, searchStart, escapedRestriction, direction);
                    continue;
                }
            }
            if ((c = chars.charAt(i)) == charToMatch) {
                ++depth;
                if (delta > 0) {
                    result = i;
                }
            } else if (c == pairChar) {
                --depth;
                if (delta < 0) {
                    result = i;
                }
            }
            if (depth == delta && (chars.charAt(i) == charToMatch || chars.charAt(i) == pairChar)) {
                result = i;
                break;
            }
            char[] cArray = new char[]{charToMatch, pairChar};
            i = SearchGroupKt.indexOfAnyOrNullInDirection(chars, cArray, i + direction.toInt(), escapedRestriction, direction);
        }
        return result;
    }

    static /* synthetic */ Integer findBlockLocation$default(VimEditor vimEditor, int n, char c, char c2, Direction direction, int n2, TextRange textRange, int n3, Object object) {
        if ((n3 & 0x40) != 0) {
            textRange = null;
        }
        return SearchGroupKt.findBlockLocation(vimEditor, n, c, c2, direction, n2, textRange);
    }

    @Nullable
    public static final TextRange findBlockRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, char type, int count, boolean isOuter) {
        boolean rangeSelection;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        CharSequence chars = editor.text();
        int pos = caret.getOffset();
        int start = caret.getSelectionStart();
        int end = caret.getSelectionEnd();
        int loc = StringsKt.indexOf$default((CharSequence)BLOCK_CHARS, (char)type, (int)0, (boolean)false, (int)6, null);
        char close = BLOCK_CHARS.charAt(loc + 1);
        if (!isOuter) {
            if (start > 1 && chars.charAt(start - 2) == type && chars.charAt(start - 1) == '\n') {
                --start;
            }
            if (end < chars.length() && chars.charAt(end) == '\n') {
                boolean isSingleLineAllWhiteSpaceUntilClose = false;
                int countWhiteSpaceCharacter = 1;
                while (end + countWhiteSpaceCharacter < chars.length()) {
                    if (Character.isWhitespace(chars.charAt(end + countWhiteSpaceCharacter)) && chars.charAt(end + countWhiteSpaceCharacter) != '\n') {
                        ++countWhiteSpaceCharacter;
                        continue;
                    }
                    if (chars.charAt(end + countWhiteSpaceCharacter) != close) break;
                    isSingleLineAllWhiteSpaceUntilClose = true;
                    break;
                }
                if (isSingleLineAllWhiteSpaceUntilClose) {
                    end += countWhiteSpaceCharacter;
                }
            }
        }
        boolean bl = rangeSelection = end - start > 1;
        if (rangeSelection && start == 0) {
            return null;
        }
        if (!isOuter && start - 1 >= 0 && type == chars.charAt(start - 1) && end < chars.length() && close == chars.charAt(end)) {
            pos = --start;
            rangeSelection = true;
        }
        if (rangeSelection) {
            pos = (int)Math.max(0.0, (double)(start - 1));
        }
        Pair<Integer, Integer> pair = SearchGroupKt.findBlock(editor, pos, type, close, count);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int blockStart = ((Number)pair2.component1()).intValue();
        int blockEnd = ((Number)pair2.component2()).intValue();
        if (!isOuter) {
            if (chars.charAt(++blockStart) == '\n') {
                ++blockStart;
            }
            int o = EngineEditorHelperKt.getLineStartForOffset(editor, blockEnd);
            boolean allWhite = true;
            int n = blockEnd;
            for (int i = o; i < n; ++i) {
                if (Character.isWhitespace(chars.charAt(i))) continue;
                allWhite = false;
                break;
            }
            blockEnd = allWhite ? o - 2 : --blockEnd;
        }
        return new TextRange(blockStart, blockEnd + 1);
    }

    private static final Pair<Integer, Integer> findBlock(VimEditor editor, int pos, char charToMatch, char pairChar, int count) {
        TextRange textRange = SearchGroupKt.getStringAtPos(editor, pos, true);
        if (textRange == null) {
            Pair<TextRange, Pair<String, String>> pair = VimInjectorKt.getInjector().getPsiService().getCommentAtPos(editor, pos);
            textRange = pair != null ? (TextRange)pair.getFirst() : null;
        }
        TextRange blockAtPos = textRange;
        Integer blockStart = null;
        Integer blockEnd = null;
        if (blockAtPos != null && (blockStart = SearchGroupKt.findBlockLocation(editor, pos, charToMatch, pairChar, Direction.BACKWARDS, editor.text().charAt(pos) == pairChar ? count - 1 : count, blockAtPos)) != null && (blockEnd = SearchGroupKt.findBlockLocation(editor, blockStart, pairChar, charToMatch, Direction.FORWARDS, 0, blockAtPos)) != null && blockEnd >= pos) {
            return TuplesKt.to((Object)blockStart, (Object)blockEnd);
        }
        blockStart = SearchGroupKt.findBlockLocation$default(editor, pos, charToMatch, pairChar, Direction.BACKWARDS, editor.text().charAt(pos) == pairChar ? count - 1 : count, null, 64, null);
        if (blockStart != null && (blockEnd = SearchGroupKt.findBlockLocation$default(editor, blockStart, charToMatch, pairChar, Direction.FORWARDS, 0, null, 64, null)) != null && blockEnd >= pos) {
            return TuplesKt.to((Object)blockStart, (Object)blockEnd);
        }
        if (count > 1) {
            return null;
        }
        blockStart = StringUtilKt.indexOfOrNull$default(editor.text(), charToMatch, pos, 0, null, 12, null);
        while (blockStart != null) {
            Pair<TextRange, Pair<String, String>> containingBlock;
            Pair<TextRange, Pair<String, String>> pair = SearchGroupKt.getStringAtPos(editor, blockStart, false);
            if (pair == null) {
                pair = VimInjectorKt.getInjector().getPsiService().getCommentAtPos(editor, blockStart);
            }
            if ((containingBlock = pair) != null) {
                Integer n = blockEnd = SearchGroupKt.findMatchingChar(editor, blockStart, charToMatch, pairChar, Direction.FORWARDS);
                if (n != null) {
                    return TuplesKt.to((Object)blockStart, (Object)n);
                }
                blockStart = StringUtilKt.indexOfOrNull$default(editor.text(), charToMatch, blockStart + 1, 0, null, 12, null);
                continue;
            }
            Integer n = blockEnd = SearchGroupKt.findMatchingChar(editor, blockStart, charToMatch, pairChar, Direction.FORWARDS);
            if (n == null) break;
            return TuplesKt.to((Object)blockStart, (Object)n);
        }
        return null;
    }

    private static final Integer indexOfAnyOrNullInDirection(CharSequence $this$indexOfAnyOrNullInDirection, char[] chars, int startIndex, Boolean escaped, Direction direction) {
        return direction == Direction.FORWARDS ? StringUtilKt.indexOfAnyOrNull($this$indexOfAnyOrNullInDirection, chars, startIndex, $this$indexOfAnyOrNullInDirection.length(), escaped) : StringUtilKt.lastIndexOfAnyOrNull($this$indexOfAnyOrNullInDirection, chars, startIndex, -1, escaped);
    }

    @Nullable
    public static final TextRange getDoubleQuotesRangeNoPSI(@NotNull CharSequence chars, int currentPos, boolean isInner) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return SearchGroupKt.getQuoteRangeNoPSI(chars, currentPos, isInner, false);
    }

    @Nullable
    public static final TextRange getSingleQuotesRangeNoPSI(@NotNull CharSequence chars, int currentPos, boolean isInner) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return SearchGroupKt.getQuoteRangeNoPSI(chars, currentPos, isInner, true);
    }

    private static final TextRange getQuoteRangeNoPSI(CharSequence chars, int currentPos, boolean isInner, boolean isSingleQuotes) {
        Pair pair;
        Function1 inQuoteCheck2;
        Object v1;
        State atPos;
        State beforePos;
        block11: {
            Object v0;
            Sequence<State> changes;
            block10: {
                State it;
                if (!(0 <= currentPos ? currentPos <= StringsKt.getLastIndex((CharSequence)chars) : false)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int start = StringsKt.lastIndexOf$default((CharSequence)chars, (char)'\n', (int)currentPos, (boolean)false, (int)4, null) + 1;
                Sequence<State> $this$lastOrNull$iv = changes = SearchGroupKt.takeWhileInclusive(SearchGroupKt.quotesChanges(chars, start), arg_0 -> SearchGroupKt.getQuoteRangeNoPSI$lambda$0(currentPos, arg_0));
                boolean $i$f$lastOrNull = false;
                Object last$iv = null;
                for (Object element$iv : $this$lastOrNull$iv) {
                    it = (State)element$iv;
                    boolean bl = false;
                    if (!(it.getPosition() < currentPos)) continue;
                    last$iv = element$iv;
                }
                beforePos = last$iv;
                Sequence<State> $this$firstOrNull$iv = changes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (State)element$iv;
                    boolean bl = false;
                    if (!(it.getPosition() == currentPos)) continue;
                    v0 = element$iv;
                    break block10;
                }
                v0 = null;
            }
            atPos = v0;
            Sequence<State> $this$firstOrNull$iv = changes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                State it = (State)element$iv;
                boolean bl = false;
                if (!(it.getPosition() > currentPos)) continue;
                v1 = element$iv;
                break block11;
            }
            v1 = null;
        }
        State afterPos = v1;
        Function1 function1 = inQuoteCheck2 = isSingleQuotes ? (Function1)getQuoteRangeNoPSI.inQuoteCheck.1.INSTANCE : (Function1)getQuoteRangeNoPSI.inQuoteCheck.2.INSTANCE;
        if (beforePos != null && atPos != null && ((Boolean)inQuoteCheck2.invoke((Object)beforePos)).booleanValue()) {
            pair = TuplesKt.to((Object)beforePos, (Object)atPos);
        } else if (beforePos != null && afterPos != null && ((Boolean)inQuoteCheck2.invoke((Object)beforePos)).booleanValue()) {
            pair = TuplesKt.to((Object)beforePos, (Object)afterPos);
        } else if (atPos != null && afterPos != null && ((Boolean)inQuoteCheck2.invoke((Object)atPos)).booleanValue()) {
            pair = TuplesKt.to((Object)atPos, (Object)afterPos);
        } else {
            return null;
        }
        Pair openToClose = pair;
        return isInner ? new TextRange(((State)openToClose.getFirst()).getPosition() + 1, ((State)openToClose.getSecond()).getPosition()) : new TextRange(((State)openToClose.getFirst()).getPosition(), ((State)openToClose.getSecond()).getPosition() + 1);
    }

    private static final boolean isEscaped(CharSequence chars, int pos) {
        int backslashCounter = 0;
        int i = pos;
        while (i-- > 0 && chars.charAt(i) == '\\') {
            ++backslashCounter;
        }
        return backslashCounter % 2 != 0;
    }

    private static final Sequence<State> quotesChanges(CharSequence chars, int startIndex) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super State>, Continuation<? super Unit>, Object>(chars, startIndex, null){
            Object L$1;
            int I$0;
            int I$1;
            int I$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CharSequence $chars;
            final /* synthetic */ int $startIndex;
            {
                this.$chars = $chars;
                this.$startIndex = $startIndex;
                super(2, $completion);
            }

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * Unable to fully structure code
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        isInDoubleQuotes = 0;
                        isInSingleQuotes = 0;
                        v0 = StringUtilKt.indexOfOrNull$default(this.$chars, '\n', this.$startIndex, 0, null, 12, null);
                        eolIndex = v0 != null ? v0.intValue() : this.$chars.length();
                        var7_7 = new char[]{'\"', '\''};
                        nextQuoteIndex = StringUtilKt.indexOfAnyOrNull(this.$chars, var7_7, this.$startIndex, eolIndex, Boxing.boxBoolean((boolean)false));
                        ** GOTO lbl33
                    }
                    case 1: {
                        eolIndex = this.I$2;
                        isInSingleQuotes = this.I$1;
                        isInDoubleQuotes = this.I$0;
                        nextQuoteIndex = (Integer)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** break;
                    }
                    case 2: {
                        eolIndex = this.I$2;
                        isInSingleQuotes = this.I$1;
                        isInDoubleQuotes = this.I$0;
                        nextQuoteIndex = (Integer)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl30:
                        // 2 sources

                        block9: while (true) {
                            var8_10 = new char[]{'\"', '\''};
                            nextQuoteIndex = StringUtilKt.indexOfAnyOrNull(this.$chars, var8_10, nextQuoteIndex + 1, eolIndex, Boxing.boxBoolean((boolean)false));
lbl33:
                            // 2 sources

                            if (nextQuoteIndex == null) break;
                            quotes = this.$chars.charAt(nextQuoteIndex);
                            switch (quotes) {
                                case '\"': {
                                    if (isInSingleQuotes != 0) ** break;
                                    isInDoubleQuotes = isInDoubleQuotes == 0 ? 1 : 0;
                                    this.L$0 = $this$sequence;
                                    this.L$1 = nextQuoteIndex;
                                    this.I$0 = isInDoubleQuotes;
                                    this.I$1 = isInSingleQuotes;
                                    this.I$2 = eolIndex;
                                    this.label = 1;
                                    v1 = $this$sequence.yield((Object)new State(nextQuoteIndex, false, isInDoubleQuotes != 0), (Continuation)this);
                                    if (v1 != var9_2) continue block9;
                                    return var9_2;
                                }
                                case '\'': {
                                    if (isInDoubleQuotes != 0) ** break;
                                    isInSingleQuotes = isInSingleQuotes == 0 ? 1 : 0;
                                    this.L$0 = $this$sequence;
                                    this.L$1 = nextQuoteIndex;
                                    this.I$0 = isInDoubleQuotes;
                                    this.I$1 = isInSingleQuotes;
                                    this.I$2 = eolIndex;
                                    this.label = 2;
                                    v2 = $this$sequence.yield((Object)new State(nextQuoteIndex, isInSingleQuotes != 0, false), (Continuation)this);
                                    if (v2 != var9_2) continue block9;
                                    return var9_2;
                                }
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super State> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final <T> Sequence<T> takeWhileInclusive(Sequence<? extends T> $this$takeWhileInclusive, Function1<? super T, Boolean> predicate) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super T>, Continuation<? super Unit>, Object>($this$takeWhileInclusive, predicate, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Sequence<T> $this_takeWhileInclusive;
            final /* synthetic */ Function1<T, Boolean> $predicate;
            {
                this.$this_takeWhileInclusive = $receiver;
                this.$predicate = $predicate;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = this.$this_takeWhileInclusive.iterator();
                        var4_5 = this.$predicate;
                        $this$invokeSuspend_u24lambda_u240 = var3_4;
                        $i$a$-with-SearchGroupKt$takeWhileInclusive$1$1 = false;
lbl10:
                        // 2 sources

                        while ($this$invokeSuspend_u24lambda_u240.hasNext()) {
                            next = $this$invokeSuspend_u24lambda_u240.next();
                            this.L$0 = $this$sequence;
                            this.L$1 = var4_5;
                            this.L$2 = $this$invokeSuspend_u24lambda_u240;
                            this.L$3 = next;
                            this.label = 1;
                            v0 = $this$sequence.yield(next, (Continuation)this);
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl30
                        }
                        ** GOTO lbl33
                    }
                    case 1: {
                        $i$a$-with-SearchGroupKt$takeWhileInclusive$1$1 = false;
                        next = this.L$3;
                        $this$invokeSuspend_u24lambda_u240 = (Iterator)this.L$2;
                        var4_5 = (Function1)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        if (((Boolean)var4_5.invoke(next)).booleanValue()) ** GOTO lbl10
lbl33:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super T> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final boolean getQuoteRangeNoPSI$lambda$0(int $currentPos, State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPosition() <= $currentPos;
    }
}

