/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group.visual;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u001a7\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\u000b0\u0001\"\u000e\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\f2\u0006\u0010\r\u001a\u0002H\u000b2\u0006\u0010\u000e\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u000f\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\u001a2\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0014"}, d2={"charToNativeSelection", "Lkotlin/Pair;", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "start", "end", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "lineToNativeSelection", "sort", "T", "", "a", "b", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)Lkotlin/Pair;", "isExclusiveSelection", "", "blockToNativeSelection", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "vim-engine"})
public final class VimVisualGroupKt {
    @NotNull
    public static final Pair<Integer, Integer> charToNativeSelection(@NotNull VimEditor editor, int start, int end, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Pair<Comparable, Comparable> pair = VimVisualGroupKt.sort(start, end);
        int nativeStart = ((Number)pair.component1()).intValue();
        int nativeEnd = ((Number)pair.component2()).intValue();
        int lineEnd = EngineEditorHelperKt.getLineEndForOffset(editor, nativeEnd);
        int adj = VimVisualGroupKt.isExclusiveSelection() || nativeEnd == lineEnd || mode instanceof Mode.SELECT ? 0 : 1;
        int adjEnd = RangesKt.coerceAtMost((int)(nativeEnd + adj), (int)((int)editor.fileSize()));
        return TuplesKt.to((Object)nativeStart, (Object)adjEnd);
    }

    @NotNull
    public static final Pair<Integer, Integer> lineToNativeSelection(@NotNull VimEditor editor, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Pair<Comparable, Comparable> pair = VimVisualGroupKt.sort(start, end);
        int nativeStart = ((Number)pair.component1()).intValue();
        int nativeEnd = ((Number)pair.component2()).intValue();
        int lineStart = EngineEditorHelperKt.getLineStartForOffset(editor, nativeStart);
        int lineEnd = RangesKt.coerceAtMost((int)(EngineEditorHelperKt.getLineEndForOffset(editor, nativeEnd) + 1), (int)((int)editor.fileSize()));
        return TuplesKt.to((Object)lineStart, (Object)lineEnd);
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Pair<T, T> sort(@NotNull T a, @NotNull T b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return a.compareTo(b) > 0 ? TuplesKt.to(b, a) : TuplesKt.to(a, b);
    }

    private static final boolean isExclusiveSelection() {
        return StringsKt.contains$default((CharSequence)VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSelection(), (CharSequence)"exclusive", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final Pair<BufferPosition, BufferPosition> blockToNativeSelection(@NotNull VimEditor editor, int start, int end, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        BufferPosition blockStart = editor.offsetToBufferPosition(start);
        BufferPosition blockEnd = editor.offsetToBufferPosition(end);
        if (!VimVisualGroupKt.isExclusiveSelection() && !(mode instanceof Mode.SELECT)) {
            if (blockStart.getColumn() > blockEnd.getColumn()) {
                if (blockStart.getColumn() < EngineEditorHelperKt.lineLength(editor, blockStart.getLine())) {
                    blockStart = new BufferPosition(blockStart.getLine(), blockStart.getColumn() + 1, false, 4, null);
                }
            } else if (blockEnd.getColumn() < EngineEditorHelperKt.lineLength(editor, blockEnd.getLine())) {
                blockEnd = new BufferPosition(blockEnd.getLine(), blockEnd.getColumn() + 1, false, 4, null);
            }
        }
        return TuplesKt.to((Object)blockStart, (Object)blockEnd);
    }
}

