/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVisualMotionGroup;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.command.TextObjectVisualType;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H&J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/handler/TextObjectActionHandler;", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "<init>", "()V", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "visualType", "Lcom/maddyhome/idea/vim/command/TextObjectVisualType;", "getVisualType", "()Lcom/maddyhome/idea/vim/command/TextObjectVisualType;", "getRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "count", "", "rawCount", "baseExecute", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
public abstract class TextObjectActionHandler
extends EditorActionHandlerBase {
    @NotNull
    private final Command.Type type = Command.Type.MOTION;

    public TextObjectActionHandler() {
        super(true);
    }

    @Override
    @NotNull
    public final Command.Type getType() {
        return this.type;
    }

    @NotNull
    public abstract TextObjectVisualType getVisualType();

    @Nullable
    public abstract TextRange getRange(@NotNull VimEditor var1, @NotNull ImmutableVimCaret var2, @NotNull ExecutionContext var3, int var4, int var5);

    @Override
    protected final boolean baseExecute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        int newend;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (!EditorExtensionsKt.getInVisualMode(editor)) {
            return true;
        }
        TextRange textRange = this.getRange(editor, caret, context, operatorArguments.getCount1(), operatorArguments.getCount0());
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        boolean block = cmd.getFlags().contains((Object)CommandFlags.FLAG_TEXT_BLOCK);
        int newstart = block || caret.getOffset() >= caret.getVimSelectionStart() ? range.getStartOffset() : EngineHelperKt.getEndOffsetInclusive(range);
        int n = newend = block || caret.getOffset() >= caret.getVimSelectionStart() ? EngineHelperKt.getEndOffsetInclusive(range) : range.getStartOffset();
        if (caret.getVimSelectionStart() == caret.getOffset() || block) {
            EngineVisualGroupKt.vimSetSelection(caret, newstart, newstart, false);
        }
        if (this.getVisualType() == TextObjectVisualType.LINE_WISE && ModeExtensionsKt.getSelectionType(editor.getMode()) != SelectionType.LINE_WISE) {
            VimVisualMotionGroup.toggleVisual$default(VimInjectorKt.getInjector().getVisualMotionGroup(), editor, 1, 0, SelectionType.LINE_WISE, null, 16, null);
        } else if (this.getVisualType() != TextObjectVisualType.LINE_WISE && ModeExtensionsKt.getSelectionType(editor.getMode()) == SelectionType.LINE_WISE) {
            VimVisualMotionGroup.toggleVisual$default(VimInjectorKt.getInjector().getVisualMotionGroup(), editor, 1, 0, SelectionType.CHARACTER_WISE, null, 16, null);
        }
        caret.moveToOffset(newend);
        return true;
    }
}

