/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.common.ArgumentCapturerKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002J8\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandKeyConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "<init>", "()V", "isApplicable", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "consumeKey", "handleAction", "", "action", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "processBuilder", "startWaitingForArgument", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "editorState", "Lcom/maddyhome/idea/vim/state/VimStateMachine;", "checkActionArgumentCompatibility", "expectedArgumentType", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandKeyConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandKeyConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandKeyConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,185:1\n28#2,4:186\n28#2,4:190\n28#2,4:194\n28#2,4:198\n39#2:202\n*S KotlinDebug\n*F\n+ 1 CommandKeyConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandKeyConsumer\n*L\n91#1:186,4\n97#1:190,4\n105#1:194,4\n131#1:198,4\n53#1:202\n*E\n"})
public final class CommandKeyConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean isApplicable(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        CommandBuilder commandBuilder = keyProcessResultBuilder.getState().getCommandBuilder();
        return commandBuilder.getExpectedArgumentType() == null || commandBuilder.getExpectedArgumentType() == Argument.Type.MOTION || commandBuilder.getExpectedArgumentType() == Argument.Type.DIGRAPH || commandBuilder.isBuildingMultiKeyCommand();
    }

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        logger.trace("Entered CommandConsumer");
        CommandBuilder commandBuilder = keyProcessResultBuilder.getState().getCommandBuilder();
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("command builder - " + commandBuilder);
        }
        KeyStroke keystroke = editor.getMode() instanceof Mode.OP_PENDING ? commandBuilder.convertDuplicateOperatorKeyStrokeToMotion(key) : key;
        VimLogger $this$trace$iv2 = logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTrace()) {
            vimLogger = $this$trace$iv2;
            boolean bl = false;
            vimLogger.trace("Original keystroke: " + key + ", substituted keystroke: " + keystroke);
        }
        return commandBuilder.processKey(keystroke, (Function1<? super EditorActionHandlerBase, Unit>)((Function1)arg_0 -> CommandKeyConsumer.consumeKey$lambda$2(this, keyProcessResultBuilder, arg_0)));
    }

    private final void handleAction(EditorActionHandlerBase action, KeyProcessResult.KeyProcessResultBuilder processBuilder) {
        CommandBuilder commandBuilder;
        Argument.Type expectedArgumentType;
        VimLogger vimLogger;
        KeyHandlerState keyState = processBuilder.getState();
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Handle command action: " + action.getId());
        }
        if (action.getFlags().contains((Object)CommandFlags.FLAG_START_EX)) {
            keyState.enterCommandLine();
            VimInjectorKt.getInjector().getRedrawService().redrawStatusLine();
        }
        if (action.getFlags().contains((Object)CommandFlags.FLAG_END_EX)) {
            keyState.leaveCommandLine();
            VimInjectorKt.getInjector().getRedrawService().redrawStatusLine();
        }
        if (!this.checkActionArgumentCompatibility(expectedArgumentType = (commandBuilder = keyState.getCommandBuilder()).getExpectedArgumentType(), action)) {
            logger.trace("Return from command node handling");
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)CommandKeyConsumer::handleAction$lambda$1));
            return;
        }
        VimLogger $this$trace$iv2 = logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTrace()) {
            vimLogger = $this$trace$iv2;
            boolean bl = false;
            vimLogger.trace("Adding action " + action.getId() + " to command builder.");
        }
        commandBuilder.addAction(action);
        if (commandBuilder.isAwaitingArgument()) {
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> CommandKeyConsumer.handleAction$lambda$3(action, this, arg_0, arg_1, arg_2)));
        }
        processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> CommandKeyConsumer.handleAction$lambda$4(action, commandBuilder, arg_0, arg_1, arg_2)));
    }

    private final void startWaitingForArgument(VimEditor editor, ExecutionContext context, EditorActionHandlerBase action, Argument.Type argument, KeyHandlerState keyState, VimStateMachine editorState) {
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        if (argument == Argument.Type.MOTION) {
            if (editorState.isDotRepeatInProgress() && ArgumentCapturerKt.getArgumentCaptured() != null) {
                Argument argument2 = ArgumentCapturerKt.getArgumentCaptured();
                Intrinsics.checkNotNull((Object)argument2);
                commandBuilder.addArgument(argument2);
            }
            editor.setMode(new Mode.OP_PENDING(editorState.getMode().getReturnTo()));
        }
        action.onStartWaitingForArgument(editor, context, keyState);
    }

    private final boolean checkActionArgumentCompatibility(Argument.Type expectedArgumentType, EditorActionHandlerBase action) {
        return expectedArgumentType != Argument.Type.MOTION || action.getType() == Command.Type.MOTION;
    }

    private static final Unit consumeKey$lambda$2(CommandKeyConsumer this$0, KeyProcessResult.KeyProcessResultBuilder $keyProcessResultBuilder, EditorActionHandlerBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleAction(it, $keyProcessResultBuilder);
        return Unit.INSTANCE;
    }

    private static final Unit handleAction$lambda$1(KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        KeyHandler.Companion.getInstance().setBadCommand(lambdaEditor, lambdaKeyState);
        return Unit.INSTANCE;
    }

    private static final Unit handleAction$lambda$3(EditorActionHandlerBase $action, CommandKeyConsumer this$0, KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext lambdaContext) {
        Argument.Type argumentType;
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
        logger.trace("Set waiting for the argument");
        Argument.Type type = argumentType = $action.getArgumentType();
        Intrinsics.checkNotNull((Object)((Object)type));
        this$0.startWaitingForArgument(lambdaEditor, lambdaContext, $action, type, lambdaKeyState, VimInjectorKt.getInjector().getVimState());
        lambdaKeyState.partialReset(lambdaEditor.getMode());
        return Unit.INSTANCE;
    }

    private static final Unit handleAction$lambda$4(EditorActionHandlerBase $action, CommandBuilder $commandBuilder, KeyHandlerState keyHandlerState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        if ($action.getFlags().contains((Object)CommandFlags.FLAG_END_EX)) {
            logger.trace("Processing ex_string");
            VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
            Intrinsics.checkNotNull((Object)vimCommandLine);
            VimCommandLine commandLine = vimCommandLine;
            String label = commandLine.getLabel();
            String text = commandLine.getText();
            Function1<String, Unit> processing = commandLine.getInputProcessing();
            commandLine.close(true, true);
            $commandBuilder.addArgument(new Argument.ExString(label.charAt(0), text, processing));
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CommandKeyConsumer.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandKeyConsumer$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

