/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.thinapi.editor;

import com.intellij.vim.api.models.CaretId;
import com.intellij.vim.api.models.CaretInfo;
import com.intellij.vim.api.models.Jump;
import com.intellij.vim.api.models.Line;
import com.intellij.vim.api.models.Mark;
import com.intellij.vim.api.models.Path;
import com.intellij.vim.api.models.Range;
import com.intellij.vim.api.scopes.editor.EditorAccessor;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVirtualFile;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.helper.SearchOptions;
import com.maddyhome.idea.vim.thinapi.PathKt;
import com.maddyhome.idea.vim.thinapi.ThinApiKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u0011H\u0016J\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u0011H\u0016J\u0018\u0010=\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u001cH\u0016J\u0018\u0010?\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u001cH\u0016J\u0018\u0010@\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u001cH\u0016J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020\u0011H\u0016J\b\u0010C\u001a\u00020\u001cH\u0016J\b\u0010D\u001a\u00020\u001cH\u0016J'\u0010E\u001a\u0004\u0018\u00010\u00112\u0006\u0010F\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010HJ/\u0010I\u001a\u0004\u0018\u00010\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010MJ \u0010N\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u00112\u0006\u0010O\u001a\u00020-2\u0006\u00104\u001a\u00020\u0011H\u0016J \u0010P\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u00112\u0006\u0010O\u001a\u00020-2\u0006\u00104\u001a\u00020\u0011H\u0016J/\u0010Q\u001a\u0004\u0018\u00010\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010MJ'\u0010R\u001a\u0004\u0018\u00010\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010S\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010HJ \u0010T\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010S\u001a\u00020\u001cH\u0016J \u0010U\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0016J\u001a\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010J\u001a\u00020\u00112\u0006\u0010S\u001a\u00020\u001cH\u0016J\"\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010Y\u001a\u00020\u001cH\u0016J\"\u0010Z\u001a\u0004\u0018\u00010W2\u0006\u0010J\u001a\u00020\u00112\u0006\u0010[\u001a\u00020-2\u0006\u0010Y\u001a\u00020\u001cH\u0016J.\u0010\\\u001a\b\u0012\u0004\u0012\u00020W0!2\u0006\u0010]\u001a\u00020^2\u0006\u0010F\u001a\u00020\u00112\u0006\u0010_\u001a\u00020\u00112\u0006\u0010`\u001a\u00020\u001cH\u0016J*\u0010a\u001a\u0004\u0018\u00010W2\u0006\u0010]\u001a\u00020^2\u0006\u0010J\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R*\u0010 \u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"j\u0002`%0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020#0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020+0/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002030!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010'R\u0014\u00107\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0013\u00a8\u0006c"}, d2={"Lcom/maddyhome/idea/vim/thinapi/editor/EditorAccessorImpl;", "Lcom/intellij/vim/api/scopes/editor/EditorAccessor;", "<init>", "()V", "vimEditor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getVimEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "textLength", "", "getTextLength", "()J", "text", "", "getText", "()Ljava/lang/CharSequence;", "lineCount", "", "getLineCount", "()I", "filePath", "Lcom/intellij/vim/api/models/Path;", "getFilePath", "()Lcom/intellij/vim/api/models/Path;", "getLineStartOffset", "line", "getLineEndOffset", "allowEnd", "", "getLine", "Lcom/intellij/vim/api/models/Line;", "offset", "caretData", "", "Lkotlin/Pair;", "Lcom/intellij/vim/api/models/CaretId;", "Lcom/intellij/vim/api/models/CaretInfo;", "Lcom/intellij/vim/api/models/CaretData;", "getCaretData", "()Ljava/util/List;", "caretIds", "getCaretIds", "getGlobalMark", "Lcom/intellij/vim/api/models/Mark;", "char", "", "globalMarks", "", "getGlobalMarks", "()Ljava/util/Set;", "getJump", "Lcom/intellij/vim/api/models/Jump;", "count", "jumps", "getJumps", "currentJumpIndex", "getCurrentJumpIndex", "scrollCaretIntoView", "", "scrollVertically", "lines", "scrollLineToTop", "start", "scrollLineToMiddle", "scrollLineToBottom", "scrollHorizontally", "columns", "scrollCaretToLeftEdge", "scrollCaretToRightEdge", "getNextParagraphBoundOffset", "startLine", "includeWhitespaceLines", "(IIZ)Ljava/lang/Integer;", "getNextSentenceStart", "startOffset", "includeCurrent", "requireAll", "(IIZZ)Ljava/lang/Integer;", "getNextSectionStart", "marker", "getPreviousSectionStart", "getNextSentenceEnd", "getNextWordStartOffset", "isBigWord", "getNextWordEndOffset", "getNextCharOnLineOffset", "getWordAtOrFollowingOffset", "Lcom/intellij/vim/api/models/Range;", "getParagraphRange", "isOuter", "getBlockQuoteInLineRange", "quote", "findAll", "pattern", "", "endLine", "ignoreCase", "findPattern", "backwards", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nEditorAccessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorAccessorImpl.kt\ncom/maddyhome/idea/vim/thinapi/editor/EditorAccessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,208:1\n1563#2:209\n1634#2,3:210\n1563#2:213\n1634#2,3:214\n1563#2:217\n1634#2,3:218\n1563#2:221\n1634#2,3:222\n1563#2:225\n1634#2,3:226\n57#3,2:229\n19#3:231\n59#3,2:232\n61#3:236\n19#3:237\n59#3,3:238\n37#4,2:234\n*S KotlinDebug\n*F\n+ 1 EditorAccessorImpl.kt\ncom/maddyhome/idea/vim/thinapi/editor/EditorAccessorImpl\n*L\n68#1:209\n68#1:210,3\n70#1:213\n70#1:214,3\n78#1:217\n78#1:218,3\n86#1:221\n86#1:222,3\n194#1:225\n194#1:226,3\n203#1:229,2\n203#1:231\n203#1:232,2\n203#1:236\n203#1:237\n203#1:238,3\n203#1:234,2\n*E\n"})
public class EditorAccessorImpl
implements EditorAccessor {
    private final VimEditor getVimEditor() {
        VimEditor vimEditor = VimInjectorKt.getInjector().getEditorGroup().getFocusedEditor();
        Intrinsics.checkNotNull((Object)vimEditor);
        return vimEditor;
    }

    public long getTextLength() {
        return this.getVimEditor().fileSize();
    }

    @NotNull
    public CharSequence getText() {
        return this.getVimEditor().text();
    }

    public int getLineCount() {
        return this.getVimEditor().lineCount();
    }

    @NotNull
    public Path getFilePath() {
        VimVirtualFile vimVirtualFile = this.getVimEditor().getVirtualFile();
        if (vimVirtualFile == null) {
            throw new IllegalStateException("Virtual file is null");
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        String filePath = virtualFile.getPath();
        String protocol = virtualFile.getProtocol();
        return PathKt.createApiPath(Path.Companion, protocol, filePath);
    }

    public int getLineStartOffset(int line) {
        return this.getVimEditor().getLineStartOffset(line);
    }

    public int getLineEndOffset(int line, boolean allowEnd) {
        return EngineEditorHelperKt.getLineEndOffset(this.getVimEditor(), line, allowEnd);
    }

    @NotNull
    public Line getLine(int offset) {
        int lineNumber = this.getVimEditor().offsetToBufferPosition(offset).getLine();
        String lineText = this.getVimEditor().getLineText(lineNumber);
        int lineStartOffset = this.getVimEditor().getLineStartOffset(lineNumber);
        int lineEndOffset = this.getVimEditor().getLineEndOffset(lineNumber);
        return new Line(lineNumber, lineText, lineStartOffset, lineEndOffset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Pair<CaretId, CaretInfo>> getCaretData() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getVimEditor().sortedCarets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void caret;
            VimCaret vimCaret = (VimCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)CaretId.box-impl((String)ThinApiKt.getCaretId((VimCaret)caret)), (Object)ThinApiKt.getCaretInfo((VimCaret)caret)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CaretId> getCaretIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getVimEditor().sortedCarets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void caret;
            VimCaret vimCaret = (VimCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CaretId.box-impl((String)ThinApiKt.getCaretId((VimCaret)caret)));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Mark getGlobalMark(char c) {
        com.maddyhome.idea.vim.mark.Mark mark;
        com.maddyhome.idea.vim.mark.Mark mark2 = mark = VimInjectorKt.getInjector().getMarkService().getGlobalMark(c);
        return mark2 != null ? ThinApiKt.toApiMark(mark2) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Mark> getGlobalMarks() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = VimInjectorKt.getInjector().getMarkService().getAllGlobalMarks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.maddyhome.idea.vim.mark.Mark mark = (com.maddyhome.idea.vim.mark.Mark)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThinApiKt.toApiMark((com.maddyhome.idea.vim.mark.Mark)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public Jump getJump(int count) {
        com.maddyhome.idea.vim.mark.Jump jump;
        com.maddyhome.idea.vim.mark.Jump jump2 = jump = VimInjectorKt.getInjector().getJumpService().getJump(this.getVimEditor().getProjectId(), count);
        return jump2 != null ? ThinApiKt.toApiJump(jump2) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Jump> getJumps() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = VimInjectorKt.getInjector().getJumpService().getJumps(this.getVimEditor().getProjectId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.maddyhome.idea.vim.mark.Jump jump = (com.maddyhome.idea.vim.mark.Jump)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThinApiKt.toApiJump((com.maddyhome.idea.vim.mark.Jump)it));
        }
        return (List)destination$iv$iv;
    }

    public int getCurrentJumpIndex() {
        return VimInjectorKt.getInjector().getJumpService().getJumpSpot(this.getVimEditor().getProjectId());
    }

    public void scrollCaretIntoView() {
        VimInjectorKt.getInjector().getScroll().scrollCaretIntoView(this.getVimEditor());
    }

    public boolean scrollVertically(int lines) {
        return VimInjectorKt.getInjector().getScroll().scrollLines(this.getVimEditor(), lines);
    }

    public boolean scrollLineToTop(int line, boolean start) {
        return VimInjectorKt.getInjector().getScroll().scrollCurrentLineToDisplayTop(this.getVimEditor(), line, start);
    }

    public boolean scrollLineToMiddle(int line, boolean start) {
        return VimInjectorKt.getInjector().getScroll().scrollCurrentLineToDisplayMiddle(this.getVimEditor(), line, start);
    }

    public boolean scrollLineToBottom(int line, boolean start) {
        return VimInjectorKt.getInjector().getScroll().scrollCurrentLineToDisplayBottom(this.getVimEditor(), line, start);
    }

    public boolean scrollHorizontally(int columns) {
        return VimInjectorKt.getInjector().getScroll().scrollColumns(this.getVimEditor(), columns);
    }

    public boolean scrollCaretToLeftEdge() {
        return VimInjectorKt.getInjector().getScroll().scrollCaretColumnToDisplayLeftEdge(this.getVimEditor());
    }

    public boolean scrollCaretToRightEdge() {
        return VimInjectorKt.getInjector().getScroll().scrollCaretColumnToDisplayRightEdge(this.getVimEditor());
    }

    @Nullable
    public Integer getNextParagraphBoundOffset(int startLine, int count, boolean includeWhitespaceLines) {
        return VimInjectorKt.getInjector().getSearchHelper().findNextParagraph(this.getVimEditor(), startLine, count, includeWhitespaceLines);
    }

    @Nullable
    public Integer getNextSentenceStart(int startOffset, int count, boolean includeCurrent, boolean requireAll) {
        return VimInjectorKt.getInjector().getSearchHelper().findNextSentenceStart(this.getVimEditor(), startOffset, count, includeCurrent, requireAll);
    }

    public int getNextSectionStart(int startLine, char marker, int count) {
        return VimInjectorKt.getInjector().getSearchHelper().findSection(this.getVimEditor(), startLine, marker, 1, count);
    }

    public int getPreviousSectionStart(int startLine, char marker, int count) {
        return VimInjectorKt.getInjector().getSearchHelper().findSection(this.getVimEditor(), startLine, marker, -1, count);
    }

    @Nullable
    public Integer getNextSentenceEnd(int startOffset, int count, boolean includeCurrent, boolean requireAll) {
        return VimInjectorKt.getInjector().getSearchHelper().findNextSentenceEnd(this.getVimEditor(), startOffset, count, includeCurrent, requireAll);
    }

    @Nullable
    public Integer getNextWordStartOffset(int startOffset, int count, boolean isBigWord) {
        int editorSize = this.getVimEditor().text().length();
        int nextWordOffset = VimInjectorKt.getInjector().getSearchHelper().findNextWord(this.getVimEditor(), startOffset, count, isBigWord);
        return nextWordOffset >= editorSize ? null : Integer.valueOf(nextWordOffset);
    }

    public int getNextWordEndOffset(int startOffset, int count, boolean isBigWord) {
        return VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(this.getVimEditor(), startOffset, count, isBigWord, true);
    }

    public int getNextCharOnLineOffset(int startOffset, int count, char c) {
        return VimInjectorKt.getInjector().getSearchHelper().findNextCharacterOnLine(this.getVimEditor(), startOffset, count, c);
    }

    @Nullable
    public Range getWordAtOrFollowingOffset(int startOffset, boolean isBigWord) {
        TextRange textRange;
        TextRange textRange2 = textRange = VimInjectorKt.getInjector().getSearchHelper().findWordAtOrFollowingCursor(this.getVimEditor(), startOffset, isBigWord);
        return (Range)(textRange2 != null ? ThinApiKt.toRange(textRange2) : null);
    }

    @Nullable
    public Range getParagraphRange(int line, int count, boolean isOuter) {
        TextRange textRange;
        TextRange textRange2 = textRange = VimInjectorKt.getInjector().getSearchHelper().findParagraphRange(this.getVimEditor(), line, count, isOuter);
        return (Range)(textRange2 != null ? ThinApiKt.toRange(textRange2) : null);
    }

    @Nullable
    public Range getBlockQuoteInLineRange(int startOffset, char quote, boolean isOuter) {
        TextRange textRange;
        TextRange textRange2 = textRange = VimInjectorKt.getInjector().getSearchHelper().findBlockQuoteInLineRange(this.getVimEditor(), startOffset, quote, isOuter);
        return (Range)(textRange2 != null ? ThinApiKt.toRange(textRange2) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Range> findAll(@NotNull String pattern, int startLine, int endLine, boolean ignoreCase) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        List<TextRange> textRanges = VimInjectorKt.getInjector().getSearchHelper().findAll(this.getVimEditor(), pattern, startLine, endLine, ignoreCase);
        Iterable $this$map$iv = textRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThinApiKt.toRange((TextRange)it));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Range findPattern(@NotNull String pattern, int startOffset, int count, boolean backwards) {
        TextRange textRange;
        EnumSet<Enum> enumSet;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (backwards) {
            SearchOptions[] searchOptionsArray = new SearchOptions[]{SearchOptions.BACKWARDS};
            value$iv = searchOptionsArray;
            $i$f$enumSetOf = false;
            switch (value$iv.length) {
                case 0: {
                    $i$f$noneOfEnum = false;
                    EnumSet<SearchOptions> enumSet2 = EnumSet.noneOf(SearchOptions.class);
                    enumSet = enumSet2;
                    Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                    break;
                }
                case 1: {
                    EnumSet<Enum> enumSet3 = EnumSet.of(value$iv[0]);
                    enumSet = enumSet3;
                    Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                    break;
                }
                default: {
                    $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                    $i$f$toTypedArray = false;
                    thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    var12_11 = thisCollection$iv$iv.toArray(new SearchOptions[0]);
                    EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(var12_11, var12_11.length));
                    enumSet = enumSet4;
                    Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
                }
            }
        } else {
            value$iv = new SearchOptions[0];
            $i$f$enumSetOf = false;
            switch (value$iv.length) {
                case 0: {
                    $i$f$noneOfEnum = false;
                    EnumSet<SearchOptions> enumSet5 = EnumSet.noneOf(SearchOptions.class);
                    enumSet = enumSet5;
                    Intrinsics.checkNotNullExpressionValue(enumSet5, (String)"noneOf(...)");
                    break;
                }
                case 1: {
                    EnumSet<Enum> enumSet6 = EnumSet.of(value$iv[0]);
                    enumSet = enumSet6;
                    Intrinsics.checkNotNullExpressionValue(enumSet6, (String)"of(...)");
                    break;
                }
                default: {
                    $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                    $i$f$toTypedArray = false;
                    thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    var12_11 = thisCollection$iv$iv.toArray(new SearchOptions[0]);
                    EnumSet<Enum[]> enumSet7 = EnumSet.of(value$iv[0], Arrays.copyOf(var12_11, var12_11.length));
                    enumSet = enumSet7;
                    Intrinsics.checkNotNullExpressionValue(enumSet7, (String)"of(...)");
                }
            }
        }
        EnumSet<Enum> vimSearchOptions = enumSet;
        TextRange textRange2 = textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern(this.getVimEditor(), pattern, startOffset, count, vimSearchOptions);
        return (Range)(textRange2 != null ? ThinApiKt.toRange(textRange2) : null);
    }
}

