/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.thinapi.editor.caret;

import com.intellij.vim.api.models.CaretId;
import com.intellij.vim.api.models.CaretInfo;
import com.intellij.vim.api.models.Line;
import com.intellij.vim.api.models.Mark;
import com.intellij.vim.api.models.Path;
import com.intellij.vim.api.models.Range;
import com.intellij.vim.api.models.TextType;
import com.intellij.vim.api.scopes.editor.EditorAccessor;
import com.intellij.vim.api.scopes.editor.caret.CaretRead;
import com.intellij.vim.api.scopes.editor.caret.CaretTransaction;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVirtualFile;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimCopiedText;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.mark.Jump;
import com.maddyhome.idea.vim.put.PutData;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.thinapi.editor.EditorAccessorImpl;
import com.maddyhome.idea.vim.thinapi.editor.caret.CaretReadImpl;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0011\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0002J*\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\"H\u0002J(\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"H\u0016J \u0010-\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010.\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020/2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$00H\u0016J\u0018\u00101\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u001a\u00102\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u001aH\u0016J\u0018\u00107\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\"H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\"H\u0016J\b\u0010=\u001a\u00020\u0018H\u0016J/\u0010>\u001a\b\u0012\u0004\u0012\u00020?002\u0006\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020\"H\u0096\u0001J+\u0010D\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020\"H\u0096\u0001J\u001b\u0010G\u001a\u0004\u0018\u00010?2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\"H\u0096\u0001J#\u0010G\u001a\u0004\u0018\u00010?2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\"H\u0096\u0001J\u001b\u0010K\u001a\u0004\u0018\u00010?2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\"H\u0096\u0001J\u0013\u0010L\u001a\u0004\u0018\u00010?2\u0006\u0010M\u001a\u00020\"H\u0096\u0001J\u0013\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020IH\u0096\u0001J\u0013\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J\u0013\u0010S\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020IH\u0096\u0001J\u0011\u0010T\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J\u0011\u0010U\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J\u0019\u0010V\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020IH\u0096\u0001J!\u0010V\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020IH\u0096\u0001J\u0011\u0010W\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J \u0010X\u001a\u0004\u0018\u00010\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010Y\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010ZJ(\u0010X\u001a\u0004\u0018\u00010\u001a2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010Y\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010[J\u0019\u0010\\\u001a\u00020\u001a2\u0006\u0010]\u001a\u00020I2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J!\u0010\\\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010]\u001a\u00020I2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J(\u0010^\u001a\u0004\u0018\u00010\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020\"2\u0006\u0010`\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010aJ0\u0010^\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020\"2\u0006\u0010`\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010bJ(\u0010c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020\"2\u0006\u0010`\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010aJ0\u0010c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020\"2\u0006\u0010`\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010bJ!\u0010d\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020\"H\u0096\u0001J(\u0010e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010[J\u001b\u0010f\u001a\u0004\u0018\u00010?2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\"H\u0096\u0001J#\u0010f\u001a\u0004\u0018\u00010?2\u0006\u00106\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\"H\u0096\u0001J\u0019\u0010g\u001a\u00020\u001a2\u0006\u0010]\u001a\u00020I2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J!\u0010g\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010]\u001a\u00020I2\u0006\u0010E\u001a\u00020\u001aH\u0096\u0001J\u0013\u0010h\u001a\u0004\u0018\u00010$2\u0006\u0010i\u001a\u00020IH\u0096\u0001J\u0013\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010i\u001a\u00020IH\u0096\u0001J\u0019\u0010l\u001a\u00020?2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\"H\u0096\u0001J\u001b\u0010m\u001a\u0004\u0018\u00010?2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020\"H\u0096\u0001J!\u0010n\u001a\u00020?2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\"2\u0006\u0010M\u001a\u00020\"H\u0096\u0001J\t\u0010o\u001a\u00020\"H\u0096\u0001J\u0011\u0010p\u001a\u00020\"2\u0006\u0010i\u001a\u00020IH\u0096\u0001J\u0011\u0010q\u001a\u00020\"2\u0006\u0010i\u001a\u00020IH\u0096\u0001J\u0011\u0010r\u001a\u00020\u00182\u0006\u0010P\u001a\u00020IH\u0096\u0001J\t\u0010s\u001a\u00020\u0018H\u0096\u0001J\t\u0010t\u001a\u00020\u0018H\u0096\u0001J\t\u0010u\u001a\u00020\u0018H\u0096\u0001J\t\u0010v\u001a\u00020\"H\u0096\u0001J\t\u0010w\u001a\u00020\"H\u0096\u0001J\u0011\u0010x\u001a\u00020\"2\u0006\u0010y\u001a\u00020\u001aH\u0096\u0001J\u0011\u0010z\u001a\u00020\"2\u0006\u0010{\u001a\u00020\u001aH\u0096\u0001J\u0011\u0010|\u001a\u00020\"2\u0006\u0010{\u001a\u00020\u001aH\u0096\u0001J\u0011\u0010}\u001a\u00020\"2\u0006\u0010~\u001a\u00020\u001aH\u0096\u0001J\u001a\u0010\u007f\u001a\u00020\"2\u0006\u00106\u001a\u00020\u001a2\u0007\u0010\u0080\u0001\u001a\u00020\"H\u0096\u0001J\u001b\u0010\u0081\u0001\u001a\u00020\"2\u0006\u00106\u001a\u00020\u001a2\u0007\u0010\u0080\u0001\u001a\u00020\"H\u0096\u0001J\u001b\u0010\u0082\u0001\u001a\u00020\"2\u0006\u00106\u001a\u00020\u001a2\u0007\u0010\u0080\u0001\u001a\u00020\"H\u0096\u0001J\u0012\u0010\u0083\u0001\u001a\u00020\"2\u0006\u0010{\u001a\u00020\u001aH\u0096\u0001J\u0012\u0010\u0084\u0001\u001a\u00020\"2\u0006\u0010i\u001a\u00020IH\u0096\u0001J\u0013\u0010\u0085\u0001\u001a\u00020\u00182\u0007\u0010\u0086\u0001\u001a\u00020\u001aH\u0096\u0001J\u0013\u0010\u0087\u0001\u001a\u00020\u00182\u0007\u0010\u0086\u0001\u001a\u00020\u001aH\u0096\u0001J\u0012\u0010\u0088\u0001\u001a\u00020\"2\u0006\u0010P\u001a\u00020IH\u0096\u0001J\u001a\u0010\u0088\u0001\u001a\u00020\"2\u0006\u0010P\u001a\u00020I2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0001J#\u0010\u0089\u0001\u001a\u00020\"2\u0006\u0010i\u001a\u00020I2\u0006\u0010#\u001a\u00020$2\u0007\u0010\u008a\u0001\u001a\u00020kH\u0096\u0001R\u0016\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R.\u0010\u008b\u0001\u001a\u001b\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0005\u0012\u00030\u008d\u00010\u008c\u0001j\u0003`\u008e\u000100X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001R\u001b\u0010\u0091\u0001\u001a\b\u0012\u0004\u0012\u00020\u000500X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0092\u0001\u0010\u0090\u0001R\u0017\u0010\u0093\u0001\u001a\u0004\u0018\u00010?X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001R\u0015\u0010\u0096\u0001\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001R\u0015\u0010\u0099\u0001\u001a\u00020IX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009a\u0001\u0010\u009b\u0001R\u0016\u0010\u009c\u0001\u001a\u00030\u009d\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009e\u0001\u0010\u009f\u0001R\u001c\u0010\u00a0\u0001\u001a\t\u0012\u0004\u0012\u00020O0\u00a1\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a2\u0001\u0010\u00a3\u0001R\u0015\u0010\u00a4\u0001\u001a\u00020\"X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a4\u0001\u0010\u00a5\u0001R\u001b\u0010\u00a6\u0001\u001a\b\u0012\u0004\u0012\u00020R00X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a7\u0001\u0010\u0090\u0001R\u0015\u0010\u00a8\u0001\u001a\u00020IX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a9\u0001\u0010\u009b\u0001R\u0013\u00106\u001a\u00020:X\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b9\u0010\u00aa\u0001R\u0015\u0010\u00ab\u0001\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00ac\u0001\u0010\u0098\u0001R\u001c\u0010\u00ad\u0001\u001a\t\u0012\u0004\u0012\u00020O0\u00a1\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00ae\u0001\u0010\u00a3\u0001R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00af\u0001\u0010\u0098\u0001R\u0014\u00103\u001a\u00020?X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b0\u0001\u0010\u0095\u0001R\u0017\u0010\u00b1\u0001\u001a\u0004\u0018\u00010?X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b2\u0001\u0010\u0095\u0001R\u0015\u0010#\u001a\u00030\u00b3\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b4\u0001\u0010\u00b5\u0001R\u0016\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b8\u0001\u0010\u00b9\u0001\u00a8\u0006\u00ba\u0001"}, d2={"Lcom/maddyhome/idea/vim/thinapi/editor/caret/CaretTransactionImpl;", "Lcom/intellij/vim/api/scopes/editor/caret/CaretTransaction;", "Lcom/intellij/vim/api/scopes/editor/caret/CaretRead;", "Lcom/intellij/vim/api/scopes/editor/EditorAccessor;", "caretId", "Lcom/intellij/vim/api/models/CaretId;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCaretId-z6jhRc4", "()Ljava/lang/String;", "Ljava/lang/String;", "vimEditor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getVimEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "executionContext", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "getExecutionContext", "()Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimCaret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "getVimCaret", "()Lcom/maddyhome/idea/vim/api/VimCaret;", "assertOffsetInRange", "", "offset", "", "range", "Lkotlin/ranges/IntRange;", "determineSelectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "startOffset", "endOffset", "putTextInternal", "", "text", "", "visualSelection", "Lcom/maddyhome/idea/vim/put/PutData$VisualSelection;", "caretAfterInsertedText", "beforeCaret", "insertText", "position", "caretAtEnd", "insertBeforeCaret", "replaceText", "replaceTextBlockwise", "Lcom/intellij/vim/api/models/Range$Block;", "", "deleteText", "updateCaret", "selection", "Lcom/intellij/vim/api/models/Range$Simple;", "getLineStartOffset", "line", "getLineEndOffset", "allowEnd", "getLine", "Lcom/intellij/vim/api/models/Line;", "addJump", "reset", "saveJumpLocation", "findAll", "Lcom/intellij/vim/api/models/Range;", "pattern", "startLine", "endLine", "ignoreCase", "findPattern", "count", "backwards", "getBlockQuoteInLineRange", "quote", "", "isOuter", "getBlockTagRange", "getCurrentOrFollowingWord", "isBigWord", "getGlobalMark", "Lcom/intellij/vim/api/models/Mark;", "char", "getJump", "Lcom/intellij/vim/api/models/Jump;", "getMark", "getMethodEndOffset", "getMethodStartOffset", "getNextCharOnLineOffset", "getNextMisspelledWordOffset", "getNextParagraphBoundOffset", "includeWhitespaceLines", "(IZ)Ljava/lang/Integer;", "(IIZ)Ljava/lang/Integer;", "getNextSectionStart", "marker", "getNextSentenceEnd", "includeCurrent", "requireAll", "(IZZ)Ljava/lang/Integer;", "(IIZZ)Ljava/lang/Integer;", "getNextSentenceStart", "getNextWordEndOffset", "getNextWordStartOffset", "getParagraphRange", "getPreviousSectionStart", "getReg", "register", "getRegType", "Lcom/intellij/vim/api/models/TextType;", "getSentenceRange", "getWordAtOrFollowingOffset", "getWordTextObjectRange", "isPrimaryRegisterSupported", "isSystemClipboard", "isWritable", "removeLocalMark", "resetAllMarksForCaret", "resetRegisters", "scrollCaretIntoView", "scrollCaretToLeftEdge", "scrollCaretToRightEdge", "scrollFullPage", "pages", "scrollHalfPageDown", "lines", "scrollHalfPageUp", "scrollHorizontally", "columns", "scrollLineToBottom", "start", "scrollLineToMiddle", "scrollLineToTop", "scrollVertically", "selectRegister", "selectWindowHorizontally", "relativePosition", "selectWindowInVertically", "setMark", "setReg", "textType", "caretData", "Lkotlin/Pair;", "Lcom/intellij/vim/api/models/CaretInfo;", "Lcom/intellij/vim/api/models/CaretData;", "getCaretData", "()Ljava/util/List;", "caretIds", "getCaretIds", "changeMarks", "getChangeMarks", "()Lcom/intellij/vim/api/models/Range;", "currentJumpIndex", "getCurrentJumpIndex", "()I", "defaultRegister", "getDefaultRegister", "()C", "filePath", "Lcom/intellij/vim/api/models/Path;", "getFilePath", "()Lcom/intellij/vim/api/models/Path;", "globalMarks", "", "getGlobalMarks", "()Ljava/util/Set;", "isRegisterSpecifiedExplicitly", "()Z", "jumps", "getJumps", "lastSelectedReg", "getLastSelectedReg", "()Lcom/intellij/vim/api/models/Line;", "lineCount", "getLineCount", "localMarks", "getLocalMarks", "getOffset", "getSelection", "selectionMarks", "getSelectionMarks", "", "getText", "()Ljava/lang/CharSequence;", "textLength", "", "getTextLength", "()J", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCaretTransactionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaretTransactionImpl.kt\ncom/maddyhome/idea/vim/thinapi/editor/caret/CaretTransactionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,291:1\n295#2,2:292\n6680#3:294\n13805#3,2:297\n37#4,2:295\n*S KotlinDebug\n*F\n+ 1 CaretTransactionImpl.kt\ncom/maddyhome/idea/vim/thinapi/editor/caret/CaretTransactionImpl\n*L\n38#1:292,2\n188#1:294\n198#1:297,2\n188#1:295,2\n*E\n"})
public final class CaretTransactionImpl
implements CaretTransaction,
CaretRead,
EditorAccessor {
    private final /* synthetic */ CaretReadImpl $$delegate_0;
    private final /* synthetic */ EditorAccessorImpl $$delegate_1;
    @NotNull
    private final String caretId;

    private CaretTransactionImpl(String caretId) {
        Intrinsics.checkNotNullParameter((Object)caretId, (String)"caretId");
        this.$$delegate_0 = new CaretReadImpl(caretId, null);
        this.$$delegate_1 = new EditorAccessorImpl();
        this.caretId = caretId;
    }

    @NotNull
    public String getCaretId-z6jhRc4() {
        return this.caretId;
    }

    private final VimEditor getVimEditor() {
        VimEditor vimEditor = VimInjectorKt.getInjector().getEditorGroup().getFocusedEditor();
        Intrinsics.checkNotNull((Object)vimEditor);
        return vimEditor;
    }

    private final ExecutionContext getExecutionContext() {
        return VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext(this.getVimEditor());
    }

    private final VimCaret getVimCaret() {
        VimCaret vimCaret;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.getVimEditor().carets();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.getCaretId-z6jhRc4())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((vimCaret = (VimCaret)v0) == null) {
            vimCaret = this.getVimEditor().primaryCaret();
        }
        return vimCaret;
    }

    private final void assertOffsetInRange(int offset, IntRange range) {
        int n = range.getFirst();
        if (!(offset <= range.getLast() ? n <= offset : false)) {
            boolean bl = false;
            String string = "Offset " + offset + " is not within the valid range " + range.getStart() + ".." + range.getEndInclusive() + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final SelectionType determineSelectionType(int startOffset, int endOffset) {
        boolean isLine;
        int endOffsetNormalized = RangesKt.coerceAtMost((int)endOffset, (int)((int)this.getVimEditor().fileSize()));
        if (endOffsetNormalized == startOffset) {
            return SelectionType.CHARACTER_WISE;
        }
        CharSequence selectedText = this.getVimEditor().text().subSequence(startOffset, endOffsetNormalized);
        int startLine = this.getVimEditor().offsetToBufferPosition(startOffset).getLine();
        int endLine = this.getVimEditor().offsetToBufferPosition(endOffset).getLine();
        int lineStartOffset = this.getVimEditor().getLineStartOffset(startLine);
        int lineEndOffset = this.getVimEditor().getLineEndOffset(endLine);
        boolean bl = isLine = startOffset == lineStartOffset && endOffset == lineEndOffset && StringsKt.endsWith$default((CharSequence)selectedText, (CharSequence)"\n", (boolean)false, (int)2, null);
        return startLine == endLine ? (isLine ? SelectionType.LINE_WISE : SelectionType.CHARACTER_WISE) : SelectionType.LINE_WISE;
    }

    private final boolean putTextInternal(String text, PutData.VisualSelection visualSelection, boolean caretAfterInsertedText, boolean beforeCaret) {
        VimCopiedText copiedText = VimInjectorKt.getInjector().getClipboardManager().dumbCopiedText(text);
        PutData.TextData textData = new PutData.TextData(null, copiedText, SelectionType.CHARACTER_WISE);
        PutData putData = new PutData(textData, visualSelection, 1, beforeCaret, false, caretAfterInsertedText, -1);
        boolean result = VimInjectorKt.getInjector().getPut().putTextForCaret(this.getVimEditor(), this.getVimCaret(), this.getExecutionContext(), putData, false, false);
        return result;
    }

    public boolean insertText(int position, @NotNull String text, boolean caretAtEnd, boolean insertBeforeCaret) {
        int endBoundary;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int fileLength = this.getVimEditor().text().length();
        IntRange validRange = new IntRange(0, fileLength);
        this.assertOffsetInRange(position, validRange);
        this.getVimCaret().moveToOffset(position);
        boolean returnValue = this.putTextInternal(text, null, caretAtEnd, insertBeforeCaret);
        int newFileLength = this.getVimEditor().text().length();
        int n = endBoundary = newFileLength > 0 ? newFileLength - 1 : 0;
        int newOffset = RangesKt.coerceIn((int)(caretAtEnd ? (insertBeforeCaret ? position + text.length() - 1 : position + text.length()) : (insertBeforeCaret ? position : position + 1)), (int)0, (int)endBoundary);
        this.getVimCaret().moveToOffset(newOffset);
        return returnValue;
    }

    public boolean replaceText(int startOffset, int endOffset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.getVimEditor().text().length() == 0) {
            int fileSize = (int)this.getVimEditor().fileSize();
            if (startOffset != 0 || endOffset != 0) {
                throw new IllegalArgumentException("Invalid offsets for an empty editor: startOffset=" + startOffset + ", endOffset=" + endOffset + ", fileSize=" + fileSize + ".");
            }
            CaretTransaction.insertText$default((CaretTransaction)this, (int)startOffset, (String)text, (boolean)true, (boolean)false, (int)8, null);
            return true;
        }
        IntRange startOffsetValidRange = RangesKt.until((int)0, (int)((int)this.getVimEditor().fileSize()));
        IntRange endOffsetValidRange = new IntRange(0, (int)this.getVimEditor().fileSize());
        this.assertOffsetInRange(startOffset, startOffsetValidRange);
        this.assertOffsetInRange(endOffset, endOffsetValidRange);
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("Start offset must be less than or equal to end offset!");
        }
        if (startOffset == endOffset) {
            this.insertText(startOffset, text, false, true);
            return true;
        }
        SelectionType selectionType = this.determineSelectionType(startOffset, endOffset);
        PutData.VisualSelection visualSelection = new PutData.VisualSelection(MapsKt.mapOf((Pair)TuplesKt.to((Object)this.getVimCaret(), (Object)VimSelection.Companion.create(startOffset, endOffset - 1, selectionType, this.getVimEditor()))), selectionType);
        return this.putTextInternal(text, visualSelection, false, true);
    }

    /*
     * WARNING - void declaration
     */
    public void replaceTextBlockwise(@NotNull Range.Block range, @NotNull List<String> text) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Object $this$sortedByDescending$iv = range.getRanges();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = ArraysKt.sortedWith((Object[])$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Range.Simple it = (Range.Simple)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (Range.Simple)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        });
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] selections = thisCollection$iv.toArray(new Range.Simple[0]);
        List listOfText = CollectionsKt.reversed((Iterable)text);
        if (listOfText.size() != selections.length) {
            throw new IllegalArgumentException("Text block size must match number of selections!");
        }
        IntRange startOffsetValidRange = RangesKt.until((int)0, (int)((int)this.getVimEditor().fileSize()));
        IntRange endOffsetValidRange = new IntRange(0, (int)this.getVimEditor().fileSize());
        Object[] $this$forEach$iv = selections;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Range.Simple element$iv;
            Range.Simple selection = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.assertOffsetInRange(selection.getStart(), startOffsetValidRange);
            this.assertOffsetInRange(selection.getEnd(), endOffsetValidRange);
        }
        for (IndexedValue selection : ArraysKt.withIndex((Object[])selections)) {
            VimInjectorKt.getInjector().getChangeGroup().replaceText(this.getVimEditor(), this.getVimCaret(), ((Range.Simple)selection.getValue()).getStart(), ((Range.Simple)selection.getValue()).getEnd(), (String)listOfText.get(selection.getIndex()));
        }
    }

    public boolean deleteText(int startOffset, int endOffset) {
        IntRange startOffsetValidRange = RangesKt.until((int)0, (int)((int)this.getVimEditor().fileSize()));
        IntRange endOffsetValidRange = new IntRange(0, (int)this.getVimEditor().fileSize());
        this.assertOffsetInRange(startOffset, startOffsetValidRange);
        this.assertOffsetInRange(endOffset, endOffsetValidRange);
        TextRange range = new TextRange(startOffset, endOffset);
        VimInjectorKt.getInjector().getChangeGroup().deleteRange(this.getVimEditor(), this.getExecutionContext(), this.getVimCaret(), range, SelectionType.CHARACTER_WISE, false, false);
        return true;
    }

    public void updateCaret(int offset, @Nullable Range.Simple selection) {
        int textLength = this.getVimEditor().text().length();
        IntRange startOffsetValidRange = RangesKt.until((int)0, (int)textLength);
        IntRange endOffsetValidRange = new IntRange(0, textLength);
        this.assertOffsetInRange(offset, startOffsetValidRange);
        if (selection != null) {
            this.assertOffsetInRange(selection.getStart(), startOffsetValidRange);
            this.assertOffsetInRange(selection.getEnd(), endOffsetValidRange);
        }
        this.getVimCaret().moveToOffset(offset);
        Range.Simple simple = selection;
        if (simple != null) {
            int end;
            Range.Simple simple2 = simple;
            boolean bl = false;
            int start = simple2.component1();
            if (start != (end = simple2.component2())) {
                this.getVimCaret().setSelection(start, end);
            }
        } else {
            this.getVimCaret().removeSelection();
        }
    }

    public int getLineStartOffset(int line) {
        return this.getVimEditor().getLineStartOffset(line);
    }

    public int getLineEndOffset(int line, boolean allowEnd) {
        return this.getVimEditor().getLineEndOffset(line);
    }

    @NotNull
    public Line getLine(int offset) {
        int lineNumber = this.getVimEditor().offsetToBufferPosition(offset).getLine();
        String lineText = this.getVimEditor().getLineText(lineNumber);
        int lineStartOffset = this.getVimEditor().getLineStartOffset(lineNumber);
        int lineEndOffset = this.getVimEditor().getLineEndOffset(lineNumber);
        return new Line(lineNumber, lineText, lineStartOffset, lineEndOffset);
    }

    public void addJump(boolean reset) {
        VimVirtualFile vimVirtualFile = this.getVimEditor().getVirtualFile();
        if (vimVirtualFile == null) {
            return;
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        String path = virtualFile.getPath();
        String protocol = virtualFile.getProtocol();
        BufferPosition position = this.getVimEditor().offsetToBufferPosition(this.getVimCaret().getOffset());
        Jump jump = new Jump(position.getLine(), position.getColumn(), path, protocol);
        VimInjectorKt.getInjector().getJumpService().addJump(this.getVimEditor().getProjectId(), jump, reset);
    }

    public void saveJumpLocation() {
        this.addJump(true);
        VimInjectorKt.getInjector().getMarkService().setMark(this.getVimEditor(), '\'');
        VimInjectorKt.getInjector().getJumpService().includeCurrentCommandAsNavigation(this.getVimEditor());
    }

    public boolean selectRegister(char register) {
        return this.$$delegate_0.selectRegister(register);
    }

    public void resetRegisters() {
        this.$$delegate_0.resetRegisters();
    }

    public boolean isWritable(char register) {
        return this.$$delegate_0.isWritable(register);
    }

    public boolean isSystemClipboard(char register) {
        return this.$$delegate_0.isSystemClipboard(register);
    }

    public boolean isPrimaryRegisterSupported() {
        return this.$$delegate_0.isPrimaryRegisterSupported();
    }

    @Nullable
    public String getReg(char register) {
        return this.$$delegate_0.getReg(register);
    }

    @Nullable
    public TextType getRegType(char register) {
        return this.$$delegate_0.getRegType(register);
    }

    public boolean setReg(char register, @NotNull String text, @NotNull TextType textType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textType, (String)"textType");
        return this.$$delegate_0.setReg(register, text, textType);
    }

    @Nullable
    public Mark getMark(char c) {
        return this.$$delegate_0.getMark(c);
    }

    public boolean setMark(char c) {
        return this.$$delegate_0.setMark(c);
    }

    public boolean setMark(char c, int offset) {
        return this.$$delegate_0.setMark(c, offset);
    }

    public void removeLocalMark(char c) {
        this.$$delegate_0.removeLocalMark(c);
    }

    public void resetAllMarksForCaret() {
        this.$$delegate_0.resetAllMarksForCaret();
    }

    public boolean scrollFullPage(int pages) {
        return this.$$delegate_0.scrollFullPage(pages);
    }

    public boolean scrollHalfPageUp(int lines) {
        return this.$$delegate_0.scrollHalfPageUp(lines);
    }

    public boolean scrollHalfPageDown(int lines) {
        return this.$$delegate_0.scrollHalfPageDown(lines);
    }

    public void selectWindowHorizontally(int relativePosition) {
        this.$$delegate_0.selectWindowHorizontally(relativePosition);
    }

    public void selectWindowInVertically(int relativePosition) {
        this.$$delegate_0.selectWindowInVertically(relativePosition);
    }

    @Nullable
    public Integer getNextParagraphBoundOffset(int count, boolean includeWhitespaceLines) {
        return this.$$delegate_0.getNextParagraphBoundOffset(count, includeWhitespaceLines);
    }

    @Nullable
    public Integer getNextParagraphBoundOffset(int startLine, int count, boolean includeWhitespaceLines) {
        return this.$$delegate_1.getNextParagraphBoundOffset(startLine, count, includeWhitespaceLines);
    }

    @Nullable
    public Integer getNextSentenceStart(int count, boolean includeCurrent, boolean requireAll) {
        return this.$$delegate_0.getNextSentenceStart(count, includeCurrent, requireAll);
    }

    @Nullable
    public Integer getNextSentenceStart(int startOffset, int count, boolean includeCurrent, boolean requireAll) {
        return this.$$delegate_1.getNextSentenceStart(startOffset, count, includeCurrent, requireAll);
    }

    public int getNextSectionStart(char marker, int count) {
        return this.$$delegate_0.getNextSectionStart(marker, count);
    }

    public int getNextSectionStart(int startLine, char marker, int count) {
        return this.$$delegate_1.getNextSectionStart(startLine, marker, count);
    }

    public int getPreviousSectionStart(char marker, int count) {
        return this.$$delegate_0.getPreviousSectionStart(marker, count);
    }

    public int getPreviousSectionStart(int startLine, char marker, int count) {
        return this.$$delegate_1.getPreviousSectionStart(startLine, marker, count);
    }

    @Nullable
    public Integer getNextSentenceEnd(int count, boolean includeCurrent, boolean requireAll) {
        return this.$$delegate_0.getNextSentenceEnd(count, includeCurrent, requireAll);
    }

    @Nullable
    public Integer getNextSentenceEnd(int startOffset, int count, boolean includeCurrent, boolean requireAll) {
        return this.$$delegate_1.getNextSentenceEnd(startOffset, count, includeCurrent, requireAll);
    }

    public int getMethodEndOffset(int count) {
        return this.$$delegate_0.getMethodEndOffset(count);
    }

    public int getMethodStartOffset(int count) {
        return this.$$delegate_0.getMethodStartOffset(count);
    }

    public int getNextCharOnLineOffset(int count, char c) {
        return this.$$delegate_0.getNextCharOnLineOffset(count, c);
    }

    public int getNextCharOnLineOffset(int startOffset, int count, char c) {
        return this.$$delegate_1.getNextCharOnLineOffset(startOffset, count, c);
    }

    @Nullable
    public Range getCurrentOrFollowingWord(boolean isBigWord) {
        return this.$$delegate_0.getCurrentOrFollowingWord(isBigWord);
    }

    @NotNull
    public Range getWordTextObjectRange(int count, boolean isOuter, boolean isBigWord) {
        return this.$$delegate_0.getWordTextObjectRange(count, isOuter, isBigWord);
    }

    @NotNull
    public Range getSentenceRange(int count, boolean isOuter) {
        return this.$$delegate_0.getSentenceRange(count, isOuter);
    }

    @Nullable
    public Range getParagraphRange(int count, boolean isOuter) {
        return this.$$delegate_0.getParagraphRange(count, isOuter);
    }

    @Nullable
    public Range getParagraphRange(int line, int count, boolean isOuter) {
        return this.$$delegate_1.getParagraphRange(line, count, isOuter);
    }

    @Nullable
    public Range getBlockTagRange(int count, boolean isOuter) {
        return this.$$delegate_0.getBlockTagRange(count, isOuter);
    }

    @Nullable
    public Range getBlockQuoteInLineRange(char quote, boolean isOuter) {
        return this.$$delegate_0.getBlockQuoteInLineRange(quote, isOuter);
    }

    @Nullable
    public Range getBlockQuoteInLineRange(int startOffset, char quote, boolean isOuter) {
        return this.$$delegate_1.getBlockQuoteInLineRange(startOffset, quote, isOuter);
    }

    public int getNextMisspelledWordOffset(int count) {
        return this.$$delegate_0.getNextMisspelledWordOffset(count);
    }

    public int getOffset() {
        return this.$$delegate_0.getOffset();
    }

    @NotNull
    public Range getSelection() {
        return this.$$delegate_0.getSelection();
    }

    @NotNull
    public Line getLine() {
        return this.$$delegate_0.getLine();
    }

    public char getLastSelectedReg() {
        return this.$$delegate_0.getLastSelectedReg();
    }

    public char getDefaultRegister() {
        return this.$$delegate_0.getDefaultRegister();
    }

    public boolean isRegisterSpecifiedExplicitly() {
        return this.$$delegate_0.isRegisterSpecifiedExplicitly();
    }

    @Nullable
    public Range getSelectionMarks() {
        return this.$$delegate_0.getSelectionMarks();
    }

    @Nullable
    public Range getChangeMarks() {
        return this.$$delegate_0.getChangeMarks();
    }

    @NotNull
    public Set<Mark> getLocalMarks() {
        return this.$$delegate_0.getLocalMarks();
    }

    @Nullable
    public Mark getGlobalMark(char c) {
        return this.$$delegate_1.getGlobalMark(c);
    }

    @Nullable
    public com.intellij.vim.api.models.Jump getJump(int count) {
        return this.$$delegate_1.getJump(count);
    }

    public void scrollCaretIntoView() {
        this.$$delegate_1.scrollCaretIntoView();
    }

    public boolean scrollVertically(int lines) {
        return this.$$delegate_1.scrollVertically(lines);
    }

    public boolean scrollLineToTop(int line, boolean start) {
        return this.$$delegate_1.scrollLineToTop(line, start);
    }

    public boolean scrollLineToMiddle(int line, boolean start) {
        return this.$$delegate_1.scrollLineToMiddle(line, start);
    }

    public boolean scrollLineToBottom(int line, boolean start) {
        return this.$$delegate_1.scrollLineToBottom(line, start);
    }

    public boolean scrollHorizontally(int columns) {
        return this.$$delegate_1.scrollHorizontally(columns);
    }

    public boolean scrollCaretToLeftEdge() {
        return this.$$delegate_1.scrollCaretToLeftEdge();
    }

    public boolean scrollCaretToRightEdge() {
        return this.$$delegate_1.scrollCaretToRightEdge();
    }

    @Nullable
    public Integer getNextWordStartOffset(int startOffset, int count, boolean isBigWord) {
        return this.$$delegate_1.getNextWordStartOffset(startOffset, count, isBigWord);
    }

    public int getNextWordEndOffset(int startOffset, int count, boolean isBigWord) {
        return this.$$delegate_1.getNextWordEndOffset(startOffset, count, isBigWord);
    }

    @Nullable
    public Range getWordAtOrFollowingOffset(int startOffset, boolean isBigWord) {
        return this.$$delegate_1.getWordAtOrFollowingOffset(startOffset, isBigWord);
    }

    @NotNull
    public List<Range> findAll(@NotNull String pattern, int startLine, int endLine, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.$$delegate_1.findAll(pattern, startLine, endLine, ignoreCase);
    }

    @Nullable
    public Range findPattern(@NotNull String pattern, int startOffset, int count, boolean backwards) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.$$delegate_1.findPattern(pattern, startOffset, count, backwards);
    }

    public long getTextLength() {
        return this.$$delegate_1.getTextLength();
    }

    @NotNull
    public CharSequence getText() {
        return this.$$delegate_1.getText();
    }

    public int getLineCount() {
        return this.$$delegate_1.getLineCount();
    }

    @NotNull
    public Path getFilePath() {
        return this.$$delegate_1.getFilePath();
    }

    @NotNull
    public List<Pair<CaretId, CaretInfo>> getCaretData() {
        return this.$$delegate_1.getCaretData();
    }

    @NotNull
    public List<CaretId> getCaretIds() {
        return this.$$delegate_1.getCaretIds();
    }

    @NotNull
    public Set<Mark> getGlobalMarks() {
        return this.$$delegate_1.getGlobalMarks();
    }

    @NotNull
    public List<com.intellij.vim.api.models.Jump> getJumps() {
        return this.$$delegate_1.getJumps();
    }

    public int getCurrentJumpIndex() {
        return this.$$delegate_1.getCurrentJumpIndex();
    }

    public /* synthetic */ CaretTransactionImpl(String caretId, DefaultConstructorMarker $constructor_marker) {
        this(caretId);
    }
}

