/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.FuncrefCallExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.FunctionCallExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.VariableExpression;
import com.maddyhome.idea.vim.vimscript.model.functions.DefinedFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/CallCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "functionCall", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getFunctionCall", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
public final class CallCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final Expression functionCall;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public CallCommand(@NotNull Range range, @NotNull Expression functionCall) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        super(range, CommandModifier.NONE, null, 4, null);
        this.range = range;
        this.functionCall = functionCall;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final Expression getFunctionCall() {
        return this.functionCall;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Expression expression = this.functionCall;
        if (expression instanceof FunctionCallExpression) {
            Object object = ((FunctionCallExpression)this.functionCall).getScope();
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            Object scopePrefix = object;
            String name = ((FunctionCallExpression)this.functionCall).getFunctionName().evaluate(editor, context, this.getVimContext()).getValue();
            FunctionHandler function = VimInjectorKt.getInjector().getFunctionService().getFunctionHandlerOrNull(((FunctionCallExpression)this.functionCall).getScope(), name, this.getVimContext());
            if (function != null) {
                if (function instanceof DefinedFunctionHandler && ((DefinedFunctionHandler)function).getFunction().getFlags().contains((Object)FunctionFlag.DICT)) {
                    Object[] objectArray = new Object[]{(String)scopePrefix + name};
                    throw ExExceptionsKt.exExceptionMessage("E725", objectArray);
                }
                function.setRange(this.range);
                function.executeFunction(((FunctionCallExpression)this.functionCall).getArguments(), editor, context, this);
                return ExecutionResult.Success.INSTANCE;
            }
            VimDataType funcref = VimInjectorKt.getInjector().getVariableService().getNullableVariableValue(new VariableExpression(((FunctionCallExpression)this.functionCall).getScope(), ((FunctionCallExpression)this.functionCall).getFunctionName()), editor, context, this.getVimContext());
            if (funcref instanceof VimFuncref) {
                ((VimFuncref)funcref).getHandler().setRange(this.range);
                ((VimFuncref)funcref).execute((String)scopePrefix + name, ((FunctionCallExpression)this.functionCall).getArguments(), editor, context, this.getVimContext());
                return ExecutionResult.Success.INSTANCE;
            }
            Object[] objectArray = new Object[]{(String)scopePrefix + name};
            throw ExExceptionsKt.exExceptionMessage("E117", objectArray);
        }
        if (expression instanceof FuncrefCallExpression) {
            ((FuncrefCallExpression)this.functionCall).evaluateWithRange(this.range, editor, context, this.getVimContext());
            return ExecutionResult.Success.INSTANCE;
        }
        throw ExExceptionsKt.exExceptionMessage("E129", new Object[0]);
    }
}

