/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.datatypes;

import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0000H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimFloat;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "value", "", "<init>", "(D)V", "getValue", "()D", "toVimFloat", "toVimNumber", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "toVimString", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimString;", "toOutputString", "", "copy", "lockVar", "", "depth", "", "unlockVar", "component1", "equals", "", "other", "", "hashCode", "vim-engine"})
public final class VimFloat
extends VimDataType {
    private final double value;

    public VimFloat(double value) {
        super("float");
        this.value = value;
    }

    public final double getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public VimFloat toVimFloat() {
        return this;
    }

    @Override
    @NotNull
    public VimInt toVimNumber() {
        throw ExExceptionsKt.exExceptionMessage("E805", new Object[0]);
    }

    @Override
    @NotNull
    public VimString toVimString() {
        throw ExExceptionsKt.exExceptionMessage("E806", new Object[0]);
    }

    @Override
    @NotNull
    public String toOutputString() {
        DecimalFormatSymbols decimalFormatSymbols;
        if (Double.isNaN(this.value)) {
            return "nan";
        }
        if (Double.isInfinite(this.value)) {
            return this.value > 0.0 ? "inf" : "-inf";
        }
        boolean tooBigOrTooSmall = Math.abs(this.value) >= 1000000.0 || Math.abs(this.value) < 0.001 && !(this.value == 0.0);
        String pattern = tooBigOrTooSmall ? "0.0#####E0" : "0.0#####";
        DecimalFormatSymbols $this$toOutputString_u24lambda_u240 = decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        boolean bl = false;
        $this$toOutputString_u24lambda_u240.setExponentSeparator("e");
        DecimalFormatSymbols symbols = decimalFormatSymbols;
        String string = new DecimalFormat(pattern, symbols).format(this.value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Override
    @NotNull
    public VimFloat copy() {
        return new VimFloat(this.value);
    }

    @Override
    public void lockVar(int depth) {
        this.setLocked(true);
    }

    @Override
    public void unlockVar(int depth) {
        this.setLocked(false);
    }

    public final double component1() {
        return this.value;
    }

    @NotNull
    public final VimFloat copy(double value) {
        return new VimFloat(value);
    }

    public static /* synthetic */ VimFloat copy$default(VimFloat vimFloat, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = vimFloat.value;
        }
        return vimFloat.copy(d);
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VimFloat)) {
            return false;
        }
        VimFloat vimFloat = (VimFloat)other;
        return Double.compare(this.value, vimFloat.value) == 0;
    }
}

