/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimBlob;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFloat;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.LValueExpression;
import com.maddyhome.idea.vim.vimscript.model.functions.DefinedFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J8\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J8\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/IndexedExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/LValueExpression;", "index", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "expression", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;)V", "getIndex", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getExpression", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "isStronglyTyped", "", "assign", "", "value", "assignmentTextForErrors", "", "assignToDictionaryItem", "dict", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDictionary;", "assignToListItem", "list", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimList;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "vim-engine"})
public final class IndexedExpression
extends LValueExpression {
    @NotNull
    private final Expression index;
    @NotNull
    private final Expression expression;

    public IndexedExpression(@NotNull Expression index, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.index = index;
        this.expression = expression;
    }

    @NotNull
    public final Expression getIndex() {
        return this.index;
    }

    @NotNull
    public final Expression getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public VimDataType evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType expressionValue = this.expression.evaluate(editor, context, vimContext);
        VimDataType indexValue = this.index.evaluate(editor, context, vimContext);
        VimString stringIndex = indexValue instanceof VimFloat ? new VimString(((VimFloat)indexValue).toOutputString()) : indexValue.toVimString();
        VimDataType vimDataType = expressionValue;
        if (vimDataType instanceof VimDictionary) {
            VimDataType vimDataType2 = ((VimDictionary)expressionValue).getDictionary().get(stringIndex);
            if (vimDataType2 == null) {
                Object[] objectArray = new Object[]{indexValue.toOutputString()};
                throw ExExceptionsKt.exExceptionMessage("E716", objectArray);
            }
            return vimDataType2;
        }
        if (vimDataType instanceof VimList) {
            int i;
            int idx = indexValue.toVimNumber().getValue();
            int n = i = idx < 0 ? idx + ((VimList)expressionValue).getValues().size() : idx;
            if (i < 0 || i >= ((VimList)expressionValue).getValues().size()) {
                Object[] objectArray = new Object[]{idx};
                throw ExExceptionsKt.exExceptionMessage("E684", objectArray);
            }
            return ((VimList)expressionValue).getValues().get(i);
        }
        String text = expressionValue.toVimString().getValue();
        int idx = indexValue.toVimNumber().getValue();
        if (idx < 0 || idx >= text.length()) {
            return VimString.Companion.getEMPTY();
        }
        return new VimString(String.valueOf(text.charAt(idx)));
    }

    @Override
    public boolean isStronglyTyped() {
        return false;
    }

    @Override
    public void assign(@NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext, @NotNull String assignmentTextForErrors) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Intrinsics.checkNotNullParameter((Object)assignmentTextForErrors, (String)"assignmentTextForErrors");
        VimDataType containerValue = this.expression.evaluate(editor, context, vimContext);
        if (containerValue instanceof VimDictionary) {
            this.assignToDictionaryItem((VimDictionary)containerValue, value, editor, context, vimContext, assignmentTextForErrors);
        } else if (containerValue instanceof VimList) {
            this.assignToListItem((VimList)containerValue, value, editor, context, vimContext, assignmentTextForErrors);
        } else {
            if (containerValue instanceof VimBlob) {
                throw new NotImplementedError(null, 1, null);
            }
            Object[] objectArray = new Object[]{containerValue.getTypeName(), assignmentTextForErrors};
            throw ExExceptionsKt.exExceptionMessage("E689", objectArray);
        }
    }

    private final void assignToDictionaryItem(VimDictionary dict, VimDataType value, VimEditor editor, ExecutionContext context, VimLContext vimContext, String assignmentTextForErrors) {
        VimString key;
        VimDataType k = this.index.evaluate(editor, context, vimContext);
        VimString vimString = key = k instanceof VimFloat ? new VimString(((VimFloat)k).toOutputString()) : k.toVimString();
        if (((Map)dict.getDictionary()).containsKey(key)) {
            VimDataType vimDataType = dict.getDictionary().get(key);
            boolean bl = vimDataType != null ? vimDataType.isLocked() : false;
            if (bl) {
                Object[] objectArray = new Object[]{assignmentTextForErrors};
                throw ExExceptionsKt.exExceptionMessage("E741", objectArray);
            }
        } else if (dict.isLocked()) {
            Object[] objectArray = new Object[]{assignmentTextForErrors};
            throw ExExceptionsKt.exExceptionMessage("E741", objectArray);
        }
        VimDataType newValue = value;
        if (value instanceof VimFuncref && !((VimFuncref)value).isSelfFixed() && ((VimFuncref)value).getHandler() instanceof DefinedFunctionHandler && ((DefinedFunctionHandler)((VimFuncref)value).getHandler()).getFunction().getFlags().contains((Object)FunctionFlag.DICT)) {
            VimDataType vimDataType = value.deepCopy(true);
            Intrinsics.checkNotNull((Object)vimDataType, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref");
            newValue = (VimFuncref)vimDataType;
            ((VimFuncref)newValue).setDictionary(dict);
        }
        ((Map)dict.getDictionary()).put(key, newValue);
    }

    private final void assignToListItem(VimList list, VimDataType value, VimEditor editor, ExecutionContext context, VimLContext vimContext, String assignmentTextForErrors) {
        int idx;
        int indexNum = this.index.evaluate(editor, context, vimContext).toVimNumber().getValue();
        int n = idx = indexNum < 0 ? indexNum + list.getValues().size() : indexNum;
        if (idx < 0 || idx >= list.getValues().size()) {
            Object[] objectArray = new Object[]{indexNum};
            throw ExExceptionsKt.exExceptionMessage("E684", objectArray);
        }
        if (list.getValues().get(idx).isLocked()) {
            Object[] objectArray = new Object[]{assignmentTextForErrors};
            throw ExExceptionsKt.exExceptionMessage("E741", objectArray);
        }
        list.getValues().set(idx, value);
    }

    @NotNull
    public final Expression component1() {
        return this.index;
    }

    @NotNull
    public final Expression component2() {
        return this.expression;
    }

    @NotNull
    public final IndexedExpression copy(@NotNull Expression index, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new IndexedExpression(index, expression);
    }

    public static /* synthetic */ IndexedExpression copy$default(IndexedExpression indexedExpression, Expression expression, Expression expression2, int n, Object object) {
        if ((n & 1) != 0) {
            expression = indexedExpression.index;
        }
        if ((n & 2) != 0) {
            expression2 = indexedExpression.expression;
        }
        return indexedExpression.copy(expression, expression2);
    }

    @NotNull
    public String toString() {
        return "IndexedExpression(index=" + this.index + ", expression=" + this.expression + ")";
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = result * 31 + this.expression.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexedExpression)) {
            return false;
        }
        IndexedExpression indexedExpression = (IndexedExpression)other;
        if (!Intrinsics.areEqual((Object)this.index, (Object)indexedExpression.index)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expression, (Object)indexedExpression.expression);
    }
}

