/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimBlob;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.LValueExpression;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J+\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u001aH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006%"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/SublistExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/LValueExpression;", "from", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "to", "expression", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;)V", "getFrom", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getTo", "getExpression", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "isStronglyTyped", "", "assign", "", "value", "assignmentTextForErrors", "", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "vim-engine"})
public final class SublistExpression
extends LValueExpression {
    @Nullable
    private final Expression from;
    @Nullable
    private final Expression to;
    @NotNull
    private final Expression expression;

    public SublistExpression(@Nullable Expression from, @Nullable Expression to, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.from = from;
        this.to = to;
        this.expression = expression;
    }

    @Nullable
    public final Expression getFrom() {
        return this.from;
    }

    @Nullable
    public final Expression getTo() {
        return this.to;
    }

    @NotNull
    public final Expression getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public VimDataType evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        VimDataType vimDataType;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType expressionValue = this.expression.evaluate(editor, context, vimContext);
        Object object = this.from;
        int fromValue = object != null && (object = ((Expression)object).evaluate(editor, context, vimContext)) != null && (object = ((VimDataType)object).toVimNumber()) != null ? ((VimInt)object).getValue() : 0;
        Object object2 = this.to;
        int toValue = object2 != null && (object2 = ((Expression)object2).evaluate(editor, context, vimContext)) != null && (object2 = ((VimDataType)object2).toVimNumber()) != null ? ((VimInt)object2).getValue() : -1;
        VimDataType vimDataType2 = expressionValue;
        if (vimDataType2 instanceof VimDictionary) {
            throw ExExceptionsKt.exExceptionMessage("E719", new Object[0]);
        }
        if (vimDataType2 instanceof VimFuncref) {
            throw ExExceptionsKt.exExceptionMessage("E695", new Object[0]);
        }
        int arraySize = vimDataType2 instanceof VimList ? ((VimList)expressionValue).getValues().size() : expressionValue.toVimString().getValue().length();
        int start = fromValue < 0 ? fromValue + arraySize : fromValue;
        int end = RangesKt.coerceAtMost((int)(toValue < 0 ? toValue + arraySize : toValue), (int)(arraySize - 1));
        if (expressionValue instanceof VimList) {
            int i;
            List result = new ArrayList();
            if (start >= 0 && end < arraySize && (i = start) <= end) {
                while (true) {
                    result.add(((VimList)expressionValue).getValues().get(i));
                    if (i == end) break;
                    ++i;
                }
            }
            vimDataType = new VimList(result);
        } else {
            VimString vimString;
            if (start < 0 || end < 0 || end < start) {
                vimString = VimString.Companion.getEMPTY();
            } else {
                String string = expressionValue.toVimString().getValue().substring(start, end + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                vimString = new VimString(string);
            }
            vimDataType = vimString;
        }
        return vimDataType;
    }

    @Override
    public boolean isStronglyTyped() {
        return false;
    }

    @Override
    public void assign(@NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext, @NotNull String assignmentTextForErrors) {
        VimDataType listValue;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Intrinsics.checkNotNullParameter((Object)assignmentTextForErrors, (String)"assignmentTextForErrors");
        VimDataType vimDataType = listValue = this.expression.evaluate(editor, context, vimContext);
        if (vimDataType instanceof VimList) {
            int end;
            VimList vimList = value instanceof VimList ? (VimList)value : null;
            if (vimList == null) {
                throw ExExceptionsKt.exExceptionMessage("E709", new Object[0]);
            }
            VimList newList = vimList;
            int total = ((VimList)listValue).getValues().size();
            Object object = this.from;
            int from = object != null && (object = ((Expression)object).evaluate(editor, context, vimContext)) != null && (object = ((VimDataType)object).toVimNumber()) != null ? ((VimInt)object).getValue() : 0;
            Object object2 = this.to;
            int to = object2 != null && (object2 = ((Expression)object2).evaluate(editor, context, vimContext)) != null && (object2 = ((VimDataType)object2).toVimNumber()) != null ? ((VimInt)object2).getValue() : total - 1;
            int start = RangesKt.coerceAtLeast((int)(from < 0 ? from + total : from), (int)0);
            int n = end = to < 0 ? to + total : to;
            if (start >= ((VimList)listValue).getValues().size()) {
                Object[] objectArray = new Object[]{from};
                throw ExExceptionsKt.exExceptionMessage("E684", objectArray);
            }
            if (end < 0) {
                Object[] objectArray = new Object[]{to};
                throw ExExceptionsKt.exExceptionMessage("E684", objectArray);
            }
            if (newList.getValues().size() < end - start + 1) {
                throw ExExceptionsKt.exExceptionMessage("E711", new Object[0]);
            }
            if (newList.getValues().size() > end - start + 1 && end < ((VimList)listValue).getValues().size() - 1) {
                throw ExExceptionsKt.exExceptionMessage("E710", new Object[0]);
            }
            int n2 = newList.getValues().size();
            for (int i = 0; i < n2; ++i) {
                VimDataType item = newList.getValues().get(i);
                if (i + start < ((VimList)listValue).getValues().size()) {
                    ((VimList)listValue).getValues().set(i + start, item);
                    continue;
                }
                ((VimList)listValue).getValues().add(item);
            }
        } else {
            if (vimDataType instanceof VimBlob) {
                throw new NotImplementedError(null, 1, null);
            }
            if (vimDataType instanceof VimDictionary) {
                throw ExExceptionsKt.exExceptionMessage("E719", new Object[0]);
            }
            Object[] objectArray = new Object[]{listValue.getTypeName(), assignmentTextForErrors};
            throw ExExceptionsKt.exExceptionMessage("E689", objectArray);
        }
    }

    @Nullable
    public final Expression component1() {
        return this.from;
    }

    @Nullable
    public final Expression component2() {
        return this.to;
    }

    @NotNull
    public final Expression component3() {
        return this.expression;
    }

    @NotNull
    public final SublistExpression copy(@Nullable Expression from, @Nullable Expression to, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new SublistExpression(from, to, expression);
    }

    public static /* synthetic */ SublistExpression copy$default(SublistExpression sublistExpression, Expression expression, Expression expression2, Expression expression3, int n, Object object) {
        if ((n & 1) != 0) {
            expression = sublistExpression.from;
        }
        if ((n & 2) != 0) {
            expression2 = sublistExpression.to;
        }
        if ((n & 4) != 0) {
            expression3 = sublistExpression.expression;
        }
        return sublistExpression.copy(expression, expression2, expression3);
    }

    @NotNull
    public String toString() {
        return "SublistExpression(from=" + this.from + ", to=" + this.to + ", expression=" + this.expression + ")";
    }

    public int hashCode() {
        int result = this.from == null ? 0 : this.from.hashCode();
        result = result * 31 + (this.to == null ? 0 : this.to.hashCode());
        result = result * 31 + this.expression.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SublistExpression)) {
            return false;
        }
        SublistExpression sublistExpression = (SublistExpression)other;
        if (!Intrinsics.areEqual((Object)this.from, (Object)sublistExpression.from)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.to, (Object)sublistExpression.to)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expression, (Object)sublistExpression.expression);
    }
}

