/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions.operators.handlers.binary;

import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFloat;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.operators.handlers.binary.BinaryOperatorWithIgnoreCaseOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0014J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000bH$J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000eH$J \u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H$J \u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J \u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J \u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/handlers/binary/ComparisonOperatorHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/handlers/binary/BinaryOperatorWithIgnoreCaseOption;", "ignoreCase", "", "<init>", "(Ljava/lang/Boolean;)V", "performOperation", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "left", "right", "coerceToVimFloatValue", "", "value", "compare", "", "", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimList;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDictionary;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimFuncref;", "vim-engine"})
public abstract class ComparisonOperatorHandler
extends BinaryOperatorWithIgnoreCaseOption {
    public ComparisonOperatorHandler(@Nullable Boolean ignoreCase) {
        super(ignoreCase);
    }

    @Override
    @NotNull
    public VimDataType performOperation(@NotNull VimDataType left, @NotNull VimDataType right, boolean ignoreCase) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        if (left instanceof VimList || right instanceof VimList) {
            VimList vimList = left instanceof VimList ? (VimList)left : null;
            if (vimList == null) {
                throw ExExceptionsKt.exExceptionMessage("E691", new Object[0]);
            }
            VimList leftList = vimList;
            VimList vimList2 = right instanceof VimList ? (VimList)right : null;
            if (vimList2 == null) {
                throw ExExceptionsKt.exExceptionMessage("E691", new Object[0]);
            }
            VimList rightList = vimList2;
            bl = this.compare(leftList, rightList, ignoreCase);
        } else if (left instanceof VimDictionary || right instanceof VimDictionary) {
            VimDictionary vimDictionary = left instanceof VimDictionary ? (VimDictionary)left : null;
            if (vimDictionary == null) {
                throw ExExceptionsKt.exExceptionMessage("E735", new Object[0]);
            }
            VimDictionary leftDictionary = vimDictionary;
            VimDictionary vimDictionary2 = right instanceof VimDictionary ? (VimDictionary)right : null;
            if (vimDictionary2 == null) {
                throw ExExceptionsKt.exExceptionMessage("E735", new Object[0]);
            }
            VimDictionary rightDictionary = vimDictionary2;
            bl = this.compare(leftDictionary, rightDictionary, ignoreCase);
        } else if (left instanceof VimFuncref || right instanceof VimFuncref) {
            VimFuncref rightFuncref;
            VimFuncref leftFuncref = left instanceof VimFuncref ? (VimFuncref)left : null;
            VimFuncref vimFuncref = rightFuncref = right instanceof VimFuncref ? (VimFuncref)right : null;
            bl = leftFuncref != null && rightFuncref != null ? this.compare(leftFuncref, rightFuncref, ignoreCase) : false;
        } else if (left instanceof VimFloat || right instanceof VimFloat) {
            double leftFloat = this.coerceToVimFloatValue(left);
            double rightFloat = this.coerceToVimFloatValue(right);
            bl = this.compare(leftFloat, rightFloat);
        } else if (left instanceof VimString || right instanceof VimString) {
            bl = this.compare(left.toVimString().getValue(), right.toVimString().getValue(), ignoreCase);
        } else if (left instanceof VimInt || right instanceof VimInt) {
            bl = this.compare(left.toVimNumber().getValue(), right.toVimNumber().getValue());
        } else {
            throw ExExceptionsKt.exExceptionMessage("E474", new Object[0]);
        }
        return VimIntKt.asVimInt(bl);
    }

    protected double coerceToVimFloatValue(@NotNull VimDataType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value instanceof VimInt ? (double)((VimInt)value).getValue() : value.toVimFloat().getValue();
    }

    protected abstract boolean compare(double var1, double var3);

    protected abstract boolean compare(int var1, int var2);

    protected abstract boolean compare(@NotNull String var1, @NotNull String var2, boolean var3);

    protected boolean compare(@NotNull VimList left, @NotNull VimList right, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        throw ExExceptionsKt.exExceptionMessage("E692", new Object[0]);
    }

    protected boolean compare(@NotNull VimDictionary left, @NotNull VimDictionary right, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        throw ExExceptionsKt.exExceptionMessage("E736", new Object[0]);
    }

    protected boolean compare(@NotNull VimFuncref left, @NotNull VimFuncref right, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        throw ExExceptionsKt.exExceptionMessage("E694", new Object[0]);
    }
}

