/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions.handlers.cursorFunctions;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a.\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"currentCol", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "variableToPosition", "Lkotlin/Pair;", "variable", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "dollarForLine", "", "indexAsNumber", "list", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimList;", "index", "", "vim-engine"})
public final class ColLineFunctionHandlerKt {
    private static final VimInt currentCol(VimEditor editor) {
        BufferPosition logicalPosition = editor.currentCaret().getBufferPosition();
        int lineLength = EngineEditorHelperKt.lineLength(editor, logicalPosition.getLine());
        if (!((Collection)((Object)VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getVirtualedit())).isEmpty()) {
            ++lineLength;
        }
        return VimIntKt.asVimInt(RangesKt.coerceAtMost((int)(logicalPosition.getColumn() + 1), (int)lineLength));
    }

    @Nullable
    public static final Pair<VimInt, VimInt> variableToPosition(@NotNull VimEditor editor, @NotNull VimDataType variable, boolean dollarForLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (variable instanceof VimList) {
            if (((VimList)variable).getValues().size() < 2) {
                return null;
            }
            VimInt vimInt = ColLineFunctionHandlerKt.indexAsNumber((VimList)variable, 0);
            if (vimInt == null) {
                return null;
            }
            VimInt line = vimInt;
            if (line.compareTo(0) <= 0 || line.compareTo(editor.lineCount()) > 0) {
                return null;
            }
            VimInt vimInt2 = ColLineFunctionHandlerKt.indexAsNumber((VimList)variable, 1);
            if (vimInt2 == null) {
                return null;
            }
            VimInt column = vimInt2;
            int lineLength = EngineEditorHelperKt.lineLength(editor, line.getValue() - 1);
            if (Intrinsics.areEqual((Object)((VimList)variable).get(1).toVimString().getValue(), (Object)"$")) {
                column = VimIntKt.asVimInt(lineLength + 1);
            }
            if (column.getValue() == 0 || column.compareTo(lineLength + 1) > 0) {
                return null;
            }
            return TuplesKt.to((Object)line, (Object)column);
        }
        String name = variable.toVimString().getValue();
        if (((CharSequence)name).length() == 0) {
            return null;
        }
        if (name.charAt(0) == '.') {
            return TuplesKt.to((Object)VimIntKt.asVimInt(editor.currentCaret().getVimLine()), (Object)ColLineFunctionHandlerKt.currentCol(editor));
        }
        if (Intrinsics.areEqual((Object)name, (Object)"v")) {
            if (!EditorExtensionsKt.getInVisualMode(editor)) {
                return TuplesKt.to((Object)VimIntKt.asVimInt(editor.currentCaret().getVimLine()), (Object)ColLineFunctionHandlerKt.currentCol(editor));
            }
            int vimStart = editor.currentCaret().getVimSelectionStart();
            BufferPosition bufferPosition = editor.offsetToBufferPosition(vimStart);
            VimInt line = VimIntKt.asVimInt(bufferPosition.getLine() + 1);
            VimInt col = VimIntKt.asVimInt(bufferPosition.getColumn() + 1);
            return TuplesKt.to((Object)line, (Object)col);
        }
        if (name.length() >= 2 && name.charAt(0) == '\'') {
            Mark mark = VimInjectorKt.getInjector().getMarkService().getMark(editor.primaryCaret(), name.charAt(1));
            if (mark == null) {
                return null;
            }
            Mark mark2 = mark;
            VimInt markLogicalLine = VimIntKt.asVimInt(mark2.getLine() + 1);
            VimInt markLogicalCol = VimIntKt.asVimInt(mark2.getCol() + 1);
            return TuplesKt.to((Object)markLogicalLine, (Object)markLogicalCol);
        }
        if (name.length() >= 2 && name.charAt(0) == 'w' && name.charAt(1) == '0') {
            if (!dollarForLine) {
                return null;
            }
            int actualVisualTop = VimInjectorKt.getInjector().getEngineEditorHelper().getVisualLineAtTopOfScreen(editor);
            int actualLogicalTop = EngineEditorHelperKt.visualLineToBufferLine(editor, actualVisualTop);
            return TuplesKt.to((Object)VimIntKt.asVimInt(actualLogicalTop + 1), (Object)ColLineFunctionHandlerKt.currentCol(editor));
        }
        if (name.length() >= 2 && name.charAt(0) == 'w' && name.charAt(1) == '$') {
            if (!dollarForLine) {
                return null;
            }
            int actualVisualBottom = VimInjectorKt.getInjector().getEngineEditorHelper().getVisualLineAtBottomOfScreen(editor);
            int actualLogicalBottom = EngineEditorHelperKt.visualLineToBufferLine(editor, actualVisualBottom);
            return TuplesKt.to((Object)VimIntKt.asVimInt(actualLogicalBottom + 1), (Object)ColLineFunctionHandlerKt.currentCol(editor));
        }
        if (name.charAt(0) == '$') {
            Pair pair;
            if (dollarForLine) {
                pair = TuplesKt.to((Object)VimIntKt.asVimInt(editor.lineCount()), (Object)VimInt.Companion.getZERO());
            } else {
                int line = editor.currentCaret().getBufferPosition().getLine();
                int lineLength = EngineEditorHelperKt.lineLength(editor, line);
                pair = TuplesKt.to((Object)VimIntKt.asVimInt(line + 1), (Object)VimIntKt.asVimInt(lineLength));
            }
            return pair;
        }
        return null;
    }

    private static final VimInt indexAsNumber(VimList list, int index) {
        VimDataType vimDataType = (VimDataType)CollectionsKt.getOrNull(list.getValues(), (int)index);
        if (vimDataType == null) {
            return null;
        }
        VimDataType value = vimDataType;
        return value.toVimNumber();
    }
}

