/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions.handlers.listFunctions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/listFunctions/CountFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "<init>", "()V", "minimumNumberOfArguments", "", "getMinimumNumberOfArguments", "()Ljava/lang/Integer;", "maximumNumberOfArguments", "getMaximumNumberOfArguments", "doFunction", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "argumentValues", "", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCountFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/handlers/listFunctions/CountFunctionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1788#2,4:82\n1788#2,4:86\n*S KotlinDebug\n*F\n+ 1 CountFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/handlers/listFunctions/CountFunctionHandler\n*L\n73#1:82,4\n76#1:86,4\n*E\n"})
public final class CountFunctionHandler
extends FunctionHandler {
    private final int minimumNumberOfArguments;
    private final int maximumNumberOfArguments;

    public CountFunctionHandler() {
        this.minimumNumberOfArguments = 2;
        this.maximumNumberOfArguments = 4;
    }

    @Override
    @NotNull
    public Integer getMinimumNumberOfArguments() {
        return this.minimumNumberOfArguments;
    }

    @Override
    @NotNull
    public Integer getMaximumNumberOfArguments() {
        return this.maximumNumberOfArguments;
    }

    @Override
    @NotNull
    protected VimDataType doFunction(@NotNull List<? extends Expression> argumentValues, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        VimDataType vimDataType;
        Intrinsics.checkNotNullParameter(argumentValues, (String)"argumentValues");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType comp = argumentValues.get(0).evaluate(editor, context, vimContext);
        VimDataType expr = argumentValues.get(1).evaluate(editor, context, vimContext);
        Object object = (Expression)CollectionsKt.getOrNull(argumentValues, (int)2);
        boolean ic = !(object != null && (object = ((Expression)object).evaluate(editor, context, vimContext)) != null && (object = ((VimDataType)object).toVimNumber()) != null ? ((VimInt)object).getValue() == 0 : false);
        Object object2 = (Expression)CollectionsKt.getOrNull(argumentValues, (int)3);
        int start = object2 != null && (object2 = ((Expression)object2).evaluate(editor, context, vimContext)) != null && (object2 = ((VimDataType)object2).toVimNumber()) != null ? ((VimInt)object2).getValue() : 0;
        VimDataType vimDataType2 = comp;
        if (vimDataType2 instanceof VimString) {
            String text = ((VimString)comp).getValue();
            String pattern = expr.toVimString().getValue();
            if (((CharSequence)pattern).length() == 0) {
                return new VimInt(0);
            }
            int count = 0;
            int index = 0;
            while (index <= text.length() - pattern.length()) {
                String substring;
                boolean matches;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(index, index + pattern.length()), (String)"substring(...)");
                boolean bl = matches = ic ? StringsKt.equals((String)substring, (String)pattern, (boolean)true) : Intrinsics.areEqual((Object)substring, (Object)pattern);
                if (matches) {
                    ++count;
                    index += pattern.length();
                    continue;
                }
                ++index;
            }
            vimDataType = new VimInt(count);
        } else if (vimDataType2 instanceof VimList) {
            int n;
            List<VimDataType> items = start > 0 && start < ((VimList)comp).getValues().size() ? ((VimList)comp).getValues().subList(start, ((VimList)comp).getValues().size()) : ((VimList)comp).getValues();
            Iterable $this$count$iv = items;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    VimDataType item = (VimDataType)element$iv;
                    boolean bl = false;
                    if (!VimDataType.valueEquals$default(item, expr, ic, 0, 4, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            vimDataType = VimIntKt.asVimInt(n);
        } else if (vimDataType2 instanceof VimDictionary) {
            int n;
            Collection<VimDataType> collection = ((VimDictionary)comp).getDictionary().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$count$iv = collection;
            boolean $i$f$count = false;
            if (((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    VimDataType item = (VimDataType)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)item);
                    if (!VimDataType.valueEquals$default(item, expr, ic, 0, 4, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            vimDataType = VimIntKt.asVimInt(n);
        } else {
            vimDataType = VimInt.Companion.getZERO();
        }
        return vimDataType;
    }
}

