/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.services;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.Key;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimStorageServiceKt;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.vimscript.model.ExecutableContext;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFloat;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.VariableExpression;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import com.maddyhome.idea.vim.vimscript.model.variables.HighLightVariable;
import com.maddyhome.idea.vim.vimscript.model.variables.RegisterVariable;
import com.maddyhome.idea.vim.vimscript.services.VariableService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClassifiers;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J0\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J0\u0010%\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070'H\u0016J0\u0010(\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J*\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J(\u0010+\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u0006H\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0019H\u0014J\u001a\u0010/\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001a\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001a\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0019H\u0014J\u001a\u00102\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0019H\u0014J\u001a\u00103\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J*\u00104\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0014J\u0018\u00105\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0007H\u0016J \u00106\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0014J \u00107\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u00108\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u00109\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0014J \u0010:\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0014J \u0010;\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J0\u0010<\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0014J'\u0010=\u001a\u0002H>\"\b\b\u0000\u0010>*\u00020?2\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020BH\u0016\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020\"H\u0016J\u0012\u00104\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u0006H\u0016J\u0018\u0010<\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0018\u0010E\u001a\u00020\u00072\u0006\u0010)\u001a\u00020?2\u0006\u0010A\u001a\u00020BH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006F"}, d2={"Lcom/maddyhome/idea/vim/vimscript/services/VimVariableServiceBase;", "Lcom/maddyhome/idea/vim/vimscript/services/VariableService;", "<init>", "()V", "globalVariables", "", "", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "windowVariablesKey", "Lcom/maddyhome/idea/vim/api/Key;", "bufferVariablesKey", "tabVariablesKey", "vimVariables", "getVimVariables", "()Ljava/util/Map;", "setVimVariables", "(Ljava/util/Map;)V", "getWindowVariables", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getBufferVariables", "getTabVariables", "getDefaultVariableScope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "executable", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "isVariableLocked", "", "variable", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/VariableExpression;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "lockVariable", "", "depth", "", "unlockVariable", "getGlobalVariables", "", "storeVariable", "value", "getNullableVariableValue", "getNonNullVariableValue", "getGlobalVariableValue", "name", "getScriptVariable", "getWindowVariable", "getTabVariable", "getFunctionVariable", "getLocalVariable", "getBufferVariable", "getVimVariable", "storeGlobalVariable", "storeScriptVariable", "storeWindowVariable", "storeTabVariable", "storeFunctionVariable", "storeLocalVariable", "storeBufferVariable", "storeVimVariable", "convertToKotlinType", "T", "", "vimDataType", "type", "Lkotlin/reflect/KType;", "(Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;Lkotlin/reflect/KType;)Ljava/lang/Object;", "clear", "convertToVimDataType", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimVariableServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimVariableServiceBase.kt\ncom/maddyhome/idea/vim/vimscript/services/VimVariableServiceBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,450:1\n1#2:451\n1#2:462\n1#2:475\n1617#3,9:452\n1869#3:461\n1870#3:463\n1626#3:464\n1617#3,9:465\n1869#3:474\n1870#3:476\n1626#3:477\n*S KotlinDebug\n*F\n+ 1 VimVariableServiceBase.kt\ncom/maddyhome/idea/vim/vimscript/services/VimVariableServiceBase\n*L\n353#1:462\n420#1:475\n353#1:452,9\n353#1:461\n353#1:463\n353#1:464\n420#1:465,9\n420#1:474\n420#1:476\n420#1:477\n*E\n"})
public abstract class VimVariableServiceBase
implements VariableService {
    @NotNull
    private Map<String, VimDataType> globalVariables = new LinkedHashMap();
    @NotNull
    private final Key<Map<String, VimDataType>> windowVariablesKey = new Key("TabVariables");
    @NotNull
    private final Key<Map<String, VimDataType>> bufferVariablesKey = new Key("BufferVariables");
    @NotNull
    private final Key<Map<String, VimDataType>> tabVariablesKey = new Key("WindowVariables");
    @NotNull
    private Map<String, VimDataType> vimVariables = new LinkedHashMap();

    @NotNull
    protected final Map<String, VimDataType> getVimVariables() {
        return this.vimVariables;
    }

    protected final void setVimVariables(@NotNull Map<String, VimDataType> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.vimVariables = map;
    }

    private final Map<String, VimDataType> getWindowVariables(VimEditor editor) {
        return VimStorageServiceKt.getOrPutWindowData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.windowVariablesKey, VimVariableServiceBase::getWindowVariables$lambda$0);
    }

    private final Map<String, VimDataType> getBufferVariables(VimEditor editor) {
        return VimStorageServiceKt.getOrPutBufferData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.bufferVariablesKey, VimVariableServiceBase::getBufferVariables$lambda$0);
    }

    private final Map<String, VimDataType> getTabVariables(VimEditor editor) {
        return VimStorageServiceKt.getOrPutTabData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.tabVariablesKey, VimVariableServiceBase::getTabVariables$lambda$0);
    }

    @NotNull
    protected final Scope getDefaultVariableScope(@NotNull VimLContext executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        return switch (WhenMappings.$EnumSwitchMapping$0[executable.getExecutableContext(executable).ordinal()]) {
            case 1, 2 -> Scope.GLOBAL_VARIABLE;
            case 3 -> Scope.LOCAL_VARIABLE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean isVariableLocked(@NotNull VariableExpression variable, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        return vimDataType != null ? vimDataType.isLocked() : false;
    }

    @Override
    public void lockVariable(@NotNull VariableExpression variable, int depth, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        if (vimDataType == null) {
            return;
        }
        VimDataType value = vimDataType;
        value.setLockOwner(variable);
        value.lockVar(depth);
    }

    @Override
    public void unlockVariable(@NotNull VariableExpression variable, int depth, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        if (vimDataType == null) {
            return;
        }
        VimDataType value = vimDataType;
        value.unlockVar(depth);
    }

    @Override
    @NotNull
    public Map<String, VimDataType> getGlobalVariables() {
        return this.globalVariables;
    }

    @Override
    public void storeVariable(@NotNull VariableExpression variable, @NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Scope scope = variable.getScope();
        if (scope == null) {
            scope = this.getDefaultVariableScope(vimContext);
        }
        Scope scope2 = scope;
        String name = variable.getName().evaluate(editor, context, vimContext).getValue();
        switch (WhenMappings.$EnumSwitchMapping$1[scope2.ordinal()]) {
            case 1: {
                this.storeGlobalVariable(name, value);
                break;
            }
            case 2: {
                this.storeScriptVariable(name, value, vimContext);
                break;
            }
            case 3: {
                this.storeWindowVariable(name, value, editor);
                break;
            }
            case 4: {
                this.storeTabVariable(name, value, editor);
                break;
            }
            case 5: {
                this.storeFunctionVariable(name, value, vimContext);
                break;
            }
            case 6: {
                this.storeLocalVariable(name, value, vimContext);
                break;
            }
            case 7: {
                this.storeBufferVariable(name, value, editor);
                break;
            }
            case 8: {
                this.storeVimVariable(name, value, editor, context, vimContext);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    @Nullable
    public VimDataType getNullableVariableValue(@NotNull VariableExpression variable, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) throws ExException {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Scope scope = variable.getScope();
        if (scope == null) {
            scope = this.getDefaultVariableScope(vimContext);
        }
        Scope scope2 = scope;
        String name = variable.getName().evaluate(editor, context, vimContext).getValue();
        return switch (WhenMappings.$EnumSwitchMapping$1[scope2.ordinal()]) {
            case 1 -> this.getGlobalVariableValue(name);
            case 2 -> this.getScriptVariable(name, vimContext);
            case 3 -> this.getWindowVariable(name, editor);
            case 4 -> this.getTabVariable(name, editor);
            case 5 -> this.getFunctionVariable(name, vimContext);
            case 6 -> this.getLocalVariable(name, vimContext);
            case 7 -> this.getBufferVariable(name, editor);
            case 8 -> this.getVimVariable(name, editor, context, vimContext);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public VimDataType getNonNullVariableValue(@NotNull VariableExpression variable, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        if (vimDataType == null) {
            Object[] objectArray = new Object[]{(String)(variable.getScope() != null ? variable.getScope().getC() + ":" : "") + variable.getName().evaluate(editor, context, vimContext).getValue()};
            throw ExExceptionsKt.exExceptionMessage("E121", objectArray);
        }
        return vimDataType;
    }

    @Override
    @Nullable
    public VimDataType getGlobalVariableValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.globalVariables.get(name);
    }

    @Nullable
    protected VimDataType getScriptVariable(@NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Script script = vimContext.getScript();
        if (script == null) {
            Object[] objectArray = new Object[]{"s:" + name};
            throw ExExceptionsKt.exExceptionMessage("E121", objectArray);
        }
        Script script2 = script;
        return script2.getScriptVariables().get(name);
    }

    @Nullable
    protected VimDataType getWindowVariable(@NotNull String name, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getWindowVariables(editor).get(name);
    }

    @Nullable
    protected VimDataType getTabVariable(@NotNull String name, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getTabVariables(editor).get(name);
    }

    @Nullable
    protected VimDataType getFunctionVariable(@NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        List visibleVariables = new ArrayList();
        VimLContext node = vimContext;
        while (!node.isFirstParentContext()) {
            if (node instanceof FunctionDeclaration) {
                visibleVariables.add(((FunctionDeclaration)node).getFunctionVariables());
                if (!((FunctionDeclaration)node).getFlags().contains((Object)FunctionFlag.CLOSURE)) break;
            }
            node = node.getPreviousParentContext();
        }
        CollectionsKt.reverse((List)visibleVariables);
        Map functionVariablesMap = new LinkedHashMap();
        for (Map map : visibleVariables) {
            functionVariablesMap.putAll(map);
        }
        return (VimDataType)functionVariablesMap.get(name);
    }

    @Nullable
    protected VimDataType getLocalVariable(@NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        List visibleVariables = new ArrayList();
        VimLContext node = vimContext;
        while (!node.isFirstParentContext()) {
            if (node instanceof FunctionDeclaration) {
                visibleVariables.add(((FunctionDeclaration)node).getLocalVariables());
                if (!((FunctionDeclaration)node).getFlags().contains((Object)FunctionFlag.CLOSURE)) break;
            }
            node = node.getPreviousParentContext();
        }
        CollectionsKt.reverse((List)visibleVariables);
        Map localVariablesMap = new LinkedHashMap();
        for (Map map : visibleVariables) {
            localVariablesMap.putAll(map);
        }
        return (VimDataType)localVariablesMap.get(name);
    }

    @Nullable
    protected VimDataType getBufferVariable(@NotNull String name, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getBufferVariables(editor).get(name);
    }

    @Nullable
    protected VimDataType getVimVariable(@NotNull String name, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        return switch (name) {
            case "count" -> new VimInt(KeyHandler.Companion.getInstance().getKeyHandlerState().getCommandBuilder().calculateCount0Snapshot());
            case "count1" -> new VimInt(RangesKt.coerceAtLeast((int)KeyHandler.Companion.getInstance().getKeyHandlerState().getCommandBuilder().calculateCount0Snapshot(), (int)1));
            case "searchforward" -> new VimInt(VimInjectorKt.getInjector().getSearchGroup().getLastSearchDirection() == Direction.FORWARDS ? 1 : 0);
            case "hlsearch" -> new HighLightVariable().evaluate(name, editor, context, vimContext);
            case "register" -> new RegisterVariable().evaluate(name, editor, context, vimContext);
            default -> throw new ExException("The 'v:" + name + "' variable is not implemented yet");
        };
    }

    @Override
    public void storeGlobalVariable(@NotNull String name, @NotNull VimDataType value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.globalVariables.put(name, value);
    }

    protected void storeScriptVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Script script = vimContext.getScript();
        if (script == null) {
            Object[] objectArray = new Object[]{"s:" + name};
            throw ExExceptionsKt.exExceptionMessage("E461", objectArray);
        }
        Script script2 = script;
        script2.getScriptVariables().put(name, value);
    }

    protected void storeWindowVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getWindowVariables(editor).put(name, value);
    }

    protected void storeTabVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getTabVariables(editor).put(name, value);
    }

    protected void storeFunctionVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimLContext node = vimContext;
        while (!node.isFirstParentContext() && !(node instanceof FunctionDeclaration)) {
            node = node.getPreviousParentContext();
        }
        if (!(node instanceof FunctionDeclaration)) {
            Object[] objectArray = new Object[]{"a:" + name};
            throw ExExceptionsKt.exExceptionMessage("E461", objectArray);
        }
        ((FunctionDeclaration)node).getFunctionVariables().put(name, value);
    }

    protected void storeLocalVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimLContext node = vimContext;
        while (!node.isFirstParentContext() && !(node instanceof FunctionDeclaration)) {
            node = node.getPreviousParentContext();
        }
        if (!(node instanceof FunctionDeclaration)) {
            Object[] objectArray = new Object[]{"l:" + name};
            throw ExExceptionsKt.exExceptionMessage("E461", objectArray);
        }
        ((FunctionDeclaration)node).getLocalVariables().put(name, value);
    }

    protected void storeBufferVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getBufferVariables(editor).put(name, value);
    }

    protected void storeVimVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        throw new ExException("The 'v' scope is not implemented yet :(");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public <T> T convertToKotlinType(@NotNull VimDataType vimDataType, @NotNull KType type) {
        Object object;
        KClass clazz;
        Intrinsics.checkNotNullParameter((Object)vimDataType, (String)"vimDataType");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        KClass kClass = clazz = (KClass)kClassifier;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            int n;
            if (vimDataType instanceof VimInt) {
                n = ((VimInt)vimDataType).getValue();
            } else {
                if (!(vimDataType instanceof VimString) || StringsKt.toIntOrNull((String)((VimString)vimDataType).getValue()) == null) throw new IllegalArgumentException("Expected Int, but got " + Reflection.getOrCreateKotlinClass(vimDataType.getClass()).getSimpleName());
                n = Integer.parseInt(((VimString)vimDataType).getValue());
            }
            object = n;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            if (!(vimDataType instanceof VimString)) throw new IllegalArgumentException("Expected String, but got " + Reflection.getOrCreateKotlinClass(vimDataType.getClass()).getSimpleName());
            object = ((VimString)vimDataType).getValue();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            if (!(vimDataType instanceof VimFloat)) {
                throw new IllegalArgumentException("Expected Double, but got " + Reflection.getOrCreateKotlinClass(vimDataType.getClass()).getSimpleName());
            }
            object = ((VimFloat)vimDataType).getValue();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            if (!(vimDataType instanceof VimFloat)) {
                throw new IllegalArgumentException("Expected Float, but got " + Reflection.getOrCreateKotlinClass(vimDataType.getClass()).getSimpleName());
            }
            object = Float.valueOf((float)((VimFloat)vimDataType).getValue());
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(List.class))) {
            KType kType;
            List list;
            block21: {
                if (!(vimDataType instanceof VimList)) throw new IllegalArgumentException("Expected List, but got " + Reflection.getOrCreateKotlinClass(vimDataType.getClass()).getSimpleName());
                list = new ArrayList();
                values = ((VimList)vimDataType).getValues();
                for (KTypeProjection it : (Iterable)type.getArguments()) {
                    boolean bl = false;
                    kType = it.getType();
                    if (kType == null) {
                        continue;
                    }
                    break block21;
                }
                kType = null;
            }
            if (kType == null) {
                throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
            }
            KType listArgumentType = kType;
            var9_14 = values.iterator();
            while (var9_14.hasNext()) {
                Object e = var9_14.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                VimDataType value = (VimDataType)e;
                list.add(this.convertToKotlinType(value, listArgumentType));
            }
            object = CollectionsKt.toList((Iterable)list);
        } else {
            void $this$mapNotNullTo$iv$iv;
            if (!Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Map.class))) throw new IllegalArgumentException("Unsupported type: " + clazz.getSimpleName());
            if (!(vimDataType instanceof VimDictionary)) throw new IllegalArgumentException("Expected Map, but got " + Reflection.getOrCreateKotlinClass(vimDataType.getClass()).getSimpleName());
            Iterable $this$mapNotNull$iv = type.getArguments();
            boolean $i$f$mapNotNull = false;
            var9_14 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KTypeProjection it = (KTypeProjection)element$iv$iv;
                boolean bl2 = false;
                if (it.getType() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List mapArgumentTypes = (List)destination$iv$iv;
            values = ((VimDictionary)vimDataType).getDictionary();
            KType keyArgumentType = (KType)mapArgumentTypes.get(0);
            if (!Intrinsics.areEqual((Object)keyArgumentType, (Object)KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(String.class)), null, (boolean)false, null, (int)7, null))) {
                throw new IllegalArgumentException("Expected Map with String as key, but got " + Reflection.getOrCreateKotlinClass(vimDataType.getClass()).getSimpleName());
            }
            KType valueArgumentType = (KType)mapArgumentTypes.get(1);
            Map map = new LinkedHashMap();
            for (Map.Entry entry : ((Map)values).entrySet()) {
                VimString key = (VimString)entry.getKey();
                VimDataType value = (VimDataType)entry.getValue();
                String keyValue = (String)this.convertToKotlinType(key, keyArgumentType);
                T valueValue = this.convertToKotlinType(value, valueArgumentType);
                map.put(keyValue, valueValue);
            }
            object = MapsKt.toMap((Map)map);
        }
        Integer n = object;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type T of com.maddyhome.idea.vim.vimscript.services.VimVariableServiceBase.convertToKotlinType");
        return (T)n;
    }

    @Override
    public void clear() {
        this.globalVariables.clear();
    }

    @Override
    @Nullable
    public VimDataType getVimVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.vimVariables.get(name);
    }

    @Override
    public void storeVimVariable(@NotNull String name, @NotNull VimDataType value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.vimVariables.put(name, value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VimDataType convertToVimDataType(@NotNull Object value, @NotNull KType type) {
        VimDataType vimDataType;
        KClass clazz;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        KClass kClass = clazz = (KClass)kClassifier;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            vimDataType = new VimInt((Integer)value);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            vimDataType = new VimString((String)value);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            vimDataType = (Boolean)value != false ? VimInt.Companion.getONE() : VimInt.Companion.getZERO();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            vimDataType = new VimFloat((Double)value);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            vimDataType = new VimFloat(((Float)value).floatValue());
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(List.class))) {
            KType kType;
            List list;
            block24: {
                list = (List)value;
                for (KTypeProjection it : (Iterable)type.getArguments()) {
                    boolean bl = false;
                    kType = it.getType();
                    if (kType == null) {
                        continue;
                    }
                    break block24;
                }
                kType = null;
            }
            if (kType == null) {
                throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
            }
            KType listArgumentType = kType;
            List vimValues = new ArrayList();
            for (Object item : list) {
                if (item != null) {
                    vimValues.add(this.convertToVimDataType(item, listArgumentType));
                    continue;
                }
                throw new IllegalArgumentException("List cannot contain null values");
            }
            vimDataType = new VimList(vimValues);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Map.class))) {
            void $this$mapNotNullTo$iv$iv;
            Map map = (Map)value;
            Iterable $this$mapNotNull$iv = type.getArguments();
            boolean $i$f$mapNotNull = false;
            Iterable item = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KTypeProjection it = (KTypeProjection)element$iv$iv;
                boolean bl2 = false;
                if (it.getType() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List mapArgumentTypes = (List)destination$iv$iv;
            KType keyArgumentType = (KType)mapArgumentTypes.get(0);
            if (!Intrinsics.areEqual((Object)keyArgumentType, (Object)KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(String.class)), null, (boolean)false, null, (int)7, null))) {
                throw new IllegalArgumentException("Map must have String keys for conversion to VimDictionary");
            }
            KType valueArgumentType = (KType)mapArgumentTypes.get(1);
            LinkedHashMap<VimString, VimDataType> dictionary = new LinkedHashMap<VimString, VimDataType>();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object mapValue = entry.getValue();
                if (key != null && mapValue != null) {
                    VimString vimKey = new VimString((String)key);
                    VimDataType vimValue = this.convertToVimDataType(mapValue, valueArgumentType);
                    ((Map)dictionary).put(vimKey, vimValue);
                    continue;
                }
                throw new IllegalArgumentException("Map cannot contain null keys or values");
            }
            vimDataType = new VimDictionary(dictionary);
        } else {
            vimDataType = value instanceof VimDataType ? (VimDataType)value : null;
            if (vimDataType == null) {
                throw new IllegalArgumentException("Unsupported type: " + clazz.getSimpleName());
            }
        }
        return vimDataType;
    }

    private static final Map getWindowVariables$lambda$0() {
        return new LinkedHashMap();
    }

    private static final Map getBufferVariables$lambda$0() {
        return new LinkedHashMap();
    }

    private static final Map getTabVariables$lambda$0() {
        return new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExecutableContext.values().length];
            try {
                nArray[ExecutableContext.SCRIPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutableContext.COMMAND_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutableContext.FUNCTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Scope.values().length];
            try {
                nArray[Scope.GLOBAL_VARIABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.SCRIPT_VARIABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.WINDOW_VARIABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.TABPAGE_VARIABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.FUNCTION_VARIABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.LOCAL_VARIABLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.BUFFER_VARIABLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.VIM_VARIABLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

