/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.change;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.action.change.OperatorActionKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.ArgumentCapturerKt;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.handler.VimActionHandler;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/action/change/OperatorAction;", "Lcom/maddyhome/idea/vim/handler/VimActionHandler$SingleExecution;", "<init>", "()V", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "argumentType", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "getArgumentType", "()Lcom/maddyhome/idea/vim/command/Argument$Type;", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "getMotionRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "argument", "Lcom/maddyhome/idea/vim/command/Argument$Motion;", "IdeaVIM"})
public final class OperatorAction
extends VimActionHandler.SingleExecution {
    @NotNull
    private final Command.Type type = Command.Type.OTHER_SELF_SYNCHRONIZED;
    @NotNull
    private final Argument.Type argumentType = Argument.Type.MOTION;

    @NotNull
    public Command.Type getType() {
        return this.type;
    }

    @NotNull
    public Argument.Type getArgumentType() {
        return this.argumentType;
    }

    public boolean execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        TextRange range;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Argument argument = cmd.getArgument();
        Argument.Motion motion = argument instanceof Argument.Motion ? (Argument.Motion)argument : null;
        if (motion == null) {
            return false;
        }
        Argument.Motion argument2 = motion;
        if (!EngineHelperKt.getInRepeatMode((VimEditor)editor)) {
            ArgumentCapturerKt.setArgumentCaptured((Argument)((Argument)argument2));
        }
        if ((range = this.getMotionRange(editor, context, argument2, operatorArguments)) != null) {
            return OperatorActionKt.access$doOperatorAction(editor, context, range, argument2.getMotionType());
        }
        return false;
    }

    private final TextRange getMotionRange(VimEditor editor, ExecutionContext context, Argument.Motion argument, OperatorArguments operatorArguments) {
        TextRange textRange;
        TextRange textRange2;
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        Caret caret = ijEditor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        TextRange textRange3 = MotionGroup.Companion.getMotionRange2(ijEditor, caret, IjEditorExecutionContextKt.getIj(context), (Argument)argument, operatorArguments);
        if (textRange3 != null && (textRange2 = textRange3.normalize()) != null) {
            TextRange it = textRange2;
            boolean bl = false;
            textRange = argument.getMotionType() == SelectionType.LINE_WISE && (long)it.getEndOffset() < editor.fileSize() ? new TextRange(it.getStartOffset(), it.getEndOffset() + 1) : it;
        } else {
            textRange = null;
        }
        return textRange;
    }
}

