/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.argtextobj;

import com.intellij.openapi.editor.Document;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.command.TextObjectVisualType;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import com.maddyhome.idea.vim.helper.InlayHelperKt;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.listener.SelectionVimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerSuppressor;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VimArgTextObjExtension
implements VimExtension {
    private static final BracketPairs DEFAULT_BRACKET_PAIRS = new BracketPairs("(", ")");

    @Override
    @NotNull
    public String getName() {
        return "argtextobj";
    }

    @Override
    public void init() {
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)MappingMode.XO, (List<? extends KeyStroke>)VimInjectorKt.getInjector().getParser().parseKeys("<Plug>InnerArgument"), this.getOwner(), new ArgumentHandler(true), false);
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)MappingMode.XO, (List<? extends KeyStroke>)VimInjectorKt.getInjector().getParser().parseKeys("<Plug>OuterArgument"), this.getOwner(), new ArgumentHandler(false), false);
        VimExtensionFacade.putKeyMappingIfMissing(MappingMode.XO, VimInjectorKt.getInjector().getParser().parseKeys("ia"), this.getOwner(), VimInjectorKt.getInjector().getParser().parseKeys("<Plug>InnerArgument"), true);
        VimExtensionFacade.putKeyMappingIfMissing(MappingMode.XO, VimInjectorKt.getInjector().getParser().parseKeys("aa"), this.getOwner(), VimInjectorKt.getInjector().getParser().parseKeys("<Plug>OuterArgument"), true);
    }

    @Nullable
    private static String bracketPairsVariable() {
        VimDataType value = VimPlugin.getVariableService().getGlobalVariableValue("argtextobj_pairs");
        if (value instanceof VimString) {
            VimString vimValue = (VimString)value;
            return vimValue.getValue();
        }
        return null;
    }

    static class ArgumentHandler
    implements ExtensionHandler {
        final boolean isInner;

        ArgumentHandler(boolean isInner) {
            this.isInner = isInner;
        }

        public boolean isRepeatable() {
            return false;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            if (editor == null) {
                ArgumentHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ArgumentHandler.$$$reportNull$$$0(1);
            }
            if (operatorArguments == null) {
                ArgumentHandler.$$$reportNull$$$0(2);
            }
            @NotNull KeyHandlerState keyHandlerState = KeyHandler.getInstance().getKeyHandlerState();
            ArgumentTextObjectHandler textObjectHandler = new ArgumentTextObjectHandler(this.isInner);
            if (!(editor.getMode() instanceof Mode.OP_PENDING)) {
                int count0 = operatorArguments.getCount0();
                editor.nativeCarets().forEach(caret -> {
                    TextRange range = textObjectHandler.getRange(editor, (ImmutableVimCaret)caret, context, Math.max(1, count0), count0);
                    if (range != null) {
                        try (VimListenerSuppressor.Locked ignored = SelectionVimListenerSuppressor.INSTANCE.lock();){
                            if (editor.getMode() instanceof Mode.VISUAL) {
                                EngineVisualGroupKt.vimSetSelection((VimCaret)caret, (int)range.getStartOffset(), (int)(range.getEndOffset() - 1), (boolean)true);
                            } else {
                                InlayHelperKt.moveToInlayAwareOffset(((IjVimCaret)((Object)caret)).getCaret(), range.getStartOffset());
                            }
                        }
                    }
                });
            } else {
                keyHandlerState.getCommandBuilder().addAction((EditorActionHandlerBase)textObjectHandler);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operatorArguments";
                    break;
                }
            }
            objectArray[1] = "com/maddyhome/idea/vim/extension/argtextobj/VimArgTextObjExtension$ArgumentHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class ArgumentTextObjectHandler
        extends TextObjectActionHandler {
            private final boolean isInner;

            ArgumentTextObjectHandler(boolean isInner) {
                this.isInner = isInner;
            }

            @Nullable
            public TextRange getRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, int count, int rawCount) {
                if (editor == null) {
                    ArgumentTextObjectHandler.$$$reportNull$$$0(0);
                }
                if (caret == null) {
                    ArgumentTextObjectHandler.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    ArgumentTextObjectHandler.$$$reportNull$$$0(2);
                }
                BracketPairs bracketPairs = DEFAULT_BRACKET_PAIRS;
                String bracketPairsVar = VimArgTextObjExtension.bracketPairsVariable();
                if (bracketPairsVar != null) {
                    try {
                        bracketPairs = BracketPairs.fromBracketPairList(bracketPairsVar);
                    }
                    catch (BracketPairs.ParseException parseException) {
                        String message = MessageHelper.message("argtextobj.error.invalid.value.of.g.argtextobj.pairs.0", parseException.getMessage());
                        VimPlugin.showMessage(message);
                        VimPlugin.indicateError();
                        return null;
                    }
                }
                ArgBoundsFinder finder = new ArgBoundsFinder(((IjVimEditor)editor).getEditor().getDocument(), bracketPairs);
                int pos = ((IjVimCaret)caret).getCaret().getOffset();
                for (int i = 0; i < count; ++i) {
                    if (!finder.findBoundsAt(pos)) {
                        VimPlugin.showMessage(finder.errorMessage());
                        VimPlugin.indicateError();
                        return null;
                    }
                    if (i + 1 < count) {
                        finder.extendTillNext();
                    }
                    pos = finder.getRightBound();
                }
                if (this.isInner) {
                    finder.adjustForInner();
                } else {
                    finder.adjustForOuter();
                }
                return new TextRange(finder.getLeftBound(), finder.getRightBound());
            }

            @NotNull
            public TextObjectVisualType getVisualType() {
                TextObjectVisualType textObjectVisualType = TextObjectVisualType.CHARACTER_WISE;
                if (textObjectVisualType == null) {
                    ArgumentTextObjectHandler.$$$reportNull$$$0(3);
                }
                return textObjectVisualType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caret";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/maddyhome/idea/vim/extension/argtextobj/VimArgTextObjExtension$ArgumentHandler$ArgumentTextObjectHandler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/maddyhome/idea/vim/extension/argtextobj/VimArgTextObjExtension$ArgumentHandler$ArgumentTextObjectHandler";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisualType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRange";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class BracketPairs {
        @NotNull
        private final String openBrackets;
        @NotNull
        private final String closeBrackets;

        @NotNull
        static BracketPairs fromBracketPairList(@NotNull String bracketPairs) throws ParseException {
            if (bracketPairs == null) {
                BracketPairs.$$$reportNull$$$0(0);
            }
            StringBuilder openBrackets = new StringBuilder();
            StringBuilder closeBrackets = new StringBuilder();
            ParseState state = ParseState.OPEN;
            block6: for (char ch : bracketPairs.toCharArray()) {
                switch (state.ordinal()) {
                    case 0: {
                        openBrackets.append(ch);
                        state = ParseState.COLON;
                        continue block6;
                    }
                    case 1: {
                        if (ch == ':') {
                            state = ParseState.CLOSE;
                            continue block6;
                        }
                        throw new ParseException("expecting ':', but got '" + ch + "' instead");
                    }
                    case 2: {
                        char lastOpenBracket = openBrackets.charAt(openBrackets.length() - 1);
                        if (lastOpenBracket == ch) {
                            throw new ParseException("open and close brackets must be different");
                        }
                        closeBrackets.append(ch);
                        state = ParseState.COMMA;
                        continue block6;
                    }
                    case 3: {
                        if (ch == ',') {
                            state = ParseState.OPEN;
                            continue block6;
                        }
                        throw new ParseException("expecting ',', but got '" + ch + "' instead");
                    }
                }
            }
            if (state != ParseState.COMMA) {
                throw new ParseException("list of pairs is incomplete");
            }
            return new BracketPairs(openBrackets.toString(), closeBrackets.toString());
        }

        BracketPairs(@NotNull String openBrackets, @NotNull String closeBrackets) {
            if (openBrackets == null) {
                BracketPairs.$$$reportNull$$$0(1);
            }
            if (closeBrackets == null) {
                BracketPairs.$$$reportNull$$$0(2);
            }
            assert (openBrackets.length() == closeBrackets.length());
            this.openBrackets = openBrackets;
            this.closeBrackets = closeBrackets;
        }

        int getBracketPrio(char ch) {
            return Math.max(this.openBrackets.indexOf(ch), this.closeBrackets.indexOf(ch));
        }

        char matchingBracket(char ch) {
            int idx = this.closeBrackets.indexOf(ch);
            if (idx != -1) {
                return this.openBrackets.charAt(idx);
            }
            assert (this.isOpenBracket(ch));
            idx = this.openBrackets.indexOf(ch);
            return this.closeBrackets.charAt(idx);
        }

        boolean isCloseBracket(int ch) {
            return this.closeBrackets.indexOf(ch) != -1;
        }

        boolean isOpenBracket(int ch) {
            return this.openBrackets.indexOf(ch) != -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bracketPairs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "openBrackets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeBrackets";
                    break;
                }
            }
            objectArray2[1] = "com/maddyhome/idea/vim/extension/argtextobj/VimArgTextObjExtension$BracketPairs";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromBracketPairList";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum ParseState {
            OPEN,
            COLON,
            CLOSE,
            COMMA;

        }

        static class ParseException
        extends Exception {
            public ParseException(@NotNull String message) {
                if (message == null) {
                    ParseException.$$$reportNull$$$0(0);
                }
                super(message);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/maddyhome/idea/vim/extension/argtextobj/VimArgTextObjExtension$BracketPairs$ParseException", "<init>"));
            }
        }
    }

    private static class ArgBoundsFinder {
        @NotNull
        private final CharSequence text;
        @NotNull
        private final Document document;
        @NotNull
        private final BracketPairs brackets;
        private int leftBound;
        private int rightBound;
        private int leftBracket;
        private int rightBracket;
        @Nls
        private String error;
        private static final String QUOTES = "\"'";
        private static final int MAX_SEARCH_LINES = 10;
        private static final int MAX_SEARCH_OFFSET = 800;

        ArgBoundsFinder(@NotNull Document document, @NotNull BracketPairs bracketPairs) {
            if (document == null) {
                ArgBoundsFinder.$$$reportNull$$$0(0);
            }
            if (bracketPairs == null) {
                ArgBoundsFinder.$$$reportNull$$$0(1);
            }
            this.leftBound = Integer.MAX_VALUE;
            this.rightBound = Integer.MIN_VALUE;
            this.error = null;
            this.text = document.getImmutableCharSequence();
            this.document = document;
            this.brackets = bracketPairs;
        }

        boolean findBoundsAt(int position) throws IllegalStateException {
            boolean nonEmptyArg;
            boolean bothBrackets;
            if (this.text.isEmpty()) {
                this.error = "empty document";
                return false;
            }
            this.leftBound = Math.min(position, this.leftBound);
            this.rightBound = Math.max(position, this.rightBound);
            this.getOutOfQuotedText();
            if (this.rightBound == this.leftBound) {
                if (this.brackets.isCloseBracket(this.getCharAt(this.rightBound))) {
                    --this.leftBound;
                } else {
                    ++this.rightBound;
                }
            }
            int nextLeft = this.leftBound;
            int nextRight = this.rightBound;
            int leftLimit = this.leftLimit(position);
            int rightLimit = this.rightLimit(position);
            do {
                this.leftBracket = nextLeft;
                this.rightBracket = nextRight;
                if (!this.findOuterBrackets(leftLimit, rightLimit)) {
                    this.error = "not inside argument list";
                    return false;
                }
                this.leftBound = nextLeft;
                this.findLeftBound();
                nextLeft = this.leftBound - 1;
                this.rightBound = nextRight;
                this.findRightBound();
                nextRight = this.rightBound + 1;
                if (nextLeft < leftLimit || nextRight > rightLimit) {
                    this.error = "not an argument";
                    return false;
                }
                bothBrackets = this.getCharAt(this.leftBound) != ',' && this.getCharAt(this.rightBound) != ',';
                boolean bl = nonEmptyArg = this.rightBound - this.leftBound > 1;
            } while ((!bothBrackets || !nonEmptyArg || !this.isIdentPreceding()) && this.leftBound > leftLimit && this.rightBound < rightLimit && bothBrackets);
            return true;
        }

        void adjustForInner() {
            ++this.leftBound;
            while (this.leftBound < this.rightBound && Character.isWhitespace(this.getCharAt(this.leftBound))) {
                ++this.leftBound;
            }
        }

        void adjustForOuter() {
            if (this.getCharAt(this.leftBound) != ',') {
                ++this.leftBound;
                this.extendTillNext();
            }
        }

        void extendTillNext() {
            if (this.rightBound + 1 < this.rightBracket && this.getCharAt(this.rightBound) == ',') {
                ++this.rightBound;
                while (this.rightBound + 1 < this.rightBracket && Character.isWhitespace(this.getCharAt(this.rightBound))) {
                    ++this.rightBound;
                }
            }
        }

        int getLeftBound() {
            return this.leftBound;
        }

        int getRightBound() {
            return this.rightBound;
        }

        private boolean isIdentPreceding() {
            int i;
            int idEnd = i = this.leftBound - 1;
            while (i >= 0 && Character.isJavaIdentifierPart(this.getCharAt(i))) {
                --i;
            }
            return idEnd - i > 0 && Character.isJavaIdentifierStart(this.getCharAt(i + 1));
        }

        private void getOutOfQuotedText() {
            int lineNo = this.document.getLineNumber(this.leftBound);
            int lineStartOffset = this.document.getLineStartOffset(lineNo);
            int lineEndOffset = this.document.getLineEndOffset(lineNo);
            for (int i = lineStartOffset; i <= this.leftBound; ++i) {
                if (!this.isQuote(i)) continue;
                int endOfQuotedText = this.skipQuotedTextForward(i, lineEndOffset);
                if (endOfQuotedText >= this.leftBound) {
                    this.leftBound = i - 1;
                    this.rightBound = endOfQuotedText + 1;
                    break;
                }
                i = endOfQuotedText;
            }
        }

        private void findRightBound() {
            char ch;
            while (this.rightBound < this.rightBracket && (ch = this.getCharAt(this.rightBound)) != ',') {
                if (this.brackets.isOpenBracket(ch)) {
                    this.rightBound = this.skipSexp(this.rightBound, this.rightBracket, SexpDirection.forward(this.brackets));
                    continue;
                }
                if (ArgBoundsFinder.isQuoteChar(ch)) {
                    this.rightBound = this.skipQuotedTextForward(this.rightBound, this.rightBracket);
                }
                ++this.rightBound;
            }
        }

        private void findLeftBound() {
            char ch;
            while (this.leftBound > this.leftBracket && (ch = this.getCharAt(this.leftBound)) != ',') {
                if (this.brackets.isCloseBracket(ch)) {
                    this.leftBound = this.skipSexp(this.leftBound, this.leftBracket, SexpDirection.backward(this.brackets));
                    continue;
                }
                if (ArgBoundsFinder.isQuoteChar(ch)) {
                    this.leftBound = this.skipQuotedTextBackward(this.leftBound, this.leftBracket);
                }
                --this.leftBound;
            }
        }

        private boolean isQuote(int i) {
            return QUOTES.indexOf(this.getCharAt(i)) != -1;
        }

        private static boolean isQuoteChar(int ch) {
            return QUOTES.indexOf(ch) != -1;
        }

        private char getCharAt(int logicalOffset) {
            assert (logicalOffset < this.text.length());
            return this.text.charAt(logicalOffset);
        }

        private int skipQuotedTextForward(int start2, int end) {
            char ch;
            int i;
            assert (start2 < end);
            char quoteChar = this.getCharAt(start2);
            boolean backSlash = false;
            for (i = start2 + 1; i <= end && ((ch = this.getCharAt(i)) != quoteChar || backSlash); ++i) {
                backSlash = ch == '\\' && !backSlash;
            }
            return i;
        }

        private int skipQuotedTextBackward(int start2, int end) {
            int i;
            assert (start2 > end);
            char quoteChar = this.getCharAt(start2);
            for (i = start2 - 1; i > end; --i) {
                char ch = this.getCharAt(i);
                char prevChar = this.getCharAt(i - 1);
                if (ch == quoteChar && prevChar != '\\') break;
            }
            return i;
        }

        private int leftLimit(int pos) {
            int offsetLimit = Math.max(pos - 800, 0);
            int lineNo = this.document.getLineNumber(pos);
            int lineOffsetLimit = this.document.getLineStartOffset(Math.max(0, lineNo - 10));
            return Math.max(offsetLimit, lineOffsetLimit);
        }

        private int rightLimit(int pos) {
            int offsetLimit = Math.min(pos + 800, this.text.length());
            int lineNo = this.document.getLineNumber(pos);
            int lineOffsetLimit = this.document.getLineEndOffset(Math.min(this.document.getLineCount() - 1, lineNo + 10));
            return Math.min(offsetLimit, lineOffsetLimit);
        }

        String errorMessage() {
            return this.error;
        }

        private int skipSexp(int start2, int end, SexpDirection dir) {
            char lastChar = this.getCharAt(start2);
            assert (dir.isOpenBracket(lastChar));
            ArrayDeque<Character> bracketStack = new ArrayDeque<Character>();
            bracketStack.push(Character.valueOf(lastChar));
            int i = start2 + dir.delta();
            while (!bracketStack.isEmpty() && i != end) {
                char ch = this.getCharAt(i);
                if (dir.isOpenBracket(ch)) {
                    bracketStack.push(Character.valueOf(ch));
                } else if (dir.isCloseBracket(ch)) {
                    if (((Character)bracketStack.getLast()).charValue() == this.brackets.matchingBracket(ch)) {
                        bracketStack.pop();
                    } else if (this.brackets.getBracketPrio(ch) < this.brackets.getBracketPrio(((Character)bracketStack.getLast()).charValue())) {
                        bracketStack.pop();
                        continue;
                    }
                } else if (ArgBoundsFinder.isQuoteChar(ch)) {
                    i = dir.skipQuotedText(i, end, this);
                }
                i += dir.delta();
            }
            if (bracketStack.isEmpty()) {
                return i;
            }
            return start2 + dir.delta();
        }

        boolean findOuterBrackets(int start2, int end) {
            boolean hasNewBracket;
            boolean bl = hasNewBracket = this.findPrevOpenBracket(start2) && this.findNextCloseBracket(end);
            while (hasNewBracket) {
                int rightPrio;
                int leftPrio = this.brackets.getBracketPrio(this.getCharAt(this.leftBracket));
                if (leftPrio == (rightPrio = this.brackets.getBracketPrio(this.getCharAt(this.rightBracket)))) {
                    return true;
                }
                if (leftPrio < rightPrio) {
                    if (this.rightBracket + 1 < end) {
                        ++this.rightBracket;
                        hasNewBracket = this.findNextCloseBracket(end);
                        continue;
                    }
                    hasNewBracket = false;
                    continue;
                }
                if (this.leftBracket > 1) {
                    --this.leftBracket;
                    hasNewBracket = this.findPrevOpenBracket(start2);
                    continue;
                }
                hasNewBracket = false;
            }
            return false;
        }

        private boolean findPrevOpenBracket(int start2) {
            char ch;
            while (!this.brackets.isOpenBracket(ch = this.getCharAt(this.leftBracket))) {
                if (this.brackets.isCloseBracket(ch)) {
                    this.leftBracket = this.skipSexp(this.leftBracket, start2, SexpDirection.backward(this.brackets));
                    continue;
                }
                if (ArgBoundsFinder.isQuoteChar(ch)) {
                    this.leftBracket = this.skipQuotedTextBackward(this.leftBracket, start2);
                } else if (this.leftBracket == start2) {
                    return false;
                }
                --this.leftBracket;
            }
            return true;
        }

        private boolean findNextCloseBracket(int end) {
            char ch;
            while (!this.brackets.isCloseBracket(ch = this.getCharAt(this.rightBracket))) {
                if (this.brackets.isOpenBracket(ch)) {
                    this.rightBracket = this.skipSexp(this.rightBracket, end, SexpDirection.forward(this.brackets));
                } else {
                    if (ArgBoundsFinder.isQuoteChar(ch)) {
                        this.rightBracket = this.skipQuotedTextForward(this.rightBracket, end);
                    }
                    ++this.rightBracket;
                }
                if (this.rightBracket < end) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bracketPairs";
                    break;
                }
            }
            objectArray[1] = "com/maddyhome/idea/vim/extension/argtextobj/VimArgTextObjExtension$ArgBoundsFinder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static abstract class SexpDirection {
            SexpDirection() {
            }

            abstract int delta();

            abstract boolean isOpenBracket(char var1);

            abstract boolean isCloseBracket(char var1);

            abstract int skipQuotedText(int var1, int var2, ArgBoundsFinder var3);

            static SexpDirection forward(final BracketPairs brackets) {
                return new SexpDirection(){

                    @Override
                    int delta() {
                        return 1;
                    }

                    @Override
                    boolean isOpenBracket(char ch) {
                        return brackets.isOpenBracket(ch);
                    }

                    @Override
                    boolean isCloseBracket(char ch) {
                        return brackets.isCloseBracket(ch);
                    }

                    @Override
                    int skipQuotedText(int pos, int end, ArgBoundsFinder self) {
                        return self.skipQuotedTextForward(pos, end);
                    }
                };
            }

            static SexpDirection backward(final BracketPairs brackets) {
                return new SexpDirection(){

                    @Override
                    int delta() {
                        return -1;
                    }

                    @Override
                    boolean isOpenBracket(char ch) {
                        return brackets.isCloseBracket(ch);
                    }

                    @Override
                    boolean isCloseBracket(char ch) {
                        return brackets.isOpenBracket(ch);
                    }

                    @Override
                    int skipQuotedText(int pos, int end, ArgBoundsFinder self) {
                        return self.skipQuotedTextBackward(pos, end);
                    }
                };
            }
        }
    }
}

