/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.hints;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001e\u001a\u00020 J\u0006\u0010%\u001a\u00020 J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J1\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010+\u001a\u00020 2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\tH\u00d6\u0001J\t\u0010.\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR&\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 0\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lcom/maddyhome/idea/vim/extension/hints/HintTarget;", "", "component", "Ljavax/accessibility/Accessible;", "location", "Ljava/awt/Point;", "size", "Ljava/awt/Dimension;", "depth", "", "<init>", "(Ljavax/accessibility/Accessible;Ljava/awt/Point;Ljava/awt/Dimension;I)V", "getComponent", "()Ljavax/accessibility/Accessible;", "getLocation", "()Ljava/awt/Point;", "getSize", "()Ljava/awt/Dimension;", "getDepth", "()I", "hint", "", "getHint", "()Ljava/lang/String;", "setHint", "(Ljava/lang/String;)V", "bounds", "Ljava/awt/Rectangle;", "getBounds", "()Ljava/awt/Rectangle;", "action", "Lkotlin/Function1;", "", "getAction", "()Lkotlin/jvm/functions/Function1;", "setAction", "(Lkotlin/jvm/functions/Function1;)V", "clickCenter", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "IdeaVIM"})
public final class HintTarget {
    @NotNull
    private final Accessible component;
    @NotNull
    private final Point location;
    @NotNull
    private final Dimension size;
    private final int depth;
    @NotNull
    private String hint;
    @NotNull
    private Function1<? super HintTarget, Boolean> action;

    public HintTarget(@NotNull Accessible component, @NotNull Point location, @NotNull Dimension size, int depth) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.component = component;
        this.location = location;
        this.size = size;
        this.depth = depth;
        this.hint = "";
        this.action = HintTarget::action$lambda$0;
    }

    @NotNull
    public final Accessible getComponent() {
        return this.component;
    }

    @NotNull
    public final Point getLocation() {
        return this.location;
    }

    @NotNull
    public final Dimension getSize() {
        return this.size;
    }

    public final int getDepth() {
        return this.depth;
    }

    @NotNull
    public final String getHint() {
        return this.hint;
    }

    public final void setHint(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.hint = string;
    }

    @NotNull
    public final Rectangle getBounds() {
        return new Rectangle(this.location, this.size);
    }

    @NotNull
    public final Function1<HintTarget, Boolean> getAction() {
        return this.action;
    }

    public final void setAction(@NotNull Function1<? super HintTarget, Boolean> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.action = function1;
    }

    public final boolean action() {
        return (Boolean)this.action.invoke((Object)this);
    }

    public final boolean clickCenter() {
        Robot robot = new Robot();
        Object object = this.component.getAccessibleContext();
        if (object == null || (object = ((AccessibleContext)object).getAccessibleComponent()) == null || (object = object.getLocationOnScreen()) == null) {
            return false;
        }
        Object locationOnScreen = object;
        robot.mouseMove(((Point)locationOnScreen).x + this.getBounds().width / 2, ((Point)locationOnScreen).y + this.getBounds().height / 2);
        robot.mousePress(1024);
        robot.mouseRelease(1024);
        return true;
    }

    @NotNull
    public final Accessible component1() {
        return this.component;
    }

    @NotNull
    public final Point component2() {
        return this.location;
    }

    @NotNull
    public final Dimension component3() {
        return this.size;
    }

    public final int component4() {
        return this.depth;
    }

    @NotNull
    public final HintTarget copy(@NotNull Accessible component, @NotNull Point location, @NotNull Dimension size, int depth) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return new HintTarget(component, location, size, depth);
    }

    public static /* synthetic */ HintTarget copy$default(HintTarget hintTarget, Accessible accessible, Point point, Dimension dimension, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            accessible = hintTarget.component;
        }
        if ((n2 & 2) != 0) {
            point = hintTarget.location;
        }
        if ((n2 & 4) != 0) {
            dimension = hintTarget.size;
        }
        if ((n2 & 8) != 0) {
            n = hintTarget.depth;
        }
        return hintTarget.copy(accessible, point, dimension, n);
    }

    @NotNull
    public String toString() {
        return "HintTarget(component=" + this.component + ", location=" + this.location + ", size=" + this.size + ", depth=" + this.depth + ")";
    }

    public int hashCode() {
        int result = this.component.hashCode();
        result = result * 31 + this.location.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + Integer.hashCode(this.depth);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HintTarget)) {
            return false;
        }
        HintTarget hintTarget = (HintTarget)other;
        if (!Intrinsics.areEqual((Object)this.component, (Object)hintTarget.component)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.location, (Object)hintTarget.location)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)hintTarget.size)) {
            return false;
        }
        return this.depth == hintTarget.depth;
    }

    private static final boolean action$lambda$0(HintTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }
}

