/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.multiplecursors;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimScrollGroup;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.extension.multiplecursors.VimMultipleCursorsExtensionKt;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.helper.CaretVisualAttributesHelperKt;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.helper.SearchOptions;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0005\u0019\u001a\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "init", "", "selectText", "Lcom/maddyhome/idea/vim/common/TextRange;", "caret", "Lcom/intellij/openapi/editor/Caret;", "text", "offset", "", "selectWordUnderCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "enterVisualMode", "Lcom/maddyhome/idea/vim/api/VimEditor;", "findNextOccurrence", "startOffset", "whole", "", "makePattern", "WriteActionHandler", "NextOccurrenceHandler", "AllOccurrencesHandler", "SkipOccurrenceHandler", "RemoveOccurrenceHandler", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimMultipleCursorsExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimMultipleCursorsExtension.kt\ncom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,333:1\n57#2,2:334\n19#2:336\n59#2,2:337\n61#2:341\n37#3,2:339\n*S KotlinDebug\n*F\n+ 1 VimMultipleCursorsExtension.kt\ncom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension\n*L\n320#1:334,2\n320#1:336\n320#1:337,2\n320#1:341\n320#1:339,2\n*E\n"})
public final class VimMultipleCursorsExtension
implements VimExtension {
    @Override
    @NotNull
    public String getName() {
        return "multiple-cursors";
    }

    @Override
    public void init() {
        Set set = MappingMode.NXO;
        List list = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>NextWholeOccurrence");
        MappingOwner mappingOwner = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set, (List<? extends KeyStroke>)list, mappingOwner, new NextOccurrenceHandler(this, false, 1, null), false);
        Set set2 = MappingMode.NXO;
        List list2 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>NextOccurrence");
        MappingOwner mappingOwner2 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner2, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set2, (List<? extends KeyStroke>)list2, mappingOwner2, new NextOccurrenceHandler(this, false), false);
        Set set3 = MappingMode.NXO;
        List list3 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>AllWholeOccurrences");
        MappingOwner mappingOwner3 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner3, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set3, (List<? extends KeyStroke>)list3, mappingOwner3, new AllOccurrencesHandler(this, false, 1, null), false);
        Set set4 = MappingMode.NXO;
        List list4 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>AllOccurrences");
        MappingOwner mappingOwner4 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner4, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set4, (List<? extends KeyStroke>)list4, mappingOwner4, new AllOccurrencesHandler(this, false), false);
        Set set5 = MappingMode.X;
        List list5 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>SkipOccurrence");
        MappingOwner mappingOwner5 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner5, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set5, (List<? extends KeyStroke>)list5, mappingOwner5, new SkipOccurrenceHandler(), false);
        Set set6 = MappingMode.X;
        List list6 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>RemoveOccurrence");
        MappingOwner mappingOwner6 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner6, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set6, (List<? extends KeyStroke>)list6, mappingOwner6, new RemoveOccurrenceHandler(), false);
        Set set7 = MappingMode.NXO;
        List list7 = VimInjectorKt.getInjector().getParser().parseKeys("<A-n>");
        MappingOwner mappingOwner7 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner7, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set7, list7, mappingOwner7, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>NextWholeOccurrence"), true);
        Set set8 = MappingMode.NXO;
        List list8 = VimInjectorKt.getInjector().getParser().parseKeys("g<A-n>");
        MappingOwner mappingOwner8 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner8, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set8, list8, mappingOwner8, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>NextOccurrence"), true);
        Set set9 = MappingMode.X;
        List list9 = VimInjectorKt.getInjector().getParser().parseKeys("<A-x>");
        MappingOwner mappingOwner9 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner9, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set9, list9, mappingOwner9, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>SkipOccurrence"), true);
        Set set10 = MappingMode.X;
        List list10 = VimInjectorKt.getInjector().getParser().parseKeys("<A-p>");
        MappingOwner mappingOwner10 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner10, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set10, list10, mappingOwner10, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>RemoveOccurrence"), true);
    }

    private final TextRange selectText(Caret caret, String text, int offset) {
        if (((CharSequence)text).length() == 0) {
            return null;
        }
        EngineVisualGroupKt.vimSetSelection((VimCaret)IjVimCaretKt.getVim(caret), (int)offset, (int)(offset + text.length() - 1), (boolean)true);
        VimScrollGroup vimScrollGroup = VimInjectorKt.getInjector().getScroll();
        Editor editor = caret.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        vimScrollGroup.scrollCaretIntoView(IjVimEditorKt.getVim(editor));
        return new TextRange(caret.getSelectionStart(), caret.getSelectionEnd());
    }

    private final TextRange selectWordUnderCaret(Editor editor, Caret caret) {
        TextRange textRange = VimInjectorKt.getInjector().getSearchHelper().findWordAtOrFollowingCursor(IjVimEditorKt.getVim(editor), (ImmutableVimCaret)IjVimCaretKt.getVim(caret), false);
        if (textRange == null) {
            return null;
        }
        TextRange range = textRange;
        if (range.getStartOffset() > caret.getOffset()) {
            return null;
        }
        this.enterVisualMode(IjVimEditorKt.getVim(editor));
        EngineVisualGroupKt.vimSetSelection((VimCaret)IjVimCaretKt.getVim(caret), (int)range.getStartOffset(), (int)EngineHelperKt.getEndOffsetInclusive((TextRange)range), (boolean)true);
        return new TextRange(caret.getSelectionStart(), caret.getSelectionEnd());
    }

    private final void enterVisualMode(VimEditor editor) {
        VimPlugin.getVisualMotion().enterVisualMode(editor, SelectionType.CHARACTER_WISE);
        KeyHandler.Companion.getInstance().reset(editor);
    }

    private final int findNextOccurrence(Editor editor, int startOffset, String text, boolean whole) {
        EnumSet<Object> enumSet;
        SearchOptions[] searchOptionsArray = new SearchOptions[]{SearchOptions.WHOLE_FILE};
        Object[] value$iv = (Enum[])searchOptionsArray;
        boolean $i$f$enumSetOf = false;
        switch (value$iv.length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<SearchOptions> enumSet2 = EnumSet.noneOf(SearchOptions.class);
                enumSet = enumSet2;
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<Enum> enumSet3 = EnumSet.of(value$iv[0]);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                break;
            }
            default: {
                Collection $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Enum[] enumArray = (Enum[])thisCollection$iv$iv.toArray(new SearchOptions[0]);
                EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(enumArray, enumArray.length));
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            }
        }
        EnumSet<Object> searchOptions = enumSet;
        if (VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)IjVimEditorKt.getVim(editor)).getWrapscan()) {
            searchOptions.add(SearchOptions.WRAP);
        }
        TextRange textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern((VimEditor)new IjVimEditor(editor), this.makePattern(text, whole), startOffset, 1, searchOptions);
        return textRange != null ? textRange.getStartOffset() : -1;
    }

    private final String makePattern(String text, boolean whole) {
        return "\\V\\C" + (String)(whole ? "\\<" + text + "\\>" : text);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$AllOccurrencesHandler;", "Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$WriteActionHandler;", "whole", "", "<init>", "(Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension;Z)V", "getWhole", "()Z", "executeInWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "IdeaVIM"})
    public final class AllOccurrencesHandler
    extends WriteActionHandler {
        private final boolean whole;
        final /* synthetic */ VimMultipleCursorsExtension this$0;

        public AllOccurrencesHandler(VimMultipleCursorsExtension this$0, boolean whole) {
            this.this$0 = this$0;
            this.whole = whole;
        }

        public /* synthetic */ AllOccurrencesHandler(VimMultipleCursorsExtension vimMultipleCursorsExtension, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(vimMultipleCursorsExtension, bl);
        }

        public final boolean getWhole() {
            return this.whole;
        }

        @Override
        public void executeInWriteAction(@NotNull Editor editor, @NotNull DataContext context) {
            String text;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            if (caretModel2.getCaretCount() > 1) {
                return;
            }
            Caret caret = caretModel2.getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Caret primaryCaret = caret;
            if (CommandStateHelper.inVisualMode(editor)) {
                v2 = primaryCaret.getSelectedText();
                if (v2 == null) {
                    return;
                }
            } else {
                TextRange textRange = VimInjectorKt.getInjector().getSearchHelper().findWordAtOrFollowingCursor(IjVimEditorKt.getVim(editor), (ImmutableVimCaret)IjVimCaretKt.getVim(primaryCaret), false);
                if (textRange == null) {
                    return;
                }
                TextRange range = textRange;
                if (range.getStartOffset() > primaryCaret.getOffset()) {
                    return;
                }
                v2 = text = EngineEditorHelperKt.getText((VimEditor)((VimEditor)new IjVimEditor(editor)), (TextRange)range);
            }
            if (!CommandStateHelper.inVisualMode(editor)) {
                this.this$0.enterVisualMode(IjVimEditorKt.getVim(editor));
            }
            String pattern = this.this$0.makePattern(text, this.whole);
            List matches = VimInjectorKt.getInjector().getSearchHelper().findAll((VimEditor)new IjVimEditor(editor), pattern, 0, -1, false);
            for (TextRange match : matches) {
                Caret caret2;
                TextRange textRange;
                if (match.contains(primaryCaret.getOffset())) {
                    IjVimCaretKt.getVim(primaryCaret).moveToOffset(match.getStartOffset());
                    textRange = this.this$0.selectText(primaryCaret, text, match.getStartOffset());
                    continue;
                }
                if (editor.getCaretModel().addCaret(editor.offsetToVisualPosition(match.getStartOffset()), true) == null) {
                    return;
                }
                textRange = this.this$0.selectText(caret2, text, match.getStartOffset());
            }
            CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(editor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$NextOccurrenceHandler;", "Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$WriteActionHandler;", "whole", "", "<init>", "(Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension;Z)V", "getWhole", "()Z", "executeInWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimMultipleCursorsExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimMultipleCursorsExtension.kt\ncom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$NextOccurrenceHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1869#2,2:334\n1869#2,2:336\n*S KotlinDebug\n*F\n+ 1 VimMultipleCursorsExtension.kt\ncom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$NextOccurrenceHandler\n*L\n174#1:334,2\n211#1:336,2\n*E\n"})
    public final class NextOccurrenceHandler
    extends WriteActionHandler {
        private final boolean whole;
        final /* synthetic */ VimMultipleCursorsExtension this$0;

        public NextOccurrenceHandler(VimMultipleCursorsExtension this$0, boolean whole) {
            this.this$0 = this$0;
            this.whole = whole;
        }

        public /* synthetic */ NextOccurrenceHandler(VimMultipleCursorsExtension vimMultipleCursorsExtension, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(vimMultipleCursorsExtension, bl);
        }

        public final boolean getWhole() {
            return this.whole;
        }

        @Override
        public void executeInWriteAction(@NotNull Editor editor, @NotNull DataContext context) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            if (!CommandStateHelper.inVisualMode(editor)) {
                if (caretModel2.getCaretCount() > 1) {
                    return;
                }
                Caret caret = caretModel2.getPrimaryCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
                TextRange selection = this.this$0.selectWordUnderCaret(editor, caret);
                VimMultipleCursorsExtensionKt.access$setVimMultipleCursorsWholeWord(editor, this.whole);
                VimMultipleCursorsExtensionKt.access$setVimMultipleCursorsLastSelection(editor, selection);
            } else {
                boolean bl;
                TreeSet patterns = SetsKt.sortedSetOf((Object[])new String[0]);
                ArrayList<VisualPosition> newPositions = new ArrayList<VisualPosition>();
                for (Caret caret : caretModel2.getAllCarets()) {
                    VisualPosition startPosition;
                    Object selectedText;
                    if (caret.getSelectedText() == null) {
                        return;
                    }
                    patterns.add(selectedText);
                    int minOffset = Math.min(caret.getSelectionEnd(), caret.getSelectionStart());
                    int maxOffset = Math.max(caret.getSelectionEnd(), caret.getSelectionStart());
                    Character c = StringsKt.lastOrNull((CharSequence)((CharSequence)selectedText));
                    char c2 = '\n';
                    if (c != null && c.charValue() == c2) {
                        --maxOffset;
                    }
                    int start2 = editor.getDocument().getLineNumber(minOffset);
                    int end = editor.getDocument().getLineNumber(maxOffset);
                    int lines = end - start2;
                    if (lines <= 0) continue;
                    int selectionStart = Math.min(caret.getSelectionStart(), caret.getSelectionEnd());
                    Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToVisualPosition(selectionStart), (String)"offsetToVisualPosition(...)");
                    int line = startPosition.line + 1;
                    int n = startPosition.line + lines;
                    if (line <= n) {
                        while (true) {
                            newPositions.add(new VisualPosition(line, startPosition.column));
                            if (line == n) break;
                            ++line;
                        }
                    }
                    Intrinsics.checkNotNull((Object)caret);
                    IjVimCaretKt.getVim(caret).moveToOffset(selectionStart);
                }
                if (newPositions.size() > 0) {
                    EngineModeExtensionsKt.exitVisualMode((VimEditor)IjVimEditorKt.getVim(editor));
                    Iterable $this$forEach$iv = newPositions;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VisualPosition it = (VisualPosition)element$iv;
                        boolean bl2 = false;
                        if (editor.getCaretModel().addCaret(it, true) == null) continue;
                    }
                    CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(editor);
                    return;
                }
                if (patterns.size() > 1) {
                    return;
                }
                TextRange currentSelection = new TextRange(caretModel2.getPrimaryCaret().getSelectionStart(), caretModel2.getPrimaryCaret().getSelectionEnd());
                TextRange lastSelection = VimMultipleCursorsExtensionKt.access$getVimMultipleCursorsLastSelection(editor);
                if (lastSelection != null && lastSelection.getStartOffset() == currentSelection.getStartOffset() && lastSelection.getEndOffset() == currentSelection.getEndOffset()) {
                    Boolean bl3 = VimMultipleCursorsExtensionKt.access$getVimMultipleCursorsWholeWord(editor);
                    bl = bl3 != null ? bl3 : false;
                } else {
                    bl = false;
                }
                boolean wholeWord = bl;
                VimMultipleCursorsExtensionKt.access$setVimMultipleCursorsWholeWord(editor, wholeWord);
                lastSelection = currentSelection;
                String pattern = EngineEditorHelperKt.getText((VimEditor)IjVimEditorKt.getVim(editor), (TextRange)lastSelection);
                Caret caret = editor.getCaretModel().getPrimaryCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
                Caret primaryCaret = caret;
                int nextOffset = this.this$0.findNextOccurrence(editor, primaryCaret.getOffset(), pattern, wholeWord);
                if (nextOffset != -1) {
                    List list = caretModel2.getAllCarets();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Caret it = (Caret)element$iv;
                        boolean bl4 = false;
                        if (it.getSelectionStart() != nextOffset) continue;
                        VimPlugin.showMessage(MessageHelper.message("multiple-cursors.message.no.more.matches"));
                        return;
                    }
                    Caret caret2 = editor.getCaretModel().addCaret(editor.offsetToVisualPosition(nextOffset), true);
                    if (caret2 == null) {
                        return;
                    }
                    Caret caret3 = caret2;
                    CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(editor);
                    VimMultipleCursorsExtensionKt.access$setVimMultipleCursorsLastSelection(editor, this.this$0.selectText(caret3, pattern, nextOffset));
                } else {
                    VimPlugin.showMessage(MessageHelper.message("multiple-cursors.message.no.more.matches"));
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$RemoveOccurrenceHandler;", "Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$WriteActionHandler;", "<init>", "(Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension;)V", "executeInWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "IdeaVIM"})
    public final class RemoveOccurrenceHandler
    extends WriteActionHandler {
        @Override
        public void executeInWriteAction(@NotNull Editor editor, @NotNull DataContext context) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Caret caret = editor.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Caret caret2 = caret;
            if (caret2.getSelectedText() == null) {
                return;
            }
            if (!editor.getCaretModel().removeCaret(caret2)) {
                EngineModeExtensionsKt.exitVisualMode((VimEditor)IjVimEditorKt.getVim(editor));
            }
            VimInjectorKt.getInjector().getScroll().scrollCaretIntoView(IjVimEditorKt.getVim(editor));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$SkipOccurrenceHandler;", "Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$WriteActionHandler;", "<init>", "(Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension;)V", "executeInWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimMultipleCursorsExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimMultipleCursorsExtension.kt\ncom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$SkipOccurrenceHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1869#2,2:334\n*S KotlinDebug\n*F\n+ 1 VimMultipleCursorsExtension.kt\ncom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$SkipOccurrenceHandler\n*L\n270#1:334,2\n*E\n"})
    public final class SkipOccurrenceHandler
    extends WriteActionHandler {
        @Override
        public void executeInWriteAction(@NotNull Editor editor, @NotNull DataContext context) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Caret caret = editor.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Caret primaryCaret = caret;
            String string = primaryCaret.getSelectedText();
            if (string == null) {
                return;
            }
            String selectedText = string;
            Boolean bl = VimMultipleCursorsExtensionKt.access$getVimMultipleCursorsWholeWord(editor);
            int nextOffset = VimMultipleCursorsExtension.this.findNextOccurrence(editor, primaryCaret.getOffset(), selectedText, bl != null ? bl : false);
            if (nextOffset != -1) {
                List list = editor.getCaretModel().getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Caret it = (Caret)element$iv;
                    boolean bl2 = false;
                    if (it.getSelectionStart() != nextOffset) continue;
                    VimPlugin.showMessage(MessageHelper.message("multiple-cursors.message.no.more.matches"));
                    return;
                }
                primaryCaret.moveToVisualPosition(editor.offsetToVisualPosition(nextOffset));
                VimMultipleCursorsExtension.this.selectText(primaryCaret, selectedText, nextOffset);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/multiplecursors/VimMultipleCursorsExtension$WriteActionHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "executeInWriteAction", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/openapi/actionSystem/DataContext;", "IdeaVIM"})
    public static abstract class WriteActionHandler
    implements ExtensionHandler {
        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            ApplicationManager.getApplication().runWriteAction(() -> WriteActionHandler.execute$lambda$0(this, editor, context));
        }

        public abstract void executeInWriteAction(@NotNull Editor var1, @NotNull DataContext var2);

        private static final void execute$lambda$0(WriteActionHandler this$0, VimEditor $editor, ExecutionContext $context) {
            this$0.executeInWriteAction(IjVimEditorKt.getIj($editor), IjEditorExecutionContextKt.getIj($context));
        }
    }
}

