/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.nerdtree;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.treeStructure.Tree;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.extension.ShortcutDispatcher;
import com.maddyhome.idea.vim.extension.nerdtree.NerdTreeAction;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher;", "Lcom/maddyhome/idea/vim/extension/ShortcutDispatcher;", "Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTreeAction;", "name", "", "mappings", "", "", "Ljavax/swing/KeyStroke;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "NerdTreeListener", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nAbstractDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDispatcher.kt\ncom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,64:1\n39#2:65\n*S KotlinDebug\n*F\n+ 1 AbstractDispatcher.kt\ncom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher\n*L\n61#1:65\n*E\n"})
public abstract class AbstractDispatcher
extends ShortcutDispatcher<NerdTreeAction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger LOG;

    public AbstractDispatcher(@NotNull String name, @NotNull Map<List<KeyStroke>, NerdTreeAction> mappings) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        super(name, mappings, NerdTreeListener.INSTANCE);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(true);
        InputEvent inputEvent = e.getInputEvent();
        KeyEvent keyEvent = inputEvent instanceof KeyEvent ? (KeyEvent)inputEvent : null;
        boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 27 : false;
        if (bl) {
            e.getPresentation().setEnabled(!((Collection)this.getKeyStrokes()).isEmpty());
            this.getKeyStrokes().clear();
        }
        if (e.getData(PlatformDataKeys.SPEED_SEARCH_TEXT) != null) {
            e.getPresentation().setEnabled(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(AbstractDispatcher.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLOG", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher$NerdTreeListener;", "Lcom/maddyhome/idea/vim/extension/ShortcutDispatcher$Listener;", "Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTreeAction;", "<init>", "()V", "onMatch", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "keyStrokes", "", "Ljavax/swing/KeyStroke;", "data", "onInvalid", "IdeaVIM"})
    private static final class NerdTreeListener
    implements ShortcutDispatcher.Listener<NerdTreeAction> {
        @NotNull
        public static final NerdTreeListener INSTANCE = new NerdTreeListener();

        private NerdTreeListener() {
        }

        @Override
        public void onMatch(@NotNull AnActionEvent e, @NotNull List<KeyStroke> keyStrokes, @NotNull NerdTreeAction data) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            if (component instanceof Tree) {
                data.getAction().invoke((Object)e, (Object)component);
            } else {
                Companion.getLOG().error("Component is not a tree: " + component);
            }
            keyStrokes.clear();
        }

        @Override
        public void onInvalid(@NotNull AnActionEvent e, @NotNull List<KeyStroke> keyStrokes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
            keyStrokes.clear();
            VimInjectorKt.getInjector().getMessages().indicateError();
        }
    }
}

