/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.nerdtree;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.CommandAliasHandler;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.extension.nerdtree.AbstractDispatcher;
import com.maddyhome.idea.vim.extension.nerdtree.NerdTreeAction;
import com.maddyhome.idea.vim.extension.nerdtree.NerdTreeKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0006\t\n\u000b\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "init", "", "dispose", "IjCommandHandler", "ToggleHandler", "CloseHandler", "NerdStartupActivity", "NerdDispatcher", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nNerdTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,299:1\n13805#2,2:300\n13805#2,2:302\n39#3:304\n*S KotlinDebug\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree\n*L\n113#1:300,2\n120#1:302,2\n177#1:304\n*E\n"})
public final class NerdTree
implements VimExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PLUGIN_NAME = "NERDTree";
    @NotNull
    private static final VimLogger LOG;

    @Override
    @NotNull
    public String getName() {
        return PLUGIN_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        LOG.info("IdeaVim: Initializing NERDTree extension. Disable this extension if you observe a strange behaviour of the project tree. E.g. moving down on 'j'");
        ReentrantReadWriteLock reentrantReadWriteLock = NerdTreeKt.access$getLock$p();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean $i$a$-write-NerdTree$init$22 = false;
            NerdTreeKt.access$setEnabled$p(true);
            VimExtensionFacade.INSTANCE.addCommand("NERDTreeFocus", new IjCommandHandler("ActivateProjectToolWindow"));
            VimExtensionFacade.INSTANCE.addCommand(PLUGIN_NAME, new IjCommandHandler("ActivateProjectToolWindow"));
            VimExtensionFacade.INSTANCE.addCommand("NERDTreeToggle", new ToggleHandler());
            VimExtensionFacade.INSTANCE.addCommand("NERDTreeClose", new CloseHandler());
            VimExtensionFacade.INSTANCE.addCommand("NERDTreeFind", new IjCommandHandler("SelectInProjectView"));
            VimExtensionFacade.INSTANCE.addCommand("NERDTreeRefreshRoot", new IjCommandHandler("Synchronize"));
            Unit $i$a$-write-NerdTree$init$22 = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project p0 = (Project)element$iv;
            boolean bl = false;
            NerdTreeKt.access$installDispatcher(p0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ReentrantReadWriteLock reentrantReadWriteLock = NerdTreeKt.access$getLock$p();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            NerdTreeKt.access$setEnabled$p(false);
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Project project = (Project)element$iv;
                boolean bl2 = false;
                ProjectView projectView = ProjectView.getInstance((Project)project);
                Intrinsics.checkNotNull((Object)projectView, (String)"null cannot be cast to non-null type com.intellij.ide.projectView.impl.ProjectViewImpl");
                JComponent component = ((ProjectViewImpl)projectView).getComponent();
                if (component != null) {
                    Intrinsics.checkNotNull((Object)project);
                    NerdDispatcher.Companion.getInstance(project).unregisterCustomShortcutSet(component);
                    continue;
                }
                LOG.error(project + ": project view component is null");
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        VimExtension.super.dispose();
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(NerdTree.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$CloseHandler;", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "<init>", "()V", "execute", "", "command", "", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "IdeaVIM"})
    public static final class CloseHandler
    implements CommandAliasHandler {
        public void execute(@NotNull String command, @NotNull Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Project project = IjVimEditorKt.getIj(editor).getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            ToolWindow toolWindow = ToolWindowManagerEx.Companion.getInstanceEx(project2).getToolWindow("Project");
            if (toolWindow == null) {
                return;
            }
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2.isVisible()) {
                toolWindow2.hide();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$Companion;", "", "<init>", "()V", "PLUGIN_NAME", "", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$IjCommandHandler;", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "actionId", "", "<init>", "(Ljava/lang/String;)V", "execute", "", "command", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "IdeaVIM"})
    public static final class IjCommandHandler
    implements CommandAliasHandler {
        @NotNull
        private final String actionId;

        public IjCommandHandler(@NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            this.actionId = actionId;
        }

        public void execute(@NotNull String command, @NotNull Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            NerdTreeAction.Companion.callAction(editor, this.actionId, context);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher;", "Lcom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher;", "<init>", "()V", "Companion", "IdeaVIM"})
    public static final class NerdDispatcher
    extends AbstractDispatcher {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public NerdDispatcher() {
            super(NerdTree.PLUGIN_NAME, NerdTreeKt.access$createMappings());
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher;", "project", "Lcom/intellij/openapi/project/Project;", "IdeaVIM"})
        @SourceDebugExtension(value={"SMAP\nNerdTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,299:1\n30#2,2:300\n*S KotlinDebug\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher$Companion\n*L\n170#1:300,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NerdDispatcher getInstance(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<NerdDispatcher> serviceClass$iv = NerdDispatcher.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (NerdDispatcher)((Object)object);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "IdeaVIM"})
    public static final class NerdStartupActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            NerdTreeKt.access$installDispatcher(project);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$ToggleHandler;", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "<init>", "()V", "execute", "", "command", "", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "IdeaVIM"})
    public static final class ToggleHandler
    implements CommandAliasHandler {
        public void execute(@NotNull String command, @NotNull Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Project project = IjVimEditorKt.getIj(editor).getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            ToolWindow toolWindow = ToolWindowManagerEx.Companion.getInstanceEx(project2).getToolWindow("Project");
            if (toolWindow == null) {
                return;
            }
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2.isVisible()) {
                toolWindow2.hide();
            } else {
                NerdTreeAction.Companion.callAction(editor, "ActivateProjectToolWindow", context);
            }
        }
    }
}

