/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.paragraphmotion;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016JB\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/extension/paragraphmotion/ParagraphMotion;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "init", "", "putKeyMappingIfMissingFromAndToKeys", "modes", "", "Lcom/maddyhome/idea/vim/command/MappingMode;", "fromKeys", "", "Ljavax/swing/KeyStroke;", "pluginOwner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "toKeys", "recursive", "", "ParagraphMotionHandler", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nParagraphMotion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphMotion.kt\ncom/maddyhome/idea/vim/extension/paragraphmotion/ParagraphMotion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n855#2,2:70\n*S KotlinDebug\n*F\n+ 1 ParagraphMotion.kt\ncom/maddyhome/idea/vim/extension/paragraphmotion/ParagraphMotion\n*L\n65#1:70,2\n*E\n"})
public final class ParagraphMotion
implements VimExtension {
    @Override
    @NotNull
    public String getName() {
        return "vim-paragraph-motion";
    }

    @Override
    public void init() {
        Set set = MappingMode.NXO;
        List list = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>(ParagraphNextMotion)");
        MappingOwner mappingOwner = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set, (List<? extends KeyStroke>)list, mappingOwner, new ParagraphMotionHandler(1), false);
        Set set2 = MappingMode.NXO;
        List list2 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>(ParagraphPrevMotion)");
        MappingOwner mappingOwner2 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner2, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set2, (List<? extends KeyStroke>)list2, mappingOwner2, new ParagraphMotionHandler(-1), false);
        Set set3 = MappingMode.NXO;
        List list3 = VimInjectorKt.getInjector().getParser().parseKeys("}");
        MappingOwner mappingOwner3 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner3, (String)"getOwner(...)");
        this.putKeyMappingIfMissingFromAndToKeys(set3, list3, mappingOwner3, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>(ParagraphNextMotion)"), true);
        Set set4 = MappingMode.NXO;
        List list4 = VimInjectorKt.getInjector().getParser().parseKeys("{");
        MappingOwner mappingOwner4 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner4, (String)"getOwner(...)");
        this.putKeyMappingIfMissingFromAndToKeys(set4, list4, mappingOwner4, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>(ParagraphPrevMotion)"), true);
    }

    /*
     * WARNING - void declaration
     */
    private final void putKeyMappingIfMissingFromAndToKeys(Set<? extends MappingMode> modes, List<? extends KeyStroke> fromKeys, MappingOwner pluginOwner, List<? extends KeyStroke> toKeys, boolean recursive) {
        void $this$filterNotTo$iv;
        Iterable iterable = modes;
        Collection destination$iv = new HashSet();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv : $this$filterNotTo$iv) {
            MappingMode it = (MappingMode)element$iv;
            boolean bl = false;
            if (VimPlugin.getKey().getKeyMapping(it).getLayer(fromKeys) != null) continue;
            destination$iv.add(element$iv);
        }
        HashSet filteredModes = (HashSet)destination$iv;
        VimExtensionFacade.putKeyMappingIfMissing(filteredModes, fromKeys, pluginOwner, toKeys, recursive);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J%\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/extension/paragraphmotion/ParagraphMotion$ParagraphMotionHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "count", "", "<init>", "(I)V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "moveCaretToNextParagraph", "caret", "Lcom/intellij/openapi/editor/Caret;", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/intellij/openapi/editor/Caret;I)Ljava/lang/Integer;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nParagraphMotion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphMotion.kt\ncom/maddyhome/idea/vim/extension/paragraphmotion/ParagraphMotion$ParagraphMotionHandler\n+ 2 Helper.kt\ncom/maddyhome/idea/vim/helper/HelperKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n30#2,4:70\n35#2:76\n1869#3,2:74\n1#4:77\n*S KotlinDebug\n*F\n+ 1 ParagraphMotion.kt\ncom/maddyhome/idea/vim/extension/paragraphmotion/ParagraphMotion$ParagraphMotionHandler\n*L\n42#1:70,4\n42#1:76\n42#1:74,2\n*E\n"})
    private static final class ParagraphMotionHandler
    implements ExtensionHandler {
        private final int count;

        public ParagraphMotionHandler(int count) {
            this.count = count;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            Editor $this$vimForEachCaret$iv = IjVimEditorKt.getIj(editor);
            boolean $i$f$vimForEachCaret = false;
            if (EditorExtensionsKt.getInBlockSelection((VimEditor)IjVimEditorKt.getVim($this$vimForEachCaret$iv))) {
                Caret caret = $this$vimForEachCaret$iv.getCaretModel().getPrimaryCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
                Caret caret2 = caret;
                boolean bl = false;
                Integer motion = this.moveCaretToNextParagraph(editor, caret2, this.count);
                if (motion != null) {
                    IjVimCaretKt.getVim(caret2).moveToOffset(motion.intValue());
                }
            } else {
                List list = $this$vimForEachCaret$iv.getCaretModel().getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
                Iterable $this$forEach$iv$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Caret caret = (Caret)element$iv$iv;
                    boolean bl = false;
                    Integer motion = this.moveCaretToNextParagraph(editor, caret, this.count);
                    if (motion == null) continue;
                    IjVimCaretKt.getVim(caret).moveToOffset(motion.intValue());
                }
            }
        }

        @Nullable
        public final Integer moveCaretToNextParagraph(@NotNull VimEditor editor, @NotNull Caret caret, int count) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Integer n2 = VimInjectorKt.getInjector().getSearchHelper().findNextParagraph(editor, (ImmutableVimCaret)IjVimCaretKt.getVim(caret), count, true);
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                n = EngineEditorHelperKt.normalizeOffset((VimEditor)editor, (int)it, (boolean)true);
            } else {
                n = null;
            }
            return n;
        }
    }
}

