/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.find.EditorSearchSession;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimEditorGroup;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimModalInput;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.helper.CaretVisualAttributesHelperKt;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.newapi.IjVimDocument;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.options.EffectiveOptionValueChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VimEditorSettings", storages={@Storage(value="$APP_CONFIG$/vim_settings.xml")})
public class EditorGroup
implements PersistentStateComponent<Element>,
VimEditorGroup {
    @NonNls
    public static final String EDITOR_STORE_ELEMENT = "editor";
    private Boolean isKeyRepeat = null;
    private final CaretListener myLineNumbersCaretListener = new CaretListener(this){

        public void caretPositionChanged(@NotNull CaretEvent e) {
            Editor editor;
            boolean relativenumber;
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            if (relativenumber = IjVimInjectorKt.ijOptions(VimInjectorKt.injector, (VimEditor)new IjVimEditor(editor = e.getEditor())).getRelativenumber()) {
                if (!EditorGroup.hasRelativeLineNumbersInstalled(editor)) {
                    EditorGroup.installRelativeLineNumbers(editor);
                } else {
                    EditorGroup.repaintRelativeLineNumbers(editor);
                }
            } else if (EditorGroup.hasRelativeLineNumbersInstalled(editor)) {
                EditorGroup.removeRelativeLineNumbers(editor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/maddyhome/idea/vim/group/EditorGroup$1", "caretPositionChanged"));
        }
    };

    private void initLineNumbers(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(0);
        }
        if (!EditorGroup.supportsVimLineNumbers(editor) || UserDataManager.getVimEditorGroup(editor)) {
            return;
        }
        editor.getCaretModel().addCaretListener(this.myLineNumbersCaretListener);
        UserDataManager.setVimEditorGroup(editor, true);
        EditorGroup.updateLineNumbers(editor);
    }

    private void deinitLineNumbers(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(1);
        }
        if (EditorGroup.isProjectDisposed(editor) || !EditorGroup.supportsVimLineNumbers(editor) || !UserDataManager.getVimEditorGroup(editor)) {
            return;
        }
        editor.getCaretModel().removeCaretListener(this.myLineNumbersCaretListener);
        UserDataManager.setVimEditorGroup(editor, false);
        EditorGroup.removeRelativeLineNumbers(editor);
    }

    private static boolean supportsVimLineNumbers(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(2);
        }
        return EditorHelper.isFileEditor(editor) && !EditorHelper.isDiffEditor(editor);
    }

    private static boolean isProjectDisposed(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(3);
        }
        return editor.getProject() == null || editor.getProject().isDisposed();
    }

    private static void updateLineNumbers(@NotNull Editor editor) {
        boolean isLineNumbersShown;
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(4);
        }
        if (!(isLineNumbersShown = editor.getSettings().isLineNumbersShown())) {
            return;
        }
        EditorSettings.LineNumerationType lineNumerationType = editor.getSettings().getLineNumerationType();
        if (lineNumerationType == EditorSettings.LineNumerationType.RELATIVE || lineNumerationType == EditorSettings.LineNumerationType.HYBRID) {
            if (!EditorGroup.hasRelativeLineNumbersInstalled(editor)) {
                EditorGroup.installRelativeLineNumbers(editor);
            }
        } else {
            EditorGroup.removeRelativeLineNumbers(editor);
        }
    }

    private static boolean hasRelativeLineNumbersInstalled(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(5);
        }
        return UserDataManager.getVimHasRelativeLineNumbersInstalled(editor);
    }

    private static void installRelativeLineNumbers(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(6);
        }
        if (!EditorGroup.hasRelativeLineNumbersInstalled(editor)) {
            EditorGutter gutter = editor.getGutter();
            gutter.setLineNumberConverter((LineNumberConverter)new RelativeLineNumberConverter());
            UserDataManager.setVimHasRelativeLineNumbersInstalled(editor, true);
        }
    }

    private static void removeRelativeLineNumbers(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(7);
        }
        if (EditorGroup.hasRelativeLineNumbersInstalled(editor)) {
            EditorGutter gutter = editor.getGutter();
            gutter.setLineNumberConverter(LineNumberConverter.DEFAULT);
            UserDataManager.setVimHasRelativeLineNumbersInstalled(editor, false);
        }
    }

    private static void repaintRelativeLineNumbers(@NotNull Editor editor) {
        EditorGutter gutter;
        EditorGutterComponentEx gutterComponent;
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(8);
        }
        EditorGutterComponentEx editorGutterComponentEx = gutterComponent = (gutter = editor.getGutter()) instanceof EditorGutterComponentEx ? (EditorGutterComponentEx)gutter : null;
        if (gutterComponent != null) {
            gutterComponent.repaint();
        }
    }

    public void saveData(@NotNull Element element) {
        if (element == null) {
            EditorGroup.$$$reportNull$$$0(9);
        }
        Element editor = new Element(EDITOR_STORE_ELEMENT);
        element.addContent(editor);
        if (this.isKeyRepeat != null) {
            Element keyRepeat = new Element("key-repeat");
            keyRepeat.setAttribute("enabled", Boolean.toString(this.isKeyRepeat));
            editor.addContent(keyRepeat);
        }
    }

    public void readData(@NotNull Element element) {
        String enabled;
        Element keyRepeat;
        Element editor;
        if (element == null) {
            EditorGroup.$$$reportNull$$$0(10);
        }
        if ((editor = element.getChild(EDITOR_STORE_ELEMENT)) != null && (keyRepeat = editor.getChild("key-repeat")) != null && (enabled = keyRepeat.getAttributeValue("enabled")) != null) {
            this.isKeyRepeat = Boolean.valueOf(enabled);
        }
    }

    @Nullable
    public Boolean isKeyRepeat() {
        return this.isKeyRepeat;
    }

    public void setKeyRepeat(@Nullable Boolean value) {
        this.isKeyRepeat = value;
    }

    public void closeEditorSearchSession(@NotNull Editor editor) {
        EditorSearchSession editorSearchSession;
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(11);
        }
        if ((editorSearchSession = EditorSearchSession.get((Editor)editor)) != null) {
            editorSearchSession.close();
        }
    }

    public void editorCreated(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(12);
        }
        UserDataManager.setVimInitialised(editor, true);
        VimPlugin.getKey().registerRequiredShortcutKeys((VimEditor)new IjVimEditor(editor));
        this.initLineNumbers(editor);
        if (editor instanceof EditorEx) {
            EditorEx editorEx = (EditorEx)editor;
            editorEx.addPropertyChangeListener((PropertyChangeListener)FontSizeChangeListener.INSTANCE);
        }
        if (VimInjectorKt.injector.getApplication().isUnitTest()) {
            this.updateCaretsVisualAttributes((VimEditor)new IjVimEditor(editor));
        }
    }

    public void editorDeinit(@NotNull Editor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(13);
        }
        this.deinitLineNumbers(editor);
        UserDataManager.unInitializeEditor(editor);
        VimPlugin.getKey().unregisterShortcutKeys((VimEditor)new IjVimEditor(editor));
        CaretVisualAttributesHelperKt.removeCaretsVisualAttributes(editor);
        if (editor instanceof EditorEx) {
            EditorEx editorEx = (EditorEx)editor;
            editorEx.removePropertyChangeListener((PropertyChangeListener)FontSizeChangeListener.INSTANCE);
        }
    }

    public void notifyIdeaJoin(@Nullable Project project, @NotNull VimEditor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(14);
        }
        if (VimPlugin.getVimState().isIdeaJoinNotified() || IjVimInjectorKt.ijOptions(VimInjectorKt.injector, editor).getIdeajoin()) {
            return;
        }
        VimPlugin.getVimState().setIdeaJoinNotified(true);
        VimPlugin.getNotifications(project).notifyAboutIdeaJoin(editor);
    }

    @Nullable
    public Element getState() {
        Element element = new Element(EDITOR_STORE_ELEMENT);
        this.saveData(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            EditorGroup.$$$reportNull$$$0(15);
        }
        this.readData(state);
    }

    public void notifyIdeaJoin(@NotNull VimEditor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(16);
        }
        this.notifyIdeaJoin(((IjVimEditor)editor).getEditor().getProject(), editor);
    }

    public void updateCaretsVisualAttributes(@NotNull VimEditor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(17);
        }
        Editor ijEditor = ((IjVimEditor)editor).getEditor();
        CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(ijEditor);
    }

    public void updateCaretsVisualPosition(@NotNull VimEditor editor) {
        if (editor == null) {
            EditorGroup.$$$reportNull$$$0(18);
        }
        Editor ijEditor = ((IjVimEditor)editor).getEditor();
        CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(ijEditor);
    }

    @Nullable
    public VimEditor getFocusedEditor() {
        try {
            Editor focusedEditor;
            DataContext dataContext = (DataContext)DataManager.getInstance().getDataContextFromFocusAsync().blockingGet(1000);
            if (dataContext != null && (focusedEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
                return new IjVimEditor(focusedEditor);
            }
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
        return null;
    }

    @NotNull
    public Collection<VimEditor> getEditorsRaw() {
        Collection collection = this.getLocalEditors().map(IjVimEditor::new).collect(Collectors.toList());
        if (collection == null) {
            EditorGroup.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public Collection<VimEditor> getEditors() {
        Collection collection = this.getLocalEditors().filter(UserDataManager::getVimInitialised).map(IjVimEditor::new).collect(Collectors.toList());
        if (collection == null) {
            EditorGroup.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @NotNull
    public Collection<VimEditor> getEditors(@NotNull VimDocument buffer) {
        if (buffer == null) {
            EditorGroup.$$$reportNull$$$0(21);
        }
        Document document = ((IjVimDocument)buffer).getDocument();
        Collection collection = this.getLocalEditors().filter(editor -> UserDataManager.getVimInitialised(editor) && editor.getDocument().equals((Object)document)).map(IjVimEditor::new).collect(Collectors.toList());
        if (collection == null) {
            EditorGroup.$$$reportNull$$$0(22);
        }
        return collection;
    }

    private Stream<Editor> getLocalEditors() {
        List appSessions = ClientSessionsManager.getAppSessions((ClientKind)ClientKind.LOCAL);
        if (!appSessions.isEmpty()) {
            ClientAppSession localSession = (ClientAppSession)appSessions.get(0);
            return ((ClientEditorManager)localSession.getService(ClientEditorManager.class)).editors();
        }
        return Stream.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = EDITOR_STORE_ELEMENT;
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/vim/group/EditorGroup";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/vim/group/EditorGroup";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsRaw";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initLineNumbers";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deinitLineNumbers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsVimLineNumbers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isProjectDisposed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLineNumbers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasRelativeLineNumbersInstalled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installRelativeLineNumbers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeRelativeLineNumbers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "repaintRelativeLineNumbers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "closeEditorSearchSession";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "editorCreated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "editorDeinit";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifyIdeaJoin";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateCaretsVisualAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateCaretsVisualPosition";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 22 -> new IllegalStateException(string);
        };
    }

    private static class RelativeLineNumberConverter
    implements LineNumberConverter {
        private RelativeLineNumberConverter() {
        }

        public Integer convert(@NotNull Editor editor, int lineNumber) {
            if (editor == null) {
                RelativeLineNumberConverter.$$$reportNull$$$0(0);
            }
            IjVimEditor ijVimEditor = new IjVimEditor(editor);
            boolean number = VimInjectorKt.options((VimInjector)VimInjectorKt.injector, (VimEditor)ijVimEditor).getNumber();
            int caretLine = editor.getCaretModel().getLogicalPosition().line;
            if (lineNumber - 1 == caretLine) {
                return number ? lineNumber : 0;
            }
            int visualLine = ijVimEditor.bufferLineToVisualLine(lineNumber - 1);
            int caretVisualLine = editor.getCaretModel().getVisualPosition().line;
            return Math.abs(caretVisualLine - visualLine);
        }

        public Integer getMaxLineNumber(@NotNull Editor editor) {
            if (editor == null) {
                RelativeLineNumberConverter.$$$reportNull$$$0(1);
            }
            return editor.getDocument().getLineCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = EditorGroup.EDITOR_STORE_ELEMENT;
            objectArray2[1] = "com/maddyhome/idea/vim/group/EditorGroup$RelativeLineNumberConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convert";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMaxLineNumber";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FontSizeChangeListener
    implements PropertyChangeListener {
        public static FontSizeChangeListener INSTANCE = new FontSizeChangeListener();

        private FontSizeChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source;
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (evt.getPropertyName().equals("fontSize") && (source = evt.getSource()) instanceof Editor) {
                VimModalInput modalInput;
                VimOutputPanel outputPanel;
                Editor editor = (Editor)source;
                VimCommandLine activeCommandLine = VimInjectorKt.injector.getCommandLine().getActiveCommandLine();
                if (activeCommandLine != null) {
                    activeCommandLine.close(true, false);
                }
                if ((outputPanel = VimInjectorKt.injector.getOutputPanel().getCurrentOutputPanel()) != null) {
                    outputPanel.close();
                }
                if ((modalInput = VimInjectorKt.injector.getModalInput().getCurrentModalInput()) != null) {
                    modalInput.deactivate(true, false);
                }
            }
        }
    }

    public static class NumberChangeListener
    implements EffectiveOptionValueChangeListener {
        public static NumberChangeListener INSTANCE = new NumberChangeListener();

        @Contract(pure=true)
        private NumberChangeListener() {
        }

        public void onEffectiveValueChanged(@NotNull VimEditor editor) {
            Editor ijEditor;
            if (editor == null) {
                NumberChangeListener.$$$reportNull$$$0(0);
            }
            if (UserDataManager.getVimEditorGroup(ijEditor = ((IjVimEditor)editor).getEditor()) && EditorGroup.supportsVimLineNumbers(ijEditor)) {
                EditorGroup.updateLineNumbers(ijEditor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EditorGroup.EDITOR_STORE_ELEMENT, "com/maddyhome/idea/vim/group/EditorGroup$NumberChangeListener", "onEffectiveValueChanged"));
        }
    }
}

