/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.util.ArrayUtil;
import com.maddyhome.idea.vim.api.LocalOptionValueOverride;
import com.maddyhome.idea.vim.api.OptionValue;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/group/FileEncodingOptionMapper;", "Lcom/maddyhome/idea/vim/api/LocalOptionValueOverride;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimString;", "<init>", "()V", "getLocalValue", "Lcom/maddyhome/idea/vim/api/OptionValue;", "storedValue", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "setLocalValue", "", "newValue", "isSafeToConvertTo", "Lcom/intellij/openapi/vfs/encoding/EncodingUtil$Magic8;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "bytesOnDisk", "", "charset", "Ljava/nio/charset/Charset;", "isSafeToReloadIn", "bytes", "IdeaVIM"})
final class FileEncodingOptionMapper
implements LocalOptionValueOverride<VimString> {
    @NotNull
    public OptionValue<VimString> getLocalValue(@Nullable OptionValue<VimString> storedValue, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = IjVimEditorKt.getIj(editor).getVirtualFile();
        if (virtualFile == null) {
            return (OptionValue)new OptionValue.External((VimDataType)VimString.Companion.getEMPTY());
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getCharset().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return (OptionValue)new OptionValue.External((VimDataType)new VimString(string3));
    }

    public boolean setLocalValue(@Nullable OptionValue<VimString> storedValue, @NotNull OptionValue<VimString> newValue, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (newValue instanceof OptionValue.Default && storedValue == null) {
            return false;
        }
        VirtualFile virtualFile = IjVimEditorKt.getIj(editor).getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        String charsetName = ((VimString)newValue.getValue()).getValue();
        if (StringsKt.isBlank((CharSequence)charsetName)) {
            return false;
        }
        if (!Charset.isSupported(charsetName)) {
            throw ExExceptionsKt.exExceptionMessage((String)"E213", (Object[])new Object[0]);
        }
        byte[] bytes = null;
        try {
            if (virtualFile2.isDirectory()) {
                return false;
            }
            bytes = VfsUtilCore.loadBytes((VirtualFile)virtualFile2);
        }
        catch (IOException e) {
            return false;
        }
        Charset charset = Charset.forName(charsetName);
        Document document = IjVimEditorKt.getIj(editor).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        CharSequence charSequence = text;
        Intrinsics.checkNotNull((Object)charset);
        EncodingUtil.Magic8 isSafeToConvert = this.isSafeToConvertTo(virtualFile2, charSequence, bytes, charset);
        EncodingUtil.Magic8 isSafeToReload = this.isSafeToReloadIn(virtualFile2, text, bytes, charset);
        Project project = IjVimEditorKt.getIj(editor).getProject();
        if (project == null) {
            project = ProjectLocator.Companion.getInstance().guessProjectForFile(virtualFile2);
        }
        Project project2 = project;
        return ChangeFileEncodingAction.changeTo((Project)Objects.requireNonNull(project2), (Document)document2, (Editor)IjVimEditorKt.getIj(editor), (VirtualFile)virtualFile2, (Charset)charset, (EncodingUtil.Magic8)isSafeToConvert, (EncodingUtil.Magic8)isSafeToReload);
    }

    private final EncodingUtil.Magic8 isSafeToConvertTo(VirtualFile virtualFile, CharSequence text, byte[] bytesOnDisk, Charset charset) {
        try {
            CharSequence charSequence;
            String string = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineSeparator(...)");
            String lineSeparator = string;
            if (Intrinsics.areEqual((Object)lineSeparator, (Object)"\n")) {
                charSequence = text;
            } else {
                CharSequence charSequence2 = StringUtilRt.convertLineSeparators((CharSequence)text, (String)lineSeparator);
                charSequence = charSequence2;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"convertLineSeparators(...)");
            }
            CharSequence textToSave = charSequence;
            Pair.NonNull nonNull = LoadTextUtil.chooseMostlyHarmlessCharset((Charset)virtualFile.getCharset(), (Charset)charset, (String)((Object)textToSave).toString());
            Intrinsics.checkNotNullExpressionValue((Object)nonNull, (String)"chooseMostlyHarmlessCharset(...)");
            Pair.NonNull chosen = nonNull;
            byte[] saved = (byte[])chosen.second;
            CharSequence charSequence3 = LoadTextUtil.getTextByBinaryPresentation((byte[])saved, (Charset)charset);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getTextByBinaryPresentation(...)");
            CharSequence textLoadedBack = charSequence3;
            return !StringUtil.equals((CharSequence)text, (CharSequence)textLoadedBack) ? EncodingUtil.Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
    }

    private final EncodingUtil.Magic8 isSafeToReloadIn(VirtualFile virtualFile, CharSequence text, byte[] bytes, Charset charset) {
        byte[] byArray;
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)charset, (byte[])bom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)charset);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        String loaded = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (Charset)charset)).toString();
        String string = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineSeparator(...)");
        String separator = string;
        LoadTextUtil.AutoDetectionReason failReason = LoadTextUtil.getCharsetAutoDetectionReason((VirtualFile)virtualFile);
        if (failReason != null && Intrinsics.areEqual((Object)StandardCharsets.UTF_8, (Object)virtualFile.getCharset()) && !Intrinsics.areEqual((Object)StandardCharsets.UTF_8, (Object)charset)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        try {
            String string2 = StringUtil.convertLineSeparators((String)loaded, (String)separator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(...)");
            byte[] byArray2 = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byArray = byArray2;
        }
        catch (UnsupportedOperationException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        catch (NullPointerException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] bytesToSave = byArray;
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            byte[] byArray3 = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"mergeArrays(...)");
            bytesToSave = byArray3;
        }
        return !Arrays.equals(bytesToSave, bytes) ? EncodingUtil.Magic8.NO_WAY : (StringUtil.equals((CharSequence)loaded, (CharSequence)text) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
    }
}

