/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMotionGroupBase;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.MotionType;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.handler.ExternalActionHandler;
import com.maddyhome.idea.vim.handler.Motion;
import com.maddyhome.idea.vim.handler.MotionActionHandler;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.ScrollHelperKt;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.impl.state.VimStateMachineImpl;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContext;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 *2\u00020\u0001:\u0002)*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J5\u0010\u0012\u001a\u001f0\u0005\u00a2\u0006\u001a\b\u0013\u0012\b\b\u0014\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b\u0015\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\"\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\fH\u0002J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J \u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016JM\u0010#\u001a\u001f0\u0005\u00a2\u0006\u001a\b\u0013\u0012\b\b\u0014\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b\u0015\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006+"}, d2={"Lcom/maddyhome/idea/vim/group/MotionGroup;", "Lcom/maddyhome/idea/vim/api/VimMotionGroupBase;", "<init>", "()V", "moveCaretToFirstDisplayLine", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "count", "normalizeToScreen", "", "moveCaretToLastDisplayLine", "moveCaretToMiddleDisplayLine", "moveCaretToCurrentDisplayLineMiddle", "Lcom/maddyhome/idea/vim/handler/Motion;", "moveCaretToCurrentDisplayLineStart", "moveCaretToCurrentDisplayLineStartSkipLeading", "Lorg/jetbrains/annotations/Range;", "from", "to", "moveCaretToCurrentDisplayLineEnd", "allowEnd", "switchEditorTab", "", "editorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "value", "absolute", "moveCaretGotoPreviousTab", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "rawCount", "moveCaretGotoNextTab", "moveCaretToScreenLocation", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/openapi/editor/Caret;", "screenLocation", "Lcom/maddyhome/idea/vim/group/MotionGroup$ScreenLocation;", "visualLineOffset", "ScreenLocation", "Companion", "IdeaVIM"})
public final class MotionGroup
extends VimMotionGroupBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public int moveCaretToFirstDisplayLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean normalizeToScreen) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.moveCaretToScreenLocation(IjVimEditorKt.getIj(editor), IjVimCaretKt.getIj(caret), ScreenLocation.TOP, count - 1, normalizeToScreen);
    }

    public int moveCaretToLastDisplayLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean normalizeToScreen) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.moveCaretToScreenLocation(IjVimEditorKt.getIj(editor), IjVimCaretKt.getIj(caret), ScreenLocation.BOTTOM, count - 1, normalizeToScreen);
    }

    public int moveCaretToMiddleDisplayLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.moveCaretToScreenLocation(IjVimEditorKt.getIj(editor), IjVimCaretKt.getIj(caret), ScreenLocation.MIDDLE, 0, false);
    }

    @NotNull
    public Motion moveCaretToCurrentDisplayLineMiddle(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int width = EditorHelper.getApproximateScreenWidth(IjVimEditorKt.getIj(editor)) / 2;
        int len = EngineEditorHelperKt.lineLength((VimEditor)editor, (int)editor.currentCaret().getBufferPosition().getLine());
        return this.moveCaretToColumn(editor, caret, Math.max(0, Math.min(len - 1, width)), false);
    }

    @NotNull
    public Motion moveCaretToCurrentDisplayLineStart(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int col = EditorHelper.getVisualColumnAtLeftOfDisplay(IjVimEditorKt.getIj(editor), caret.getVisualPosition().getLine());
        return this.moveCaretToColumn(editor, caret, col, false);
    }

    public int moveCaretToCurrentDisplayLineStartSkipLeading(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int col = EditorHelper.getVisualColumnAtLeftOfDisplay(IjVimEditorKt.getIj(editor), caret.getVisualPosition().getLine());
        int bufferLine = caret.getLine();
        return EngineEditorHelperKt.getLeadingCharacterOffset((VimEditor)editor, (int)bufferLine, (int)col);
    }

    @NotNull
    public Motion moveCaretToCurrentDisplayLineEnd(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, boolean allowEnd) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int col = EditorHelper.getVisualColumnAtRightOfDisplay(IjVimEditorKt.getIj(editor), caret.getVisualPosition().getLine());
        return this.moveCaretToColumn(editor, caret, col, allowEnd);
    }

    private final void switchEditorTab(EditorWindow editorWindow, int value, boolean absolute) {
        if (editorWindow != null) {
            EditorTabbedContainer tabbedPane = editorWindow.getTabbedPane();
            if (absolute) {
                v0 = tabbedPane.setSelectedIndex(value);
            } else {
                int tabIndex = (value + tabbedPane.getSelectedIndex()) % tabbedPane.getTabCount();
                int newIndex = tabIndex < 0 ? tabIndex + tabbedPane.getTabCount() : tabIndex;
                v0 = tabbedPane.setSelectedIndex(newIndex);
            }
        }
    }

    public int moveCaretGotoPreviousTab(@NotNull VimEditor editor, @NotNull ExecutionContext context, int rawCount) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = IjVimEditorKt.getIj(editor).getProject();
        if (project == null) {
            return editor.currentCaret().getOffset();
        }
        Project project2 = project;
        EditorWindow currentWindow = FileEditorManagerEx.Companion.getInstanceEx(project2).getSplitters().getCurrentWindow();
        this.switchEditorTab(currentWindow, rawCount >= 1 ? -rawCount : -1, false);
        return editor.currentCaret().getOffset();
    }

    public int moveCaretGotoNextTab(@NotNull VimEditor editor, @NotNull ExecutionContext context, int rawCount) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean absolute = rawCount >= 1;
        Project project = IjVimEditorKt.getIj(editor).getProject();
        if (project == null) {
            return editor.currentCaret().getOffset();
        }
        Project project2 = project;
        EditorWindow currentWindow = FileEditorManagerEx.Companion.getInstanceEx(project2).getSplitters().getCurrentWindow();
        this.switchEditorTab(currentWindow, absolute ? rawCount - 1 : 1, absolute);
        return editor.currentCaret().getOffset();
    }

    private final int moveCaretToScreenLocation(Editor editor, Caret caret, ScreenLocation screenLocation, int visualLineOffset, boolean normalizeToScreen) {
        VimEditor vimEditor = IjVimEditorKt.getVim(editor);
        int scrollOffset = normalizeToScreen ? ScrollHelperKt.getNormalizedScrollOffset(editor) : 0;
        int maxVisualLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)vimEditor);
        int topVisualLine = EditorHelper.getVisualLineAtTopOfScreen(editor);
        int topScrollOff = topVisualLine > 0 ? scrollOffset : 0;
        int bottomVisualLine = EditorHelper.getVisualLineAtBottomOfScreen(editor);
        int bottomScrollOff = bottomVisualLine < maxVisualLine - 1 ? scrollOffset : 0;
        int topMaxVisualLine = normalizeToScreen ? bottomVisualLine - bottomScrollOff : maxVisualLine;
        int bottomMinVisualLine = normalizeToScreen ? topVisualLine + topScrollOff : 0;
        int targetVisualLine = switch (WhenMappings.$EnumSwitchMapping$0[screenLocation.ordinal()]) {
            case 1 -> Math.min(topVisualLine + Math.max(topScrollOff, visualLineOffset), topMaxVisualLine);
            case 2 -> EditorHelper.getVisualLineAtMiddleOfScreen(editor);
            case 3 -> Math.max(bottomVisualLine - Math.max(bottomScrollOff, visualLineOffset), bottomMinVisualLine);
            default -> throw new NoWhenBranchMatchedException();
        };
        int targetLogicalLine = EngineEditorHelperKt.visualLineToBufferLine((VimEditor)vimEditor, (int)targetVisualLine);
        return this.moveCaretToLineWithStartOfLineOption(vimEditor, targetLogicalLine, (ImmutableVimCaret)IjVimCaretKt.getVim(caret));
    }

    @JvmStatic
    @Nullable
    public static final TextRange getMotionRange2(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        return Companion.getMotionRange2(editor, caret, context, argument, operatorArguments);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/group/MotionGroup$Companion;", "", "<init>", "()V", "getMotionRange2", "Lcom/maddyhome/idea/vim/common/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "moveCaretToView", "", "fileEditorManagerSelectionChangedCallback", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final TextRange getMotionRange2(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            if (!(argument instanceof Argument.Motion)) {
                throw new RuntimeException("Unexpected argument passed to getMotionRange2: " + argument);
            }
            start = 0;
            end = 0;
            action = ((Argument.Motion)argument).getMotion();
            var9_9 = action;
            if (var9_9 instanceof MotionActionHandler) {
                start = caret.getOffset();
                v0 = (MotionActionHandler)action;
                v1 = IjVimEditorKt.getVim(editor);
                v2 = (ImmutableVimCaret)IjVimCaretKt.getVim(caret);
                v3 = context;
                Intrinsics.checkNotNull((Object)v3);
                motion = v0.getHandlerOffset(v1, v2, (ExecutionContext)new IjEditorExecutionContext(v3), ((Argument.Motion)argument).getArgument(), operatorArguments);
                if (Intrinsics.areEqual((Object)Motion.Error.INSTANCE, (Object)motion)) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)Motion.NoMotion.INSTANCE, (Object)motion)) {
                    return null;
                }
                Intrinsics.checkNotNull((Object)motion, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.Motion.AbsoluteOffset");
                end = ((Motion.AbsoluteOffset)motion).getOffset();
                if (((MotionActionHandler)action).getMotionType() == MotionType.INCLUSIVE && (long)end < IjVimEditorKt.getVim(editor).fileSize()) {
                    if (start > end) {
                        ++start;
                    } else {
                        ++end;
                    }
                }
            } else if (var9_9 instanceof TextObjectActionHandler) {
                v4 = (TextObjectActionHandler)action;
                v5 = IjVimEditorKt.getVim(editor);
                v6 = (ImmutableVimCaret)IjVimCaretKt.getVim(caret);
                v7 = context;
                Intrinsics.checkNotNull((Object)v7);
                v8 = v4.getRange(v5, v6, (ExecutionContext)new IjEditorExecutionContext(v7), operatorArguments.getCount1(), operatorArguments.getCount0());
                if (v8 == null) {
                    return null;
                }
                range = v8;
                start = range.getStartOffset();
                end = range.getEndOffset();
                if (((Argument.Motion)argument).isLinewiseMotion()) {
                    --end;
                }
            } else if (var9_9 instanceof ExternalActionHandler) {
                v9 = ((ExternalActionHandler)action).getRange((ImmutableVimCaret)IjVimCaretKt.getVim(caret));
                if (v9 == null) {
                    return null;
                }
                range = v9;
                start = range.getStartOffset();
                end = range.getEndOffset();
            } else {
                throw new RuntimeException("Commands doesn't take " + action.getClass().getSimpleName() + " as an operator");
            }
            id = ((Argument.Motion)argument).getMotion().getId();
            switch (id.hashCode()) {
                case -1839425192: {
                    if (!id.equals("VimMotionBigWordRightAction")) {
                        break;
                    }
                    ** GOTO lbl67
                }
                case 706646936: {
                    if (!id.equals("VimMotionWordRightAction")) {
                        break;
                    }
                    ** GOTO lbl67
                }
                case 1101678924: {
                    if (!id.equals("VimMotionCamelRightAction")) break;
lbl67:
                    // 3 sources

                    if ((lastNewLine = StringsKt.lastIndexOf$default((CharSequence)(text = editor.getDocument().getCharsSequence().subSequence(start, end).toString()), (char)'\n', (int)0, (boolean)false, (int)6, null)) <= 0 || EngineEditorHelperKt.anyNonWhitespace((VimEditor)IjVimEditorKt.getVim(editor), (int)end, (int)-1)) break;
                    end = start + lastNewLine;
                }
            }
            return new TextRange(start, end);
        }

        public final void moveCaretToView(@NotNull Editor editor) {
            int caretColumn;
            int oldColumn;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            VimEditor vimEditor = IjVimEditorKt.getVim(editor);
            int scrollOffset = ScrollHelperKt.getNormalizedScrollOffset(editor);
            int topVisualLine = EditorHelper.getVisualLineAtTopOfScreen(editor);
            int bottomVisualLine = EditorHelper.getVisualLineAtBottomOfScreen(editor);
            int caretVisualLine = editor.getCaretModel().getVisualPosition().line;
            int lastVisualLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)vimEditor) - 1;
            int newVisualLine = caretVisualLine < topVisualLine + scrollOffset ? EngineEditorHelperKt.normalizeVisualLine((VimEditor)vimEditor, (int)(topVisualLine + scrollOffset)) : (bottomVisualLine < lastVisualLine && caretVisualLine > bottomVisualLine - scrollOffset ? EngineEditorHelperKt.normalizeVisualLine((VimEditor)vimEditor, (int)(bottomVisualLine - scrollOffset)) : caretVisualLine);
            int sideScrollOffset = ScrollHelperKt.getNormalizedSideScrollOffset(editor);
            int col = oldColumn = editor.getCaretModel().getVisualPosition().column;
            if (col >= EngineEditorHelperKt.lineLength((VimEditor)vimEditor, (int)vimEditor.currentCaret().getBufferPosition().getLine()) - 1) {
                Caret caret = editor.getCaretModel().getPrimaryCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
                col = UserDataManager.getVimLastColumn(caret);
            }
            int leftVisualColumn = EditorHelper.getVisualColumnAtLeftOfDisplay(editor, newVisualLine);
            int rightVisualColumn = EditorHelper.getVisualColumnAtRightOfDisplay(editor, newVisualLine);
            int newColumn = caretColumn = col;
            if (leftVisualColumn > 0 && caretColumn < leftVisualColumn + sideScrollOffset) {
                newColumn = leftVisualColumn + sideScrollOffset;
            } else if (caretColumn > rightVisualColumn - sideScrollOffset) {
                newColumn = rightVisualColumn - sideScrollOffset;
            }
            if (newVisualLine == caretVisualLine && newColumn != caretColumn) {
                col = newColumn;
            }
            newColumn = EditorHelper.normalizeVisualColumn(editor, newVisualLine, newColumn, EngineHelperKt.isEndAllowed((VimEditor)IjVimEditorKt.getVim(editor)));
            if (newVisualLine != caretVisualLine || newColumn != oldColumn) {
                int offset = editor.visualPositionToOffset(new VisualPosition(newVisualLine, newColumn));
                vimEditor.primaryCaret().moveToOffset(offset);
                Caret caret = editor.getCaretModel().getPrimaryCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
                UserDataManager.setVimLastColumn(caret, col);
            }
        }

        public final void fileEditorManagerSelectionChangedCallback(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            FileEditor fileEditor = event.getOldEditor();
            if (fileEditor instanceof TextEditor) {
                Editor editor = ((TextEditor)fileEditor).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (!editor2.isDisposed()) {
                    VimEditor vimEditor = IjVimEditorKt.getVim(editor2);
                    boolean bl = false;
                    Mode mode2 = vimEditor.getMode();
                    if (mode2 instanceof Mode.VISUAL) {
                        EngineModeExtensionsKt.exitVisualMode((VimEditor)vimEditor);
                        KeyHandler.Companion.getInstance().reset(vimEditor);
                    } else if (mode2 instanceof Mode.CMD_LINE) {
                        VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
                        if (vimCommandLine == null) {
                            return;
                        }
                        VimCommandLine commandLine = vimCommandLine;
                        commandLine.close(false, false);
                        VimOutputPanel vimOutputPanel = VimInjectorKt.getInjector().getOutputPanel().getCurrentOutputPanel();
                        if (vimOutputPanel != null) {
                            vimOutputPanel.close();
                        }
                    }
                }
            } else {
                VimStateMachine vimStateMachine = VimInjectorKt.getInjector().getVimState();
                Intrinsics.checkNotNull((Object)vimStateMachine, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.impl.state.VimStateMachineImpl");
                VimStateMachineImpl state = (VimStateMachineImpl)vimStateMachine;
                if (state.getMode() instanceof Mode.VISUAL) {
                    state.setMode(state.getMode().getReturnTo());
                }
                KeyHandler keyHandler = KeyHandler.Companion.getInstance();
                KeyHandler.Companion.getInstance().reset(keyHandler.getKeyHandlerState(), state.getMode());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/group/MotionGroup$ScreenLocation;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "MIDDLE", "BOTTOM", "IdeaVIM"})
    private static final class ScreenLocation
    extends Enum<ScreenLocation> {
        public static final /* enum */ ScreenLocation TOP = new ScreenLocation();
        public static final /* enum */ ScreenLocation MIDDLE = new ScreenLocation();
        public static final /* enum */ ScreenLocation BOTTOM = new ScreenLocation();
        private static final /* synthetic */ ScreenLocation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScreenLocation[] values() {
            return (ScreenLocation[])$VALUES.clone();
        }

        public static ScreenLocation valueOf(String value) {
            return Enum.valueOf(ScreenLocation.class, value);
        }

        @NotNull
        public static EnumEntries<ScreenLocation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = screenLocationArray = new ScreenLocation[]{ScreenLocation.TOP, ScreenLocation.MIDDLE, ScreenLocation.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScreenLocation.values().length];
            try {
                nArray[ScreenLocation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScreenLocation.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScreenLocation.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

