/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PatternUtil;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.group.InternalOptionValueAccessor;
import com.maddyhome.idea.vim.group.LocalOptionToGlobalLocalIdeaSettingMapper;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.ToggleOption;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import java.awt.Container;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/group/WrapOptionMapper;", "Lcom/maddyhome/idea/vim/group/LocalOptionToGlobalLocalIdeaSettingMapper;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "wrapOption", "Lcom/maddyhome/idea/vim/options/ToggleOption;", "internalOptionValueAccessor", "Lcom/maddyhome/idea/vim/group/InternalOptionValueAccessor;", "<init>", "(Lcom/maddyhome/idea/vim/options/ToggleOption;Lcom/maddyhome/idea/vim/group/InternalOptionValueAccessor;)V", "canUserModifyExternalLocalValue", "", "getCanUserModifyExternalLocalValue", "()Z", "getGlobalExternalValue", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getEffectiveExternalValue", "setLocalExternalValue", "", "value", "canInitialiseOptionFrom", "sourceEditor", "targetEditor", "getGlobalIsUseSoftWraps", "getEffectiveIsUseSoftWraps", "setIsUseSoftWraps", "onGlobalIdeaValueChanged", "propertyName", "", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nOptionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionGroup.kt\ncom/maddyhome/idea/vim/group/WrapOptionMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1356:1\n1869#2,2:1357\n*S KotlinDebug\n*F\n+ 1 OptionGroup.kt\ncom/maddyhome/idea/vim/group/WrapOptionMapper\n*L\n1290#1:1357,2\n*E\n"})
final class WrapOptionMapper
extends LocalOptionToGlobalLocalIdeaSettingMapper<VimInt> {
    private final boolean canUserModifyExternalLocalValue;

    public WrapOptionMapper(@NotNull ToggleOption wrapOption, @NotNull InternalOptionValueAccessor internalOptionValueAccessor) {
        Intrinsics.checkNotNullParameter((Object)wrapOption, (String)"wrapOption");
        Intrinsics.checkNotNullParameter((Object)internalOptionValueAccessor, (String)"internalOptionValueAccessor");
        super((Option)wrapOption, internalOptionValueAccessor);
        this.canUserModifyExternalLocalValue = true;
    }

    protected boolean getCanUserModifyExternalLocalValue() {
        return this.canUserModifyExternalLocalValue;
    }

    @NotNull
    protected VimInt getGlobalExternalValue(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return VimIntKt.asVimInt((boolean)this.getGlobalIsUseSoftWraps(editor));
    }

    @NotNull
    protected VimInt getEffectiveExternalValue(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return VimIntKt.asVimInt((boolean)this.getEffectiveIsUseSoftWraps(editor));
    }

    protected void setLocalExternalValue(@NotNull VimEditor editor, @NotNull VimInt value) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setIsUseSoftWraps(editor, value.getBooleanValue());
    }

    public boolean canInitialiseOptionFrom(@NotNull VimEditor sourceEditor, @NotNull VimEditor targetEditor) {
        Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
        Intrinsics.checkNotNullParameter((Object)targetEditor, (String)"targetEditor");
        EditorKind editorKind = IjVimEditorKt.getIj(sourceEditor).getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
        SoftWrapAppliancePlaces sourceKind = WrapOptionMapper.canInitialiseOptionFrom$editorKindToSoftWrapAppliancesPlace(editorKind);
        EditorKind editorKind2 = IjVimEditorKt.getIj(targetEditor).getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind2, (String)"getEditorKind(...)");
        SoftWrapAppliancePlaces targetKind = WrapOptionMapper.canInitialiseOptionFrom$editorKindToSoftWrapAppliancesPlace(editorKind2);
        return sourceKind == targetKind;
    }

    private final boolean getGlobalIsUseSoftWraps(VimEditor editor) {
        SoftWrapAppliancePlaces softWrapAppliancePlace = switch (WhenMappings.$EnumSwitchMapping$0[IjVimEditorKt.getIj(editor).getEditorKind().ordinal()]) {
            case 1, 2, 3 -> SoftWrapAppliancePlaces.MAIN_EDITOR;
            case 4 -> SoftWrapAppliancePlaces.CONSOLE;
            case 5 -> SoftWrapAppliancePlaces.PREVIEW;
            default -> throw new NoWhenBranchMatchedException();
        };
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (softWrapAppliancePlace == SoftWrapAppliancePlaces.MAIN_EDITOR) {
            if (settings.isUseSoftWraps()) {
                String string = settings.getSoftWrapFileMasks();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSoftWrapFileMasks(...)");
                String masks = string;
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)masks)).toString(), (Object)"*")) {
                    return true;
                }
                VirtualFile virtualFile = IjVimEditorKt.getIj(editor).getVirtualFile();
                if (virtualFile != null) {
                    VirtualFile file = virtualFile;
                    boolean bl = false;
                    String[] stringArray = new String[]{";"};
                    Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)masks, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String mask = (String)element$iv;
                        boolean bl2 = false;
                        String trimmed = ((Object)StringsKt.trim((CharSequence)mask)).toString();
                        if (!(((CharSequence)trimmed).length() > 0) || !PatternUtil.fromMask((String)trimmed).matcher(file.getName()).matches()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return settings.isUseSoftWraps(softWrapAppliancePlace);
    }

    private final boolean getEffectiveIsUseSoftWraps(VimEditor editor) {
        return IjVimEditorKt.getIj(editor).getSettings().isUseSoftWraps();
    }

    private final void setIsUseSoftWraps(VimEditor editor, boolean value) {
        block0: {
            Editor editor2;
            Object object;
            IjVimEditorKt.getIj(editor).getSettings().setUseSoftWraps(value);
            if (!ApplicationManager.getApplication().isUnitTestMode() || (object = (editor2 = IjVimEditorKt.getIj(editor)) instanceof EditorEx ? (EditorEx)editor2 : null) == null || (object = object.getScrollPane()) == null || (object = ((JScrollPane)object).getViewport()) == null) break block0;
            ((Container)object).doLayout();
        }
    }

    @Override
    public void onGlobalIdeaValueChanged(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        if (Intrinsics.areEqual((Object)propertyName, (Object)"useSoftWraps") || Intrinsics.areEqual((Object)propertyName, (Object)"softWrapFileMasks")) {
            this.doOnGlobalIdeaValueChanged();
        }
    }

    private static final SoftWrapAppliancePlaces canInitialiseOptionFrom$editorKindToSoftWrapAppliancesPlace(EditorKind kind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1, 2, 3 -> SoftWrapAppliancePlaces.MAIN_EDITOR;
            case 4 -> SoftWrapAppliancePlaces.CONSOLE;
            case 5 -> SoftWrapAppliancePlaces.MAIN_EDITOR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EditorKind.values().length];
            try {
                nArray[EditorKind.UNTYPED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EditorKind.DIFF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EditorKind.MAIN_EDITOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EditorKind.CONSOLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EditorKind.PREVIEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

