/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group.visual;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Computable;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.StringListOptionValue;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.group.visual.VimVisualTimer;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.HelperKt;
import com.maddyhome.idea.vim.helper.ModeHelper;
import com.maddyhome.idea.vim.helper.VimLockLabel;
import com.maddyhome.idea.vim.listener.VimListenerManager;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelper;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelperKt;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000fH\u0003R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/group/visual/IdeaSelectionControl;", "", "<init>", "()V", "controlNonVimSelectionChange", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "selectionSource", "Lcom/maddyhome/idea/vim/listener/VimListenerManager$SelectionSource;", "predictMode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "activateMode", "mode", "dontChangeMode", "", "chooseNonSelectionMode", "chooseSelectionMode", "logReason", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nIdeaSelectionControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaSelectionControl.kt\ncom/maddyhome/idea/vim/group/visual/IdeaSelectionControl\n+ 2 VimVisualTimer.kt\ncom/maddyhome/idea/vim/group/visual/VimVisualTimer\n*L\n1#1,203:1\n62#2,10:204\n*S KotlinDebug\n*F\n+ 1 IdeaSelectionControl.kt\ncom/maddyhome/idea/vim/group/visual/IdeaSelectionControl\n*L\n61#1:204,10\n*E\n"})
public final class IdeaSelectionControl {
    @NotNull
    public static final IdeaSelectionControl INSTANCE = new IdeaSelectionControl();
    @NotNull
    private static final Logger logger;

    private IdeaSelectionControl() {
    }

    /*
     * WARNING - void declaration
     */
    public final void controlNonVimSelectionChange(@NotNull Editor editor, @NotNull VimListenerManager.SelectionSource selectionSource) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionSource), (String)"selectionSource");
        VimVisualTimer vimVisualTimer = VimVisualTimer.INSTANCE;
        Mode currentMode$iv = IjVimEditorKt.getVim(editor).getMode();
        boolean $i$f$singleTask = false;
        Timer timer2 = this_$iv.getSwingTimer();
        if (timer2 != null) {
            timer2.stop();
        }
        if (this_$iv.getMode() == null) {
            this_$iv.setMode(currentMode$iv);
        }
        Timer timer$iv = new Timer(IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getVisualdelay(), new ActionListener(editor, selectionSource){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ VimListenerManager.SelectionSource $selectionSource$inlined;
            {
                this.$editor$inlined = editor;
                this.$selectionSource$inlined = selectionSource;
            }

            public final void actionPerformed(ActionEvent it) {
                VimVisualTimer this_$iv;
                block6: {
                    block11: {
                        block8: {
                            block10: {
                                block9: {
                                    Boolean hasSelection2;
                                    block7: {
                                        this_$iv = VimVisualTimer.INSTANCE;
                                        boolean $i$f$timerAction = false;
                                        Mode initialMode = this_$iv.getMode();
                                        boolean bl = false;
                                        if (HelperKt.vimDisabled(this.$editor$inlined)) break block6;
                                        IdeaSelectionControl.access$getLogger$p().debug("Adjust non-vim selection. Source: " + this.$selectionSource$inlined + ", initialMode: " + initialMode);
                                        hasSelection2 = (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(this.$editor$inlined){
                                            final /* synthetic */ Editor $editor;
                                            {
                                                this.$editor = $editor;
                                            }

                                            public final Boolean compute() {
                                                return this.$editor.getSelectionModel().hasSelection(true);
                                            }
                                        });
                                        Mode mode2 = initialMode;
                                        boolean bl2 = mode2 != null ? !CommandStateHelper.getHasVisualSelection(mode2) : false;
                                        if (!bl2 || hasSelection2.booleanValue()) break block7;
                                        Logger $this$trace$iv = IdeaSelectionControl.access$getLogger$p();
                                        boolean $i$f$trace = false;
                                        if ($this$trace$iv.isTraceEnabled()) {
                                            Logger logger = $this$trace$iv;
                                            boolean bl3 = false;
                                            logger.trace("Exiting without selection adjusting");
                                        }
                                        break block6;
                                    }
                                    if (!hasSelection2.booleanValue()) break block8;
                                    if (!EditorExtensionsKt.getInCommandLineMode((VimEditor)IjVimEditorKt.getVim(this.$editor$inlined)) || !CommandStateHelper.getHasVisualSelection(IjVimEditorKt.getVim(this.$editor$inlined).getMode().getReturnTo())) break block9;
                                    Logger $this$trace$iv = IdeaSelectionControl.access$getLogger$p();
                                    boolean $i$f$trace = false;
                                    if ($this$trace$iv.isTraceEnabled()) {
                                        Logger logger = $this$trace$iv;
                                        boolean bl = false;
                                        logger.trace("Modifying selection while in Command-line mode, most likely incsearch");
                                    }
                                    break block6;
                                }
                                if (!IdeaSelectionControl.access$dontChangeMode(IdeaSelectionControl.INSTANCE, this.$editor$inlined)) break block10;
                                IdeaRefactorModeHelper.INSTANCE.correctEditorSelection(this.$editor$inlined);
                                Logger $this$trace$iv = IdeaSelectionControl.access$getLogger$p();
                                boolean $i$f$trace = false;
                                if ($this$trace$iv.isTraceEnabled()) {
                                    Logger logger = $this$trace$iv;
                                    boolean bl = false;
                                    logger.trace("Selection corrected for refactoring");
                                }
                                break block6;
                            }
                            IdeaSelectionControl.access$getLogger$p().debug("Some carets have selection. State before adjustment: " + IjVimEditorKt.getVim(this.$editor$inlined).getMode());
                            IjVimEditorKt.getVim(this.$editor$inlined).setMode((Mode)new Mode.NORMAL(null, 1, null));
                            Mode mode3 = (Mode)VimInjectorKt.getInjector().getApplication().runReadAction((Function0)new Function0<Mode>(this.$editor$inlined, this.$selectionSource$inlined){
                                final /* synthetic */ Editor $editor;
                                final /* synthetic */ VimListenerManager.SelectionSource $selectionSource;
                                {
                                    this.$editor = $editor;
                                    this.$selectionSource = $selectionSource;
                                }

                                public final Mode invoke() {
                                    return IdeaSelectionControl.access$chooseSelectionMode(IdeaSelectionControl.INSTANCE, this.$editor, this.$selectionSource, true);
                                }
                            });
                            IdeaSelectionControl.access$activateMode(IdeaSelectionControl.INSTANCE, this.$editor$inlined, mode3);
                            break block11;
                        }
                        IdeaSelectionControl.access$getLogger$p().debug("None of carets have selection. State before adjustment: " + IjVimEditorKt.getVim(this.$editor$inlined).getMode());
                        if (EditorExtensionsKt.getInVisualMode((VimEditor)IjVimEditorKt.getVim(this.$editor$inlined))) {
                            EngineModeExtensionsKt.exitVisualMode((VimEditor)IjVimEditorKt.getVim(this.$editor$inlined));
                        }
                        if (EditorExtensionsKt.getInSelectMode((VimEditor)IjVimEditorKt.getVim(this.$editor$inlined))) {
                            ModeHelper.exitSelectMode(IjVimEditorKt.getVim(this.$editor$inlined), false);
                        }
                        if (EditorExtensionsKt.getInNormalMode((VimEditor)IjVimEditorKt.getVim(this.$editor$inlined))) {
                            IdeaSelectionControl.access$activateMode(IdeaSelectionControl.INSTANCE, this.$editor$inlined, IdeaSelectionControl.access$chooseNonSelectionMode(IdeaSelectionControl.INSTANCE, this.$editor$inlined));
                        }
                    }
                    KeyHandler.Companion.getInstance().reset(IjVimEditorKt.getVim(this.$editor$inlined));
                    IdeaSelectionControl.access$getLogger$p().debug(IjVimEditorKt.getVim(this.$editor$inlined).getMode() + " is enabled");
                }
                this_$iv.setSwingTimer(null);
                this_$iv.setMode(null);
            }
        });
        timer$iv.setRepeats(false);
        timer$iv.start();
        this_$iv.setSwingTimer(timer$iv);
    }

    public static /* synthetic */ void controlNonVimSelectionChange$default(IdeaSelectionControl ideaSelectionControl, Editor editor, VimListenerManager.SelectionSource selectionSource, int n, Object object) {
        if ((n & 2) != 0) {
            selectionSource = VimListenerManager.SelectionSource.OTHER;
        }
        ideaSelectionControl.controlNonVimSelectionChange(editor, selectionSource);
    }

    @VimLockLabel.RequiresReadLock
    @RequiresReadLock
    @NotNull
    public final Mode predictMode(@NotNull Editor editor, @NotNull VimListenerManager.SelectionSource selectionSource) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionSource), (String)"selectionSource");
        if (editor.getSelectionModel().hasSelection(true)) {
            if (this.dontChangeMode(editor)) {
                return IjVimEditorKt.getVim(editor).getMode();
            }
            return this.chooseSelectionMode(editor, selectionSource, false);
        }
        return this.chooseNonSelectionMode(editor);
    }

    private final void activateMode(Editor editor, Mode mode2) {
        Mode mode3 = mode2;
        if (mode3 instanceof Mode.VISUAL) {
            VimPlugin.getVisualMotion().enterVisualMode(IjVimEditorKt.getVim(editor), ((Mode.VISUAL)mode2).getSelectionType());
        } else if (mode3 instanceof Mode.SELECT) {
            VimPlugin.getVisualMotion().enterSelectMode(IjVimEditorKt.getVim(editor), ((Mode.SELECT)mode2).getSelectionType());
        } else if (mode3 instanceof Mode.INSERT) {
            VimPlugin.getChange().insertBeforeCaret(IjVimEditorKt.getVim(editor), VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext(IjVimEditorKt.getVim(editor)));
        } else if (!(mode3 instanceof Mode.NORMAL)) {
            throw new IllegalStateException(("Unexpected mode: " + mode2).toString());
        }
    }

    private final boolean dontChangeMode(Editor editor) {
        return HelperKt.isTemplateActive(editor) && (IdeaRefactorModeHelperKt.isIdeaRefactorModeKeep(IjVimEditorKt.getVim(editor)) || CommandStateHelper.getHasVisualSelection(IjVimEditorKt.getVim(editor).getMode()));
    }

    private final Mode chooseNonSelectionMode(Editor editor) {
        if (HelperKt.isTemplateActive(editor) && CommandStateHelper.getInNormalMode(IjVimEditorKt.getVim(editor).getMode()) && IdeaRefactorModeHelperKt.isIdeaRefactorModeSelect(IjVimEditorKt.getVim(editor)) || CommandStateHelper.inInsertMode(editor)) {
            return (Mode)Mode.INSERT.INSTANCE;
        }
        return (Mode)new Mode.NORMAL(null, 1, null);
    }

    @VimLockLabel.RequiresReadLock
    @RequiresReadLock
    private final Mode chooseSelectionMode(Editor editor, VimListenerManager.SelectionSource selectionSource, boolean logReason) {
        Mode mode2;
        StringListOptionValue selectmode = VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)IjVimEditorKt.getVim(editor)).getSelectmode();
        if (editor.isOneLineMode()) {
            if (logReason) {
                logger.debug("Enter select mode. Reason: one line mode");
            }
            mode2 = (Mode)new Mode.SELECT(VimPlugin.getVisualMotion().detectSelectionType(IjVimEditorKt.getVim(editor)), null, 2, null);
        } else if (selectionSource == VimListenerManager.SelectionSource.MOUSE && selectmode.contains((Object)"mouse")) {
            if (logReason) {
                logger.debug("Enter select mode. Selection source is mouse and selectMode option has mouse");
            }
            mode2 = (Mode)new Mode.SELECT(VimPlugin.getVisualMotion().detectSelectionType(IjVimEditorKt.getVim(editor)), null, 2, null);
        } else if (HelperKt.isTemplateActive(editor) && IdeaRefactorModeHelperKt.isIdeaRefactorModeSelect(IjVimEditorKt.getVim(editor))) {
            if (logReason) {
                logger.debug("Enter select mode. Template is active and selectMode has template");
            }
            mode2 = (Mode)new Mode.SELECT(VimPlugin.getVisualMotion().detectSelectionType(IjVimEditorKt.getVim(editor)), null, 2, null);
        } else if (selectionSource == VimListenerManager.SelectionSource.OTHER && selectmode.contains((Object)"ideaselection")) {
            if (logReason) {
                logger.debug("Enter select mode. Selection source is OTHER and selectMode has refactoring");
            }
            mode2 = (Mode)new Mode.SELECT(VimPlugin.getVisualMotion().detectSelectionType(IjVimEditorKt.getVim(editor)), null, 2, null);
        } else {
            if (logReason) {
                logger.debug("Enter visual mode");
            }
            mode2 = (Mode)new Mode.VISUAL(VimPlugin.getVisualMotion().detectSelectionType(IjVimEditorKt.getVim(editor)), null, 2, null);
        }
        return mode2;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ boolean access$dontChangeMode(IdeaSelectionControl $this, Editor editor) {
        return $this.dontChangeMode(editor);
    }

    public static final /* synthetic */ Mode access$chooseSelectionMode(IdeaSelectionControl $this, Editor editor, VimListenerManager.SelectionSource selectionSource, boolean logReason) {
        return $this.chooseSelectionMode(editor, selectionSource, logReason);
    }

    public static final /* synthetic */ void access$activateMode(IdeaSelectionControl $this, Editor editor, Mode mode2) {
        $this.activateMode(editor, mode2);
    }

    public static final /* synthetic */ Mode access$chooseNonSelectionMode(IdeaSelectionControl $this, Editor editor) {
        return $this.chooseNonSelectionMode(editor);
    }

    static {
        Logger logger = Logger.getInstance(IdeaSelectionControl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IdeaSelectionControl.logger = logger;
    }
}

