/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.IndentConfig;
import com.maddyhome.idea.vim.newapi.IjVimDocument;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.ui.ex.ExEntryPanel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHelper {
    private static final int BLOCK_INLAY_MAX_LINE_HEIGHT = 3;

    @NotNull
    public static Rectangle getVisibleArea(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(0);
        }
        Rectangle rectangle = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        if (rectangle == null) {
            EditorHelper.$$$reportNull$$$0(1);
        }
        return rectangle;
    }

    public static boolean scrollVertically(@NotNull Editor editor, int verticalOffset) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(2);
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        Rectangle area = scrollingModel.getVisibleAreaOnScrollingFinished();
        scrollingModel.scroll(area.x, verticalOffset);
        if (area.y != verticalOffset && area.y >= 0) {
            VimInjectorKt.injector.getRedrawService().redraw();
        }
        return scrollingModel.getVisibleAreaOnScrollingFinished().y != area.y;
    }

    public static void scrollHorizontally(@NotNull Editor editor, int horizontalOffset) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(3);
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        Rectangle area = scrollingModel.getVisibleAreaOnScrollingFinished();
        scrollingModel.scroll(horizontalOffset, area.y);
        if (area.x != horizontalOffset && area.x >= 0) {
            VimInjectorKt.injector.getRedrawService().redraw();
        }
    }

    public static int getVisualLineAtTopOfScreen(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(4);
        }
        Rectangle visibleArea = EditorHelper.getVisibleArea(editor);
        return EditorHelper.getFullVisualLine(editor, visibleArea.y, visibleArea.y, visibleArea.y + visibleArea.height);
    }

    public static int getVisualLineAtMiddleOfScreen(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(5);
        }
        int lastLineBaseline = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)new IjVimEditor((Editor)editor).lineCount(), (int)0)).y;
        Rectangle visibleArea = EditorHelper.getVisibleArea(editor);
        int height = Integer.min(lastLineBaseline - visibleArea.y, visibleArea.height);
        return editor.yToVisualLine(visibleArea.y + height / 2);
    }

    public static int getNonNormalizedVisualLineAtBottomOfScreen(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(6);
        }
        Rectangle visibleArea = EditorHelper.getVisibleArea(editor);
        int height = visibleArea.height - EditorHelper.getExEntryHeight() - EditorHelper.getHorizontalScrollbarHeight(editor);
        return EditorHelper.getFullVisualLine(editor, visibleArea.y + height, visibleArea.y, visibleArea.y + height);
    }

    public static int getVisualLineAtBottomOfScreen(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(7);
        }
        int line = EditorHelper.getNonNormalizedVisualLineAtBottomOfScreen(editor);
        return EngineEditorHelperKt.normalizeVisualLine((VimEditor)new IjVimEditor(editor), (int)line);
    }

    public static int getVisualLineLength(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(8);
        }
        return EditorUtil.getLastVisualLineColumnNumber((Editor)editor, (int)visualLine);
    }

    public static int normalizeVisualColumn(@NotNull Editor editor, int visualLine, int col, boolean allowEnd) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(9);
        }
        return Integer.max(0, Integer.min(col, EditorHelper.getVisualLineLength(editor, visualLine) - (allowEnd ? 0 : 1)));
    }

    public static int normalizeScrollOffset(@NotNull Editor editor, int scrollOffset) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(10);
        }
        return Math.min(scrollOffset, EditorHelper.getApproximateScreenHeight(editor) / 2);
    }

    public static int normalizeSideScrollOffset(@NotNull Editor editor, int sideScrollOffset) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(11);
        }
        return Math.min(sideScrollOffset, EditorHelper.getApproximateScreenWidth(editor) / 2);
    }

    public static int getApproximateScreenHeight(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(12);
        }
        return EditorHelper.getVisibleArea((Editor)editor).height / editor.getLineHeight();
    }

    public static int getApproximateScreenWidth(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(13);
        }
        return (int)((float)EditorHelper.getVisibleArea((Editor)editor).width / EditorHelper.getPlainSpaceWidthFloat(editor));
    }

    public static int getApproximateOutputPanelWidth(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(14);
        }
        return (int)((float)editor.getComponent().getWidth() / EditorHelper.getPlainSpaceWidthFloat(editor));
    }

    public static float getPlainSpaceWidthFloat(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(15);
        }
        return EditorUtil.fontForChar((char)' ', (int)0, (Editor)editor).charWidth2D(32);
    }

    public static int getVisualColumnAtLeftOfDisplay(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(16);
        }
        Rectangle area = EditorHelper.getVisibleArea(editor);
        return EditorHelper.getFullVisualColumn(editor, area.x, editor.visualLineToY(visualLine), area.x, area.x + area.width);
    }

    public static int getVisualColumnAtRightOfDisplay(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(17);
        }
        Rectangle area = EditorHelper.getVisibleArea(editor);
        return EditorHelper.getFullVisualColumn(editor, area.x + area.width - 1, editor.visualLineToY(visualLine), area.x, area.x + area.width);
    }

    @Nullable
    public static VimEditor getEditor(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        if (doc == null) {
            return null;
        }
        return VimInjectorKt.injector.getEditorGroup().getEditors((VimDocument)new IjVimDocument(doc)).stream().findFirst().orElse(null);
    }

    @NotNull
    public static String pad(@NotNull Editor editor, int line, int to) {
        int len;
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(18);
        }
        if ((len = EngineEditorHelperKt.lineLength((VimEditor)new IjVimEditor(editor), (int)line)) >= to) {
            return "";
        }
        int limit = to - len;
        String string = IndentConfig.create(editor).createIndentBySize(limit);
        if (string == null) {
            EditorHelper.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static List<Caret> getOrderedCaretsList(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(20);
        }
        @NotNull List carets = editor.getCaretModel().getAllCarets();
        carets.sort(Comparator.comparingInt(Caret::getOffset));
        Collections.reverse(carets);
        List list = carets;
        if (list == null) {
            EditorHelper.$$$reportNull$$$0(21);
        }
        return list;
    }

    public static void scrollVisualLineToCaretLocation(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(22);
        }
        Rectangle visibleArea = EditorHelper.getVisibleArea(editor);
        int caretScreenOffset = editor.visualLineToY(editor.getCaretModel().getVisualPosition().line) - visibleArea.y;
        int yVisualLine = editor.visualLineToY(visualLine);
        int topInlayHeight = EditorUtil.getInlaysHeight((Editor)editor, (int)visualLine, (boolean)true);
        int bottomInlayHeight = EditorUtil.getInlaysHeight((Editor)editor, (int)visualLine, (boolean)false);
        int inlayOffset = 0;
        if (topInlayHeight > caretScreenOffset) {
            inlayOffset = topInlayHeight;
        } else if (bottomInlayHeight > visibleArea.height - caretScreenOffset + editor.getLineHeight()) {
            inlayOffset = -bottomInlayHeight;
        }
        @NotNull IjVimEditor editor1 = new IjVimEditor(editor);
        int lastVisualLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)editor1) - 1;
        int yBottomLineOffset = Integer.max(EditorHelper.getOffsetToScrollVisualLineToBottomOfScreen(editor, lastVisualLine), visibleArea.y);
        EditorHelper.scrollVertically(editor, Integer.min(yVisualLine - caretScreenOffset - inlayOffset, yBottomLineOffset));
    }

    public static boolean scrollVisualLineToTopOfScreen(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(23);
        }
        int inlayHeight = EditorUtil.getInlaysHeight((Editor)editor, (int)visualLine, (boolean)true);
        int maxInlayHeight = 3 * editor.getLineHeight();
        int y = editor.visualLineToY(visualLine) - Math.min(inlayHeight, maxInlayHeight);
        if (!editor.getSettings().isAdditionalPageAtBottom()) {
            int editorHeight = EditorHelper.getVisibleArea((Editor)editor).height;
            int virtualSpaceHeight = editor.getSettings().getAdditionalLinesCount() * editor.getLineHeight();
            int yLastLine = editor.visualLineToY(new IjVimEditor(editor).lineCount());
            y = Math.min(y, yLastLine + virtualSpaceHeight - editorHeight);
        }
        return EditorHelper.scrollVertically(editor, y);
    }

    public static void scrollVisualLineToMiddleOfScreen(@NotNull Editor editor, int visualLine, boolean allowVirtualSpace) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(24);
        }
        int y = editor.visualLineToY(EngineEditorHelperKt.normalizeVisualLine((VimEditor)new IjVimEditor(editor), (int)visualLine));
        Rectangle visibleArea = EditorHelper.getVisibleArea(editor);
        int screenHeight = visibleArea.height;
        int lineHeight = editor.getLineHeight();
        int offset = y - (screenHeight - lineHeight) / lineHeight / 2 * lineHeight;
        @NotNull IjVimEditor editor1 = new IjVimEditor(editor);
        int lastVisualLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)editor1) - 1;
        int offsetForLastLineAtBottom = EditorHelper.getOffsetToScrollVisualLineToBottomOfScreen(editor, lastVisualLine);
        if (!allowVirtualSpace && offset > offsetForLastLineAtBottom) {
            EditorHelper.scrollVertically(editor, offsetForLastLineAtBottom);
        } else {
            EditorHelper.scrollVertically(editor, offset);
        }
    }

    public static boolean scrollVisualLineToBottomOfScreen(@NotNull Editor editor, int nonNormalisedVisualLine) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(25);
        }
        int offset = EditorHelper.getOffsetToScrollVisualLineToBottomOfScreen(editor, nonNormalisedVisualLine);
        return EditorHelper.scrollVertically(editor, offset);
    }

    private static int getOffsetToScrollVisualLineToBottomOfScreen(@NotNull Editor editor, int nonNormalisedVisualLine) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(26);
        }
        int lineHeight = editor.getLineHeight();
        int screenHeight = EditorHelper.getVisibleArea((Editor)editor).height - EditorHelper.getExEntryHeight() - EditorHelper.getHorizontalScrollbarHeight(editor);
        int inlayHeight = EditorUtil.getInlaysHeight((Editor)editor, (int)nonNormalisedVisualLine, (boolean)false);
        int maxInlayHeight = 3 * lineHeight;
        int y = editor.visualLineToY(nonNormalisedVisualLine) + lineHeight + Integer.min(inlayHeight, maxInlayHeight);
        return Integer.max(0, y - screenHeight);
    }

    private static int getExEntryHeight() {
        ExEntryPanel instance = ExEntryPanel.Companion.getInstance();
        return instance != null && instance.isActive() ? instance.getHeight() : 0;
    }

    private static int getHorizontalScrollbarHeight(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(27);
        }
        if (!SystemInfo.isMac && editor instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor;
            if (Registry.is((String)"editor.transparent.scrollbar")) {
                return editorImpl.getScrollPane().getHorizontalScrollBar().getHeight();
            }
        }
        return 0;
    }

    public static void scrollColumnToLeftOfScreen(@NotNull Editor editor, int visualLine, int visualColumn) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(28);
        }
        int targetVisualColumn = visualColumn;
        Inlay inlay = editor.getInlayModel().getInlineElementAt(new VisualPosition(visualLine, visualColumn));
        if (inlay != null && inlay.isRelatedToPrecedingText()) {
            targetVisualColumn = visualColumn + 1;
        } else if (visualColumn > 0 && (inlay = editor.getInlayModel().getInlineElementAt(new VisualPosition(visualLine, visualColumn - 1))) != null && !inlay.isRelatedToPrecedingText()) {
            targetVisualColumn = visualColumn - 1;
        }
        int columnLeftX = (int)Math.round(editor.visualPositionToPoint2D(new VisualPosition(visualLine, targetVisualColumn)).getX());
        EditorHelper.scrollHorizontally(editor, columnLeftX);
    }

    public static void scrollColumnToMiddleOfScreen(@NotNull Editor editor, int visualLine, int visualColumn) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(29);
        }
        Point2D point = editor.visualPositionToPoint2D(new VisualPosition(visualLine, visualColumn));
        int screenWidth = EditorHelper.getVisibleArea((Editor)editor).width;
        float standardColumnWidth = EditorHelper.getPlainSpaceWidthFloat(editor);
        int screenMidColumn = (int)((float)screenWidth / standardColumnWidth / 2.0f);
        int x = Integer.max(0, (int)Math.round(point.getX() - (double)((float)screenMidColumn * standardColumnWidth)));
        EditorHelper.scrollHorizontally(editor, x);
    }

    public static void scrollColumnToRightOfScreen(@NotNull Editor editor, int visualLine, int visualColumn) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(30);
        }
        int targetVisualColumn = visualColumn;
        Inlay inlay = editor.getInlayModel().getInlineElementAt(new VisualPosition(visualLine, visualColumn));
        if (inlay != null && !inlay.isRelatedToPrecedingText()) {
            targetVisualColumn = visualColumn - 1;
        } else {
            inlay = editor.getInlayModel().getInlineElementAt(new VisualPosition(visualLine, visualColumn + 1));
            if (inlay != null && inlay.isRelatedToPrecedingText()) {
                targetVisualColumn = visualColumn + 1;
            }
        }
        int targetColumnRightX = (int)Math.round(editor.visualPositionToPoint2D(new VisualPosition(visualLine, targetVisualColumn + 1)).getX());
        int screenWidth = EditorHelper.getVisibleArea((Editor)editor).width;
        EditorHelper.scrollHorizontally(editor, targetColumnRightX - screenWidth);
    }

    public static Pair<Boolean, Integer> scrollFullPageDown(@NotNull Editor editor, int pages) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(31);
        }
        Rectangle visibleArea = EditorHelper.getVisibleArea(editor);
        @NotNull IjVimEditor editor2 = new IjVimEditor(editor);
        int lastVisualLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)editor2) - 1;
        int y = visibleArea.y + visibleArea.height;
        int topBound = visibleArea.y;
        int bottomBound = visibleArea.y + visibleArea.height;
        int targetTopVisualLine = 0;
        int caretVisualLine = -1;
        boolean completed = true;
        for (int i = 0; i < pages; ++i) {
            targetTopVisualLine = EditorHelper.getFullVisualLine(editor, y, topBound, bottomBound);
            if (targetTopVisualLine >= lastVisualLine) {
                if (i == pages - 1) {
                    caretVisualLine = lastVisualLine;
                } else {
                    @NotNull IjVimEditor editor1 = new IjVimEditor(editor);
                    caretVisualLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)editor1) - 1;
                    completed = false;
                }
                targetTopVisualLine = lastVisualLine;
                break;
            }
            topBound = y = editor.visualLineToY(--targetTopVisualLine);
            y = bottomBound = y + visibleArea.height;
            caretVisualLine = targetTopVisualLine;
        }
        EditorHelper.scrollVisualLineToTopOfScreen(editor, targetTopVisualLine);
        return new Pair((Object)completed, (Object)caretVisualLine);
    }

    public static Pair<Boolean, Integer> scrollFullPageUp(@NotNull Editor editor, int pages) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(32);
        }
        Rectangle visibleArea = EditorHelper.getVisibleArea(editor);
        int lineHeight = editor.getLineHeight();
        @NotNull IjVimEditor editor1 = new IjVimEditor(editor);
        int lastVisualLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)editor1) - 1;
        int y = visibleArea.y;
        int topBound = visibleArea.y;
        int bottomBound = visibleArea.y + visibleArea.height;
        int targetBottomVisualLine = 0;
        int caretVisualLine = -1;
        boolean completed = true;
        for (int i = 0; i < pages; ++i) {
            targetBottomVisualLine = EditorHelper.getFullVisualLine(editor, y, topBound, bottomBound) + 1;
            if (targetBottomVisualLine == 1) {
                completed = i == pages - 1;
                break;
            }
            if (targetBottomVisualLine == lastVisualLine) {
                --targetBottomVisualLine;
            }
            y = editor.visualLineToY(targetBottomVisualLine);
            bottomBound = y + lineHeight;
            y = topBound = bottomBound - visibleArea.height;
            caretVisualLine = targetBottomVisualLine;
        }
        EditorHelper.scrollVisualLineToBottomOfScreen(editor, targetBottomVisualLine);
        return new Pair((Object)completed, (Object)caretVisualLine);
    }

    private static int getFullVisualLine(@NotNull Editor editor, int y, int topBound, int bottomBound) {
        int line;
        int yActual;
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(33);
        }
        if ((yActual = editor.visualLineToY(line = editor.yToVisualLine(y))) < topBound) {
            ++line;
        } else if (yActual + editor.getLineHeight() > bottomBound) {
            --line;
        }
        return line;
    }

    private static int getFullVisualColumn(@NotNull Editor editor, int x, int y, int leftBound, int rightBound) {
        VisualPosition closestVisualPosition;
        long xActualLeft;
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(34);
        }
        if ((xActualLeft = Math.round(editor.visualPositionToPoint2D(closestVisualPosition = editor.xyToVisualPosition(new Point(x, y))).getX())) > (long)x) {
            closestVisualPosition = EditorHelper.getPreviousNonInlayVisualPosition(editor, closestVisualPosition);
            xActualLeft = Math.round(editor.visualPositionToPoint2D(closestVisualPosition).getX());
        }
        if (xActualLeft >= (long)leftBound) {
            VisualPosition nextVisualPosition = new VisualPosition(closestVisualPosition.line, closestVisualPosition.column + 1);
            long xActualRight = Math.round(editor.visualPositionToPoint2D(nextVisualPosition).getX()) - 1L;
            if (xActualRight <= (long)rightBound) {
                return closestVisualPosition.column;
            }
            return EditorHelper.getPreviousNonInlayVisualPosition((Editor)editor, (VisualPosition)closestVisualPosition).column;
        }
        return EditorHelper.getNextNonInlayVisualPosition((Editor)editor, (VisualPosition)closestVisualPosition).column;
    }

    private static VisualPosition getNextNonInlayVisualPosition(@NotNull Editor editor, VisualPosition position) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(35);
        }
        InlayModel inlayModel = editor.getInlayModel();
        int lineLength = EditorHelper.getVisualLineLength(editor, position.line);
        position = new VisualPosition(position.line, position.column + 1);
        while (position.column < lineLength && inlayModel.hasInlineElementAt(position)) {
            position = new VisualPosition(position.line, position.column + 1);
        }
        return position;
    }

    private static VisualPosition getPreviousNonInlayVisualPosition(@NotNull Editor editor, VisualPosition position) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(36);
        }
        if (position.column == 0) {
            return position;
        }
        InlayModel inlayModel = editor.getInlayModel();
        position = new VisualPosition(position.line, position.column - 1);
        while (position.column > 0 && inlayModel.hasInlineElementAt(position)) {
            position = new VisualPosition(position.line, position.column - 1);
        }
        return position;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(37);
        }
        return FileDocumentManager.getInstance().getFile(editor.getDocument());
    }

    public static boolean isFileEditor(@NotNull Editor editor) {
        VirtualFile virtualFile;
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(38);
        }
        if ((virtualFile = EditorHelper.getVirtualFile(editor)) == null) {
            return false;
        }
        if (virtualFile instanceof LightVirtualFile) {
            VirtualFile hostVirtualFile = EditorHelper.getHostFileFromInjectedFile(virtualFile);
            if (hostVirtualFile == null) {
                return false;
            }
            return !(hostVirtualFile instanceof LightVirtualFile);
        }
        return true;
    }

    @Nullable
    private static VirtualFile getHostFileFromInjectedFile(@NotNull VirtualFile virtualFile) {
        VirtualFile vf;
        if (virtualFile == null) {
            EditorHelper.$$$reportNull$$$0(39);
        }
        if ((vf = VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile)) instanceof VirtualFileWindow) {
            return ((VirtualFileWindow)vf).getDelegate();
        }
        return null;
    }

    public static boolean isDiffEditor(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(40);
        }
        return editor.getEditorKind() == EditorKind.DIFF;
    }

    public static boolean hasUnsavedChanges(@NotNull Editor editor) {
        if (editor == null) {
            EditorHelper.$$$reportNull$$$0(41);
        }
        Document document = editor.getDocument();
        for (int line = 0; line < document.getLineCount(); ++line) {
            if (!document.isLineModified(line)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/vim/helper/EditorHelper";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/vim/helper/EditorHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleArea";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "pad";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedCaretsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleArea";
                break;
            }
            case 1: 
            case 19: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scrollVertically";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scrollHorizontally";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineAtTopOfScreen";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineAtMiddleOfScreen";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonNormalizedVisualLineAtBottomOfScreen";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineAtBottomOfScreen";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineLength";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVisualColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeScrollOffset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "normalizeSideScrollOffset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getApproximateScreenHeight";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getApproximateScreenWidth";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getApproximateOutputPanelWidth";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlainSpaceWidthFloat";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVisualColumnAtLeftOfDisplay";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVisualColumnAtRightOfDisplay";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "pad";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrderedCaretsList";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scrollVisualLineToCaretLocation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "scrollVisualLineToTopOfScreen";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "scrollVisualLineToMiddleOfScreen";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "scrollVisualLineToBottomOfScreen";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetToScrollVisualLineToBottomOfScreen";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHorizontalScrollbarHeight";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "scrollColumnToLeftOfScreen";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "scrollColumnToMiddleOfScreen";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "scrollColumnToRightOfScreen";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "scrollFullPageDown";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "scrollFullPageUp";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFullVisualLine";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFullVisualColumn";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonInlayVisualPosition";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousNonInlayVisualPosition";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFileEditor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getHostFileFromInjectedFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isDiffEditor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasUnsavedChanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 19, 21 -> new IllegalStateException(string);
        };
    }
}

