/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.newapi;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.LineDeleteShift;
import com.maddyhome.idea.vim.api.MutableLinearEditor;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretListener;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimEditorBase;
import com.maddyhome.idea.vim.api.VimFoldRegion;
import com.maddyhome.idea.vim.api.VimIndentConfig;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimScrollingModel;
import com.maddyhome.idea.vim.api.VimVirtualFile;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.IndentConfig;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimEditorReplaceMask;
import com.maddyhome.idea.vim.common.VimEditorReplaceMaskKt;
import com.maddyhome.idea.vim.group.visual.VisualModeHelperKt;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.HelperKt;
import com.maddyhome.idea.vim.helper.ModeHelper;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.impl.state.VimStateMachineImpl;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjLiveRangeKt;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimDocument;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.undo.VimKeyBasedUndoService;
import com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService;
import com.maddyhome.idea.vim.undo.VimUndoRedo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00a8\u00012\u00020\u00012\u00020\u0002:\u0002\u00a8\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020+H\u0016J\u0015\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020+H\u0016\u00a2\u0006\u0002\u00101J \u00102\u001a\u00020\u00142\u0006\u00103\u001a\u0002042\u0006\u00100\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u0016J \u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0016J\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0;2\u0006\u0010<\u001a\u00020+H\u0016J\u0010\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020+H\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u0002040@H\u0016J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u0002040@H\u0016J\u001c\u0010B\u001a\u00020\u00142\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u00140DH\u0016J$\u0010E\u001a\u00020\u00142\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u00140D2\u0006\u0010F\u001a\u00020\u0019H\u0016J\b\u0010G\u001a\u00020\u0019H\u0016J\b\u0010H\u001a\u000204H\u0016J\b\u0010I\u001a\u000204H\u0016J\b\u0010J\u001a\u00020\u0019H\u0016J\b\u0010K\u001a\u00020\u0019H\u0016J\b\u0010L\u001a\u00020\u0019H\u0016J\u0018\u0010M\u001a\u00020)2\u0006\u0010N\u001a\u00020+2\u0006\u0010O\u001a\u00020+H\u0016JF\u0010P\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0;\u0012\u0004\u0012\u00020Q\u0018\u00010;2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0;2\u0006\u0010\u0003\u001a\u00020S2\u0006\u0010T\u001a\u00020QH\u0016J\u0010\u0010U\u001a\u00020V2\u0006\u0010>\u001a\u00020+H\u0016J\u0010\u0010W\u001a\u00020X2\u0006\u0010>\u001a\u00020+H\u0016J\u0010\u0010Y\u001a\u00020+2\u0006\u0010Z\u001a\u00020XH\u0016J\n\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\u0010\u0010]\u001a\u00020\u00142\u0006\u0010^\u001a\u00020_H\u0016J\b\u0010`\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020\u00142\u0006\u00103\u001a\u000204H\u0016J\u0012\u0010c\u001a\u0004\u0018\u0001042\u0006\u0010>\u001a\u00020+H\u0016J\b\u0010d\u001a\u00020\u0014H\u0016J\u0018\u0010e\u001a\u00020\u00142\u0006\u00106\u001a\u00020X2\u0006\u00107\u001a\u00020XH\u0016J\u0010\u0010f\u001a\u00020+2\u0006\u0010<\u001a\u00020+H\u0016J\u0010\u0010g\u001a\u00020+2\u0006\u0010<\u001a\u00020+H\u0016J\u0010\u0010n\u001a\u00020\u00142\u0006\u0010o\u001a\u00020jH\u0016J\u0010\u0010p\u001a\u00020\u00142\u0006\u0010o\u001a\u00020jH\u0016J\b\u0010q\u001a\u00020\u0019H\u0016J\b\u0010r\u001a\u00020\u0014H\u0016J\n\u0010s\u001a\u0004\u0018\u000109H\u0016J\n\u0010t\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010x\u001a\u00020+2\u0006\u0010Z\u001a\u00020VH\u0016J\u0010\u0010y\u001a\u00020\u00142\u0006\u0010z\u001a\u00020{H\u0016J\u0010\u0010|\u001a\u00020\u00142\u0006\u0010}\u001a\u00020\u0019H\u0016J\b\u0010~\u001a\u00020\u0014H\u0016J\b\u0010\u007f\u001a\u00020\u0014H\u0016J\t\u0010\u0086\u0001\u001a\u00020\u0019H\u0016J\t\u0010\u0087\u0001\u001a\u00020\u0019H\u0016J\u0011\u0010\u0088\u0001\u001a\u00020+2\u0006\u0010<\u001a\u00020+H\u0016J\u0011\u0010\u0089\u0001\u001a\u00020X2\u0006\u0010Z\u001a\u00020VH\u0016J\u0011\u0010\u008a\u0001\u001a\u00020V2\u0006\u0010Z\u001a\u00020XH\u0016J\u001a\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0006\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020+H\u0016J\u0011\u0010\u008d\u0001\u001a\u00020+2\u0006\u0010<\u001a\u00020+H\u0016J\u0012\u0010\u0096\u0001\u001a\u0002092\u0007\u0010\u0097\u0001\u001a\u00020+H\u0016J\u0014\u0010\u0098\u0001\u001a\u0005\u0018\u00010\u0099\u00012\u0006\u0010>\u001a\u00020+H\u0016J%\u0010\u009a\u0001\u001a\u0003H\u009b\u0001\"\n\b\u0000\u0010\u009b\u0001*\u00030\u009c\u00012\u0007\u00103\u001a\u0003H\u009b\u0001H\u0016\u00a2\u0006\u0003\u0010\u009d\u0001J!\u0010\u009e\u0001\u001a\u00020\u0019*\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0;2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002JV\u0010\u009f\u0001\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0;2\t\b\u0002\u0010\u00a0\u0001\u001a\u00020+2\t\b\u0002\u0010\u00a1\u0001\u001a\u00020+2$\u0010C\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0;\u0012\u0004\u0012\u00020\u00140D\u00a2\u0006\u0003\b\u00a2\u0001H\u0082\bJ\u0016\u0010\u00a3\u0001\u001a\u00020\u00192\n\u0010\u00a4\u0001\u001a\u0005\u0018\u00010\u00a5\u0001H\u0096\u0002J\t\u0010\u00a6\u0001\u001a\u00020+H\u0016J\t\u0010\u00a7\u0001\u001a\u000209H\u0016R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u001a\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u001d\u001a\u0004\u0018\u00010\u00162\b\u0010\f\u001a\u0004\u0018\u00010\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001d\u0010h\u001a\u000e\u0012\u0004\u0012\u00020j\u0012\u0004\u0012\u00020k0i\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010mR\u0014\u0010u\u001a\u000209X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010wR/\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0080\u00012\t\u0010\f\u001a\u0005\u0018\u00010\u0080\u00018V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R(\u0010\u008e\u0001\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u00198V@VX\u0096\u000e\u00a2\u0006\u000f\u001a\u0005\b\u008f\u0001\u0010\u001c\"\u0006\b\u0090\u0001\u0010\u0091\u0001R\u0018\u0010\u0092\u0001\u001a\u00030\u0093\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001\u00a8\u0006\u00a9\u0001"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimEditor;", "Lcom/maddyhome/idea/vim/api/MutableLinearEditor;", "Lcom/maddyhome/idea/vim/api/VimEditorBase;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "Lorg/jetbrains/annotations/NotNull;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "originalEditor", "getOriginalEditor", "value", "Lcom/maddyhome/idea/vim/common/VimEditorReplaceMask;", "replaceMask", "getReplaceMask", "()Lcom/maddyhome/idea/vim/common/VimEditorReplaceMask;", "setReplaceMask", "(Lcom/maddyhome/idea/vim/common/VimEditorReplaceMask;)V", "updateMode", "", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "updateIsReplaceCharacter", "isReplaceCharacter", "", "lfMakesNewLine", "getLfMakesNewLine", "()Z", "vimChangeActionSwitchMode", "getVimChangeActionSwitchMode", "()Lcom/maddyhome/idea/vim/state/mode/Mode;", "setVimChangeActionSwitchMode", "(Lcom/maddyhome/idea/vim/state/mode/Mode;)V", "indentConfig", "Lcom/maddyhome/idea/vim/api/VimIndentConfig;", "getIndentConfig", "()Lcom/maddyhome/idea/vim/api/VimIndentConfig;", "fileSize", "", "text", "", "nativeLineCount", "", "deleteRange", "leftOffset", "rightOffset", "addLine", "atPosition", "(I)Ljava/lang/Integer;", "insertText", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "replaceString", "start", "end", "newString", "", "getLineRange", "Lkotlin/Pair;", "line", "getLine", "offset", "carets", "", "nativeCarets", "forEachCaret", "action", "Lkotlin/Function1;", "forEachNativeCaret", "reverse", "isInForEachCaretScope", "primaryCaret", "currentCaret", "isWritable", "isDocumentWritable", "isOneLineMode", "getText", "left", "right", "search", "Lcom/maddyhome/idea/vim/api/LineDeleteShift;", "pair", "Lcom/maddyhome/idea/vim/api/VimEditor;", "shiftType", "offsetToVisualPosition", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "offsetToBufferPosition", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "bufferPositionToOffset", "position", "getVirtualFile", "Lcom/maddyhome/idea/vim/api/VimVirtualFile;", "deleteString", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "getScrollingModel", "Lcom/maddyhome/idea/vim/api/VimScrollingModel;", "removeCaret", "addCaret", "removeSecondaryCarets", "vimSetSystemBlockSelectionSilently", "getLineStartOffset", "getLineEndOffset", "listenersMap", "", "Lcom/maddyhome/idea/vim/api/VimCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "getListenersMap", "()Ljava/util/Map;", "addCaretListener", "listener", "removeCaretListener", "isDisposed", "removeSelection", "getPath", "extractProtocol", "projectId", "getProjectId", "()Ljava/lang/String;", "visualPositionToOffset", "exitInsertMode", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "exitSelectModeNative", "adjustCaret", "startGuardedBlockChecking", "stopGuardedBlockChecking", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "vimLastSelectionType", "getVimLastSelectionType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "setVimLastSelectionType", "(Lcom/maddyhome/idea/vim/state/mode/SelectionType;)V", "isTemplateActive", "hasUnsavedChanges", "getLastVisualLineColumnNumber", "visualPositionToBufferPosition", "bufferPositionToVisualPosition", "createLiveMarker", "Lcom/maddyhome/idea/vim/common/LiveRange;", "bufferLineToVisualLine", "insertMode", "getInsertMode", "setInsertMode", "(Z)V", "document", "Lcom/maddyhome/idea/vim/api/VimDocument;", "getDocument", "()Lcom/maddyhome/idea/vim/api/VimDocument;", "createIndentBySize", "size", "getFoldRegionAtOffset", "Lcom/maddyhome/idea/vim/api/VimFoldRegion;", "findLastVersionOfCaret", "T", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;)Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "noGuard", "shift", "shiftStart", "shiftEnd", "Lkotlin/ExtensionFunctionType;", "equals", "other", "", "hashCode", "toString", "Companion", "IdeaVIM"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIjVimEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjVimEditor.kt\ncom/maddyhome/idea/vim/newapi/IjVimEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,544:1\n506#1:554\n505#1,4:555\n500#1,9:559\n500#1,9:568\n1#2:545\n1563#3:546\n1634#3,3:547\n1563#3:550\n1634#3,3:551\n*S KotlinDebug\n*F\n+ 1 IjVimEditor.kt\ncom/maddyhome/idea/vim/newapi/IjVimEditor\n*L\n249#1:554\n249#1:555,4\n253#1:559,9\n263#1:568,9\n172#1:546\n172#1:547,3\n177#1:550\n177#1:551,3\n*E\n"})
public final class IjVimEditor
extends VimEditorBase
implements MutableLinearEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Editor originalEditor;
    private final boolean lfMakesNewLine;
    @NotNull
    private final Map<VimCaretListener, CaretListener> listenersMap;
    @NotNull
    private final String projectId;
    @NotNull
    public static final String DEFAULT_PROJECT_ID = "no project";

    /*
     * WARNING - void declaration
     */
    public IjVimEditor(@NotNull Editor editor) {
        Object object;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.editor = HelperKt.getTopLevelEditor(editor);
                this.originalEditor = editor;
                this.lfMakesNewLine = true;
                this.listenersMap = new LinkedHashMap();
                IjVimEditor ijVimEditor = this;
                object = editor.getProject();
                if (object == null) break block2;
                Project project = object;
                IjVimEditor ijVimEditor2 = ijVimEditor;
                boolean bl = false;
                String string = VimInjectorKt.getInjector().getFile().getProjectId((Object)it);
                ijVimEditor = ijVimEditor2;
                object = string;
                if (string != null) break block3;
            }
            object = DEFAULT_PROJECT_ID;
        }
        ijVimEditor.projectId = object;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Editor getOriginalEditor() {
        return this.originalEditor;
    }

    @Nullable
    public VimEditorReplaceMask getReplaceMask() {
        return UserDataManager.getReplaceMask(this.editor);
    }

    public void setReplaceMask(@Nullable VimEditorReplaceMask value) {
        UserDataManager.setReplaceMask(this.editor, value);
    }

    protected void updateMode(@NotNull Mode mode2) {
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        VimStateMachine vimStateMachine = VimInjectorKt.getInjector().getVimState();
        Intrinsics.checkNotNull((Object)vimStateMachine, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.impl.state.VimStateMachineImpl");
        ((VimStateMachineImpl)vimStateMachine).setMode(mode2);
    }

    protected void updateIsReplaceCharacter(boolean isReplaceCharacter) {
        VimStateMachine vimStateMachine = VimInjectorKt.getInjector().getVimState();
        Intrinsics.checkNotNull((Object)vimStateMachine, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.impl.state.VimStateMachineImpl");
        ((VimStateMachineImpl)vimStateMachine).setReplaceCharacter(isReplaceCharacter);
    }

    public boolean getLfMakesNewLine() {
        return this.lfMakesNewLine;
    }

    @Nullable
    public Mode getVimChangeActionSwitchMode() {
        return UserDataManager.getVimChangeActionSwitchMode(this.editor);
    }

    public void setVimChangeActionSwitchMode(@Nullable Mode value) {
        UserDataManager.setVimChangeActionSwitchMode(this.editor, value);
    }

    @NotNull
    public VimIndentConfig getIndentConfig() {
        return IndentConfig.Companion.create(this.editor);
    }

    public long fileSize() {
        return this.editor.getDocument().getTextLength();
    }

    @NotNull
    public CharSequence text() {
        CharSequence charSequence = this.editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        return charSequence;
    }

    public int nativeLineCount() {
        return this.editor.getDocument().getLineCount();
    }

    public void deleteRange(int leftOffset, int rightOffset) {
        this.editor.getDocument().deleteString(leftOffset, rightOffset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Integer addLine(int atPosition) {
        int n;
        if (atPosition < this.lineCount()) {
            void var3_2;
            int lineStart = RangesKt.coerceAtLeast((int)(this.editor.getDocument().getLineStartOffset(atPosition) - 1), (int)0);
            RangeMarker guard = this.editor.getDocument().getOffsetGuard(lineStart);
            n = guard != null && guard.getEndOffset() == lineStart + 1 ? lineStart + 1 : var3_2;
        } else {
            n = (int)this.fileSize();
        }
        int offset = n;
        this.editor.getDocument().insertString(offset, (CharSequence)"\n");
        return atPosition;
    }

    public void insertText(@NotNull VimCaret caret, int atPosition, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (VimInjectorKt.getInjector().getVimState().getMode() instanceof Mode.INSERT) {
            VimUndoRedo undo = VimInjectorKt.getInjector().getUndo();
            VimUndoRedo vimUndoRedo = undo;
            if (vimUndoRedo instanceof VimKeyBasedUndoService) {
                VimKeyBasedUndoService.setInsertNonMergeUndoKey$default((VimKeyBasedUndoService)((VimKeyBasedUndoService)undo), (boolean)false, (int)1, null);
            } else if (vimUndoRedo instanceof VimTimestampBasedUndoService) {
                ((VimTimestampBasedUndoService)undo).startInsertSequence(caret, atPosition, System.nanoTime());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.editor.getDocument().insertString(atPosition, text);
    }

    public void replaceString(int start2, int end, @NotNull String newString) {
        Intrinsics.checkNotNullParameter((Object)newString, (String)"newString");
        this.editor.getDocument().replaceString(start2, end, (CharSequence)newString);
    }

    @NotNull
    public Pair<Integer, Integer> getLineRange(int line) {
        return TuplesKt.to((Object)this.editor.getDocument().getLineStartOffset(line), (Object)this.editor.getDocument().getLineEndOffset(line));
    }

    public int getLine(int offset) {
        return this.editor.offsetToLogicalPosition((int)offset).line;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<VimCaret> carets() {
        List list;
        if (EditorExtensionsKt.getInBlockSelection((VimEditor)IjVimEditorKt.getVim(this.editor)) || CommandStateHelper.inExMode(this.editor) && IjVimEditorKt.getVim(this.editor).getVimLastSelectionType() == SelectionType.BLOCK_WISE) {
            Caret caret = this.editor.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            list = CollectionsKt.listOf((Object)((Object)new IjVimCaret(caret)));
        } else {
            void $this$mapTo$iv$iv;
            List list2 = this.editor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Caret caret = (Caret)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new IjVimCaret((Caret)it));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<VimCaret> nativeCarets() {
        void $this$mapTo$iv$iv;
        List list = this.editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Caret caret = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new IjVimCaret((Caret)it));
        }
        return (List)destination$iv$iv;
    }

    public void forEachCaret(@NotNull Function1<? super VimCaret, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (EditorExtensionsKt.getInBlockSelection((VimEditor)IjVimEditorKt.getVim(this.editor))) {
            Caret caret = this.editor.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            action.invoke((Object)new IjVimCaret(caret));
        } else {
            this.editor.getCaretModel().runForEachCaret(arg_0 -> IjVimEditor.forEachCaret$lambda$0(action, arg_0), false);
        }
    }

    public void forEachNativeCaret(@NotNull Function1<? super VimCaret, Unit> action, boolean reverse) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.editor.getCaretModel().runForEachCaret(arg_0 -> IjVimEditor.forEachNativeCaret$lambda$0(action, arg_0), reverse);
    }

    public boolean isInForEachCaretScope() {
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNull((Object)caretModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.CaretModelImpl");
        return ((CaretModelImpl)caretModel).isIteratingOverCarets();
    }

    @NotNull
    public VimCaret primaryCaret() {
        Caret caret = this.editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        return (VimCaret)new IjVimCaret(caret);
    }

    @NotNull
    public VimCaret currentCaret() {
        Caret caret = this.editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        return (VimCaret)new IjVimCaret(caret);
    }

    public boolean isWritable() {
        if (this.editor.isViewer()) {
            ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)this.editor.getUserData(ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW);
            if (consoleViewImpl != null) {
                ConsoleViewImpl it = consoleViewImpl;
                boolean bl = false;
                if (it.isRunning()) {
                    return true;
                }
            }
        }
        boolean modificationAllowed = EditorModificationUtil.checkModificationAllowed((Editor)this.editor);
        boolean writeRequested = EditorModificationUtil.requestWriting((Editor)this.editor);
        return modificationAllowed && writeRequested;
    }

    public boolean isDocumentWritable() {
        return this.editor.getDocument().isWritable();
    }

    public boolean isOneLineMode() {
        return this.editor.isOneLineMode();
    }

    @NotNull
    public CharSequence getText(int left, int right) {
        return this.editor.getDocument().getCharsSequence().subSequence(left, right);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Pair<Pair<Integer, Integer>, LineDeleteShift> search(@NotNull Pair<Integer, Integer> pair, @NotNull VimEditor editor, @NotNull LineDeleteShift shiftType) {
        Object v0;
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)shiftType, (String)"shiftType");
        Editor ijEditor = ((IjVimEditor)editor).editor;
        switch (WhenMappings.$EnumSwitchMapping$0[shiftType.ordinal()]) {
            case 1: {
                if (this.noGuard(pair, ijEditor)) {
                    return TuplesKt.to(pair, (Object)shiftType);
                }
                v0 = null;
                break;
            }
            case 2: {
                void $receiver$iv;
                int shiftStart$iv;
                Pair<Integer, Integer> $this$shift$iv;
                Pair data$iv;
                if (this.noGuard(pair, ijEditor)) {
                    return TuplesKt.to(pair, (Object)shiftType);
                }
                IjVimEditor ijVimEditor = this;
                Pair<Integer, Integer> pair2 = pair;
                int n = -1;
                int shiftEnd$iv = -1;
                boolean $i$f$shift = false;
                Pair $this$search_u24lambda_u240 = data$iv = TuplesKt.to((Object)RangesKt.coerceAtLeast((int)(((Number)$this$shift$iv.getFirst()).intValue() + shiftStart$iv), (int)0), (Object)RangesKt.coerceAtLeast((int)(((Number)$this$shift$iv.getSecond()).intValue() + shiftEnd$iv), (int)0));
                boolean bl = false;
                if (this.noGuard((Pair<Integer, Integer>)$this$search_u24lambda_u240, ijEditor)) {
                    return TuplesKt.to((Object)$this$search_u24lambda_u240, (Object)LineDeleteShift.NL_ON_START);
                }
                IjVimEditor this_$iv = this;
                $this$shift$iv = pair;
                shiftEnd$iv = -1;
                shiftStart$iv = 0;
                $i$f$shift = false;
                Pair $this$search_u24lambda_u241 = data$iv = TuplesKt.to((Object)RangesKt.coerceAtLeast((int)(((Number)$receiver$iv.getFirst()).intValue() + shiftStart$iv), (int)0), (Object)RangesKt.coerceAtLeast((int)(((Number)$receiver$iv.getSecond()).intValue() + shiftEnd$iv), (int)0));
                boolean bl2 = false;
                if (this.noGuard((Pair<Integer, Integer>)$this$search_u24lambda_u241, ijEditor)) {
                    return TuplesKt.to((Object)$this$search_u24lambda_u241, (Object)LineDeleteShift.NO_NL);
                }
                v0 = null;
                break;
            }
            case 3: {
                Pair data$iv;
                if (this.noGuard(pair, ijEditor)) {
                    return TuplesKt.to(pair, (Object)shiftType);
                }
                IjVimEditor $this$iv = this;
                Pair<Integer, Integer> $receiver$iv = pair;
                int shiftStart$iv = 1;
                int shiftEnd$iv = 0;
                boolean $i$f$shift = false;
                Pair $this$search_u24lambda_u242 = data$iv = TuplesKt.to((Object)RangesKt.coerceAtLeast((int)(((Number)$receiver$iv.getFirst()).intValue() + shiftStart$iv), (int)0), (Object)RangesKt.coerceAtLeast((int)(((Number)$receiver$iv.getSecond()).intValue() + shiftEnd$iv), (int)0));
                boolean bl = false;
                if (this.noGuard((Pair<Integer, Integer>)$this$search_u24lambda_u242, ijEditor)) {
                    return TuplesKt.to((Object)$this$search_u24lambda_u242, (Object)LineDeleteShift.NO_NL);
                }
                v0 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v0;
    }

    @NotNull
    public VimVisualPosition offsetToVisualPosition(int offset) {
        VisualPosition it = this.editor.offsetToVisualPosition(offset);
        boolean bl = false;
        return new VimVisualPosition(it.line, it.column, it.leansRight);
    }

    @NotNull
    public BufferPosition offsetToBufferPosition(int offset) {
        LogicalPosition it = this.editor.offsetToLogicalPosition(offset);
        boolean bl = false;
        return new BufferPosition(it.line, it.column, it.leansForward);
    }

    public int bufferPositionToOffset(@NotNull BufferPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        LogicalPosition logicalPosition = new LogicalPosition(position.getLine(), position.getColumn(), position.getLeansForward());
        return this.editor.logicalPositionToOffset(logicalPosition);
    }

    @Nullable
    public VimVirtualFile getVirtualFile() {
        VimVirtualFile vimVirtualFile;
        VirtualFile vf;
        VirtualFile virtualFile = vf = EditorHelper.getVirtualFile(this.editor);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            vimVirtualFile = new VimVirtualFile(vf){
                private final String path;
                private final String protocol;
                private final String extension;
                {
                    String string = $vf.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    this.path = string;
                    String string2 = $vf.getFileSystem().getProtocol();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProtocol(...)");
                    this.protocol = string2;
                    this.extension = $vf.getExtension();
                }

                public String getPath() {
                    return this.path;
                }

                public String getProtocol() {
                    return this.protocol;
                }

                public String getExtension() {
                    return this.extension;
                }
            };
        } else {
            vimVirtualFile = null;
        }
        return vimVirtualFile;
    }

    public void deleteString(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
    }

    @NotNull
    public VimScrollingModel getScrollingModel() {
        return new VimScrollingModel(this){
            private final ScrollingModelEx sm;
            {
                ScrollingModel scrollingModel = $receiver.getEditor().getScrollingModel();
                Intrinsics.checkNotNull((Object)scrollingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.ScrollingModelEx");
                this.sm = (ScrollingModelEx)scrollingModel;
            }

            public void accumulateViewportChanges() {
                this.sm.accumulateViewportChanges();
            }

            public void flushViewportChanges() {
                this.sm.flushViewportChanges();
            }
        };
    }

    public void removeCaret(@NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.editor.getCaretModel().removeCaret(((IjVimCaret)caret).getCaret());
    }

    @Nullable
    public VimCaret addCaret(int offset) {
        Caret caret = this.editor.getCaretModel().addCaret(this.editor.offsetToVisualPosition(offset));
        return caret != null ? IjVimCaretKt.getVim(caret) : null;
    }

    public void removeSecondaryCarets() {
        this.editor.getCaretModel().removeSecondaryCarets();
    }

    public void vimSetSystemBlockSelectionSilently(@NotNull BufferPosition start2, @NotNull BufferPosition end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        LogicalPosition startPosition = new LogicalPosition(start2.getLine(), start2.getColumn(), start2.getLeansForward());
        LogicalPosition endPosition = new LogicalPosition(end.getLine(), end.getColumn(), end.getLeansForward());
        SelectionModel selectionModel = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        VisualModeHelperKt.vimSetSystemBlockSelectionSilently(selectionModel, startPosition, endPosition);
    }

    public int getLineStartOffset(int line) {
        int n;
        if (line < 0) {
            StrictMode.INSTANCE.fail("Incorrect line: " + line);
            n = 0;
        } else if (line >= this.lineCount()) {
            if (this.lineCount() != 0) {
                StrictMode.INSTANCE.fail("Incorrect line: " + line + ", out of " + this.lineCount());
            }
            n = this.editor.getDocument().getTextLength();
        } else {
            n = this.editor.getDocument().getLineStartOffset(line);
        }
        return n;
    }

    public int getLineEndOffset(int line) {
        return this.editor.getDocument().getLineEndOffset(line);
    }

    @NotNull
    public final Map<VimCaretListener, CaretListener> getListenersMap() {
        return this.listenersMap;
    }

    public void addCaretListener(@NotNull VimCaretListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        CaretListener caretListener2 = new CaretListener(listener2){
            final /* synthetic */ VimCaretListener $listener;
            {
                this.$listener = $listener;
            }

            public void caretRemoved(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Caret caret = event.getCaret();
                this.$listener.caretRemoved((ImmutableVimCaret)(caret != null ? IjVimCaretKt.getVim(caret) : null));
            }
        };
        this.listenersMap.put(listener2, caretListener2);
        this.editor.getCaretModel().addCaretListener(caretListener2);
    }

    public void removeCaretListener(@NotNull VimCaretListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        CaretListener caretListener2 = this.listenersMap.remove(listener2);
        if (caretListener2 == null) {
            throw new IllegalStateException("Existing listener expected".toString());
        }
        CaretListener caretListener3 = caretListener2;
        this.editor.getCaretModel().removeCaretListener(caretListener3);
    }

    public boolean isDisposed() {
        return this.editor.isDisposed();
    }

    public void removeSelection() {
        this.editor.getSelectionModel().removeSelection();
    }

    @Nullable
    public String getPath() {
        VirtualFile virtualFile = EditorHelper.getVirtualFile(this.editor);
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    @Nullable
    public String extractProtocol() {
        String string;
        Object object = EditorHelper.getVirtualFile(this.editor);
        if (object != null && (object = object.getUrl()) != null) {
            Object it = object;
            boolean bl = false;
            string = VirtualFileManager.extractProtocol((String)it);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public String getProjectId() {
        return this.projectId;
    }

    public int visualPositionToOffset(@NotNull VimVisualPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.editor.visualPositionToOffset(new VisualPosition(position.getLine(), position.getColumn(), position.getLeansRight()));
    }

    public void exitInsertMode(@NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModeHelper.exitInsertMode(this.editor, IjEditorExecutionContextKt.getIj(context));
    }

    public void exitSelectModeNative(boolean adjustCaret) {
        ModeHelper.exitSelectMode((VimEditor)this, adjustCaret);
    }

    public void startGuardedBlockChecking() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        doc.startGuardedBlockChecking();
    }

    public void stopGuardedBlockChecking() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        doc.stopGuardedBlockChecking();
    }

    @Nullable
    public SelectionType getVimLastSelectionType() {
        return UserDataManager.getVimLastSelectionType(this.editor);
    }

    public void setVimLastSelectionType(@Nullable SelectionType value) {
        UserDataManager.setVimLastSelectionType(this.editor, value);
    }

    public boolean isTemplateActive() {
        return HelperKt.isTemplateActive(this.editor);
    }

    public boolean hasUnsavedChanges() {
        return EditorHelper.hasUnsavedChanges(this.editor);
    }

    public int getLastVisualLineColumnNumber(int line) {
        return EditorUtil.getLastVisualLineColumnNumber((Editor)IjVimEditorKt.getIj((VimEditor)this), (int)line);
    }

    @NotNull
    public BufferPosition visualPositionToBufferPosition(@NotNull VimVisualPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        LogicalPosition logicalPosition = this.editor.visualToLogicalPosition(new VisualPosition(position.getLine(), position.getColumn(), position.getLeansRight()));
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"visualToLogicalPosition(...)");
        LogicalPosition logPosition = logicalPosition;
        return new BufferPosition(logPosition.line, logPosition.column, logPosition.leansForward);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VimVisualPosition bufferPositionToVisualPosition(@NotNull BufferPosition position) {
        VisualPosition visualPosition;
        void $this$bufferPositionToVisualPosition_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        BufferPosition bufferPosition = position;
        Editor editor = this.editor;
        boolean bl = false;
        VisualPosition visualPosition2 = editor.logicalToVisualPosition(new LogicalPosition($this$bufferPositionToVisualPosition_u24lambda_u240.getLine(), $this$bufferPositionToVisualPosition_u24lambda_u240.getColumn(), $this$bufferPositionToVisualPosition_u24lambda_u240.getLeansForward()));
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition2, (String)"logicalToVisualPosition(...)");
        VisualPosition $this$bufferPositionToVisualPosition_u24lambda_u241 = visualPosition = visualPosition2;
        boolean bl2 = false;
        return new VimVisualPosition($this$bufferPositionToVisualPosition_u24lambda_u241.line, $this$bufferPositionToVisualPosition_u24lambda_u241.column, $this$bufferPositionToVisualPosition_u24lambda_u241.leansRight);
    }

    @NotNull
    public LiveRange createLiveMarker(int start2, int end) {
        RangeMarker rangeMarker = this.editor.getDocument().createRangeMarker(start2, end);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        return IjLiveRangeKt.getVim(rangeMarker);
    }

    public int bufferLineToVisualLine(int line) {
        if (this.editor instanceof EditorImpl) {
            return ((EditorImpl)this.editor).offsetToVisualLine(((EditorImpl)this.editor).getDocument().getLineStartOffset(line));
        }
        return super.bufferLineToVisualLine(line);
    }

    public boolean getInsertMode() {
        Editor editor = this.editor;
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        return editorEx != null ? editorEx.isInsertMode() : false;
    }

    public void setInsertMode(boolean value) {
        Editor editor = this.editor;
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx != null) {
            editorEx.setInsertMode(value);
        }
        VimEditorReplaceMaskKt.forgetAllReplaceMasks();
    }

    @NotNull
    public VimDocument getDocument() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return new IjVimDocument(document);
    }

    @NotNull
    public String createIndentBySize(int size) {
        return IndentConfig.Companion.create(this.editor).createIndentBySize(size);
    }

    @Nullable
    public VimFoldRegion getFoldRegionAtOffset(int offset) {
        FoldRegion foldRegion = this.editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
        if (foldRegion == null) {
            return null;
        }
        FoldRegion ijFoldRegion = foldRegion;
        return new VimFoldRegion(ijFoldRegion, this){
            final /* synthetic */ FoldRegion $ijFoldRegion;
            final /* synthetic */ IjVimEditor this$0;
            {
                this.$ijFoldRegion = $ijFoldRegion;
                this.this$0 = $receiver;
            }

            public boolean isExpanded() {
                return this.$ijFoldRegion.isExpanded();
            }

            public void setExpanded(boolean value) {
                this.this$0.getEditor().getFoldingModel().runBatchFoldingOperation(() -> getFoldRegionAtOffset.1._set_isExpanded_$lambda$0(this.$ijFoldRegion, value));
            }

            public int getStartOffset() {
                return this.$ijFoldRegion.getStartOffset();
            }

            public int getEndOffset() {
                return this.$ijFoldRegion.getEndOffset();
            }

            private static final void _set_isExpanded_$lambda$0(FoldRegion $ijFoldRegion, boolean $value) {
                $ijFoldRegion.setExpanded($value);
            }
        };
    }

    @NotNull
    public <T extends ImmutableVimCaret> T findLastVersionOfCaret(@NotNull T caret) {
        Intrinsics.checkNotNullParameter(caret, (String)"caret");
        return caret;
    }

    private final boolean noGuard(Pair<Integer, Integer> $this$noGuard, Editor editor) {
        return editor.getDocument().getRangeGuard(((Number)$this$noGuard.getFirst()).intValue(), ((Number)$this$noGuard.getSecond()).intValue()) == null;
    }

    private final void shift(Pair<Integer, Integer> $this$shift, int shiftStart, int shiftEnd, Function1<? super Pair<Integer, Integer>, Unit> action) {
        boolean $i$f$shift = false;
        Pair data = TuplesKt.to((Object)RangesKt.coerceAtLeast((int)(((Number)$this$shift.getFirst()).intValue() + shiftStart), (int)0), (Object)RangesKt.coerceAtLeast((int)(((Number)$this$shift.getSecond()).intValue() + shiftEnd), (int)0));
        action.invoke((Object)data);
    }

    static /* synthetic */ void shift$default(IjVimEditor $this, Pair $receiver, int shiftStart, int shiftEnd, Function1 action, int n, Object object) {
        if ((n & 1) != 0) {
            shiftStart = 0;
        }
        if ((n & 2) != 0) {
            shiftEnd = 0;
        }
        boolean $i$f$shift = false;
        Pair data = TuplesKt.to((Object)RangesKt.coerceAtLeast((int)(((Number)$receiver.getFirst()).intValue() + shiftStart), (int)0), (Object)RangesKt.coerceAtLeast((int)(((Number)$receiver.getSecond()).intValue() + shiftEnd), (int)0));
        action.invoke((Object)data);
    }

    public boolean equals(@Nullable Object other) {
        throw new IllegalStateException("equals and hashCode should not be used with IjVimEditor".toString());
    }

    public int hashCode() {
        throw new IllegalStateException("equals and hashCode should not be used with IjVimEditor".toString());
    }

    @NotNull
    public String toString() {
        String string = Integer.toString(System.identityHashCode(this.editor), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "IjVimEditor[" + this.editor + "@" + string + "]";
    }

    private static final void forEachCaret$lambda$0(Function1 $action, Caret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isValid()) {
            $action.invoke((Object)new IjVimCaret(it));
        }
    }

    private static final void forEachNativeCaret$lambda$0(Function1 $action, Caret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $action.invoke((Object)new IjVimCaret(it));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimEditor$Companion;", "", "<init>", "()V", "DEFAULT_PROJECT_ID", "", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineDeleteShift.values().length];
            try {
                nArray[LineDeleteShift.NO_NL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDeleteShift.NL_ON_END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDeleteShift.NL_ON_START.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

